/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Collide;
import net.phys2d.raw.Contact;

public strictfp class Arbiter {
    public static final int MAX_POINTS = 10;
    private Contact[] contacts = new Contact[10];
    private int numContacts;
    private Body body1;
    private Body body2;
    private float friction;
    private Vector2f scaleTemp = new Vector2f();

    Arbiter(Body b1, Body b2, boolean w) {
        this.body1 = b1;
        this.body2 = b2;
    }

    Arbiter(Body b1, Body b2) {
        for (int i = 0; i < 10; ++i) {
            this.contacts[i] = new Contact();
        }
        this.body1 = b1;
        this.body2 = b2;
    }

    public boolean hasRestingPair() {
        return this.body1.isResting() && this.body2.isResting();
    }

    public void collide(float dt) {
        this.numContacts = Collide.collide(this.contacts, this.body1, this.body2, dt);
    }

    Contact getContact(int index) {
        return this.contacts[index];
    }

    public void init() {
        if (this.numContacts > 0) {
            this.friction = (float)Math.sqrt(this.body1.getFriction() * this.body2.getFriction());
        }
    }

    public Contact[] getContacts() {
        return this.contacts;
    }

    public int getNumContacts() {
        return this.numContacts;
    }

    public Body getBody1() {
        return this.body1;
    }

    public Body getBody2() {
        return this.body2;
    }

    void update(Contact[] newContacts, int numNewContacts) {
        int i;
        Contact[] mergedContacts = new Contact[10];
        for (i = 0; i < mergedContacts.length; ++i) {
            mergedContacts[i] = new Contact();
        }
        for (i = 0; i < numNewContacts; ++i) {
            Contact cOld;
            Contact cNew = newContacts[i];
            int k = -1;
            for (int j = 0; j < this.numContacts; ++j) {
                cOld = this.contacts[j];
                if (!cNew.feature.equals(cOld.feature)) continue;
                k = j;
                break;
            }
            if (k > -1) {
                Contact c = mergedContacts[i];
                cOld = this.contacts[k];
                c.set(cNew);
                c.accumulatedNormalImpulse = cOld.accumulatedNormalImpulse;
                c.accumulatedTangentImpulse = cOld.accumulatedTangentImpulse;
                continue;
            }
            mergedContacts[i].set(newContacts[i]);
        }
        for (i = 0; i < numNewContacts; ++i) {
            this.contacts[i].set(mergedContacts[i]);
        }
        this.numContacts = numNewContacts;
    }

    public boolean concerns(Body body) {
        boolean result = this.body1 == body || this.body2 == body;
        return result;
    }

    void preStep(float invDT, float dt, float damping) {
        float allowedPenetration = 0.01f;
        float biasFactor = 0.8f;
        for (int i = 0; i < this.numContacts; ++i) {
            Contact c = this.contacts[i];
            c.normal.normalise();
            Vector2f r1 = new Vector2f(c.position);
            r1.sub(this.body1.getPosition());
            Vector2f r2 = new Vector2f(c.position);
            r2.sub(this.body2.getPosition());
            float rn1 = r1.dot(c.normal);
            float rn2 = r2.dot(c.normal);
            float kNormal = this.body1.getInvMass() + this.body2.getInvMass();
            c.massNormal = damping / (kNormal += this.body1.getInvI() * (r1.dot(r1) - rn1 * rn1) + this.body2.getInvI() * (r2.dot(r2) - rn2 * rn2));
            Vector2f tangent = MathUtil.cross(c.normal, 1.0f);
            float rt1 = r1.dot(tangent);
            float rt2 = r2.dot(tangent);
            float kTangent = this.body1.getInvMass() + this.body2.getInvMass();
            c.massTangent = damping / (kTangent += this.body1.getInvI() * (r1.dot(r1) - rt1 * rt1) + this.body2.getInvI() * (r2.dot(r2) - rt2 * rt2));
            Vector2f relativeVelocity = new Vector2f(this.body2.getVelocity());
            relativeVelocity.add(MathUtil.cross(r2, this.body2.getAngularVelocity()));
            relativeVelocity.sub(this.body1.getVelocity());
            relativeVelocity.sub(MathUtil.cross(r1, this.body1.getAngularVelocity()));
            float combinedRestitution = this.body1.getRestitution() * this.body2.getRestitution();
            float relVel = c.normal.dot(relativeVelocity);
            c.restitution = combinedRestitution * -relVel;
            c.restitution = Math.max(c.restitution, 0.0f);
            float penVel = -c.separation / dt;
            c.bias = c.restitution >= penVel ? 0.0f : -biasFactor * invDT * Math.min(0.0f, c.separation + allowedPenetration);
            c.accumulatedNormalImpulse *= damping;
            Vector2f impulse = MathUtil.scale(c.normal, c.accumulatedNormalImpulse);
            impulse.add(MathUtil.scale(tangent, c.accumulatedTangentImpulse));
            this.body1.adjustVelocity(MathUtil.scale(impulse, -this.body1.getInvMass()));
            this.body1.adjustAngularVelocity(-this.body1.getInvI() * MathUtil.cross(r1, impulse));
            this.body2.adjustVelocity(MathUtil.scale(impulse, this.body2.getInvMass()));
            this.body2.adjustAngularVelocity(this.body2.getInvI() * MathUtil.cross(r2, impulse));
            c.biasImpulse = 0.0f;
        }
    }

    void applyImpulse() {
        Body b1 = this.body1;
        Body b2 = this.body2;
        for (int i = 0; i < this.numContacts; ++i) {
            Contact c = this.contacts[i];
            Vector2f r1 = new Vector2f(c.position);
            r1.sub(b1.getPosition());
            Vector2f r2 = new Vector2f(c.position);
            r2.sub(b2.getPosition());
            Vector2f relativeVelocity = new Vector2f(b2.getVelocity());
            relativeVelocity.add(MathUtil.cross(b2.getAngularVelocity(), r2));
            relativeVelocity.sub(b1.getVelocity());
            relativeVelocity.sub(MathUtil.cross(b1.getAngularVelocity(), r1));
            float vn = relativeVelocity.dot(c.normal);
            float normalImpulse = c.massNormal * (c.restitution - vn);
            float oldNormalImpulse = c.accumulatedNormalImpulse;
            c.accumulatedNormalImpulse = Math.max(oldNormalImpulse + normalImpulse, 0.0f);
            normalImpulse = c.accumulatedNormalImpulse - oldNormalImpulse;
            Vector2f impulse = MathUtil.scale(c.normal, normalImpulse);
            this.scaleTemp.set(impulse);
            this.scaleTemp.scale(-b1.getInvMass());
            b1.adjustVelocity(this.scaleTemp);
            b1.adjustAngularVelocity(-(b1.getInvI() * MathUtil.cross(r1, impulse)));
            this.scaleTemp.set(impulse);
            this.scaleTemp.scale(b2.getInvMass());
            b2.adjustVelocity(this.scaleTemp);
            b2.adjustAngularVelocity(b2.getInvI() * MathUtil.cross(r2, impulse));
            relativeVelocity.set(b2.getBiasedVelocity());
            relativeVelocity.add(MathUtil.cross(b2.getBiasedAngularVelocity(), r2));
            relativeVelocity.sub(b1.getBiasedVelocity());
            relativeVelocity.sub(MathUtil.cross(b1.getBiasedAngularVelocity(), r1));
            float vnb = relativeVelocity.dot(c.normal);
            float biasImpulse = c.massNormal * (-vnb + c.bias);
            float oldBiasImpulse = c.biasImpulse;
            c.biasImpulse = Math.max(oldBiasImpulse + biasImpulse, 0.0f);
            biasImpulse = c.biasImpulse - oldBiasImpulse;
            Vector2f Pb = MathUtil.scale(c.normal, biasImpulse);
            this.scaleTemp.set(Pb);
            this.scaleTemp.scale(-b1.getInvMass());
            b1.adjustBiasedVelocity(this.scaleTemp);
            b1.adjustBiasedAngularVelocity(-(b1.getInvI() * MathUtil.cross(r1, Pb)));
            this.scaleTemp.set(Pb);
            this.scaleTemp.scale(b2.getInvMass());
            b2.adjustBiasedVelocity(this.scaleTemp);
            b2.adjustBiasedAngularVelocity(b2.getInvI() * MathUtil.cross(r2, Pb));
            float maxTangentImpulse = this.friction * c.accumulatedNormalImpulse;
            relativeVelocity.set(b2.getVelocity());
            relativeVelocity.add(MathUtil.cross(b2.getAngularVelocity(), r2));
            relativeVelocity.sub(b1.getVelocity());
            relativeVelocity.sub(MathUtil.cross(b1.getAngularVelocity(), r1));
            Vector2f tangent = MathUtil.cross(c.normal, 1.0f);
            float vt = relativeVelocity.dot(tangent);
            float tangentImpulse = c.massTangent * -vt;
            float oldTangentImpulse = c.accumulatedTangentImpulse;
            c.accumulatedTangentImpulse = MathUtil.clamp(oldTangentImpulse + tangentImpulse, -maxTangentImpulse, maxTangentImpulse);
            tangentImpulse = c.accumulatedTangentImpulse - oldTangentImpulse;
            impulse = MathUtil.scale(tangent, tangentImpulse);
            this.scaleTemp.set(impulse);
            this.scaleTemp.scale(-b1.getInvMass());
            b1.adjustVelocity(this.scaleTemp);
            b1.adjustAngularVelocity(-b1.getInvI() * MathUtil.cross(r1, impulse));
            this.scaleTemp.set(impulse);
            this.scaleTemp.scale(b2.getInvMass());
            b2.adjustVelocity(this.scaleTemp);
            b2.adjustAngularVelocity(b2.getInvI() * MathUtil.cross(r2, impulse));
        }
    }

    protected float getEnergy(Body body1, Body body2) {
        Vector2f combinedVel = MathUtil.scale(body1.getVelocity(), body1.getMass());
        combinedVel.add(MathUtil.scale(body2.getVelocity(), body2.getMass()));
        float combinedInertia = body1.getI() * body1.getAngularVelocity();
        combinedInertia += body2.getI() * body2.getAngularVelocity();
        float vel1Energy = body1.getMass() * body1.getVelocity().dot(body1.getVelocity());
        float vel2Energy = body2.getMass() * body2.getVelocity().dot(body2.getVelocity());
        float ang1Energy = body1.getI() * (body1.getAngularVelocity() * body1.getAngularVelocity());
        float ang2Energy = body2.getI() * (body2.getAngularVelocity() * body2.getAngularVelocity());
        float energy = vel1Energy + vel2Energy + ang1Energy + ang2Energy;
        return energy;
    }

    public int hashCode() {
        return this.body1.hashCode() + this.body2.hashCode();
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(this.getClass())) {
            Arbiter o = (Arbiter)other;
            return o.body1.equals(this.body1) && o.body2.equals(this.body2);
        }
        return false;
    }

    protected String keyCode() {
        return String.valueOf(this.body1.hashCode()) + String.valueOf(this.body2.hashCode());
    }
}

