/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import com.sun.management.OperatingSystemMXBean;
import icy.common.Version;
import icy.file.FileUtil;
import icy.main.Icy;
import icy.system.IcyExceptionHandler;
import icy.type.collection.CollectionUtil;
import icy.util.ReflectionUtil;
import icy.util.StringUtil;
import java.awt.BufferCapabilities;
import java.awt.Desktop;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ImageCapabilities;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SystemUtil {
    public static final String SYSTEM_WINDOWS = "win";
    public static final String SYSTEM_MAC_OS = "mac";
    public static final String SYSTEM_UNIX = "unix";
    private static Properties props = System.getProperties();
    private static long lastNano = 0L;
    private static long lastCpu = 0L;
    private static int lastCpuLoad = 0;

    public static Process execJAR(String jarPath, String vmArgs, String appArgs, String workDir) {
        return SystemUtil.exec("java " + vmArgs + " -jar " + jarPath + " " + appArgs, workDir);
    }

    public static Process execJAR(String jarPath, String vmArgs, String appArgs) {
        return SystemUtil.exec("java " + vmArgs + " -jar " + jarPath + " " + appArgs);
    }

    public static Process execJAR(String jarPath, String appArgs) {
        return SystemUtil.execJAR(jarPath, "", appArgs);
    }

    public static Process execJAR(String jarPath) {
        return SystemUtil.execJAR(jarPath, "", "");
    }

    public static Process exec(String cmd) {
        return SystemUtil.exec(cmd, ".");
    }

    public static Process exec(String cmd, String dir) {
        try {
            return Runtime.getRuntime().exec(cmd, null, new File(dir));
        }
        catch (Exception e) {
            System.err.println("SystemUtil.exec(" + cmd + ") error :");
            IcyExceptionHandler.showErrorMessage(e, false);
            return null;
        }
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return new BufferedImage(width, height, 1);
        }
        return defaultGC.createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            if (transparency == 1) {
                return new BufferedImage(width, height, 1);
            }
            return new BufferedImage(width, height, 2);
        }
        return defaultGC.createCompatibleImage(width, height, transparency);
    }

    public static VolatileImage createCompatibleVolatileImage(int width, int height) {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return null;
        }
        return defaultGC.createCompatibleVolatileImage(width, height);
    }

    public static VolatileImage createCompatibleVolatileImage(int width, int height, int transparency) {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return null;
        }
        return defaultGC.createCompatibleVolatileImage(width, height, transparency);
    }

    public static Desktop getDesktop() {
        if (Desktop.isDesktopSupported()) {
            return Desktop.getDesktop();
        }
        return null;
    }

    public static boolean openFolder(String folder) throws IOException {
        Desktop desktop = SystemUtil.getDesktop();
        if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
            desktop.open(new File(folder));
            return true;
        }
        return false;
    }

    public static String getProperty(String name) {
        return props.getProperty(name);
    }

    public static String getProperty(String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static String setProperty(String name, String value) {
        return (String)props.setProperty(name, value);
    }

    @Deprecated
    public static int getCtrlMask() {
        return SystemUtil.getMenuCtrlMask();
    }

    public static int getMenuCtrlMask() {
        try {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (HeadlessException e) {
            return 2;
        }
    }

    @Deprecated
    public static int getSystemCtrlMask() {
        return SystemUtil.getMenuCtrlMask();
    }

    public static GraphicsEnvironment getLocalGraphicsEnvironment() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment();
    }

    public static GraphicsDevice getDefaultScreenDevice() {
        if (Icy.getMainInterface().isHeadLess()) {
            return null;
        }
        return SystemUtil.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        GraphicsDevice screenDevice = SystemUtil.getDefaultScreenDevice();
        if (screenDevice != null) {
            return screenDevice.getDefaultConfiguration();
        }
        return null;
    }

    @Deprecated
    public static GraphicsConfiguration getSystemGraphicsConfiguration() {
        return SystemUtil.getDefaultGraphicsConfiguration();
    }

    public static List<GraphicsDevice> getScreenDevices() {
        ArrayList<GraphicsDevice> result = new ArrayList<GraphicsDevice>();
        if (Icy.getMainInterface().isHeadLess()) {
            return result;
        }
        try {
            return CollectionUtil.asList((Object[])SystemUtil.getLocalGraphicsEnvironment().getScreenDevices());
        }
        catch (HeadlessException e) {
            return result;
        }
    }

    public static int getScreenDeviceCount() {
        if (Icy.getMainInterface().isHeadLess()) {
            return 0;
        }
        try {
            return SystemUtil.getLocalGraphicsEnvironment().getScreenDevices().length;
        }
        catch (HeadlessException e) {
            return 0;
        }
    }

    public static GraphicsDevice getScreenDevice(int index) {
        if (Icy.getMainInterface().isHeadLess()) {
            return null;
        }
        try {
            return SystemUtil.getLocalGraphicsEnvironment().getScreenDevices()[index];
        }
        catch (HeadlessException e) {
            return null;
        }
    }

    public static List<GraphicsDevice> getScreenDevices(Rectangle region) {
        ArrayList<GraphicsDevice> result = new ArrayList<GraphicsDevice>();
        if (Icy.getMainInterface().isHeadLess()) {
            return result;
        }
        for (GraphicsDevice gd : SystemUtil.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!SystemUtil.getScreenBounds(gd, true).intersects(region)) continue;
            result.add(gd);
        }
        return result;
    }

    public static GraphicsDevice getScreenDevice(Rectangle region) {
        if (Icy.getMainInterface().isHeadLess()) {
            return null;
        }
        GraphicsDevice result = null;
        Rectangle2D largest = null;
        for (GraphicsDevice gd : SystemUtil.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle2D intersection = SystemUtil.getScreenBounds(gd, true).createIntersection(region);
            if (intersection.isEmpty() || largest != null && !(intersection.getWidth() * intersection.getHeight() > largest.getWidth() * largest.getHeight())) continue;
            largest = intersection;
            result = gd;
        }
        return result;
    }

    public static GraphicsDevice getScreenDevice(Point position) {
        if (Icy.getMainInterface().isHeadLess()) {
            return null;
        }
        for (GraphicsDevice gd : SystemUtil.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!SystemUtil.getScreenBounds(gd, false).contains(position)) continue;
            return gd;
        }
        return null;
    }

    public static boolean isHeadLess() {
        return GraphicsEnvironment.isHeadless();
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static BufferCapabilities getSystemBufferCapabilities() {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return null;
        }
        return defaultGC.getBufferCapabilities();
    }

    public static ImageCapabilities getSystemImageCapabilities() {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return null;
        }
        return defaultGC.getImageCapabilities();
    }

    public static ColorModel getSystemColorModel() {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return null;
        }
        return defaultGC.getColorModel();
    }

    public static ColorModel getSystemColorModel(int transparency) {
        GraphicsConfiguration defaultGC = SystemUtil.getDefaultGraphicsConfiguration();
        if (defaultGC == null) {
            return null;
        }
        return defaultGC.getColorModel(transparency);
    }

    public static Rectangle getScreenBounds(GraphicsDevice graphicsDevice, boolean removeInsets) {
        if (graphicsDevice == null) {
            return new Rectangle();
        }
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Rectangle bounds = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static Rectangle getDesktopBounds(boolean removeInsets) {
        Rectangle result = new Rectangle();
        if (Icy.getMainInterface().isHeadLess()) {
            return result;
        }
        GraphicsDevice[] gs = SystemUtil.getLocalGraphicsEnvironment().getScreenDevices();
        for (int j = 0; j < gs.length; ++j) {
            result = result.union(SystemUtil.getScreenBounds(gs[j], removeInsets));
        }
        return result;
    }

    public static Rectangle getDesktopBounds() {
        return SystemUtil.getDesktopBounds(true);
    }

    public static Rectangle getMaximumWindowBounds() {
        if (Icy.getMainInterface().isHeadLess()) {
            return new Rectangle();
        }
        return SystemUtil.getLocalGraphicsEnvironment().getMaximumWindowBounds();
    }

    public static DisplayMode getSystemDisplayMode() {
        GraphicsDevice screenDevice = SystemUtil.getDefaultScreenDevice();
        if (screenDevice != null) {
            return screenDevice.getDisplayMode();
        }
        return null;
    }

    @Deprecated
    public static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfCPUs() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getJavaFreeMemory() {
        return SystemUtil.getJavaMaxMemory() - SystemUtil.getJavaUsedMemory();
    }

    public static long getJavaMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    @Deprecated
    public static long getJavaTotalMemory() {
        return SystemUtil.getJavaAllocatedMemory();
    }

    public static long getJavaAllocatedMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getJavaUsedMemory() {
        return SystemUtil.getJavaAllocatedMemory() - Runtime.getRuntime().freeMemory();
    }

    private static OperatingSystemMXBean getOSMXBean() {
        java.lang.management.OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        if (bean instanceof OperatingSystemMXBean) {
            return (OperatingSystemMXBean)bean;
        }
        return null;
    }

    public static long getTotalMemory() {
        OperatingSystemMXBean bean = SystemUtil.getOSMXBean();
        if (bean != null) {
            return bean.getTotalPhysicalMemorySize();
        }
        return -1L;
    }

    @Deprecated
    public static long getSystemTotalMemory() {
        return SystemUtil.getTotalMemory();
    }

    public static long getFreeMemory() {
        OperatingSystemMXBean bean = SystemUtil.getOSMXBean();
        if (bean != null) {
            return bean.getFreePhysicalMemorySize();
        }
        return -1L;
    }

    @Deprecated
    public static long getSystemFreeMemory() {
        return SystemUtil.getFreeMemory();
    }

    public static long getProcessCpuTime() {
        OperatingSystemMXBean bean = SystemUtil.getOSMXBean();
        if (bean != null) {
            return bean.getProcessCpuTime();
        }
        return -1L;
    }

    @Deprecated
    public static long getSystemProcessCpuTime() {
        return SystemUtil.getProcessCpuTime();
    }

    public static int getCpuLoad() {
        OperatingSystemMXBean bean = SystemUtil.getOSMXBean();
        if (bean != null) {
            if (lastNano == 0L) {
                lastNano = System.nanoTime();
                lastCpu = bean.getProcessCpuTime();
            } else {
                long nanoAfter = System.nanoTime();
                long cpuAfter = bean.getProcessCpuTime();
                long dNano = nanoAfter - lastNano;
                long dCpu = cpuAfter - lastCpu;
                if (dNano > 500000000L) {
                    lastCpuLoad = (int)(dCpu * 100L / (dNano * (long)SystemUtil.getNumberOfCPUs()));
                    lastNano = nanoAfter;
                    lastCpu = cpuAfter;
                }
            }
            return lastCpuLoad;
        }
        return -1;
    }

    @Deprecated
    public static int getSystemCpuLoad() {
        return SystemUtil.getCpuLoad();
    }

    public static String getUserName() {
        return SystemUtil.getProperty("user.name");
    }

    public static String getJavaName() {
        return SystemUtil.getProperty("java.runtime.name");
    }

    public static String getJavaVersion() {
        String result = SystemUtil.getProperty("java.runtime.version");
        if (result.equals("unknow")) {
            result = SystemUtil.getProperty("java.version");
        }
        return result;
    }

    public static double getJavaVersionAsNumber() {
        String version = SystemUtil.getJavaVersion().replaceAll("[^\\d.]", "");
        int firstSepInd = version.indexOf(46);
        if (firstSepInd >= 0) {
            if (version.substring(0, firstSepInd).equals("1")) {
                version = version.substring(firstSepInd + 1);
                firstSepInd = version.indexOf(46);
            }
            int lastSepInd = version.lastIndexOf(46);
            while (lastSepInd != firstSepInd) {
                version = version.substring(0, lastSepInd) + version.substring(lastSepInd + 1);
                lastSepInd = version.lastIndexOf(46);
            }
            if (version.charAt(firstSepInd + 1) == '0') {
                version = version.substring(0, lastSepInd + 1) + version.substring(lastSepInd + 2);
            }
        }
        return StringUtil.parseDouble(version, 0.0);
    }

    public static Version getJavaVersionAsVersion() {
        String version = SystemUtil.getJavaVersion().replaceAll("-", ".");
        version = version.replaceAll("_", ".");
        int firstSepInd = (version = version.replaceAll("[^\\d.]", "")).indexOf(46);
        if (firstSepInd >= 0 && version.substring(0, firstSepInd).equals("1")) {
            version = version.substring(firstSepInd + 1);
            firstSepInd = version.indexOf(46);
        }
        return new Version(version);
    }

    public static int getJavaArchDataModel() {
        return Integer.parseInt(SystemUtil.getProperty("sun.arch.data.model"));
    }

    public static String getOSName() {
        return SystemUtil.getProperty("os.name");
    }

    public static String getOSArch() {
        return SystemUtil.getProperty("os.arch");
    }

    public static String getOSVersion() {
        return SystemUtil.getProperty("os.version");
    }

    public static String getOSNameId() {
        if (SystemUtil.isWindows()) {
            return SYSTEM_WINDOWS;
        }
        if (SystemUtil.isMac()) {
            return SYSTEM_MAC_OS;
        }
        if (SystemUtil.isUnix()) {
            return SYSTEM_UNIX;
        }
        return "";
    }

    public static String getOSArchIdString() {
        String javaBit = Integer.toString(SystemUtil.getJavaArchDataModel());
        if (SystemUtil.isWindows()) {
            return SYSTEM_WINDOWS + javaBit;
        }
        if (SystemUtil.isMac()) {
            return SYSTEM_MAC_OS + javaBit;
        }
        if (SystemUtil.isUnix()) {
            return SYSTEM_UNIX + javaBit;
        }
        return "";
    }

    public static boolean isLinkSupported() {
        return SystemUtil.isMac() || SystemUtil.isUnix();
    }

    public static boolean is32bits() {
        return SystemUtil.getJavaArchDataModel() == 32;
    }

    public static boolean is64bits() {
        return SystemUtil.getJavaArchDataModel() == 64;
    }

    @Deprecated
    public static boolean isWindow() {
        return SystemUtil.isWindows();
    }

    public static boolean isWindows() {
        return SystemUtil.getOSName().toLowerCase().indexOf(SYSTEM_WINDOWS) >= 0;
    }

    public static boolean isMac() {
        return SystemUtil.getOSName().toLowerCase().indexOf(SYSTEM_MAC_OS) >= 0;
    }

    public static boolean isUnix() {
        String os = SystemUtil.getOSName().toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isWindows64() {
        if (!SystemUtil.isWindows()) {
            return false;
        }
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        if (wow64Arch != null && wow64Arch.endsWith("64")) {
            return true;
        }
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        return arch != null && arch.endsWith("64");
    }

    public static String getTempDirectory() {
        return FileUtil.getTempDirectory();
    }

    public static String getTempLibraryDirectory() {
        return FileUtil.getTempDirectory() + "/lib";
    }

    @Deprecated
    public static boolean addToJavaLibraryPath(String[] directories) {
        try {
            String path_separator = System.getProperty("path.separator");
            Field pathsField = ReflectionUtil.getField(ClassLoader.class, (String)"usr_paths", (boolean)true);
            ArrayList userPaths = CollectionUtil.asArrayList((Object[])((String[])pathsField.get(null)));
            for (String dir : directories) {
                if (userPaths.contains(dir)) continue;
                userPaths.add(dir);
            }
            pathsField.set(null, userPaths.toArray(new String[userPaths.size()]));
            return true;
        }
        catch (Throwable t) {
            if (SystemUtil.getJavaVersionAsNumber() >= 12.0) {
                System.out.println("Java 12 (or above) don't support patching java library path.");
                return false;
            }
            System.err.println(t.getMessage());
            System.err.println("Cannot patch Java Library Path...");
            return false;
        }
    }

    public static void loadLibrary(String dir, String name) {
        File libPath = new File(dir, System.mapLibraryName(name));
        if (libPath.exists()) {
            System.load(libPath.getAbsolutePath());
        } else {
            System.loadLibrary(name);
        }
    }

    public static void loadLibrary(String pathname) {
        File file = new File(pathname);
        if (file.exists()) {
            System.load(file.getAbsolutePath());
        } else {
            System.loadLibrary(pathname);
        }
    }
}

