/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.video;

import com.xuggle.ferry.JNIReference;
import com.xuggle.xuggler.IMediaData;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.AConverter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.atomic.AtomicReference;

public class ArgbConverter
extends AConverter {
    private static final int[] mBitMasks = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final ColorModel mColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);

    public ArgbConverter(IPixelFormat.Type pictureType, int pictureWidth, int pictureHeight, int imageWidth, int imageHeight) {
        super(pictureType, IPixelFormat.Type.ARGB, 2, pictureWidth, pictureHeight, imageWidth, imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVideoPicture toPicture(BufferedImage image, long timestamp) {
        this.validateImage(image);
        DataBuffer imageBuffer = image.getRaster().getDataBuffer();
        byte[] imageBytes = null;
        int[] imageInts = null;
        if (imageBuffer instanceof DataBufferByte) {
            imageBytes = ((DataBufferByte)imageBuffer).getData();
        } else if (imageBuffer instanceof DataBufferInt) {
            imageInts = ((DataBufferInt)imageBuffer).getData();
        } else {
            throw new IllegalArgumentException("Unsupported BufferedImage data buffer type: " + imageBuffer.getDataType());
        }
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        IMediaData resamplePicture = null;
        try {
            IVideoPicture picture = IVideoPicture.make(this.getRequiredPictureType(), image.getWidth(), image.getHeight());
            ByteBuffer pictureByteBuffer = picture.getByteBuffer(ref);
            if (imageInts != null) {
                pictureByteBuffer.order(ByteOrder.BIG_ENDIAN);
                IntBuffer pictureIntBuffer = pictureByteBuffer.asIntBuffer();
                pictureIntBuffer.put(imageInts);
            } else {
                pictureByteBuffer.put(imageBytes);
            }
            pictureByteBuffer = null;
            picture.setComplete(true, this.getRequiredPictureType(), image.getWidth(), image.getHeight(), timestamp);
            if (this.willResample()) {
                resamplePicture = picture;
                picture = ArgbConverter.resample((IVideoPicture)resamplePicture, this.mToPictureResampler);
            }
            IVideoPicture iVideoPicture = picture;
            return iVideoPicture;
        }
        finally {
            if (resamplePicture != null) {
                resamplePicture.delete();
            }
            if (ref.get() != null) {
                ((JNIReference)ref.get()).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage toImage(IVideoPicture picture) {
        this.validatePicture((IVideoPicture)picture);
        IMediaData resamplePic = null;
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        ByteBuffer byteBuf = null;
        IntBuffer intBuf = null;
        int[] ints = null;
        DataBufferInt db = null;
        SinglePixelPackedSampleModel sm = null;
        WritableRaster wr = null;
        try {
            if (this.willResample()) {
                picture = resamplePic = ArgbConverter.resample((IVideoPicture)picture, this.mToImageResampler);
            }
            int w = ((IVideoPicture)picture).getWidth();
            int h = ((IVideoPicture)picture).getHeight();
            byteBuf = picture.getByteBuffer(ref);
            byteBuf.order(ByteOrder.BIG_ENDIAN);
            intBuf = byteBuf.asIntBuffer();
            ints = new int[((IVideoPicture)picture).getSize() / 4];
            intBuf.get(ints, 0, ints.length);
            db = new DataBufferInt(ints, ints.length);
            sm = new SinglePixelPackedSampleModel(db.getDataType(), w, h, mBitMasks);
            wr = Raster.createWritableRaster(sm, db, null);
            BufferedImage bufferedImage = new BufferedImage(mColorModel, wr, false, null);
            return bufferedImage;
        }
        finally {
            if (resamplePic != null) {
                resamplePic.delete();
            }
            if (ref.get() != null) {
                ((JNIReference)ref.get()).delete();
            }
            if (byteBuf != null) {
                byteBuf.clear();
                byteBuf = null;
            }
            if (intBuf != null) {
                intBuf.clear();
                intBuf = null;
            }
            if (ints != null) {
                ints = null;
            }
            if (db != null) {
                db = null;
            }
            if (sm != null) {
                sm = null;
            }
            if (wr != null) {
                wr = null;
            }
        }
    }

    @Override
    public void delete() {
        super.close();
    }
}

