/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.file.FileUtil;
import icy.gui.dialog.SaveDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.plugin.interface_.PluginBundled;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.poi.ss.usermodel.Workbook;
import org.math.plot.Plot2DPanel;
import plugins.adufour.blocks.tools.io.WorkbookToFile;
import plugins.adufour.roi.ROIMeasures;
import plugins.adufour.roi.ROITrackStatistics;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarChannel;
import plugins.adufour.vars.lang.VarROIDescriptor;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarListener;
import plugins.fab.trackmanager.PluginTrackManagerProcessor;

public class ROIStatisticsTrackProcessor
extends PluginTrackManagerProcessor
implements PluginBundled {
    private final JButton exportButton = new JButton("Export to XLS...");
    private VarSequence sequence = new VarSequence("Sequence", null);
    final VarROIDescriptor roiDescriptor = new VarROIDescriptor("Plot:");
    private VarChannel channel = new VarChannel("Channel", (Var)this.sequence, false);
    VarEditor<Integer> channelSelector = this.channel.createVarEditor();
    private VarEditor<String> roiDescriptorSelector = this.roiDescriptor.createVarEditor(true);
    private final JPanel chartPanel = new JPanel();
    private final Plot2DPanel plotPanel = new Plot2DPanel();

    public String getMainPluginClassName() {
        return ROIMeasures.class.getName();
    }

    public ROIStatisticsTrackProcessor() {
        super.getDescriptor().setDescription("Monitor shape and intensity over time");
        super.setName("ROI Statistics");
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.panel.add(Box.createVerticalStrut(5));
        this.panel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createHorizontalStrut(10), new JLabel("Plot:"), Box.createHorizontalStrut(5), (JComponent)this.roiDescriptorSelector.getEditorComponent(), Box.createHorizontalStrut(10), new JLabel("Channel:"), Box.createHorizontalStrut(5), (JComponent)this.channelSelector.getEditorComponent(), Box.createHorizontalStrut(10), this.exportButton, Box.createHorizontalStrut(10)}));
        this.panel.add(this.chartPanel);
        this.exportButton.setEnabled(false);
        this.sequence.addListener((VarListener)new VarListener<Sequence>(){

            public void valueChanged(Var<Sequence> source, Sequence oldValue, Sequence newValue) {
                ROIStatisticsTrackProcessor.this.channelSelector.setEnabled(ROIDescriptor.getDescriptor((String)((String)ROIStatisticsTrackProcessor.this.roiDescriptor.getValue())).separateChannel());
                ROIStatisticsTrackProcessor.this.Compute();
            }

            public void referenceChanged(Var<Sequence> source, Var<? extends Sequence> oldReference, Var<? extends Sequence> newReference) {
            }
        });
        this.roiDescriptor.addListener((VarListener)new VarListener<String>(){

            public void valueChanged(Var<String> source, String oldValue, String newValue) {
                ROIStatisticsTrackProcessor.this.channelSelector.setEnabled(ROIDescriptor.getDescriptor((String)((String)ROIStatisticsTrackProcessor.this.roiDescriptor.getValue())).separateChannel());
                ROIStatisticsTrackProcessor.this.Compute();
            }

            public void referenceChanged(Var<String> source, Var<? extends String> oldReference, Var<? extends String> newReference) {
            }
        });
        this.channel.addListener((VarListener)new VarListener<Integer>(){

            public void valueChanged(Var<Integer> source, Integer oldValue, Integer newValue) {
                ROIStatisticsTrackProcessor.this.Compute();
            }

            public void referenceChanged(Var<Integer> source, Var<? extends Integer> oldReference, Var<? extends Integer> newReference) {
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROIStatisticsTrackProcessor.this.export();
            }
        });
        this.plotPanel.setPreferredSize(new Dimension(500, 300));
    }

    public void Close() {
        this.channelSelector.setEnabled(false);
    }

    public void Compute() {
        this.chartPanel.removeAll();
        if (!super.isEnabled()) {
            return;
        }
        Sequence seq = this.trackPool.getDisplaySequence();
        try {
            ROITrackStatistics.buildPlot(this.trackPool.getTrackGroupList(), seq, this.channel.getValue(), ROIDescriptor.getDescriptor((String)((String)this.roiDescriptor.getValue())), this.plotPanel);
            if (this.plotPanel.getPlots().size() > 0) {
                this.chartPanel.add((Component)this.plotPanel);
                this.exportButton.setEnabled(true);
            } else {
                this.chartPanel.add(new JLabel("No statistics available. This may happen when tracking particles (with no shape)"));
                this.exportButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.chartPanel.add(new JLabel("Cannot compute descriptor: " + e.getMessage()));
            this.exportButton.setEnabled(false);
        }
        this.panel.updateUI();
    }

    public void displaySequenceChanged() {
        this.sequence.setValue(this.trackPool.getDisplaySequence());
        this.Compute();
    }

    private void export() {
        if (this.plotPanel.getPlots().size() == 0) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Sequence seq = ROIStatisticsTrackProcessor.this.trackPool.getDisplaySequence();
                String name = ROIDescriptor.getDescriptor((String)((String)ROIStatisticsTrackProcessor.this.roiDescriptor.getValue())).getName();
                String xlsFolder = ROIStatisticsTrackProcessor.this.getPreferencesRoot().get("xlsFolder", null);
                String path = SaveDialog.chooseFile((String)"Export statistics", (String)xlsFolder, (String)name, (String)".xls");
                if (path == null) {
                    return;
                }
                ROIStatisticsTrackProcessor.this.getPreferencesRoot().put("xlsFolder", FileUtil.getDirectory((String)path));
                try (AnnounceFrame message = new AnnounceFrame("Exporting statistics...", 0);){
                    Workbook wb = ROITrackStatistics.getWorkBook(seq, name, ROIStatisticsTrackProcessor.this.plotPanel);
                    if (wb != null) {
                        WorkbookToFile.saveAsSpreadSheet((Workbook)wb, (String)path, (WorkbookToFile.MergePolicy)WorkbookToFile.MergePolicy.Overwrite);
                        wb.close();
                    }
                }
            }
        }.start();
    }
}

