/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi.intensitycenter;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.adufour.roi.intensitycenter.ROIIntensityCenterXDescriptor;
import plugins.adufour.roi.intensitycenter.ROIIntensityCenterYDescriptor;
import plugins.adufour.roi.intensitycenter.ROIIntensityCenterZDescriptor;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi3d.ROI3DPoint;

public class ROIIntensityCenterDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_MASS_CENTER_X = "Intensity center X";
    public static final String ID_MASS_CENTER_Y = "Intensity center Y";
    public static final String ID_MASS_CENTER_Z = "Intensity center Z";
    public static final ROIIntensityCenterXDescriptor intensityCenterXDescriptor = new ROIIntensityCenterXDescriptor();
    public static final ROIIntensityCenterYDescriptor intensityCenterYDescriptor = new ROIIntensityCenterYDescriptor();
    public static final ROIIntensityCenterZDescriptor intensityCenterZDescriptor = new ROIIntensityCenterZDescriptor();

    public static Point3D computeIntensityCenter(ROI roi, Sequence sequence) throws InterruptedException {
        Rectangle5D bounds = roi.getBounds5D();
        if (bounds.isEmpty()) {
            return new Point3D.Double(bounds.getX(), bounds.getY(), bounds.getZ());
        }
        if (roi instanceof ROI2DPoint || roi instanceof ROI3DPoint) {
            return new Point3D.Double(bounds.getX(), bounds.getY(), bounds.getZ());
        }
        if (bounds.getSizeX() * bounds.getSizeY() <= 1.0 && (bounds.isInfiniteZ() || bounds.getSizeZ() <= 1.0)) {
            return new Point3D.Double(bounds.getX(), bounds.getY(), bounds.getZ());
        }
        SequenceDataIterator it = new SequenceDataIterator(sequence, roi, true);
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double sumW = 0.0;
        long numPts = 0L;
        while (!it.done()) {
            max = Math.max(max, it.get());
            min = Math.min(min, it.get());
            it.next();
        }
        double valueDynamic = max - min == 0.0 ? 1.0 : max - min;
        double extra = max - min == 0.0 ? 1.0 : 0.0;
        it.reset();
        while (!it.done()) {
            if ((numPts & 0xFFFFL) == 0L && Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            double weight = (it.get() + extra - min) / valueDynamic;
            x += (double)it.getPositionX() * weight;
            y += (double)it.getPositionY() * weight;
            z += (double)it.getPositionZ() * weight;
            sumW += weight;
            ++numPts;
            it.next();
        }
        return new Point3D.Double(x / sumW, y / sumW, z / sumW);
    }

    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(intensityCenterXDescriptor);
        result.add(intensityCenterYDescriptor);
        result.add(intensityCenterZDescriptor);
        return result;
    }

    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        try {
            Point3D intensityCenter = ROIIntensityCenterDescriptorsPlugin.computeIntensityCenter(roi, sequence);
            result.put(intensityCenterXDescriptor, ROIIntensityCenterXDescriptor.getIntensityCenterX(intensityCenter));
            result.put(intensityCenterYDescriptor, ROIIntensityCenterYDescriptor.getIntensityCenterY(intensityCenter));
            result.put(intensityCenterZDescriptor, ROIIntensityCenterZDescriptor.getIntensityCenterZ(intensityCenter));
        }
        catch (Exception e) {
            String mess = ((Object)((Object)this)).getClass().getSimpleName() + ": cannot compute descriptors for '" + roi.getName() + "'";
            throw new UnsupportedOperationException(mess, e);
        }
        return result;
    }
}

