/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.TrimmedButton;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.plugin.frame.ContrastPlot;
import ij.plugin.frame.PlugInDialog;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.TrimmedLabel;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import ij.process.StackStatistics;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ContrastAdjuster
extends PlugInDialog
implements Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    public static final String LOC_KEY = "b&c.loc";
    public static final String[] sixteenBitRanges = new String[]{"Automatic", "8-bit (0-255)", "10-bit (0-1023)", "12-bit (0-4095)", "14-bit (0-16383)", "15-bit (0-32767)", "16-bit (0-65535)"};
    static final int AUTO_THRESHOLD = 5000;
    static final String[] channelLabels = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "All"};
    static final String[] altChannelLabels = new String[]{"Channel 1", "Channel 2", "Channel 3", "Channel 4", "Channel 5", "Channel 6", "All"};
    static final int[] channelConstants = new int[]{4, 2, 1, 3, 5, 6, 7};
    ContrastPlot plot = new ContrastPlot();
    Thread thread;
    private static ContrastAdjuster instance;
    int minSliderValue = -1;
    int maxSliderValue = -1;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    int previousImageID;
    int previousType;
    int previousSlice = 1;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label windowLabel;
    Label levelLabel;
    boolean done;
    int autoThreshold;
    GridBagLayout gridbag;
    GridBagConstraints c;
    int y = 0;
    boolean windowLevel;
    boolean balance;
    Font monoFont = new Font("Monospaced", 0, 11);
    Font sanFont = ImageJ.SansSerif12;
    int channels = 7;
    Choice choice;
    private String blankMinLabel = "-------";
    private String blankMaxLabel = "--------";
    private double scale = Prefs.getGuiScale();
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int MIN = 5;
    static final int MAX = 6;
    static final int BRIGHTNESS = 7;
    static final int CONTRAST = 8;
    static final int UPDATE = 9;

    public ContrastAdjuster() {
        super("B&C");
    }

    @Override
    public void run(String arg) {
        this.windowLevel = arg.equals("wl");
        this.balance = arg.equals("balance");
        if (this.windowLevel) {
            this.setTitle("W&L");
        } else if (this.balance) {
            this.setTitle("Color");
            this.channels = 4;
        }
        if (instance != null) {
            if (!instance.getTitle().equals(this.getTitle())) {
                ContrastAdjuster ca = instance;
                Prefs.saveLocation(LOC_KEY, ca.getLocation());
                ca.close();
            } else {
                instance.toFront();
                return;
            }
        }
        instance = this;
        IJ.register(ContrastAdjuster.class);
        WindowManager.addWindow(this);
        this.ij = IJ.getInstance();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        if (this.scale > 1.0) {
            this.sanFont = this.sanFont.deriveFont((float)((double)this.sanFont.getSize() * this.scale));
            this.monoFont = this.monoFont.deriveFont((float)((double)this.monoFont.getSize() * this.scale));
        }
        this.c.gridx = 0;
        this.y = 0;
        this.c.gridy = this.y++;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.gridbag.setConstraints(this.plot, this.c);
        this.add(this.plot);
        this.plot.addKeyListener(this.ij);
        if (!this.windowLevel) {
            this.panel = new Panel();
            this.c.gridy = this.y++;
            this.c.insets = new Insets(0, 10, 0, 10);
            this.gridbag.setConstraints(this.panel, this.c);
            this.panel.setLayout(new BorderLayout());
            this.minLabel = new Label(this.blankMinLabel, 0);
            this.minLabel.setFont(this.monoFont);
            if (IJ.debugMode) {
                this.minLabel.setBackground(Color.yellow);
            }
            this.panel.add("West", this.minLabel);
            this.maxLabel = new Label(this.blankMaxLabel, 2);
            this.maxLabel.setFont(this.monoFont);
            if (IJ.debugMode) {
                this.maxLabel.setBackground(Color.yellow);
            }
            this.panel.add("East", this.maxLabel);
            this.add(this.panel);
            this.blankMinLabel = "       ";
            this.blankMaxLabel = "        ";
        }
        if (!this.windowLevel) {
            this.minSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.minSlider, this.c);
            this.add(this.minSlider);
            this.minSlider.addAdjustmentListener(this);
            this.minSlider.addKeyListener(this.ij);
            this.minSlider.setUnitIncrement(1);
            this.minSlider.setFocusable(false);
            this.addLabel("Minimum", null);
        }
        if (!this.windowLevel) {
            this.maxSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.maxSlider, this.c);
            this.add(this.maxSlider);
            this.maxSlider.addAdjustmentListener(this);
            this.maxSlider.addKeyListener(this.ij);
            this.maxSlider.setUnitIncrement(1);
            this.maxSlider.setFocusable(false);
            this.addLabel("Maximum", null);
        }
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(this.windowLevel ? 12 : 2, 10, 0, 10);
        this.gridbag.setConstraints(this.brightnessSlider, this.c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.addKeyListener(this.ij);
        this.brightnessSlider.setUnitIncrement(1);
        this.brightnessSlider.setFocusable(false);
        if (this.windowLevel) {
            this.levelLabel = new TrimmedLabel("        ");
            this.addLabel("Level: ", this.levelLabel);
        } else {
            this.addLabel("Brightness", null);
        }
        if (!this.balance) {
            this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.contrastSlider, this.c);
            this.add(this.contrastSlider);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.addKeyListener(this.ij);
            this.contrastSlider.setUnitIncrement(1);
            this.contrastSlider.setFocusable(false);
            if (this.windowLevel) {
                this.windowLabel = new TrimmedLabel("        ");
                this.addLabel("Window: ", this.windowLabel);
            } else {
                this.addLabel("Contrast", null);
            }
        }
        if (this.balance) {
            this.c.gridy = this.y++;
            this.c.insets = new Insets(5, 10, 0, 10);
            this.choice = new Choice();
            this.addBalanceChoices();
            this.gridbag.setConstraints(this.choice, this.c);
            this.choice.addItemListener(this);
            this.add(this.choice);
        }
        if (this.scale > 1.0) {
            Font font = this.getFont();
            font = font != null ? font.deriveFont((float)((double)font.getSize() * this.scale)) : new Font("SansSerif", 0, (int)(12.0 * this.scale));
            this.setFont(font);
        }
        int trim = IJ.isMacOSX() ? 20 : 0;
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(0, 2, 0, 0));
        this.autoB = new TrimmedButton("Auto", trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.resetB = new TrimmedButton("Reset", trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", trim);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        this.applyB = new TrimmedButton("Apply", trim);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(8, 5, 10, 5);
        this.gridbag.setConstraints(this.panel, this.c);
        this.add(this.panel);
        this.addKeyListener(this.ij);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.centerOnImageJScreen(this);
        }
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.show();
        this.thread = new Thread((Runnable)this, "ContrastAdjuster");
        this.thread.start();
        this.setup();
    }

    void addBalanceChoices() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && imp.isComposite()) {
            for (int i = 0; i < altChannelLabels.length; ++i) {
                this.choice.addItem(altChannelLabels[i]);
            }
        } else {
            for (int i = 0; i < channelLabels.length; ++i) {
                this.choice.addItem(channelLabels[i]);
            }
        }
    }

    void addLabel(String text, Label label2) {
        if (label2 == null && IJ.isMacOSX()) {
            text = text + "    ";
        }
        this.panel = new Panel();
        this.c.gridy = this.y++;
        int bottomInset = IJ.isMacOSX() ? 4 : 0;
        this.c.insets = new Insets(0, 10, bottomInset, 0);
        this.gridbag.setConstraints(this.panel, this.c);
        this.panel.setLayout(new FlowLayout(label2 == null ? 1 : 0, 0, 0));
        TrimmedLabel label = new TrimmedLabel(text);
        label.setFont(this.sanFont);
        this.panel.add(label);
        if (label2 != null) {
            label2.setFont(this.monoFont);
            label2.setAlignment(0);
            this.panel.add(label2);
        }
        this.add(this.panel);
    }

    void setup() {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            if (imp.getType() == 4 && imp.isLocked()) {
                return;
            }
            this.setup(imp);
            this.updatePlot();
            this.updateLabels(imp);
            imp.updateAndDraw();
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        Object source = e.getSource();
        if (source == this.minSlider) {
            this.minSliderValue = this.minSlider.getValue();
        } else if (source == this.maxSlider) {
            this.maxSliderValue = this.maxSlider.getValue();
        } else if (source == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.setB) {
            this.doSet = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        Roi roi = imp.getRoi();
        if (roi != null) {
            roi.endPaste();
        }
        ImageProcessor ip = imp.getProcessor();
        int type = imp.getType();
        int slice = imp.getCurrentSlice();
        boolean bl = this.RGBImage = type == 4;
        if (imp.getID() != this.previousImageID || type != this.previousType || slice != this.previousSlice) {
            this.setupNewImage(imp, ip);
        }
        this.previousImageID = imp.getID();
        this.previousType = type;
        this.previousSlice = slice;
        return ip;
    }

    void setupNewImage(ImagePlus imp, ImageProcessor ip) {
        int bitDepth;
        boolean newRGBImage;
        Undo.reset();
        this.previousMin = this.min;
        this.previousMax = this.max;
        boolean bl = newRGBImage = this.RGBImage && !((ColorProcessor)ip).caSnapshot();
        if (newRGBImage) {
            ip.snapshot();
            ((ColorProcessor)ip).caSnapshot(true);
        }
        double min2 = imp.getDisplayRangeMin();
        double max2 = imp.getDisplayRangeMax();
        if (newRGBImage) {
            min2 = 0.0;
            max2 = 255.0;
        }
        if ((bitDepth = imp.getBitDepth()) == 16 || bitDepth == 32) {
            imp.resetDisplayRange();
            this.defaultMin = imp.getDisplayRangeMin();
            this.defaultMax = imp.getDisplayRangeMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.setMinAndMax(imp, min2, max2);
        this.min = imp.getDisplayRangeMin();
        this.max = imp.getDisplayRangeMax();
        if (IJ.debugMode) {
            IJ.log("min: " + this.min);
            IJ.log("max: " + this.max);
            IJ.log("defaultMin: " + this.defaultMin);
            IJ.log("defaultMax: " + this.defaultMax);
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        int valueRange = (int)(this.defaultMax - this.defaultMin);
        int newSliderRange = valueRange;
        if (newSliderRange > 640 && newSliderRange < 1280) {
            newSliderRange /= 2;
        } else if (newSliderRange >= 1280) {
            newSliderRange /= 5;
        }
        if (newSliderRange < 256) {
            newSliderRange = 256;
        }
        if (newSliderRange > 1024) {
            newSliderRange = 1024;
        }
        double displayRange = this.max - this.min;
        if (valueRange >= 1280 && valueRange != 0 && displayRange / (double)valueRange < 0.25) {
            newSliderRange = (int)((double)newSliderRange * 1.6666);
        }
        if (newSliderRange != this.sliderRange) {
            this.sliderRange = newSliderRange;
            this.updateScrollBars(null, true);
        } else {
            this.updateScrollBars(null, false);
        }
        if (this.balance) {
            if (imp.isComposite()) {
                int channel = imp.getChannel();
                if (channel <= 4) {
                    this.choice.select(channel - 1);
                    this.channels = channelConstants[channel - 1];
                }
                if (this.choice.getItem(0).equals("Red")) {
                    this.choice.removeAll();
                    this.addBalanceChoices();
                }
            } else if (this.choice.getItem(0).equals("Channel 1")) {
                this.choice.removeAll();
                this.addBalanceChoices();
            }
        }
        if (!this.doReset) {
            this.plotHistogram(imp);
        }
        this.autoThreshold = 0;
        if (imp.isComposite()) {
            IJ.setKeyUp(16);
        }
    }

    void setMinAndMax(ImagePlus imp, double min, double max) {
        boolean rgb;
        boolean bl = rgb = imp.getType() == 4;
        if (this.channels != 7 && rgb) {
            imp.setDisplayRange(min, max, this.channels);
        } else {
            imp.setDisplayRange(min, max);
        }
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp) {
        boolean realValue;
        double min = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        int type = imp.getType();
        Calibration cal = imp.getCalibration();
        boolean bl = realValue = type == 2;
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
            realValue = true;
        }
        if (this.windowLevel) {
            int digits = realValue ? 2 : 0;
            double window = max - min;
            double level = min + window / 2.0;
            this.windowLabel.setText(IJ.d2s(window, digits));
            this.levelLabel.setText(IJ.d2s(level, digits));
        } else {
            int digits;
            int n = digits = realValue ? 4 : 0;
            if (realValue) {
                double s = min < 0.0 || max < 0.0 ? 0.1 : 1.0;
                double amin = Math.abs(min);
                double amax = Math.abs(max);
                if (amin > 99.0 * s || amax > 99.0 * s) {
                    digits = 3;
                }
                if (amin > 999.0 * s || amax > 999.0 * s) {
                    digits = 2;
                }
                if (amin > 9999.0 * s || amax > 9999.0 * s) {
                    digits = 1;
                }
                if (amin > 99999.0 * s || amax > 99999.0 * s) {
                    digits = 0;
                }
                if (amin > 9999999.0 * s || amax > 9999999.0 * s) {
                    digits = -2;
                }
            }
            String minString = IJ.d2s(min, min == 0.0 ? 0 : digits) + this.blankMinLabel;
            this.minLabel.setText(minString.substring(0, this.blankMinLabel.length()));
            String maxString = this.blankMaxLabel + IJ.d2s(max, digits);
            maxString = maxString.substring(maxString.length() - this.blankMaxLabel.length(), maxString.length());
            this.maxLabel.setText(maxString);
        }
    }

    void updateScrollBars(Scrollbar sb, boolean newRange) {
        if (sb == null || sb != this.contrastSlider) {
            double mid = this.sliderRange / 2;
            double c = (this.defaultMax - this.defaultMin) / (this.max - this.min) * mid;
            if (c > mid) {
                c = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * mid;
            }
            this.contrast = (int)c;
            if (this.contrastSlider != null) {
                if (newRange) {
                    this.contrastSlider.setValues(this.contrast, 1, 0, this.sliderRange);
                } else {
                    this.contrastSlider.setValue(this.contrast);
                }
            }
        }
        if (sb == null || sb != this.brightnessSlider) {
            double level = this.min + (this.max - this.min) / 2.0;
            double normalizedLevel = 1.0 - (level - this.defaultMin) / (this.defaultMax - this.defaultMin);
            this.brightness = (int)(normalizedLevel * (double)this.sliderRange);
            if (newRange) {
                this.brightnessSlider.setValues(this.brightness, 1, 0, this.sliderRange);
            } else {
                this.brightnessSlider.setValue(this.brightness);
            }
        }
        if (this.minSlider != null && (sb == null || sb != this.minSlider)) {
            if (newRange) {
                this.minSlider.setValues(this.scaleDown(this.min), 1, 0, this.sliderRange);
            } else {
                this.minSlider.setValue(this.scaleDown(this.min));
            }
        }
        if (this.maxSlider != null && (sb == null || sb != this.maxSlider)) {
            if (newRange) {
                this.maxSlider.setValues(this.scaleDown(this.max), 1, 0, this.sliderRange);
            } else {
                this.maxSlider.setValue(this.scaleDown(this.max));
            }
        }
    }

    int scaleDown(double v) {
        if (v < this.defaultMin) {
            v = this.defaultMin;
        }
        if (v > this.defaultMax) {
            v = this.defaultMax;
        }
        return (int)((v - this.defaultMin) * ((double)this.sliderRange - 1.0) / (this.defaultMax - this.defaultMin));
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask = imp.getMask();
        if (mask != null) {
            Rectangle r = ip.getRoi();
            if (mask.getWidth() != r.width || mask.getHeight() != r.height) {
                ip.setRoi(imp.getRoi());
                mask = ip.getMask();
            }
            ip.reset(mask);
        }
    }

    void adjustMin(ImagePlus imp, ImageProcessor ip, double minvalue) {
        this.min = this.defaultMin + minvalue * (this.defaultMax - this.defaultMin) / ((double)this.sliderRange - 1.0);
        if (this.max > this.defaultMax) {
            this.max = this.defaultMax;
        }
        if (this.min > this.max) {
            this.max = this.min;
        }
        this.setMinAndMax(imp, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.minSlider, false);
    }

    void adjustMax(ImagePlus imp, ImageProcessor ip, double maxvalue) {
        this.max = this.defaultMin + maxvalue * (this.defaultMax - this.defaultMin) / ((double)this.sliderRange - 1.0);
        if (this.min < this.defaultMin) {
            this.min = this.defaultMin;
        }
        if (this.max < this.min) {
            this.min = this.max;
        }
        this.setMinAndMax(imp, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.maxSlider, false);
    }

    void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.max - this.min;
        this.min = center - width / 2.0;
        this.max = center + width / 2.0;
        this.setMinAndMax(imp, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.brightnessSlider, false);
    }

    void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.min + (this.max - this.min) / 2.0;
        double range = this.defaultMax - this.defaultMin;
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.min = center - 0.5 * range / slope;
            this.max = center + 0.5 * range / slope;
        }
        this.setMinAndMax(imp, this.min, this.max);
        if (this.RGBImage) {
            this.doMasking(imp, ip);
        }
        this.updateScrollBars(this.contrastSlider, false);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        int bitDepth;
        if (this.RGBImage) {
            ip.reset();
        }
        if ((bitDepth = imp.getBitDepth()) == 16 || bitDepth == 32) {
            imp.resetDisplayRange();
            this.defaultMin = imp.getDisplayRangeMin();
            this.defaultMax = imp.getDisplayRangeMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(imp, this.min, this.max);
        this.updateScrollBars(null, false);
        this.plotHistogram(imp);
        this.autoThreshold = 0;
    }

    void plotHistogram(ImagePlus imp) {
        ImageStatistics stats;
        if (this.balance && (this.channels == 4 || this.channels == 2 || this.channels == 1) && imp.getType() == 4) {
            int w = imp.getWidth();
            int h = imp.getHeight();
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            ((ColorProcessor)imp.getProcessor()).getRGB(r, g, b);
            byte[] pixels = null;
            if (this.channels == 4) {
                pixels = r;
            } else if (this.channels == 2) {
                pixels = g;
            } else if (this.channels == 1) {
                pixels = b;
            }
            ByteProcessor ip = new ByteProcessor(w, h, pixels, null);
            stats = ImageStatistics.getStatistics(ip, 0, imp.getCalibration());
        } else {
            int range;
            int n = range = imp.getType() == 1 ? ImagePlus.getDefault16bitRange() : 0;
            if (range != 0 && imp.getProcessor().getMax() == Math.pow(2.0, range) - 1.0 && !imp.getCalibration().isSigned16Bit()) {
                ImagePlus imp2 = new ImagePlus("Temp", imp.getProcessor());
                stats = new StackStatistics(imp2, 256, 0.0, Math.pow(2.0, range));
            } else {
                stats = imp.getStatistics();
            }
        }
        Color color = Color.gray;
        if (imp.isComposite() && (!this.balance || this.channels != 7)) {
            color = ((CompositeImage)imp).getChannelColor();
        }
        this.plot.setHistogram(stats, color);
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (this.balance && imp.isComposite()) {
            return;
        }
        String option = null;
        if (this.RGBImage) {
            imp.unlock();
        }
        if (!imp.lock()) {
            return;
        }
        if (this.RGBImage) {
            if (imp.getStackSize() > 1) {
                this.applyRGBStack(imp);
            } else {
                this.applyRGB(imp, ip);
            }
            return;
        }
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 32) {
            IJ.beep();
            IJ.showStatus("\"Apply\" does not work with 32-bit images");
            imp.unlock();
            return;
        }
        int range = 256;
        if (bitDepth == 16) {
            range = 65536;
            int defaultRange = imp.getDefault16bitRange();
            if (defaultRange > 0) {
                range = (int)Math.pow(2.0, defaultRange) - 1;
            }
        }
        int tableSize = bitDepth == 16 ? 65536 : 256;
        int[] table = new int[tableSize];
        int min = (int)imp.getDisplayRangeMin();
        int max = (int)imp.getDisplayRangeMax();
        if (IJ.debugMode) {
            IJ.log("Apply: mapping " + min + "-" + max + " to 0-" + (range - 1));
        }
        for (int i = 0; i < tableSize; ++i) {
            table[i] = i <= min ? 0 : (i >= max ? range - 1 : (int)((double)(i - min) / (double)(max - min) * (double)range));
        }
        ip.setRoi(imp.getRoi());
        if (imp.getStackSize() > 1 && !imp.isComposite()) {
            ImageStack stack = imp.getStack();
            YesNoCancelDialog d = new YesNoCancelDialog(new Frame(), "Entire Stack?", "Apply LUT to all " + stack.getSize() + " stack slices?");
            if (d.cancelPressed()) {
                imp.unlock();
                return;
            }
            if (d.yesPressed()) {
                if (imp.getStack().isVirtual()) {
                    imp.unlock();
                    IJ.error("\"Apply\" does not work with virtual stacks. Use\nImage>Duplicate to convert to a normal stack.");
                    return;
                }
                int current = imp.getCurrentSlice();
                ImageProcessor mask = imp.getMask();
                for (int i = 1; i <= imp.getStackSize(); ++i) {
                    imp.setSlice(i);
                    ip = imp.getProcessor();
                    if (mask != null) {
                        ip.snapshot();
                    }
                    ip.applyTable(table);
                    ip.reset(mask);
                }
                imp.setSlice(current);
                option = "stack";
            } else {
                ip.snapshot();
                ip.applyTable(table);
                ip.reset(ip.getMask());
                option = "slice";
            }
        } else {
            ip.snapshot();
            ip.applyTable(table);
            ip.reset(ip.getMask());
        }
        this.reset(imp, ip);
        imp.changes = true;
        imp.unlock();
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                if (option == null) {
                    option = "";
                }
                Recorder.recordCall("IJ.run(imp, \"Apply LUT\", \"" + option + "\");");
            } else if (option != null) {
                Recorder.record("run", "Apply LUT", option);
            } else {
                Recorder.record("run", "Apply LUT");
            }
        }
    }

    void applyRGB(ImagePlus imp, ImageProcessor ip) {
        double min = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        ip.setRoi(imp.getRoi());
        ip.reset();
        if (this.channels != 7) {
            ((ColorProcessor)ip).setMinAndMax(min, max, this.channels);
        } else {
            ip.setMinAndMax(min, max);
        }
        ip.reset(ip.getMask());
        imp.changes = true;
        this.previousImageID = 0;
        ((ColorProcessor)ip).caSnapshot(false);
        this.setup();
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.run(imp, \"Apply LUT\", \"\");");
            } else {
                Recorder.record("run", "Apply LUT");
            }
        }
    }

    private void applyRGBStack(ImagePlus imp) {
        double min = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        if (IJ.debugMode) {
            IJ.log("applyRGBStack: " + min + "-" + max);
        }
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel("Update Entire Stack?", "Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \nNOTE: There is no Undo for this operation.")) {
            return;
        }
        ImageProcessor mask = imp.getMask();
        Rectangle roi = imp.getRoi() != null ? imp.getRoi().getBounds() : null;
        ImageStack stack = imp.getStack();
        for (int i = 1; i <= n; ++i) {
            IJ.showProgress(i, n);
            IJ.showStatus(i + "/" + n);
            if (i == current) continue;
            ImageProcessor ip = stack.getProcessor(i);
            ip.setRoi(roi);
            if (mask != null) {
                ip.snapshot();
            }
            if (this.channels != 7) {
                ((ColorProcessor)ip).setMinAndMax(min, max, this.channels);
            } else {
                ip.setMinAndMax(min, max);
            }
            if (mask == null) continue;
            ip.reset(mask);
        }
        imp.setStack(null, stack);
        imp.setSlice(current);
        imp.changes = true;
        this.previousImageID = 0;
        this.setup();
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.run(imp, \"Apply LUT\", \"stack\");");
            } else {
                Recorder.record("run", "Apply LUT", "stack");
            }
        }
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(this.max, 255.0, 2);
        } else {
            ip.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        int count;
        if (this.RGBImage) {
            ip.reset();
        }
        ImageStatistics stats = imp.getRawStatistics();
        int limit = stats.pixelCount / 10;
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            if ((count = histogram[++i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            if ((count = histogram[--i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i > 0);
        int hmax = i;
        Roi roi = imp.getRoi();
        if (hmax >= hmin) {
            if (this.RGBImage) {
                imp.deleteRoi();
            }
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            if (this.min == this.max) {
                this.min = stats.min;
                this.max = stats.max;
            }
            this.setMinAndMax(imp, this.min, this.max);
            if (this.RGBImage && roi != null) {
                imp.setRoi(roi);
            }
        } else {
            this.reset(imp, ip);
            return;
        }
        this.updateScrollBars(null, false);
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.run(imp, \"Enhance Contrast\", \"saturated=0.35\");");
            } else {
                Recorder.record("run", "Enhance Contrast", "saturated=0.35");
            }
        }
    }

    void setMinAndMax(ImagePlus imp, ImageProcessor ip) {
        int range2;
        this.min = imp.getDisplayRangeMin();
        this.max = imp.getDisplayRangeMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        int channels = imp.getNChannels();
        GenericDialog gd = new GenericDialog("Set Display Range");
        gd.addNumericField("Minimum displayed value: ", minValue, digits);
        gd.addNumericField("Maximum displayed value: ", maxValue, digits);
        gd.addChoice("Unsigned 16-bit range:", sixteenBitRanges, sixteenBitRanges[ContrastAdjuster.get16bitRangeIndex()]);
        String label = "Propagate to all other ";
        label = imp.isComposite() ? label + channels + " channel images" : label + "open images";
        gd.addCheckbox(label, false);
        boolean allChannels = false;
        if (imp.isComposite() && channels > 1) {
            label = "Propagate to the other ";
            label = channels == 2 ? label + "channel of this image" : label + (channels - 1) + " channels of this image";
            gd.addCheckbox(label, allChannels);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        minValue = gd.getNextNumber();
        maxValue = gd.getNextNumber();
        minValue = cal.getRawValue(minValue);
        maxValue = cal.getRawValue(maxValue);
        int rangeIndex = gd.getNextChoiceIndex();
        int range1 = ImagePlus.getDefault16bitRange();
        if (range1 != (range2 = ContrastAdjuster.set16bitRange(rangeIndex)) && imp.getType() == 1 && !cal.isSigned16Bit()) {
            this.reset(imp, ip);
            minValue = imp.getDisplayRangeMin();
            maxValue = imp.getDisplayRangeMax();
        }
        boolean propagate = gd.getNextBoolean();
        if (imp.isComposite() && channels > 1) {
            allChannels = gd.getNextBoolean();
        }
        if (maxValue >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(imp, this.min, this.max);
            this.updateScrollBars(null, false);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
            if (allChannels) {
                int channel = imp.getChannel();
                for (int c = 1; c <= channels; ++c) {
                    imp.setPositionWithoutUpdate(c, imp.getSlice(), imp.getFrame());
                    imp.setDisplayRange(this.min, this.max);
                }
                ((CompositeImage)imp).reset();
                imp.setPosition(channel, imp.getSlice(), imp.getFrame());
            }
            if (propagate) {
                this.propagate(imp);
            }
            if (Recorder.record) {
                if (imp.getBitDepth() == 32) {
                    ContrastAdjuster.recordSetMinAndMax(this.min, this.max);
                } else {
                    int imin = (int)this.min;
                    int imax = (int)this.max;
                    if (cal.isSigned16Bit()) {
                        imin = (int)cal.getCValue(imin);
                        imax = (int)cal.getCValue(imax);
                    }
                    ContrastAdjuster.recordSetMinAndMax(imin, imax);
                }
                if (range2 > 0) {
                    if (Recorder.scriptMode()) {
                        Recorder.recordCall("ImagePlus.setDefault16bitRange(" + range2 + ");");
                    } else {
                        Recorder.recordString("call(\"ij.ImagePlus.setDefault16bitRange\", " + range2 + ");\n");
                    }
                }
            }
        }
    }

    private void propagate(ImagePlus img) {
        if (img.getBitDepth() == 24) {
            GenericDialog gd = new GenericDialog("Contrast Adjuster");
            gd.addMessage("Propagation of RGB images not supported. As a work-around,\nconvert images to multi-channel composite color.");
            gd.hideCancelButton();
            gd.showDialog();
            return;
        }
        int[] list = WindowManager.getIDList();
        if (list == null) {
            return;
        }
        int nImages = list.length;
        if (nImages <= 1) {
            return;
        }
        ImageProcessor ip = img.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int depth = img.getBitDepth();
        if (depth == 24) {
            return;
        }
        int id = img.getID();
        if (img.isComposite()) {
            int nChannels = img.getNChannels();
            for (int i = 0; i < nImages; ++i) {
                ImagePlus img2 = WindowManager.getImage(list[i]);
                if (img2 == null) continue;
                int nChannels2 = img2.getNChannels();
                if (!img2.isComposite() || img2.getBitDepth() != depth || img2.getID() == id || img2.getNChannels() != nChannels || img2.getWindow() == null) continue;
                int channel = img2.getChannel();
                for (int c = 1; c <= nChannels; ++c) {
                    LUT lut = ((CompositeImage)img).getChannelLut(c);
                    img2.setPosition(c, img2.getSlice(), img2.getFrame());
                    img2.setDisplayRange(lut.min, lut.max);
                    img2.updateAndDraw();
                }
                img2.setPosition(channel, img2.getSlice(), img2.getFrame());
            }
        } else {
            for (int i = 0; i < nImages; ++i) {
                ImagePlus img2 = WindowManager.getImage(list[i]);
                if (img2 == null || img2.getBitDepth() != depth || img2.getID() == id || img2.getNChannels() != 1 || img2.getWindow() == null) continue;
                ImageProcessor ip2 = img2.getProcessor();
                ip2.setMinAndMax(min, max);
                img2.updateAndDraw();
            }
        }
    }

    public static int get16bitRangeIndex() {
        int range = ImagePlus.getDefault16bitRange();
        int index = 0;
        if (range == 8) {
            index = 1;
        } else if (range == 10) {
            index = 2;
        } else if (range == 12) {
            index = 3;
        } else if (range == 14) {
            index = 4;
        } else if (range == 15) {
            index = 5;
        } else if (range == 16) {
            index = 6;
        }
        return index;
    }

    public static int set16bitRange(int index) {
        int range = 0;
        if (index == 1) {
            range = 8;
        } else if (index == 2) {
            range = 10;
        } else if (index == 3) {
            range = 12;
        } else if (index == 4) {
            range = 14;
        } else if (index == 5) {
            range = 15;
        } else if (index == 6) {
            range = 16;
        }
        ImagePlus.setDefault16bitRange(range);
        return range;
    }

    public static String[] getSixteenBitRanges() {
        return sixteenBitRanges;
    }

    void setWindowLevel(ImagePlus imp, ImageProcessor ip) {
        this.min = imp.getDisplayRangeMin();
        this.max = imp.getDisplayRangeMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        double windowValue = maxValue - minValue;
        double levelValue = minValue + windowValue / 2.0;
        GenericDialog gd = new GenericDialog("Set W&L");
        gd.addNumericField("Window Center (Level): ", levelValue, digits);
        gd.addNumericField("Window Width: ", windowValue, digits);
        gd.addCheckbox("Propagate to all open images", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        levelValue = gd.getNextNumber();
        windowValue = gd.getNextNumber();
        minValue = levelValue - windowValue / 2.0;
        maxValue = levelValue + windowValue / 2.0;
        minValue = cal.getRawValue(minValue);
        maxValue = cal.getRawValue(maxValue);
        boolean propagate = gd.getNextBoolean();
        if (maxValue >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(imp, minValue, maxValue);
            this.updateScrollBars(null, false);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
            if (propagate) {
                this.propagate(imp);
            }
            if (Recorder.record) {
                if (imp.getBitDepth() == 32) {
                    ContrastAdjuster.recordSetMinAndMax(this.min, this.max);
                } else {
                    int imin = (int)this.min;
                    int imax = (int)this.max;
                    if (cal.isSigned16Bit()) {
                        imin = (int)cal.getCValue(imin);
                        imax = (int)cal.getCValue(imax);
                    }
                    ContrastAdjuster.recordSetMinAndMax(imin, imax);
                }
            }
        }
    }

    public static void recordSetMinAndMax(double min, double max) {
        if ((double)((int)min) == min && (double)((int)max) == max) {
            int imin = (int)min;
            int imax = (int)max;
            if (Recorder.scriptMode()) {
                Recorder.recordCall("imp.setDisplayRange(" + imin + ", " + imax + ");");
            } else {
                Recorder.record("setMinAndMax", imin, imax);
            }
        } else if (Recorder.scriptMode()) {
            Recorder.recordCall("imp.setDisplayRange(" + IJ.d2s(min, 2) + ", " + IJ.d2s(max, 2) + ");");
        } else {
            Recorder.record("setMinAndMax", IJ.d2s(min, 2), IJ.d2s(max, 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            ContrastAdjuster contrastAdjuster = this;
            synchronized (contrastAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int minvalue = this.minSliderValue;
        int maxvalue = this.maxSliderValue;
        int bvalue = this.brightnessValue;
        int cvalue = this.contrastValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doSet) {
            action = 2;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.minSliderValue >= 0) {
            action = 5;
        } else if (this.maxSliderValue >= 0) {
            action = 6;
        } else if (this.brightnessValue >= 0) {
            action = 7;
        } else if (this.contrastValue >= 0) {
            action = 8;
        } else {
            return;
        }
        this.contrastValue = -1;
        this.brightnessValue = -1;
        this.maxSliderValue = -1;
        this.minSliderValue = -1;
        this.doApplyLut = false;
        this.doSet = false;
        this.doAutoAdjust = false;
        this.doReset = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        if (imp.getOverlay() != null && imp.getOverlay().isCalibrationBar()) {
            IJ.beep();
            IJ.showStatus("Has calibration bar");
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        if (this.RGBImage && !imp.lock()) {
            imp = null;
            return;
        }
        switch (action) {
            case 0: {
                this.reset(imp, ip);
                if (!Recorder.record) break;
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("IJ.resetMinAndMax(imp);");
                    break;
                }
                Recorder.record("resetMinAndMax");
                break;
            }
            case 1: {
                this.autoAdjust(imp, ip);
                break;
            }
            case 2: {
                if (this.windowLevel) {
                    this.setWindowLevel(imp, ip);
                    break;
                }
                this.setMinAndMax(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp, ip);
                break;
            }
            case 5: {
                this.adjustMin(imp, ip, minvalue);
                break;
            }
            case 6: {
                this.adjustMax(imp, ip, maxvalue);
                break;
            }
            case 7: {
                this.adjustBrightness(imp, ip, bvalue);
                break;
            }
            case 8: {
                this.adjustContrast(imp, ip, cvalue);
            }
        }
        this.updatePlot();
        this.updateLabels(imp);
        if ((IJ.shiftKeyDown() || this.balance && this.channels == 7) && imp.isComposite()) {
            ((CompositeImage)imp).updateAllChannelsAndDraw();
        } else {
            imp.updateChannelAndDraw();
        }
        if (this.RGBImage) {
            imp.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        ContrastAdjuster contrastAdjuster = this;
        synchronized (contrastAdjuster) {
            this.notify();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
        ImagePlus imp2;
        super.windowActivated(e);
        if (IJ.isMacro() && (imp2 = WindowManager.getCurrentImage()) != null && imp2.getBitDepth() == 24) {
            return;
        }
        this.previousImageID = 0;
        this.setup();
        WindowManager.setWindow(this);
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        int index = this.choice.getSelectedIndex();
        this.channels = channelConstants[index];
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && imp.isComposite()) {
            if (index + 1 <= imp.getNChannels()) {
                imp.setPosition(index + 1, imp.getSlice(), imp.getFrame());
            } else {
                this.choice.select(channelLabels.length - 1);
                this.channels = 7;
            }
        } else {
            this.doReset = true;
        }
        this.notify();
    }

    public void updateAndDraw() {
        this.previousImageID = 0;
        this.toFront();
    }

    public static void update() {
        if (instance != null) {
            ContrastAdjuster.instance.previousImageID = 0;
            instance.setup();
        }
    }
}

