/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.io.EndianType;
import jj2000.j2k.io.RandomAccessIO;

public abstract class BufferedRandomAccessFile
implements RandomAccessIO,
EndianType {
    private String fileName;
    private boolean isReadOnly = true;
    private RandomAccessFile theFile;
    protected byte[] byteBuffer;
    protected boolean byteBufferChanged;
    protected int offset;
    protected int pos;
    protected int maxByte;
    protected boolean isEOFInBuffer;
    protected int byteOrdering;

    protected BufferedRandomAccessFile(File file2, String mode, int bufferSize) throws IOException {
        this.fileName = file2.getName();
        if (mode.equals("rw") || mode.equals("rw+")) {
            this.isReadOnly = false;
            if (mode.equals("rw") && file2.exists()) {
                file2.delete();
            }
            mode = "rw";
        }
        this.theFile = new RandomAccessFile(file2, mode);
        this.byteBuffer = new byte[bufferSize];
        this.readNewBuffer(0);
    }

    protected BufferedRandomAccessFile(File file2, String mode) throws IOException {
        this(file2, mode, 512);
    }

    protected BufferedRandomAccessFile(String name, String mode, int bufferSize) throws IOException {
        this(new File(name), mode, bufferSize);
    }

    protected BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(name, mode, 512);
    }

    protected final void readNewBuffer(int off) throws IOException {
        if (this.byteBufferChanged) {
            this.flush();
        }
        if (this.isReadOnly && (long)off >= this.theFile.length()) {
            throw new EOFException();
        }
        this.offset = off;
        this.theFile.seek(this.offset);
        this.maxByte = this.theFile.read(this.byteBuffer, 0, this.byteBuffer.length);
        this.pos = 0;
        if (this.maxByte < this.byteBuffer.length) {
            this.isEOFInBuffer = true;
            if (this.maxByte == -1) {
                ++this.maxByte;
            }
        } else {
            this.isEOFInBuffer = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.byteBuffer = null;
        this.theFile.close();
    }

    @Override
    public int getPos() {
        return this.offset + this.pos;
    }

    @Override
    public int length() throws IOException {
        int len = (int)this.theFile.length();
        if (this.offset + this.maxByte <= len) {
            return len;
        }
        return this.offset + this.maxByte;
    }

    @Override
    public void seek(int off) throws IOException {
        if (off >= this.offset && off < this.offset + this.byteBuffer.length) {
            if (this.isReadOnly && this.isEOFInBuffer && off > this.offset + this.maxByte) {
                throw new EOFException();
            }
            this.pos = off - this.offset;
        } else {
            this.readNewBuffer(off);
        }
    }

    @Override
    public final int read() throws IOException, EOFException {
        if (this.pos < this.maxByte) {
            return this.byteBuffer[this.pos++] & 0xFF;
        }
        if (this.isEOFInBuffer) {
            this.pos = this.maxByte + 1;
            throw new EOFException();
        }
        this.readNewBuffer(this.offset + this.pos);
        return this.read();
    }

    @Override
    public final void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            if (this.pos < this.maxByte) {
                int clen = this.maxByte - this.pos;
                if (clen > len) {
                    clen = len;
                }
                System.arraycopy(this.byteBuffer, this.pos, b, off, clen);
                this.pos += clen;
                off += clen;
                len -= clen;
                continue;
            }
            if (this.isEOFInBuffer) {
                this.pos = this.maxByte + 1;
                throw new EOFException();
            }
            this.readNewBuffer(this.offset + this.pos);
        }
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.pos < this.byteBuffer.length) {
            if (this.isReadOnly) {
                throw new IOException("File is read only");
            }
            this.byteBuffer[this.pos] = (byte)b;
            if (this.pos >= this.maxByte) {
                this.maxByte = this.pos + 1;
            }
            ++this.pos;
            this.byteBufferChanged = true;
        } else {
            this.readNewBuffer(this.offset + this.pos);
            this.write(b);
        }
    }

    public final void write(byte b) throws IOException {
        if (this.pos < this.byteBuffer.length) {
            if (this.isReadOnly) {
                throw new IOException("File is read only");
            }
            this.byteBuffer[this.pos] = b;
            if (this.pos >= this.maxByte) {
                this.maxByte = this.pos + 1;
            }
            ++this.pos;
            this.byteBufferChanged = true;
        } else {
            this.readNewBuffer(this.offset + this.pos);
            this.write(b);
        }
    }

    public final void write(byte[] b, int offset, int length) throws IOException {
        int stop = offset + length;
        if (stop > b.length) {
            throw new ArrayIndexOutOfBoundsException(b.length);
        }
        for (int i = offset; i < stop; ++i) {
            this.write(b[i]);
        }
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public final void flush() throws IOException {
        if (this.byteBufferChanged) {
            this.theFile.seek(this.offset);
            this.theFile.write(this.byteBuffer, 0, this.maxByte);
            this.byteBufferChanged = false;
        }
    }

    @Override
    public final byte readByte() throws EOFException, IOException {
        if (this.pos < this.maxByte) {
            return this.byteBuffer[this.pos++];
        }
        if (this.isEOFInBuffer) {
            this.pos = this.maxByte + 1;
            throw new EOFException();
        }
        this.readNewBuffer(this.offset + this.pos);
        return this.readByte();
    }

    @Override
    public final int readUnsignedByte() throws EOFException, IOException {
        return this.read();
    }

    @Override
    public int getByteOrdering() {
        return this.byteOrdering;
    }

    @Override
    public int skipBytes(int n) throws EOFException, IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can not skip negative number of bytes");
        }
        if (n <= this.maxByte - this.pos) {
            this.pos += n;
            return n;
        }
        this.seek(this.offset + this.pos + n);
        return n;
    }

    public String toString() {
        return "BufferedRandomAccessFile: " + this.fileName + " (" + (this.isReadOnly ? "read only" : "read/write") + ")";
    }
}

