/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import com.google.common.collect.MapMaker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import loci.common.BZip2Handle;
import loci.common.GZipHandle;
import loci.common.IRandomAccess;
import loci.common.NIOFileHandle;
import loci.common.S3Handle;
import loci.common.StreamHandle;
import loci.common.URLHandle;
import loci.common.ZipHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Location {
    private static final Logger LOGGER = LoggerFactory.getLogger(Location.class);
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static ThreadLocal<HashMap<String, Object>> idMap = new ThreadLocal<HashMap<String, Object>>(){

        @Override
        protected HashMap<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private static volatile boolean cacheListings = false;
    private static volatile long cacheNanos = 3600000000000L;
    private static final Map<String, ListingsResult> fileListings = new MapMaker().makeMap();
    private static final Pattern URL_MATCHER = Pattern.compile("\\p{Alnum}+(\\+\\p{Alnum}+)?://.*");
    private static final Pattern URL_ABOVE_PARENT = Pattern.compile("\\p{Alnum}+(\\+\\p{Alnum}+)?:/$");
    private boolean isURL = false;
    private UrlType urlType;
    private URL url;
    private URI uri;
    private File file;
    private URLLocationProperties cachedProperties;

    public Location(String pathname) {
        this((String)null, pathname);
    }

    public Location(File file2) {
        LOGGER.trace("Location({})", (Object)file2);
        this.isURL = false;
        this.file = file2;
    }

    public Location(String parent, String child) {
        LOGGER.trace("Location({}, {})", (Object)parent, (Object)child);
        String mapped = null;
        String pathname = null;
        if (child != null && URL_MATCHER.matcher(child).matches()) {
            try {
                mapped = Location.getMappedId(child);
                pathname = child;
                this.uri = new URI(mapped);
                this.isURL = true;
                if (S3Handle.canHandleScheme(this.uri.toString())) {
                    this.urlType = UrlType.S3;
                    this.url = null;
                } else {
                    this.urlType = UrlType.GENERIC;
                    this.url = this.uri.toURL();
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.debug("Invalid URL: {} {}", (Object)child, (Object)e);
                this.isURL = false;
                this.urlType = null;
                this.url = null;
                this.uri = null;
            }
        }
        if (pathname == null) {
            pathname = parent != null ? parent + File.separator + child : child;
            mapped = Location.getMappedId(pathname);
        }
        if (!this.isURL) {
            this.file = new File(mapped);
        }
    }

    public Location(Location parent, String child) {
        this(parent == null ? (String)null : parent.getAbsolutePath(), child);
    }

    public static void reset() {
        cacheListings = false;
        cacheNanos = 3600000000000L;
        fileListings.clear();
        Location.getIdMap().clear();
    }

    public static void cacheDirectoryListings(boolean cache) {
        cacheListings = cache;
    }

    public static void setCacheDirectoryTimeout(double sec) {
        cacheNanos = (long)(sec * 1000.0 * 1000.0 * 1000.0);
    }

    public static void clearDirectoryListingsCache() {
        fileListings.clear();
    }

    public static void cleanStaleCacheEntries() {
        long t = System.nanoTime() - cacheNanos;
        Iterator<ListingsResult> cacheValues = fileListings.values().iterator();
        while (cacheValues.hasNext()) {
            if (cacheValues.next().time >= t) continue;
            cacheValues.remove();
        }
    }

    public static void mapId(String id, String filename) {
        if (id == null) {
            return;
        }
        if (filename == null) {
            Location.getIdMap().remove(id);
        } else {
            Location.getIdMap().put(id, filename);
        }
        LOGGER.debug("Location.mapId: {} -> {}", (Object)id, (Object)filename);
    }

    public static void mapFile(String id, IRandomAccess ira) {
        if (id == null) {
            return;
        }
        if (ira == null) {
            Location.getIdMap().remove(id);
        } else {
            Location.getIdMap().put(id, ira);
        }
        LOGGER.debug("Location.mapFile: {} -> {}", (Object)id, (Object)ira);
    }

    public static String getMappedId(String id) {
        if (Location.getIdMap() == null) {
            return id;
        }
        String filename = null;
        if (id != null && Location.getIdMap().get(id) instanceof String) {
            filename = (String)Location.getIdMap().get(id);
        }
        return filename == null ? id : filename;
    }

    public static IRandomAccess getMappedFile(String id) {
        if (Location.getIdMap() == null) {
            return null;
        }
        IRandomAccess ira = null;
        if (id != null && Location.getIdMap().get(id) instanceof IRandomAccess) {
            ira = (IRandomAccess)Location.getIdMap().get(id);
        }
        return ira;
    }

    public static HashMap<String, Object> getIdMap() {
        return idMap.get();
    }

    public static void setIdMap(HashMap<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null");
        }
        idMap.set(map);
    }

    public static IRandomAccess getHandle(String id) throws IOException {
        return Location.getHandle(id, false);
    }

    public static IRandomAccess getHandle(String id, boolean writable) throws IOException {
        return Location.getHandle(id, writable, true);
    }

    public static IRandomAccess getHandle(String id, boolean writable, boolean allowArchiveHandles) throws IOException {
        return Location.getHandle(id, writable, allowArchiveHandles, 0);
    }

    public static IRandomAccess getHandle(String id, boolean writable, boolean allowArchiveHandles, int bufferSize) throws IOException {
        LOGGER.trace("getHandle(id = {}, writable = {})", (Object)id, (Object)writable);
        IRandomAccess handle = Location.getMappedFile(id);
        if (handle == null) {
            LOGGER.trace("no handle was mapped for this ID");
            String mapId = Location.getMappedId(id);
            if (S3Handle.canHandleScheme(id)) {
                StreamHandle.Settings ss = new StreamHandle.Settings();
                if (ss.getRemoteCacheRootDir() != null) {
                    String cachedFile = S3Handle.cacheObject(mapId, ss);
                    handle = bufferSize > 0 ? new NIOFileHandle(new File(cachedFile), "r", bufferSize) : new NIOFileHandle(cachedFile, "r");
                } else {
                    handle = new S3Handle(mapId);
                }
            } else {
                handle = id.startsWith("http://") || id.startsWith("https://") ? new URLHandle(mapId) : (allowArchiveHandles && ZipHandle.isZipFile(mapId) ? new ZipHandle(mapId) : (allowArchiveHandles && GZipHandle.isGZipFile(mapId) ? new GZipHandle(mapId) : (allowArchiveHandles && BZip2Handle.isBZip2File(mapId) ? new BZip2Handle(mapId) : (bufferSize > 0 ? new NIOFileHandle(new File(mapId), writable ? "rw" : "r", bufferSize) : new NIOFileHandle(mapId, writable ? "rw" : "r")))));
            }
            LOGGER.trace("Created new handle {} -> {}", (Object)id, (Object)handle);
        }
        LOGGER.trace("Location.getHandle: {} -> {}", (Object)id, (Object)handle);
        return handle;
    }

    public static void checkValidId(String id) throws IOException {
        if (Location.getMappedFile(id) != null) {
            return;
        }
        Location.getHandle(id).close();
    }

    public String[] list(boolean noHiddenFiles) {
        ArrayList<String> files;
        String[] result;
        String key;
        block17: {
            LOGGER.trace("list({})", (Object)noHiddenFiles);
            key = this.getAbsolutePath() + Boolean.toString(noHiddenFiles);
            result = null;
            if (cacheListings) {
                Location.cleanStaleCacheEntries();
                ListingsResult listingsResult = fileListings.get(key);
                if (listingsResult != null) {
                    return listingsResult.listing;
                }
            }
            files = new ArrayList<String>();
            if (this.isURL) {
                try {
                    String input;
                    if (this.urlType == UrlType.S3) {
                        if (this.isDirectory()) {
                            LOGGER.trace("list s3 {}: Returning []", (Object)this.uri);
                            return new String[0];
                        }
                        LOGGER.trace("list s3 {}: Returning null", (Object)this.uri);
                        return null;
                    }
                    URLConnection c = this.url.openConnection();
                    InputStream is = c.getInputStream();
                    boolean foundEnd = false;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    StringBuffer buffer = new StringBuffer();
                    while ((input = br.readLine()) != null) {
                        buffer.append(input);
                    }
                    br.close();
                    String s2 = buffer.toString();
                    while (!foundEnd) {
                        int ndx;
                        int idx;
                        if (s2.toLowerCase().indexOf("</html>") != -1) {
                            foundEnd = true;
                        }
                        while (s2.indexOf("a href") != -1 && (idx = s2.indexOf("\"", ndx = s2.indexOf("a href") + 8)) >= 0) {
                            Location check;
                            String f = s2.substring(ndx, idx);
                            if (files.size() > 0 && f.startsWith("/")) {
                                return null;
                            }
                            s2 = s2.substring(idx + 1);
                            if (f.startsWith("?") || !(check = new Location(this.getAbsolutePath(), f)).exists() || noHiddenFiles && check.isHidden()) continue;
                            files.add(check.getName());
                        }
                    }
                    is.close();
                    if (files.size() == 0) {
                        return null;
                    }
                    break block17;
                }
                catch (IOException e) {
                    LOGGER.trace("Could not retrieve directory listing", e);
                    return null;
                }
            }
            if (this.file == null) {
                return null;
            }
            String[] f = this.file.list();
            if (f == null) {
                return null;
            }
            String path = this.file.getAbsolutePath();
            for (String name : f) {
                if (noHiddenFiles && (name.startsWith(".") || new Location(path, name).isHidden())) continue;
                files.add(name);
            }
        }
        result = files.toArray(new String[files.size()]);
        if (cacheListings) {
            fileListings.put(key, new ListingsResult(result, System.nanoTime()));
        }
        LOGGER.trace("  returning {} files", (Object)files.size());
        return result;
    }

    public boolean canRead() {
        LOGGER.trace("canRead()");
        return this.isURL ? this.isDirectory() || this.isFile() : this.file.canRead();
    }

    public boolean canWrite() {
        LOGGER.trace("canWrite()");
        return this.isURL ? false : this.file.canWrite();
    }

    public boolean createNewFile() throws IOException {
        if (this.isURL) {
            throw new IOException("Unimplemented");
        }
        return this.file.createNewFile();
    }

    public boolean mkdirs() {
        if (this.file == null) {
            return false;
        }
        return this.file.mkdirs();
    }

    public boolean delete() {
        return this.isURL ? false : this.file.delete();
    }

    public void deleteOnExit() {
        if (!this.isURL) {
            this.file.deleteOnExit();
        }
    }

    public boolean equals(Object obj) {
        String absPath = this.getAbsolutePath();
        String thatPath = null;
        thatPath = obj instanceof Location ? ((Location)obj).getAbsolutePath() : obj.toString();
        return absPath.equals(thatPath);
    }

    public int hashCode() {
        return this.getAbsolutePath().hashCode();
    }

    public boolean exists() {
        if (this.isURL) {
            LOGGER.trace("exists(url)");
            if (this.cachedProperties == null) {
                this.cachedProperties = new URLLocationProperties(this);
            }
            return this.cachedProperties.exists;
        }
        LOGGER.trace("exists(file)");
        if (this.file.exists()) {
            return true;
        }
        if (Location.getMappedFile(this.file.getPath()) != null) {
            return true;
        }
        String mappedId = Location.getMappedId(this.file.getPath());
        return mappedId != null && new File(mappedId).exists();
    }

    public Location getAbsoluteFile() {
        return new Location(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        LOGGER.trace("getAbsolutePath()");
        return this.isURL ? this.uri.normalize().toString() : this.file.getAbsolutePath();
    }

    public Location getCanonicalFile() throws IOException {
        return this.isURL ? this.getAbsoluteFile() : new Location(this.file.getCanonicalFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.isURL ? this.getAbsolutePath() : this.file.getCanonicalPath();
    }

    public String getName() {
        LOGGER.trace("getName()");
        if (this.isURL) {
            return new File(this.uri.getPath()).getName();
        }
        return this.file.getName();
    }

    public String getParent() {
        LOGGER.trace("getParent()");
        if (this.isURL) {
            String absPath = this.getAbsolutePath();
            if (URL_ABOVE_PARENT.matcher(absPath = absPath.substring(0, absPath.lastIndexOf("/"))).matches()) {
                return null;
            }
            return absPath;
        }
        return this.file.getParent();
    }

    public Location getParentFile() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new Location(parent);
    }

    public String getPath() {
        return this.isURL ? this.uri.getHost() + this.uri.getPath() : this.file.getPath();
    }

    public boolean isAbsolute() {
        LOGGER.trace("isAbsolute()");
        return this.isURL ? this.uri.isAbsolute() : this.file.isAbsolute();
    }

    public boolean isDirectory() {
        LOGGER.trace("isDirectory()");
        if (this.isURL) {
            if (this.urlType == UrlType.S3) {
                try {
                    S3Handle h2 = new S3Handle(this.uri.toString());
                    boolean isBucket = h2.isBucket();
                    h2.close();
                    return isBucket;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            String[] list = this.list();
            return list != null;
        }
        return this.file.isDirectory();
    }

    public boolean isFile() {
        LOGGER.trace("isFile()");
        return this.isURL ? !this.isDirectory() && this.exists() : this.file.isFile();
    }

    public boolean isHidden() {
        LOGGER.trace("isHidden()");
        if (this.isURL) {
            return false;
        }
        boolean dotFile = this.file.getName().startsWith(".");
        if (IS_WINDOWS) {
            return dotFile || this.file.isHidden();
        }
        return dotFile;
    }

    public long lastModified() {
        LOGGER.trace("lastModified()");
        if (this.isURL) {
            try {
                if (this.url != null) {
                    return this.url.openConnection().getLastModified();
                }
                return 0L;
            }
            catch (IOException e) {
                LOGGER.trace("Could not determine URL's last modification time", e);
                return 0L;
            }
        }
        return this.file.lastModified();
    }

    public long length() {
        if (this.isURL) {
            LOGGER.trace("length(url)");
            this.exists();
            return this.cachedProperties.length;
        }
        LOGGER.trace("length(file)");
        return this.file.length();
    }

    public String[] list() {
        return this.list(false);
    }

    public Location[] listFiles() {
        String[] s2 = this.list();
        if (s2 == null) {
            return null;
        }
        Location[] f = new Location[s2.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = new Location(this.getAbsolutePath(), s2[i]);
            f[i] = f[i].getAbsoluteFile();
        }
        return f;
    }

    public URL toURL() throws MalformedURLException {
        return this.isURL ? this.url : this.file.toURI().toURL();
    }

    public String toString() {
        return this.isURL ? this.uri.toString() : this.file.toString();
    }

    class URLLocationProperties {
        public final long length;
        public final boolean exists;

        public URLLocationProperties(Location loc) {
            LOGGER.trace("Getting LocationProperties");
            boolean bexists = false;
            long llength = 0L;
            if (!loc.isURL) {
                throw new IllegalArgumentException("Location must be a URL");
            }
            try {
                IRandomAccess handle = Location.getHandle(Location.this.uri.toString());
                try {
                    bexists = handle.exists();
                }
                catch (IOException e) {
                    LOGGER.trace("Failed to retrieve content from URL", e);
                }
                if (bexists) {
                    try {
                        llength = handle.length();
                    }
                    catch (IOException e) {
                        LOGGER.trace("Could not determine URL's content length", e);
                    }
                }
                handle.close();
            }
            catch (IOException e) {
                LOGGER.trace("Failed to retrieve content from URL", e);
            }
            this.exists = bexists;
            this.length = llength;
            LOGGER.trace("exists:{} length:{}", (Object)bexists, (Object)llength);
        }
    }

    protected class ListingsResult {
        public final String[] listing;
        public final long time;

        ListingsResult(String[] listing, long time) {
            this.listing = listing;
            this.time = time;
        }
    }

    protected static enum UrlType {
        GENERIC,
        S3;

    }
}

