/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassList<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassList.class);
    private static final String[] KEYS = new String[]{"type"};
    private Class<T> base;
    private List<Class<? extends T>> classes;
    private Map<String, String> options;

    public ClassList(Class<T> base) {
        this.base = base;
        this.classes = new ArrayList<Class<? extends T>>();
        this.options = new HashMap<String, String>();
    }

    public ClassList(String file2, Class<T> base) throws IOException {
        this(file2, base, ClassList.class);
    }

    public ClassList(String file2, Class<T> base, Class<?> location) throws IOException {
        this(base);
        if (file2 == null) {
            return;
        }
        this.parseFile(file2, location);
    }

    public Map<String, String> parseOptions(String s2) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st1 = new StringTokenizer(s2, ",");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            if (!st2.hasMoreTokens()) continue;
            String key = st2.nextToken();
            if (!st2.hasMoreTokens()) continue;
            map.put(key, st2.nextToken());
        }
        return map;
    }

    public void parseLine(String line) {
        int ndx = line.indexOf(35);
        if (ndx >= 0) {
            line = line.substring(0, ndx);
        }
        if ((line = line.trim()).equals("")) {
            return;
        }
        Map<Object, Object> o = new HashMap();
        if (line.endsWith("]") && (ndx = line.indexOf(91)) >= 0) {
            o = this.parseOptions(line.substring(ndx + 1, line.length() - 1));
            line = line.substring(0, ndx).trim();
        }
        Class<T> c = null;
        try {
            Class<?> rawClass = Class.forName(line);
            c = this.cast(rawClass);
        }
        catch (ClassNotFoundException exc) {
            LOGGER.debug("Could not find {}", (Object)line, (Object)exc);
        }
        catch (NoClassDefFoundError err) {
            LOGGER.debug("Could not find {}", (Object)line, (Object)err);
        }
        catch (ExceptionInInitializerError err) {
            LOGGER.debug("Failed to create an instance of {}", (Object)line, (Object)err);
        }
        catch (RuntimeException exc) {
            String msg = exc.getMessage();
            if (msg != null && msg.indexOf("ClassNotFound") < 0) {
                throw exc;
            }
            LOGGER.debug("", exc);
        }
        if (c == null) {
            if (!o.containsKey("type") || !((String)o.get("type")).equals("external")) {
                LOGGER.error("\"{}\" is not valid.", (Object)line);
            }
        } else {
            this.classes.add(c);
            for (Map.Entry<Object, Object> entry : o.entrySet()) {
                this.addOption(line + "." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void parseFile(String file2, Class<?> location) throws IOException {
        InputStream stream = null;
        if (location == null) {
            try {
                stream = new FileInputStream(file2);
            }
            catch (FileNotFoundException e) {
                LOGGER.debug(e.getMessage());
            }
        } else {
            stream = location.getResourceAsStream(file2);
        }
        if (stream == null) {
            LOGGER.warn("Could not find " + file2);
            return;
        }
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        while (true) {
            String line = null;
            line = in.readLine();
            if (line == null) break;
            this.parseLine(line);
        }
        in.close();
    }

    public void addClass(int index, Class<? extends T> c) {
        this.classes.add(index, c);
    }

    public void addClass(Class<? extends T> c) {
        this.classes.add(c);
    }

    public void removeClass(Class<? extends T> c) {
        this.classes.remove(c);
    }

    public void append(ClassList<T> c) {
        this.append(Arrays.asList(c.getClasses()));
    }

    public void append(List<Class<? extends T>> l) {
        for (int i = 0; i < l.size(); ++i) {
            this.addClass(l.get(i));
        }
    }

    public void prepend(ClassList<T> c) {
        this.prepend(Arrays.asList(c.getClasses()));
    }

    public void prepend(List<Class<? extends T>> l) {
        for (int i = l.size() - 1; i >= 0; --i) {
            this.addClass(0, l.get(i));
        }
    }

    public Class<? extends T>[] getClasses() {
        return this.classes.toArray(new Class[0]);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    @Deprecated
    public boolean isWhitelistedKey(String s2) {
        return this.isAllowedKey(s2);
    }

    public boolean isAllowedKey(String s2) {
        String key = s2.substring(s2.lastIndexOf(".") + 1);
        for (String k : KEYS) {
            if (!key.equals(k)) continue;
            return true;
        }
        return false;
    }

    public void addOption(String key, String value) {
        if (!this.isAllowedKey(key)) {
            LOGGER.debug("{} is not an allowed key", (Object)key);
        }
        this.options.put(key, value);
    }

    private Class<? extends T> cast(Class<?> rawClass) {
        if (!this.base.isAssignableFrom(rawClass)) {
            return null;
        }
        return rawClass;
    }
}

