/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvas3D;
import icy.gui.util.FontUtil;
import icy.preferences.GeneralPreferences;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.edit.PositionROIEdit;
import icy.sequence.Sequence;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.XMLUtil;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public abstract class ROI3D
extends ROI {
    public static final String ID_T = "t";
    public static final String ID_C = "c";
    protected int t = -1;
    protected int c = -1;

    @Deprecated
    public static ArrayList<ROI3D> getROI3DList(ArrayList<ROI> rois) {
        ArrayList<ROI3D> result = new ArrayList<ROI3D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI3D)) continue;
            result.add((ROI3D)roi);
        }
        return result;
    }

    public static List<ROI3D> getROI3DList(List<ROI> rois) {
        ArrayList<ROI3D> result = new ArrayList<ROI3D>();
        for (ROI roi : rois) {
            if (!(roi instanceof ROI3D)) continue;
            result.add((ROI3D)roi);
        }
        return result;
    }

    @Override
    public String getDefaultName() {
        return "ROI3D";
    }

    @Override
    public final int getDimension() {
        return 3;
    }

    protected boolean onSamePos(ROI3D roi, boolean shouldContain) {
        int t = this.getT();
        int c = this.getC();
        int roiT = roi.getT();
        int roiC = roi.getC();
        if (shouldContain) {
            if (t != -1 && t != roiT) {
                return false;
            }
            if (c != -1 && c != roiC) {
                return false;
            }
        } else {
            if (t != -1 && roiT != -1 && t != roiT) {
                return false;
            }
            if (c != -1 && roiC != -1 && c != roiC) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Point3D p) {
        return this.contains(p.getX(), p.getY(), p.getZ());
    }

    public boolean contains(Rectangle3D r) {
        return this.contains(r.getX(), r.getY(), r.getZ(), r.getSizeX(), r.getSizeY(), r.getSizeZ());
    }

    public abstract boolean contains(double var1, double var3, double var5);

    public abstract boolean contains(double var1, double var3, double var5, double var7, double var9, double var11);

    @Override
    public boolean contains(double x, double y, double z, double t, double c) {
        boolean cok;
        boolean tok;
        if (this.getT() == -1) {
            tok = true;
        } else {
            boolean bl = tok = t >= (double)this.getT() && t < (double)this.getT() + 1.0;
        }
        if (this.getC() == -1) {
            cok = true;
        } else {
            boolean bl = cok = c >= (double)this.getC() && c < (double)this.getC() + 1.0;
        }
        return this.contains(x, y, z) && tok && cok;
    }

    @Override
    public boolean contains(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        boolean cok;
        boolean tok;
        if (this.getT() == -1) {
            tok = true;
        } else {
            boolean bl = tok = t >= (double)this.getT() && t + sizeT <= (double)this.getT() + 1.0;
        }
        if (this.getC() == -1) {
            cok = true;
        } else {
            boolean bl = cok = c >= (double)this.getC() && c + sizeC <= (double)this.getC() + 1.0;
        }
        return this.contains(x, y, z, sizeX, sizeY, sizeZ) && tok && cok;
    }

    @Override
    public boolean contains(ROI roi) throws InterruptedException {
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            if (this.onSamePos(roi3d, true)) {
                BooleanMask3D roiMask;
                if (roi3d.isEmpty()) {
                    return this.contains(roi3d.getPosition3D());
                }
                if (!this.contains(roi3d.getBounds3D())) {
                    return false;
                }
                BooleanMask3D mask = this.getBooleanMask(false);
                if (!mask.contains(roiMask = roi3d.getBooleanMask(false))) {
                    return false;
                }
                mask = this.getBooleanMask(true);
                return mask.contains(roiMask = roi3d.getBooleanMask(true));
            }
            return false;
        }
        return super.contains(roi);
    }

    public boolean intersects(Rectangle3D r) {
        return this.intersects(r.getX(), r.getY(), r.getZ(), r.getSizeX(), r.getSizeY(), r.getSizeZ());
    }

    public abstract boolean intersects(double var1, double var3, double var5, double var7, double var9, double var11);

    @Override
    public boolean intersects(double x, double y, double z, double t, double c, double sizeX, double sizeY, double sizeZ, double sizeT, double sizeC) {
        boolean cok;
        boolean tok;
        if (sizeX == 0.0 || sizeY == 0.0 || sizeZ == 0.0 || sizeT == 0.0 || sizeC == 0.0) {
            return false;
        }
        if (this.getT() == -1 || sizeT == Double.POSITIVE_INFINITY) {
            tok = true;
        } else {
            boolean bl = tok = t + sizeT > (double)this.getT() && t < (double)this.getT() + 1.0;
        }
        if (this.getC() == -1 || sizeC == Double.POSITIVE_INFINITY) {
            cok = true;
        } else {
            boolean bl = cok = c + sizeC > (double)this.getC() && c < (double)this.getC() + 1.0;
        }
        return this.intersects(x, y, z, sizeX, sizeY, sizeZ) && tok && cok;
    }

    @Override
    public boolean intersects(ROI roi) throws InterruptedException {
        ROI3D roi3d;
        if (roi instanceof ROI3D && this.onSamePos(roi3d = (ROI3D)roi, false)) {
            if (!this.intersects(roi3d.getBounds3D())) {
                return false;
            }
            return this.getBooleanMask(true).intersects(roi3d.getBooleanMask(true));
        }
        return super.intersects(roi);
    }

    public abstract Rectangle3D computeBounds3D();

    @Override
    public Rectangle5D computeBounds5D() {
        Rectangle3D bounds3D = this.computeBounds3D();
        if (bounds3D == null) {
            return new Rectangle5D.Double();
        }
        Rectangle5D.Double result = new Rectangle5D.Double(bounds3D.getX(), bounds3D.getY(), bounds3D.getZ(), 0.0, 0.0, bounds3D.getSizeX(), bounds3D.getSizeY(), bounds3D.getSizeZ(), 0.0, 0.0);
        if (this.getT() == -1) {
            result.t = Double.NEGATIVE_INFINITY;
            result.sizeT = Double.POSITIVE_INFINITY;
        } else {
            result.t = this.getT();
            result.sizeT = 1.0;
        }
        if (this.getC() == -1) {
            result.c = Double.NEGATIVE_INFINITY;
            result.sizeC = Double.POSITIVE_INFINITY;
        } else {
            result.c = this.getC();
            result.sizeC = 1.0;
        }
        return result;
    }

    public Rectangle3D.Integer getBounds() {
        return this.getBounds3D().toInteger();
    }

    public Rectangle3D getBounds3D() {
        return this.getBounds5D().toRectangle3D();
    }

    public Point3D.Integer getPosition() {
        Rectangle3D.Integer bounds = this.getBounds();
        return new Point3D.Integer(bounds.x, bounds.y, bounds.z);
    }

    public Point3D getPosition3D() {
        return this.getBounds3D().getPosition();
    }

    @Override
    public boolean canSetBounds() {
        return false;
    }

    public void setBounds3D(Rectangle3D bounds) {
    }

    @Override
    public void setBounds5D(Rectangle5D bounds) {
        this.beginUpdate();
        try {
            if (bounds.getSizeT() == Double.POSITIVE_INFINITY) {
                this.setT(-1);
            } else {
                this.setT((int)bounds.getT());
            }
            if (bounds.getSizeC() == Double.POSITIVE_INFINITY) {
                this.setC(-1);
            } else {
                this.setC((int)bounds.getC());
            }
            this.setBounds3D(bounds.toRectangle3D());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    public boolean canSetPosition() {
        return this.canTranslate();
    }

    public void setPosition3D(Point3D position) {
        if (this.canTranslate()) {
            Point3D oldPos = this.getPosition3D();
            this.translate(position.getX() - oldPos.getX(), position.getY() - oldPos.getY(), position.getZ() - oldPos.getZ());
        }
    }

    @Override
    public void setPosition5D(Point5D position) {
        this.beginUpdate();
        try {
            this.setT((int)position.getT());
            this.setC((int)position.getC());
            this.setPosition3D(position.toPoint3D());
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean canTranslate() {
        return false;
    }

    public void translate(double dx, double dy, double dz) {
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(t, c)) {
            return new boolean[Math.max(0, width) * Math.max(0, height)];
        }
        return this.getBooleanMask2D(x, y, width, height, z, inclusive);
    }

    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, boolean inclusive) throws InterruptedException {
        boolean[] result = new boolean[Math.max(0, width) * Math.max(0, height)];
        int offset = 0;
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                result[offset] = inclusive ? this.intersects(x + i, y + j, z, 1.0, 1.0, 1.0) : this.contains(x + i, y + j, z, 1.0, 1.0, 1.0);
                ++offset;
                ++i;
            }
            if ((j & 0xF) == 15 && Thread.interrupted()) {
                throw new InterruptedException("ROI3D.getBooleanMask2D(..) process interrupted.");
            }
            ++j;
        }
        return result;
    }

    public boolean[] getBooleanMask2D(Rectangle rect, int z, boolean inclusive) throws InterruptedException {
        return this.getBooleanMask2D(rect.x, rect.y, rect.width, rect.height, z, inclusive);
    }

    @Override
    public BooleanMask2D getBooleanMask2D(int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(t, c)) {
            return new BooleanMask2D(new Rectangle(), new boolean[0]);
        }
        return this.getBooleanMask2D(z, inclusive);
    }

    public BooleanMask2D getBooleanMask2D(int z, boolean inclusive) throws InterruptedException {
        Rectangle bounds = this.getBounds3D().toRectangle2D().getBounds();
        if (bounds.isEmpty()) {
            return new BooleanMask2D(new Rectangle(), new boolean[0]);
        }
        BooleanMask2D result = new BooleanMask2D(bounds, this.getBooleanMask2D(bounds, z, inclusive));
        result.optimizeBounds();
        return result;
    }

    public BooleanMask3D getBooleanMask3D(int z, int t, int c, boolean inclusive) throws InterruptedException {
        if (!this.isActiveFor(t, c)) {
            return new BooleanMask3D();
        }
        if (z == -1) {
            return this.getBooleanMask(inclusive);
        }
        Rectangle3D.Integer bounds = this.getBounds();
        bounds.setZ(z);
        bounds.setSizeZ(1.0);
        return new BooleanMask3D(bounds, new BooleanMask2D[]{this.getBooleanMask2D(z, inclusive)});
    }

    public BooleanMask3D getBooleanMask(boolean inclusive) throws InterruptedException {
        Rectangle3D.Integer bounds = this.getBounds();
        BooleanMask2D[] masks = new BooleanMask2D[bounds.sizeZ];
        int z = 0;
        while (z < masks.length) {
            masks[z] = this.getBooleanMask2D(bounds.z + z, inclusive);
            ++z;
        }
        return new BooleanMask3D(bounds, masks);
    }

    @Override
    public double computeNumberOfContourPoints() throws InterruptedException {
        return this.getBooleanMask(true).getContourLength();
    }

    @Override
    public double computeNumberOfPoints() throws InterruptedException {
        double numPoints = 0.0;
        numPoints += (double)this.getBooleanMask(true).getNumberOfPoints();
        numPoints += (double)this.getBooleanMask(false).getNumberOfPoints();
        return numPoints /= 2.0;
    }

    public double computeSurfaceArea(Sequence sequence) throws InterruptedException {
        return sequence.calculateSize(this.getNumberOfContourPoints(), 3, 2);
    }

    public double getSurfaceArea(Sequence sequence) throws InterruptedException {
        return this.computeSurfaceArea(sequence);
    }

    @Override
    public double getLength(Sequence sequence) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getLength() not supported for " + this.getClassName() + ".");
    }

    @Deprecated
    public double getSurfaceArea() throws InterruptedException {
        return this.getNumberOfContourPoints();
    }

    @Override
    @Deprecated
    public double getVolume() throws InterruptedException {
        return this.getNumberOfPoints();
    }

    public int getT() {
        return this.t;
    }

    public void setT(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.t != v) {
            this.t = v;
            this.roiChanged(false);
        }
    }

    public int getC() {
        return this.c;
    }

    public void setC(int value) {
        int v = value == Integer.MIN_VALUE ? -1 : value;
        if (this.c != v) {
            this.c = v;
            this.roiChanged(false);
        }
    }

    @Override
    public boolean isActiveFor(IcyCanvas canvas) {
        return this.isActiveFor(canvas.getPositionT(), canvas.getPositionC());
    }

    public boolean isActiveFor(int t, int c) {
        return !(this.getT() != -1 && t != -1 && this.getT() != t || this.getC() != -1 && c != -1 && this.getC() != c);
    }

    public boolean isOverEdge(IcyCanvas canvas, Point3D p) {
        return this.isOverEdge(canvas, p.getX(), p.getY(), p.getZ());
    }

    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z) {
        return false;
    }

    public boolean isOverEdge(IcyCanvas canvas, Point5D p) {
        return this.isOverEdge(canvas, p.getX(), p.getY(), p.getZ(), p.getT(), p.getC());
    }

    public boolean isOverEdge(IcyCanvas canvas, double x, double y, double z, double t, double c) {
        if (this.isActiveFor((int)t, (int)c)) {
            return this.isOverEdge(canvas, x, y, z);
        }
        return false;
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.setT(XMLUtil.getElementIntValue(node, ID_T, -1));
            this.setC(XMLUtil.getElementIntValue(node, ID_C, -1));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        XMLUtil.setElementIntValue(node, ID_T, this.getT());
        XMLUtil.setElementIntValue(node, ID_C, this.getC());
        return true;
    }

    public abstract class ROI3DPainter
    extends ROI.ROIPainter {
        protected Point3D startDragMousePosition = null;
        protected Point3D startDragROIPosition = null;

        @Override
        protected boolean updateFocus(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (imagePoint == null) {
                return false;
            }
            boolean focused = ROI3D.this.isOverEdge(canvas, imagePoint.getX(), imagePoint.getY(), imagePoint.getZ());
            ROI3D.this.setFocused(focused);
            return focused;
        }

        @Override
        protected boolean updateDrag(InputEvent e, Point5D imagePoint, IcyCanvas canvas) {
            if (this.startDragMousePosition == null) {
                return false;
            }
            if (imagePoint == null) {
                return false;
            }
            if (!ROI3D.this.canSetPosition()) {
                return false;
            }
            double dx = imagePoint.getX() - this.startDragMousePosition.getX();
            double dy = imagePoint.getY() - this.startDragMousePosition.getY();
            double dz = imagePoint.getZ() - this.startDragMousePosition.getZ();
            if (EventUtil.isShiftDown(e)) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0.0;
                    if (Math.abs(dz) > Math.abs(dx)) {
                        dx = 0.0;
                    } else {
                        dz = 0.0;
                    }
                } else {
                    dx = 0.0;
                    if (Math.abs(dz) > Math.abs(dy)) {
                        dy = 0.0;
                    } else {
                        dz = 0.0;
                    }
                }
            }
            Sequence sequence = canvas != null ? canvas.getSequence() : null;
            Point5D savePosition = sequence != null ? ROI3D.this.getPosition5D() : null;
            ROI3D.this.setPosition3D(new Point3D.Double(this.startDragROIPosition.getX() + dx, this.startDragROIPosition.getY() + dy, this.startDragROIPosition.getZ() + dz));
            if (sequence != null && savePosition != null) {
                sequence.addUndoableEdit(new PositionROIEdit((ROI)ROI3D.this, savePosition));
            }
            return true;
        }

        @Override
        public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mousePressed(e, imagePoint, canvas);
            if (!this.isReadOnly() && imagePoint != null && ROI3D.this.isActiveFor(canvas) && EventUtil.isLeftMouseButton(e)) {
                ROI3D.this.beginUpdate();
                try {
                    if (ROI3D.this.isFocused()) {
                        this.startDragMousePosition = imagePoint.toPoint3D();
                        this.startDragROIPosition = ROI3D.this.getPosition3D();
                    }
                }
                finally {
                    ROI3D.this.endUpdate();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseReleased(e, imagePoint, canvas);
            this.startDragMousePosition = null;
        }

        @Override
        public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
            super.mouseDrag(e, imagePoint, canvas);
            if (!e.isConsumed() && !this.isReadOnly() && imagePoint != null && ROI3D.this.isActiveFor(canvas) && EventUtil.isLeftMouseButton(e)) {
                ROI3D.this.beginUpdate();
                try {
                    if (ROI3D.this.isFocused()) {
                        if (this.startDragMousePosition == null) {
                            this.startDragMousePosition = imagePoint.toPoint3D();
                            this.startDragROIPosition = ROI3D.this.getPosition3D();
                        }
                        this.updateDrag(e, imagePoint, canvas);
                        e.consume();
                    }
                }
                finally {
                    ROI3D.this.endUpdate();
                }
            }
        }

        @Override
        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            super.paint(g, sequence, canvas);
            if (ROI3D.this.isActiveFor(canvas)) {
                this.drawROI(g, sequence, canvas);
                if (this.getShowName()) {
                    this.drawName(g, sequence, canvas);
                }
            }
        }

        public abstract void drawROI(Graphics2D var1, Sequence var2, IcyCanvas var3);

        public void drawName(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D) {
                if (g == null) {
                    return;
                }
                Rectangle3D bounds3d = ROI3D.this.getBounds3D();
                int posZ = canvas.getPositionZ();
                if (posZ != -1 && bounds3d.getMinZ() > (double)posZ || bounds3d.getMaxZ() < (double)posZ) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)g.create();
                IcyCanvas2D cnv2d = (IcyCanvas2D)canvas;
                Rectangle2D bounds = bounds3d.toRectangle2D();
                Point pos = cnv2d.imageToCanvas(bounds.getCenterX(), bounds.getMinY());
                double coef = Math.log(canvas.getScaleX() + 1.0);
                double fontSize = GeneralPreferences.getGuiFontSize() - 4 + (int)(coef * 10.0);
                g2.transform(cnv2d.getInverseTransform());
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setFont(FontUtil.setSize(g2.getFont(), (int)fontSize));
                g2.setColor(this.getColor());
                GraphicsUtil.drawHCenteredString(g2, this.getName(), pos.x, pos.y - (int)(2.0 * fontSize), true);
                g2.dispose();
            }
            boolean cfr_ignored_0 = canvas instanceof IcyCanvas3D;
        }
    }
}

