/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.image.IcyBufferedImage;
import icy.image.IntensityInfo;
import icy.math.DataIteratorMath;
import icy.math.MathUtil;
import icy.painter.Anchor2D;
import icy.painter.Anchor3D;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.BooleanMask4D;
import icy.roi.BooleanMask5D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROI4D;
import icy.roi.ROI5D;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.SequenceUtil;
import icy.type.DataIteratorUtil;
import icy.type.DataType;
import icy.type.collection.CollectionUtil;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import icy.type.geom.GeomUtil;
import icy.type.geom.Polygon2D;
import icy.type.point.Point3D;
import icy.type.point.Point4D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle2DUtil;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import icy.type.rectangle.Rectangle5D;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.kernel.roi.morphology.ROIDilationCalculator;
import plugins.kernel.roi.morphology.ROIDistanceTransformCalculator;
import plugins.kernel.roi.morphology.ROIErosionCalculator;
import plugins.kernel.roi.morphology.skeletonization.ROISkeletonCalculator;
import plugins.kernel.roi.morphology.watershed.ROIWatershedCalculator;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPoint;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectShape;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi3d.ROI3DBox;
import plugins.kernel.roi.roi3d.ROI3DCylinder;
import plugins.kernel.roi.roi3d.ROI3DFlatPolygon;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.kernel.roi.roi3d.ROI3DShape;
import plugins.kernel.roi.roi3d.ROI3DStack;
import plugins.kernel.roi.roi3d.ROI3DStackEllipse;
import plugins.kernel.roi.roi3d.ROI3DStackPolygon;
import plugins.kernel.roi.roi3d.ROI3DStackRectangle;
import plugins.kernel.roi.roi3d.ROI3DZShape;
import plugins.kernel.roi.roi4d.ROI4DArea;
import plugins.kernel.roi.roi5d.ROI5DArea;

public class ROIUtil {
    public static final String ZEXT_SUFFIX = " Z extended";
    public static final String STACK_SUFFIX = " stack";
    public static final String MASK_SUFFIX = " mask";
    public static final String SHAPE_SUFFIX = " shape";
    public static final String OBJECT_SUFFIX = " object";
    public static final String PART_SUFFIX = " part";

    public static Map<ROIDescriptor, PluginROIDescriptor> getROIDescriptors() {
        return ROIDescriptor.getDescriptors();
    }

    public static Object computeDescriptor(Collection<ROIDescriptor> roiDescriptors, String descriptorId, ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIDescriptor.computeDescriptor(roiDescriptors, descriptorId, roi, sequence);
    }

    @Deprecated
    public static Object computeDescriptor(Set<ROIDescriptor> roiDescriptors, String descriptorId, ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIDescriptor.computeDescriptor(roiDescriptors, descriptorId, roi, sequence);
    }

    public static Object computeDescriptor(String descriptorId, ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIDescriptor.computeDescriptor(descriptorId, roi, sequence);
    }

    @Deprecated
    public static double getStandardDeviation(Sequence sequence, ROI roi, int z, int t, int c) {
        try {
            SequenceDataIterator it = new SequenceDataIterator(sequence, roi, false, z, t, c);
            long numPixels = 0L;
            double sum = 0.0;
            double sum2 = 0.0;
            while (!it.done()) {
                double value = it.get();
                sum += value;
                sum2 += value * value;
                ++numPixels;
                it.next();
            }
            if (numPixels > 0L) {
                double x1 = sum2 / (double)numPixels;
                double x2 = sum / (double)numPixels;
                x2 *= x2;
                return Math.sqrt(x1 - x2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    @Deprecated
    public static IntensityInfo getIntensityInfo(Sequence sequence, ROI roi, int z, int t, int c) {
        try {
            IntensityInfo result = new IntensityInfo();
            SequenceDataIterator it = new SequenceDataIterator(sequence, roi, false, z, t, c);
            long numPixels = 0L;
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            double sum = 0.0;
            while (!it.done()) {
                double value = it.get();
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
                sum += value;
                ++numPixels;
                it.next();
            }
            if (numPixels > 0L) {
                result.minIntensity = min;
                result.maxIntensity = max;
                result.meanIntensity = sum / (double)numPixels;
            } else {
                result.minIntensity = 0.0;
                result.maxIntensity = 0.0;
                result.meanIntensity = 0.0;
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getNumPixel(Sequence sequence, ROI roi, int z, int t, int c) throws InterruptedException {
        return DataIteratorUtil.count(new SequenceDataIterator(sequence, roi, false, z, t, c));
    }

    @Deprecated
    public static double getMinIntensity(Sequence sequence, ROI roi, int z, int t, int c) throws InterruptedException {
        return DataIteratorMath.min(new SequenceDataIterator(sequence, roi, false, z, t, c));
    }

    @Deprecated
    public static double getMaxIntensity(Sequence sequence, ROI roi, int z, int t, int c) throws InterruptedException {
        return DataIteratorMath.max(new SequenceDataIterator(sequence, roi, false, z, t, c));
    }

    @Deprecated
    public static double getMeanIntensity(Sequence sequence, ROI roi, int z, int t, int c) throws InterruptedException {
        return DataIteratorMath.mean(new SequenceDataIterator(sequence, roi, false, z, t, c));
    }

    @Deprecated
    public static double getSumIntensity(Sequence sequence, ROI roi, int z, int t, int c) throws InterruptedException {
        return DataIteratorMath.sum(new SequenceDataIterator(sequence, roi, false, z, t, c));
    }

    @Deprecated
    public static double getStandardDeviation(Sequence sequence, ROI roi) {
        return ROIUtil.getStandardDeviation(sequence, roi, -1, -1, -1);
    }

    @Deprecated
    public static IntensityInfo getIntensityInfo(Sequence sequence, ROI roi) {
        return ROIUtil.getIntensityInfo(sequence, roi, -1, -1, -1);
    }

    public static long getNumPixel(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getNumPixel(sequence, roi, -1, -1, -1);
    }

    @Deprecated
    public static double getMinIntensity(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getMinIntensity(sequence, roi, -1, -1, -1);
    }

    @Deprecated
    public static double getMaxIntensity(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getMaxIntensity(sequence, roi, -1, -1, -1);
    }

    @Deprecated
    public static double getMeanIntensity(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getMeanIntensity(sequence, roi, -1, -1, -1);
    }

    @Deprecated
    public static double getSumIntensity(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getSumIntensity(sequence, roi, -1, -1, -1);
    }

    @Deprecated
    public static Point5D getMassCenter(ROI roi) throws InterruptedException {
        switch (roi.getDimension()) {
            case 2: {
                ROI2D roi2d = (ROI2D)roi;
                Point2D pt2d = ROIUtil.getMassCenter(roi2d);
                return new Point5D.Double(pt2d.getX(), pt2d.getY(), roi2d.getZ(), roi2d.getT(), roi2d.getC());
            }
            case 3: {
                ROI3D roi3d = (ROI3D)roi;
                Point3D pt3d = ROIUtil.getMassCenter(roi3d);
                return new Point5D.Double(pt3d.getX(), pt3d.getY(), pt3d.getZ(), roi3d.getT(), roi3d.getC());
            }
            case 4: {
                ROI4D roi4d = (ROI4D)roi;
                Point4D pt4d = ROIUtil.getMassCenter(roi4d);
                return new Point5D.Double(pt4d.getX(), pt4d.getY(), pt4d.getZ(), pt4d.getT(), roi4d.getC());
            }
            case 5: {
                return ROIUtil.getMassCenter((ROI5D)roi);
            }
        }
        return null;
    }

    @Deprecated
    public static Point2D getMassCenter(ROI2D roi) throws InterruptedException {
        double x = 0.0;
        double y = 0.0;
        long len = 0L;
        BooleanMask2D mask = roi.getBooleanMask(true);
        boolean[] m = mask.mask;
        int h = mask.bounds.height;
        int w = mask.bounds.width;
        int off = 0;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                if (m[off++]) {
                    x += (double)i;
                    y += (double)j;
                    ++len;
                }
                ++i;
            }
            ++j;
        }
        Rectangle2D bounds2D = roi.getBounds2D();
        if (len == 0L) {
            return new Point2D.Double(bounds2D.getCenterX(), bounds2D.getCenterY());
        }
        return new Point2D.Double(bounds2D.getX() + x / (double)len, bounds2D.getY() + y / (double)len);
    }

    @Deprecated
    public static Point3D getMassCenter(ROI3D roi) throws InterruptedException {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        long len = 0L;
        BooleanMask3D mask3d = roi.getBooleanMask(true);
        for (Integer zSlice : mask3d.mask.keySet()) {
            int zi = zSlice;
            double zd = zi;
            BooleanMask2D mask = mask3d.getMask2D(zi);
            boolean[] m = mask.mask;
            double bx = mask.bounds.x;
            double by = mask.bounds.y;
            int h = mask.bounds.height;
            int w = mask.bounds.width;
            int off = 0;
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    if (m[off++]) {
                        x += bx + (double)i;
                        y += by + (double)j;
                        z += zd;
                        ++len;
                    }
                    ++i;
                }
                ++j;
            }
        }
        Rectangle3D bounds3D = roi.getBounds3D();
        if (len == 0L) {
            return new Point3D.Double(bounds3D.getCenterX(), bounds3D.getCenterY(), bounds3D.getCenterZ());
        }
        return new Point3D.Double(x / (double)len, y / (double)len, z / (double)len);
    }

    @Deprecated
    public static Point4D getMassCenter(ROI4D roi) throws InterruptedException {
        BooleanMask4D mask4d = roi.getBooleanMask(true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double t = 0.0;
        long len = 0L;
        for (Integer tFrame : mask4d.mask.keySet()) {
            int ti = tFrame;
            double td = ti;
            BooleanMask3D mask3d = mask4d.getMask3D(ti);
            for (Integer zSlice : mask3d.mask.keySet()) {
                int zi = zSlice;
                double zd = zi;
                BooleanMask2D mask = mask3d.getMask2D(zi);
                boolean[] m = mask.mask;
                double bx = mask.bounds.x;
                double by = mask.bounds.y;
                int h = mask.bounds.height;
                int w = mask.bounds.width;
                int off = 0;
                int j = 0;
                while (j < h) {
                    int i = 0;
                    while (i < w) {
                        if (m[off++]) {
                            x += bx + (double)i;
                            y += by + (double)j;
                            z += zd;
                            t += td;
                            ++len;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
        }
        Rectangle4D bounds4D = roi.getBounds4D();
        if (len == 0L) {
            return new Point4D.Double(bounds4D.getCenterX(), bounds4D.getCenterY(), bounds4D.getCenterZ(), bounds4D.getCenterT());
        }
        return new Point4D.Double(x / (double)len, y / (double)len, z / (double)len, t / (double)len);
    }

    @Deprecated
    public static Point5D getMassCenter(ROI5D roi) throws InterruptedException {
        BooleanMask5D mask5d = roi.getBooleanMask(true);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double t = 0.0;
        double c = 0.0;
        long len = 0L;
        for (Integer cChannel : mask5d.mask.keySet()) {
            int ci = cChannel;
            double cd = ci;
            BooleanMask4D mask4d = mask5d.getMask4D(ci);
            for (Integer tFrame : mask4d.mask.keySet()) {
                int ti = tFrame;
                double td = ti;
                BooleanMask3D mask3d = mask4d.getMask3D(ti);
                for (Integer zSlice : mask3d.mask.keySet()) {
                    int zi = zSlice;
                    double zd = zi;
                    BooleanMask2D mask = mask3d.getMask2D(zi);
                    boolean[] m = mask.mask;
                    double bx = mask.bounds.x;
                    double by = mask.bounds.y;
                    int h = mask.bounds.height;
                    int w = mask.bounds.width;
                    int off = 0;
                    int j = 0;
                    while (j < h) {
                        int i = 0;
                        while (i < w) {
                            if (m[off++]) {
                                x += bx + (double)i;
                                y += by + (double)j;
                                z += zd;
                                t += td;
                                c += cd;
                                ++len;
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        Rectangle5D bounds5D = roi.getBounds5D();
        if (len == 0L) {
            return new Point5D.Double(bounds5D.getCenterX(), bounds5D.getCenterY(), bounds5D.getCenterZ(), bounds5D.getCenterT(), bounds5D.getCenterC());
        }
        return new Point5D.Double(x / (double)len, y / (double)len, z / (double)len, t / (double)len, c / (double)len);
    }

    @Deprecated
    private static double getMultiplier(Sequence sequence, ROI roi, int dim) {
        int dimRoi = roi.getDimension();
        if (dimRoi > dim) {
            return 0.0;
        }
        Rectangle5D boundsRoi = roi.getBounds5D();
        double mul = 1.0;
        switch (dim) {
            case 5: {
                if (dimRoi == 4) {
                    int sizeC = sequence.getSizeC();
                    mul = boundsRoi.getSizeC() == Double.POSITIVE_INFINITY && sizeC > 1 ? (mul *= (double)sizeC) : 0.0;
                }
            }
            case 4: {
                if (dimRoi == 3) {
                    int sizeT = sequence.getSizeT();
                    mul = boundsRoi.getSizeT() == Double.POSITIVE_INFINITY && sizeT > 1 ? (mul *= (double)sizeT) : 0.0;
                }
            }
            case 3: {
                if (dimRoi == 2) {
                    int sizeZ = sequence.getSizeZ();
                    mul = boundsRoi.getSizeZ() == Double.POSITIVE_INFINITY && sizeZ > 1 ? (mul *= (double)sizeZ) : 0.0;
                }
            }
            case 2: {
                if (dimRoi != 1) break;
                int sizeY = sequence.getSizeY();
                if (boundsRoi.getSizeY() == Double.POSITIVE_INFINITY && sizeY > 1) {
                    mul *= (double)sizeY;
                    break;
                }
                mul = 0.0;
            }
        }
        return mul;
    }

    @Deprecated
    public static String getContourSize(Sequence sequence, double contourPoints, ROI roi, int dim, int roundSignificant) {
        double mul = ROIUtil.getMultiplier(sequence, roi, dim);
        if (mul != 0.0) {
            return sequence.calculateSize(MathUtil.roundSignificant(contourPoints, roundSignificant) * mul, dim, dim - 1, 5);
        }
        return "";
    }

    @Deprecated
    public static String getContourSize(Sequence sequence, ROI roi, int dim, int roundSignificant) throws InterruptedException {
        return ROIUtil.getContourSize(sequence, roi.getNumberOfContourPoints(), roi, dim, roundSignificant);
    }

    @Deprecated
    public static String getContourSize(Sequence sequence, ROI roi, int dim) throws InterruptedException {
        return ROIUtil.getContourSize(sequence, roi, dim, 0);
    }

    @Deprecated
    public static String getInteriorSize(Sequence sequence, double interiorPoints, ROI roi, int dim, int roundSignificant) {
        double mul = ROIUtil.getMultiplier(sequence, roi, dim);
        if (mul != 0.0) {
            return sequence.calculateSize(MathUtil.roundSignificant(interiorPoints, roundSignificant) * mul, dim, dim, 5);
        }
        return "";
    }

    @Deprecated
    public static String getInteriorSize(Sequence sequence, ROI roi, int dim, int roundSignificant) throws InterruptedException {
        return ROIUtil.getInteriorSize(sequence, roi.getNumberOfPoints(), roi, dim, roundSignificant);
    }

    @Deprecated
    public static String getInteriorSize(Sequence sequence, ROI roi, int dim) throws InterruptedException {
        return ROIUtil.getInteriorSize(sequence, roi, dim, 0);
    }

    @Deprecated
    public static String getPerimeter(Sequence sequence, ROI roi, int roundSignificant) throws InterruptedException {
        return ROIUtil.getContourSize(sequence, roi, 2, roundSignificant);
    }

    @Deprecated
    public static String getPerimeter(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getPerimeter(sequence, roi, 0);
    }

    @Deprecated
    public static String getArea(Sequence sequence, ROI roi, int roundSignificant) throws InterruptedException {
        return ROIUtil.getInteriorSize(sequence, roi, 2, roundSignificant);
    }

    @Deprecated
    public static String getArea(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getArea(sequence, roi, 0);
    }

    @Deprecated
    public static String getSurfaceArea(Sequence sequence, ROI roi, int roundSignificant) throws InterruptedException {
        return ROIUtil.getContourSize(sequence, roi, 3, roundSignificant);
    }

    @Deprecated
    public static String getSurfaceArea(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getSurfaceArea(sequence, roi, 0);
    }

    @Deprecated
    public static String getVolume(Sequence sequence, ROI roi, int roundSignificant) throws InterruptedException {
        return ROIUtil.getInteriorSize(sequence, roi, 3, roundSignificant);
    }

    @Deprecated
    public static String getVolume(Sequence sequence, ROI roi) throws InterruptedException {
        return ROIUtil.getVolume(sequence, roi, 0);
    }

    public static int getEffectiveDimension(Rectangle5D bounds) {
        int result = 5;
        if (bounds.isInfiniteC() || bounds.getSizeC() <= 1.0) {
            --result;
            if (bounds.isInfiniteT() || bounds.getSizeT() <= 1.0) {
                --result;
                if (bounds.isInfiniteZ() || bounds.getSizeZ() <= 1.0) {
                    --result;
                }
            }
        }
        return result;
    }

    private static Dimension5D.Integer getOpDim(int dim, Rectangle5D.Integer bounds) {
        Dimension5D.Integer result = new Dimension5D.Integer();
        switch (dim) {
            case 2: {
                result.sizeZ = 1;
                result.sizeT = 1;
                result.sizeC = 1;
                break;
            }
            case 3: {
                result.sizeZ = bounds.sizeZ;
                result.sizeT = 1;
                result.sizeC = 1;
                break;
            }
            case 4: {
                result.sizeZ = bounds.sizeZ;
                result.sizeT = bounds.sizeT;
                result.sizeC = 1;
                break;
            }
            default: {
                result.sizeZ = bounds.sizeZ;
                result.sizeT = bounds.sizeT;
                result.sizeC = bounds.sizeC;
            }
        }
        return result;
    }

    private static ROI getOpResult(int dim, BooleanMask5D mask, Rectangle5D.Integer bounds) {
        ROI result;
        switch (dim) {
            case 2: {
                result = new ROI2DArea(mask.getMask2D(bounds.z, bounds.t, bounds.c));
                result.beginUpdate();
                try {
                    ((ROI2D)result).setZ(bounds.z);
                    ((ROI2D)result).setT(bounds.t);
                    ((ROI2D)result).setC(bounds.c);
                    break;
                }
                finally {
                    result.endUpdate();
                }
            }
            case 3: {
                result = new ROI3DArea(mask.getMask3D(bounds.t, bounds.c));
                result.beginUpdate();
                try {
                    ((ROI3D)result).setT(bounds.t);
                    ((ROI3D)result).setC(bounds.c);
                    break;
                }
                finally {
                    result.endUpdate();
                }
            }
            case 4: {
                result = new ROI4DArea(mask.getMask4D(bounds.c));
                ((ROI4D)result).setC(bounds.c);
                break;
            }
            case 5: {
                result = new ROI5DArea(mask);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can't process boolean operation on a ROI with unknown dimension.");
            }
        }
        return result;
    }

    public static Rectangle5D getUnionBounds(ROI roi1, ROI roi2) throws UnsupportedOperationException {
        if (roi1 == null) {
            if (roi2 == null) {
                return new Rectangle5D.Double();
            }
            return roi2.getBounds5D();
        }
        if (roi2 == null) {
            return roi1.getBounds5D();
        }
        Rectangle5D bounds1 = roi1.getBounds5D();
        Rectangle5D bounds2 = roi2.getBounds5D();
        boolean ic1 = bounds1.isInfiniteC();
        boolean ic2 = bounds2.isInfiniteC();
        boolean it1 = bounds1.isInfiniteT();
        boolean it2 = bounds2.isInfiniteT();
        boolean iz1 = bounds1.isInfiniteZ();
        boolean iz2 = bounds2.isInfiniteZ();
        if (ic1 ^ ic2 || it1 ^ it2 || iz1 ^ iz2) {
            throw new UnsupportedOperationException("Can't process union on ROI with different infinite dimension");
        }
        Rectangle5D.union(bounds1, bounds2, bounds1);
        boolean ic = bounds1.isInfiniteC();
        boolean it = bounds1.isInfiniteT();
        boolean iz = bounds1.isInfiniteZ();
        if (!ic && (it || iz)) {
            throw new UnsupportedOperationException("Can't process union on ROI with a finite C dimension and infinite T or Z dimension");
        }
        if (!it && iz) {
            throw new UnsupportedOperationException("Can't process union on ROI with a finite T dimension and infinite Z dimension");
        }
        return bounds1;
    }

    protected static Rectangle5D getIntersectionBounds(ROI roi1, ROI roi2) throws UnsupportedOperationException {
        if (roi1 == null || roi2 == null) {
            return new Rectangle5D.Double();
        }
        Rectangle5D bounds1 = roi1.getBounds5D();
        Rectangle5D bounds2 = roi2.getBounds5D();
        Rectangle5D.intersect(bounds1, bounds2, bounds1);
        boolean ic = bounds1.isInfiniteC();
        boolean it = bounds1.isInfiniteT();
        boolean iz = bounds1.isInfiniteZ();
        if (!ic && (it || iz)) {
            throw new UnsupportedOperationException("Can't process intersection on ROI with a finite C dimension and infinite T or Z dimension");
        }
        if (!it && iz) {
            throw new UnsupportedOperationException("Can't process intersection on ROI with a finite T dimension and infinite Z dimension");
        }
        return bounds1;
    }

    protected static Rectangle5D getSubtractionBounds(ROI roi1, ROI roi2) throws UnsupportedOperationException {
        if (roi1 == null) {
            return new Rectangle5D.Double();
        }
        if (roi2 == null) {
            return roi1.getBounds5D();
        }
        Rectangle5D bounds1 = roi1.getBounds5D();
        Rectangle5D bounds2 = roi2.getBounds5D();
        boolean ic1 = bounds1.isInfiniteC();
        boolean ic2 = bounds2.isInfiniteC();
        boolean it1 = bounds1.isInfiniteT();
        boolean it2 = bounds2.isInfiniteT();
        boolean iz1 = bounds1.isInfiniteZ();
        boolean iz2 = bounds2.isInfiniteZ();
        if (ic1 && !ic2) {
            throw new UnsupportedOperationException("Can't process subtraction: ROI 1 has infinite C dimension while ROI 2 has a finite one");
        }
        if (it1 && !it2) {
            throw new UnsupportedOperationException("Can't process subtraction: ROI 1 has infinite T dimension while ROI 2 has a finite one");
        }
        if (iz1 && !iz2) {
            throw new UnsupportedOperationException("Can't process subtraction: ROI 1 has infinite Z dimension while ROI 2 has a finite one");
        }
        return bounds1;
    }

    public static ROI getUnion(ROI roi1, ROI roi2) throws UnsupportedOperationException, InterruptedException {
        if (roi1 == null) {
            if (roi2 == null) {
                return new ROI2DArea();
            }
            return roi2.getCopy();
        }
        if (roi2 == null) {
            return roi1.getCopy();
        }
        Rectangle5D bounds5D = ROIUtil.getUnionBounds(roi1, roi2);
        int dim = ROIUtil.getEffectiveDimension(bounds5D);
        Rectangle5D.Integer bounds = bounds5D.toInteger();
        Dimension5D.Integer roiSize = ROIUtil.getOpDim(dim, bounds);
        Rectangle3D.Integer bounds3D = (Rectangle3D.Integer)bounds.toRectangle3D();
        Rectangle4D.Integer bounds4D = (Rectangle4D.Integer)bounds.toRectangle4D();
        BooleanMask4D[] mask5D = new BooleanMask4D[roiSize.sizeC];
        int c = 0;
        while (c < roiSize.sizeC) {
            BooleanMask3D[] mask4D = new BooleanMask3D[roiSize.sizeT];
            int t = 0;
            while (t < roiSize.sizeT) {
                BooleanMask2D[] mask3D = new BooleanMask2D[roiSize.sizeZ];
                int z = 0;
                while (z < roiSize.sizeZ) {
                    mask3D[z] = BooleanMask2D.getUnion(roi1.getBooleanMask2D(bounds.z + z, bounds.t + t, bounds.c + c, true), roi2.getBooleanMask2D(bounds.z + z, bounds.t + t, bounds.c + c, true));
                    ++z;
                }
                mask4D[t] = new BooleanMask3D(new Rectangle3D.Integer(bounds3D), mask3D);
                ++t;
            }
            mask5D[c] = new BooleanMask4D(new Rectangle4D.Integer(bounds4D), mask4D);
            ++c;
        }
        BooleanMask5D mask = new BooleanMask5D(bounds, mask5D);
        mask.optimizeBounds();
        ROI result = ROIUtil.getOpResult(dim, mask, bounds);
        result.setName("Union");
        return result;
    }

    public static ROI getIntersection(ROI roi1, ROI roi2) throws UnsupportedOperationException, InterruptedException {
        if (roi1 == null || roi2 == null) {
            return new ROI2DArea();
        }
        Rectangle5D bounds5D = ROIUtil.getIntersectionBounds(roi1, roi2);
        int dim = ROIUtil.getEffectiveDimension(bounds5D);
        Rectangle5D.Integer bounds = bounds5D.toInteger();
        Dimension5D.Integer roiSize = ROIUtil.getOpDim(dim, bounds);
        Rectangle bounds2D = (Rectangle)bounds.toRectangle2D();
        Rectangle3D.Integer bounds3D = (Rectangle3D.Integer)bounds.toRectangle3D();
        Rectangle4D.Integer bounds4D = (Rectangle4D.Integer)bounds.toRectangle4D();
        BooleanMask4D[] mask5D = new BooleanMask4D[roiSize.sizeC];
        int c = 0;
        while (c < roiSize.sizeC) {
            BooleanMask3D[] mask4D = new BooleanMask3D[roiSize.sizeT];
            int t = 0;
            while (t < roiSize.sizeT) {
                BooleanMask2D[] mask3D = new BooleanMask2D[roiSize.sizeZ];
                int z = 0;
                while (z < roiSize.sizeZ) {
                    BooleanMask2D roi1Mask2D = new BooleanMask2D(new Rectangle(bounds2D), roi1.getBooleanMask2D(bounds2D, bounds.z + z, bounds.t + t, bounds.c + c, true));
                    BooleanMask2D roi2Mask2D = new BooleanMask2D(new Rectangle(bounds2D), roi2.getBooleanMask2D(bounds2D, bounds.z + z, bounds.t + t, bounds.c + c, true));
                    mask3D[z] = BooleanMask2D.getIntersection(roi1Mask2D, roi2Mask2D);
                    ++z;
                }
                mask4D[t] = new BooleanMask3D(new Rectangle3D.Integer(bounds3D), mask3D);
                ++t;
            }
            mask5D[c] = new BooleanMask4D(new Rectangle4D.Integer(bounds4D), mask4D);
            ++c;
        }
        BooleanMask5D mask = new BooleanMask5D(bounds, mask5D);
        mask.optimizeBounds();
        ROI result = ROIUtil.getOpResult(dim, mask, bounds);
        result.setName("Intersection");
        return result;
    }

    public static ROI getExclusiveUnion(ROI roi1, ROI roi2) throws UnsupportedOperationException, InterruptedException {
        if (roi1 == null) {
            if (roi2 == null) {
                return new ROI2DArea();
            }
            return roi2.getCopy();
        }
        if (roi2 == null) {
            return roi1.getCopy();
        }
        Rectangle5D bounds5D = ROIUtil.getUnionBounds(roi1, roi2);
        int dim = ROIUtil.getEffectiveDimension(bounds5D);
        Rectangle5D.Integer bounds = bounds5D.toInteger();
        Dimension5D.Integer roiSize = ROIUtil.getOpDim(dim, bounds);
        Rectangle3D.Integer bounds3D = (Rectangle3D.Integer)bounds.toRectangle3D();
        Rectangle4D.Integer bounds4D = (Rectangle4D.Integer)bounds.toRectangle4D();
        BooleanMask4D[] mask5D = new BooleanMask4D[roiSize.sizeC];
        int c = 0;
        while (c < roiSize.sizeC) {
            BooleanMask3D[] mask4D = new BooleanMask3D[roiSize.sizeT];
            int t = 0;
            while (t < roiSize.sizeT) {
                BooleanMask2D[] mask3D = new BooleanMask2D[roiSize.sizeZ];
                int z = 0;
                while (z < roiSize.sizeZ) {
                    mask3D[z] = BooleanMask2D.getExclusiveUnion(roi1.getBooleanMask2D(bounds.z + z, bounds.t + t, bounds.c + c, true), roi2.getBooleanMask2D(bounds.z + z, bounds.t + t, bounds.c + c, true));
                    ++z;
                }
                mask4D[t] = new BooleanMask3D(new Rectangle3D.Integer(bounds3D), mask3D);
                ++t;
            }
            mask5D[c] = new BooleanMask4D(new Rectangle4D.Integer(bounds4D), mask4D);
            ++c;
        }
        BooleanMask5D mask = new BooleanMask5D(bounds, mask5D);
        mask.optimizeBounds();
        ROI result = ROIUtil.getOpResult(dim, mask, bounds);
        result.setName("Exclusive union");
        return result;
    }

    public static ROI getSubtraction(ROI roi1, ROI roi2) throws UnsupportedOperationException, InterruptedException {
        if (roi1 == null) {
            return new ROI2DArea();
        }
        if (roi2 == null) {
            return roi1.getCopy();
        }
        Rectangle5D bounds5D = ROIUtil.getSubtractionBounds(roi1, roi2);
        int dim = ROIUtil.getEffectiveDimension(bounds5D);
        Rectangle5D.Integer bounds = bounds5D.toInteger();
        Dimension5D.Integer roiSize = ROIUtil.getOpDim(dim, bounds);
        Rectangle3D.Integer bounds3D = (Rectangle3D.Integer)bounds.toRectangle3D();
        Rectangle4D.Integer bounds4D = (Rectangle4D.Integer)bounds.toRectangle4D();
        BooleanMask4D[] mask5D = new BooleanMask4D[roiSize.sizeC];
        int c = 0;
        while (c < roiSize.sizeC) {
            BooleanMask3D[] mask4D = new BooleanMask3D[roiSize.sizeT];
            int t = 0;
            while (t < roiSize.sizeT) {
                BooleanMask2D[] mask3D = new BooleanMask2D[roiSize.sizeZ];
                int z = 0;
                while (z < roiSize.sizeZ) {
                    mask3D[z] = BooleanMask2D.getSubtraction(roi1.getBooleanMask2D(bounds.z + z, bounds.t + t, bounds.c + c, true), roi2.getBooleanMask2D(bounds.z + z, bounds.t + t, bounds.c + c, true));
                    ++z;
                }
                mask4D[t] = new BooleanMask3D(new Rectangle3D.Integer(bounds3D), mask3D);
                ++t;
            }
            mask5D[c] = new BooleanMask4D(new Rectangle4D.Integer(bounds4D), mask4D);
            ++c;
        }
        BooleanMask5D mask = new BooleanMask5D(bounds, mask5D);
        mask.optimizeBounds();
        ROI result = ROIUtil.getOpResult(dim, mask, bounds);
        result.setName("Substraction");
        return result;
    }

    public static ROI merge(List<? extends ROI> rois, ShapeUtil.BooleanOperator operator) throws UnsupportedOperationException, InterruptedException {
        if (rois.size() == 0) {
            return null;
        }
        ROI result = rois.get(0).getCopy();
        if (result != null) {
            switch (operator) {
                case AND: {
                    int i = 1;
                    while (i < rois.size()) {
                        Thread.currentThread();
                        if (Thread.interrupted()) {
                            throw new InterruptedException("ROI AND merging process interrupted.");
                        }
                        result = result.intersect(rois.get(i), true);
                        ++i;
                    }
                    break;
                }
                case OR: {
                    int i = 1;
                    while (i < rois.size()) {
                        Thread.currentThread();
                        if (Thread.interrupted()) {
                            throw new InterruptedException("ROI OR merging process interrupted.");
                        }
                        result = result.add(rois.get(i), true);
                        ++i;
                    }
                    break;
                }
                case XOR: {
                    int i = 1;
                    while (i < rois.size()) {
                        Thread.currentThread();
                        if (Thread.interrupted()) {
                            throw new InterruptedException("ROI XOR merging process interrupted.");
                        }
                        result = result.exclusiveAdd(rois.get(i), true);
                        ++i;
                    }
                    break;
                }
            }
        }
        return result;
    }

    public static ROI getUnion(List<? extends ROI> rois) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.merge(rois, ShapeUtil.BooleanOperator.OR);
    }

    public static ROI getExclusiveUnion(List<? extends ROI> rois) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.merge(rois, ShapeUtil.BooleanOperator.XOR);
    }

    public static ROI getIntersection(List<? extends ROI> rois) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.merge(rois, ShapeUtil.BooleanOperator.AND);
    }

    public static ROI subtract(ROI roi1, ROI roi2) throws UnsupportedOperationException, InterruptedException {
        return roi1.getSubtraction(roi2);
    }

    public static ROI convertToPoint(ROI roi) throws InterruptedException {
        ROI result;
        Point5D pt = ROIMassCenterDescriptorsPlugin.computeMassCenter(roi);
        if (roi instanceof ROI2D) {
            result = new ROI2DPoint(pt.getX(), pt.getY());
            ((ROI2D)result).setZ(((ROI2D)roi).getZ());
            ((ROI2D)result).setT(((ROI2D)roi).getT());
            ((ROI2DPoint)result).setC(((ROI2D)roi).getC());
        } else if (roi instanceof ROI3D) {
            result = new ROI3DPoint(pt.getX(), pt.getY(), pt.getZ());
            ((ROI3DPoint)result).setT(((ROI3D)roi).getT());
            ((ROI3DPoint)result).setC(((ROI3D)roi).getC());
        } else {
            result = new ROI3DPoint(pt.getX(), pt.getY(), pt.getZ());
            ((ROI3DPoint)result).setT((int)pt.getT());
            ((ROI3DPoint)result).setC((int)pt.getC());
        }
        ROIUtil.copyROIProperties(roi, result, true);
        return result;
    }

    public static ROI2DEllipse convertToEllipse(ROI roi, double radiusX, double radiusY) throws InterruptedException {
        Point5D pt = ROIMassCenterDescriptorsPlugin.computeMassCenter(roi);
        double x = pt.getX();
        double y = pt.getY();
        ROI2DEllipse result = new ROI2DEllipse(x - radiusX, y - radiusY, x + radiusX, y + radiusY);
        if (roi instanceof ROI2D) {
            result.setZ(((ROI2D)roi).getZ());
            result.setT(((ROI2D)roi).getT());
            result.setC(((ROI2D)roi).getC());
        } else if (roi instanceof ROI3D) {
            result.setZ((int)pt.getZ());
            result.setT(((ROI3D)roi).getT());
            result.setC(((ROI3D)roi).getC());
        } else {
            result.setZ((int)pt.getZ());
            result.setT((int)pt.getT());
            result.setC((int)pt.getC());
        }
        ROIUtil.copyROIProperties(roi, result, true);
        return result;
    }

    public static ROI2DRectangle convertToRectangle(ROI roi, double width, double height) throws InterruptedException {
        Point5D pt = ROIMassCenterDescriptorsPlugin.computeMassCenter(roi);
        double x = pt.getX();
        double y = pt.getY();
        double rw = width / 2.0;
        double rh = height / 2.0;
        ROI2DRectangle result = new ROI2DRectangle(x - rw, y - rh, x + rw, y + rh);
        if (roi instanceof ROI2D) {
            result.setZ(((ROI2D)roi).getZ());
            result.setT(((ROI2D)roi).getT());
            result.setC(((ROI2D)roi).getC());
        } else if (roi instanceof ROI3D) {
            result.setZ((int)pt.getZ());
            result.setT(((ROI3D)roi).getT());
            result.setC(((ROI3D)roi).getC());
        } else {
            result.setZ((int)pt.getZ());
            result.setT((int)pt.getT());
            result.setC((int)pt.getC());
        }
        ROIUtil.copyROIProperties(roi, result, true);
        return result;
    }

    public static ROI convertToStack(ROI2D roi, int zMin, int zMax) throws InterruptedException {
        ROI3DStack result = null;
        if (roi instanceof ROI2DRectangle) {
            result = new ROI3DStackRectangle(((ROI2DRectangle)roi).getRectangle(), zMin, zMax);
        } else if (roi instanceof ROI2DEllipse) {
            result = new ROI3DStackEllipse(((ROI2DEllipse)roi).getEllipse(), zMin, zMax);
        } else if (roi instanceof ROI2DPolygon) {
            result = new ROI3DStackPolygon(((ROI2DPolygon)roi).getPolygon2D(), zMin, zMax);
        } else if (roi instanceof ROI2DArea) {
            result = new ROI3DArea(((ROI2DArea)roi).getBooleanMask(true), zMin, zMax);
        } else if (roi != null) {
            result = new ROI3DArea(roi.getBooleanMask2D(roi.getZ(), roi.getT(), roi.getC(), true), zMin, zMax);
        }
        if (roi != null && result != null) {
            ((ROI)result).unselectAllPoints();
            ((ROI)result).setName(String.valueOf(roi.getName()) + STACK_SUFFIX);
            ROIUtil.copyROIProperties(roi, result, false);
        }
        return result;
    }

    public static ROI[] unstack(ROI3D roi) throws InterruptedException {
        return ROIUtil.convertTo2D(roi);
    }

    public static ROI convertTo3D(ROI2D roi, double z, double sizeZ) throws InterruptedException {
        ROI3D result = null;
        if (roi instanceof ROI2DRectangle) {
            result = new ROI3DBox(roi.getBounds2D(), z, sizeZ);
        } else if (roi instanceof ROI2DEllipse) {
            result = new ROI3DCylinder(roi.getBounds2D(), z, sizeZ);
        } else if (roi instanceof ROI2DPolygon) {
            result = new ROI3DFlatPolygon(((ROI2DPolygon)roi).getPolygon2D(), z, sizeZ);
        } else {
            int zMin = (int)z;
            int zMax = (int)(z + sizeZ);
            if ((double)zMax == z + sizeZ) {
                --zMax;
            }
            if (zMin > zMax) {
                return null;
            }
            result = roi instanceof ROI2DArea ? new ROI3DArea(((ROI2DArea)roi).getBooleanMask(true), zMin, zMax) : new ROI3DArea(roi.getBooleanMask2D(roi.getZ(), roi.getT(), roi.getC(), true), zMin, zMax);
        }
        if (result != null) {
            ((ROI)result).unselectAllPoints();
            if (!roi.isDefaultName()) {
                ((ROI)result).setName(String.valueOf(roi.getName()) + ZEXT_SUFFIX);
            }
            ROIUtil.copyROIProperties(roi, result, false);
        }
        return result;
    }

    public static ROI[] convertTo2D(ROI3D roi) throws InterruptedException {
        Object roi2d;
        int z;
        ROI3D roi3d;
        ROI[] result = null;
        if (roi instanceof ROI3DPoint) {
            roi3d = (ROI3DPoint)roi;
            Point3D position = roi3d.getPosition3D();
            ROI2DPoint roi2d2 = new ROI2DPoint(position.getX(), position.getY());
            roi2d2.c = ((ROI3DPoint)roi3d).c;
            roi2d2.t = ((ROI3DPoint)roi3d).t;
            roi2d2.z = (int)Math.round(position.getZ());
            result = new ROI[]{roi2d2};
        } else if (roi instanceof ROI3DStack) {
            int z0;
            roi3d = (ROI3DStack)roi;
            ArrayList<Object> rois2d = new ArrayList<Object>(((ROI3DStack)roi3d).getSizeZ());
            z = z0 = (int)Math.floor(roi3d.getBounds3D().getZ());
            while (z < z0 + ((ROI3DStack)roi3d).getSizeZ()) {
                roi2d = ((ROI3DStack)roi3d).getSlice(z);
                if (roi2d != null) {
                    roi2d = (ROI2D)((ROI)roi2d).getCopy();
                    ((ROI2D)roi2d).setZ(z);
                    ((ROI2D)roi2d).setC(((ROI3DStack)roi3d).c);
                    ((ROI2D)roi2d).setT(((ROI3DStack)roi3d).t);
                    rois2d.add(roi2d);
                }
                ++z;
            }
            result = rois2d.toArray(new ROI[rois2d.size()]);
        } else if (roi instanceof ROI3DZShape) {
            roi3d = (ROI3DZShape)roi;
            ROI2DShape roi2d3 = ((ROI3DZShape)roi3d).getShape2DROI();
            if (roi2d3 != null) {
                roi2d3 = (ROI2DShape)roi2d3.getCopy();
                roi2d3.setZ(-1);
                roi2d3.setC(((ROI3DZShape)roi3d).c);
                roi2d3.setT(((ROI3DZShape)roi3d).t);
            }
            result = new ROI[]{roi2d3};
        } else if (roi instanceof ROI3DArea) {
            int z0;
            roi3d = (ROI3DArea)roi;
            ArrayList<Object> rois2d = new ArrayList<Object>(((ROI3DStack)roi3d).getSizeZ());
            z = z0 = (int)Math.floor(roi3d.getBounds3D().getZ());
            while (z < z0 + ((ROI3DStack)roi3d).getSizeZ()) {
                roi2d = new ROI2DArea(((ROI3DStack)roi3d).getBooleanMask2D(z, true));
                ((ROI2D)roi2d).setZ(z);
                ((ROI2D)roi2d).setC(((ROI3DArea)roi3d).c);
                ((ROI2D)roi2d).setT(((ROI3DArea)roi3d).t);
                rois2d.add(roi2d);
                ++z;
            }
            result = rois2d.toArray(new ROI[rois2d.size()]);
        } else if (roi != null) {
            roi3d = roi;
            int sizeZ = (int)Math.round(roi3d.getBounds3D().getSizeZ());
            ArrayList<ROI2DArea> rois2d = new ArrayList<ROI2DArea>(sizeZ);
            z = (int)Math.floor(roi3d.getBounds3D().getZ());
            while (z <= sizeZ) {
                BooleanMask2D mask2d = roi3d.getBooleanMask2D(z, true);
                if (mask2d != null && !mask2d.isEmpty()) {
                    ROI2DArea roi2d4 = new ROI2DArea(mask2d);
                    roi2d4.setZ(z);
                    roi2d4.setC(roi3d.c);
                    roi2d4.setT(roi3d.t);
                    rois2d.add(roi2d4);
                }
                ++z;
            }
            result = rois2d.toArray(new ROI[rois2d.size()]);
        }
        if (roi != null && result != null) {
            String name = roi.getName();
            if (name.endsWith(STACK_SUFFIX)) {
                name = StringUtil.removeLast(name, STACK_SUFFIX.length());
            } else if (name.endsWith(ZEXT_SUFFIX)) {
                name = StringUtil.removeLast(name, ZEXT_SUFFIX.length());
            }
            ROI[] rOIArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                ROI roi2d5 = rOIArray[n2];
                roi2d5.unselectAllPoints();
                if (!roi.isDefaultName()) {
                    roi2d5.setName(name);
                }
                ROIUtil.copyROIProperties(roi, roi2d5, false);
                ++n2;
            }
        }
        return result;
    }

    public static ROI convertToMask(ROI roi) throws InterruptedException {
        if (roi instanceof ROI2DArea || roi instanceof ROI3DArea || roi instanceof ROI4DArea || roi instanceof ROI5DArea) {
            return roi;
        }
        Rectangle5D bounds5D = roi.getBounds5D();
        int dim = ROIUtil.getEffectiveDimension(bounds5D);
        Rectangle5D.Integer bounds = bounds5D.toInteger();
        Dimension5D.Integer roiSize = ROIUtil.getOpDim(dim, bounds);
        Rectangle bounds2D = (Rectangle)bounds.toRectangle2D();
        Rectangle3D.Integer bounds3D = (Rectangle3D.Integer)bounds.toRectangle3D();
        Rectangle4D.Integer bounds4D = (Rectangle4D.Integer)bounds.toRectangle4D();
        BooleanMask4D[] mask5D = new BooleanMask4D[roiSize.sizeC];
        int c = 0;
        while (c < roiSize.sizeC) {
            BooleanMask3D[] mask4D = new BooleanMask3D[roiSize.sizeT];
            int t = 0;
            while (t < roiSize.sizeT) {
                BooleanMask2D[] mask3D = new BooleanMask2D[roiSize.sizeZ];
                int z = 0;
                while (z < roiSize.sizeZ) {
                    mask3D[z] = new BooleanMask2D(new Rectangle(bounds2D), roi.getBooleanMask2D(bounds2D, bounds.z + z, bounds.t + t, bounds.c + c, true));
                    ++z;
                }
                mask4D[t] = new BooleanMask3D(new Rectangle3D.Integer(bounds3D), mask3D);
                ++t;
            }
            mask5D[c] = new BooleanMask4D(new Rectangle4D.Integer(bounds4D), mask4D);
            ++c;
        }
        BooleanMask5D mask = new BooleanMask5D(bounds, mask5D);
        mask.optimizeBounds();
        ROI result = ROIUtil.getOpResult(dim, mask, bounds);
        String newName = String.valueOf(roi.getName()) + MASK_SUFFIX;
        String cancelableSuffix = " shape mask";
        if (newName.endsWith(" shape mask")) {
            newName = newName.substring(0, newName.length() - " shape mask".length());
        }
        result.setName(newName);
        ROIUtil.copyROIProperties(roi, result, false);
        return result;
    }

    public static ROI convertToShape(ROI roi, double maxDeviation) throws UnsupportedOperationException, InterruptedException {
        if (roi instanceof ROI2DShape) {
            return roi;
        }
        if (roi instanceof ROI2D) {
            double dev;
            ROI2D roi2d = (ROI2D)roi;
            List<Point> points = roi2d.getBooleanMask(true).getConnectedContourPoints();
            ArrayList<Point2D> points2D = new ArrayList<Point2D>(points.size());
            for (Point pt : points) {
                points2D.add(new Point2D.Double((double)pt.x + 0.5, (double)pt.y + 0.5));
            }
            if (maxDeviation < 0.0) {
                Rectangle2D bnd = roi2d.getBounds2D();
                dev = Math.log10(Math.sqrt(bnd.getWidth() * bnd.getHeight())) / Math.log10(3.0);
            } else {
                dev = maxDeviation;
            }
            ROI2DPolygon result = new ROI2DPolygon(Polygon2D.getPolygon2D(points2D, dev));
            String newName = String.valueOf(roi.getName()) + SHAPE_SUFFIX;
            String cancelableSuffix = " mask shape";
            if (newName.endsWith(" mask shape")) {
                newName = newName.substring(0, newName.length() - " mask shape".length());
            }
            result.setName(newName);
            ROIUtil.copyROIProperties(roi, result, false);
            return result;
        }
        if (roi instanceof ROI3D) {
            throw new UnsupportedOperationException("ROIUtil.convertToShape(ROI): Operation not supported for 3D ROI.");
        }
        throw new UnsupportedOperationException("ROIUtil.convertToShape(ROI): Operation not supported for this ROI: " + roi.getName());
    }

    public static List<ROI> getConnectedComponents(ROI roi) throws UnsupportedOperationException, InterruptedException {
        ArrayList<ROI> result = new ArrayList<ROI>();
        if (roi instanceof ROI2D) {
            ROI2D roi2d = (ROI2D)roi;
            int ind = 0;
            BooleanMask2D[] booleanMask2DArray = roi2d.getBooleanMask(true).getComponents();
            int n = booleanMask2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                BooleanMask2D component = booleanMask2DArray[n2];
                ROI2DArea componentRoi = new ROI2DArea(component);
                if (!componentRoi.isEmpty()) {
                    componentRoi.setName(String.valueOf(roi.getName()) + OBJECT_SUFFIX + " #" + ind++);
                    ROIUtil.copyROIProperties(roi, componentRoi, false);
                    result.add(componentRoi);
                }
                ++n2;
            }
            return result;
        }
        if (roi instanceof ROI3D) {
            ROI3D roi3d = (ROI3D)roi;
            int ind = 0;
            for (BooleanMask3D component : roi3d.getBooleanMask(true).getComponents()) {
                ROI3DArea componentRoi = new ROI3DArea(component);
                if (componentRoi.isEmpty()) continue;
                componentRoi.setName(String.valueOf(roi.getName()) + " object #" + ind++);
                componentRoi.setT(roi3d.t);
                componentRoi.setC(roi3d.c);
                ROIUtil.copyROIProperties(roi, componentRoi, false);
                result.add(componentRoi);
            }
            return result;
        }
        throw new UnsupportedOperationException("ROIUtil.getConnectedComponents(ROI): Operation not supported for this ROI: " + roi.getName());
    }

    static boolean computePolysFromLine(Line2D line, Point2D edgePt1, Point2D edgePt2, Polygon2D poly1, Polygon2D poly2, boolean inner) {
        Line2D.Double edgeLine = new Line2D.Double(edgePt1, edgePt2);
        if (edgeLine.intersectsLine(line)) {
            Point2D intersection = GeomUtil.getIntersection(edgeLine, line);
            if (inner) {
                poly2.addPoint(intersection);
                poly1.addPoint(intersection);
                poly1.addPoint(edgePt2);
            } else {
                poly1.addPoint(intersection);
                poly2.addPoint(intersection);
                poly2.addPoint(edgePt2);
            }
            return !inner;
        }
        if (inner) {
            poly2.addPoint(edgePt2);
        } else {
            poly1.addPoint(edgePt2);
        }
        return inner;
    }

    public static List<ROI> split(ROI roi, Line2D line) throws UnsupportedOperationException, InterruptedException {
        Rectangle2D bounds2d = roi.getBounds5D().toRectangle2D();
        Rectangle2D extendedBounds2d = Rectangle2DUtil.getScaledRectangle(bounds2d, 1.1, true);
        Line2D extendedLine = Rectangle2DUtil.getIntersectionLine(extendedBounds2d, line);
        if (extendedLine != null && bounds2d.intersectsLine(extendedLine)) {
            ArrayList<ROI> result = new ArrayList<ROI>();
            Point2D.Double topLeft = new Point2D.Double(bounds2d.getMinX(), bounds2d.getMinY());
            Point2D.Double topRight = new Point2D.Double(bounds2d.getMaxX(), bounds2d.getMinY());
            Point2D.Double bottomRight = new Point2D.Double(bounds2d.getMaxX(), bounds2d.getMaxY());
            Point2D.Double bottomLeft = new Point2D.Double(bounds2d.getMinX(), bounds2d.getMaxY());
            Polygon2D poly1 = new Polygon2D();
            Polygon2D poly2 = new Polygon2D();
            poly1.addPoint(topLeft);
            boolean inner = false;
            inner = ROIUtil.computePolysFromLine(extendedLine, topLeft, topRight, poly1, poly2, inner);
            inner = ROIUtil.computePolysFromLine(extendedLine, topRight, bottomRight, poly1, poly2, inner);
            inner = ROIUtil.computePolysFromLine(extendedLine, bottomRight, bottomLeft, poly1, poly2, inner);
            inner = ROIUtil.computePolysFromLine(extendedLine, bottomLeft, topLeft, poly1, poly2, inner);
            ROI roiPart1 = new ROI2DPolygon(poly1).getIntersection(roi);
            ROI roiPart2 = new ROI2DPolygon(poly2).getIntersection(roi);
            roiPart1.setName(String.valueOf(roi.getName()) + PART_SUFFIX + " #1");
            ROIUtil.copyROIProperties(roi, roiPart1, false);
            roiPart2.setName(String.valueOf(roi.getName()) + PART_SUFFIX + " #2");
            ROIUtil.copyROIProperties(roi, roiPart2, false);
            result.add(roiPart1);
            result.add(roiPart2);
            return result;
        }
        return null;
    }

    public static Sequence convertToSequence(List<ROI> inputRois, int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT, DataType dataType, boolean label) throws InterruptedException {
        boolean canMerge;
        ArrayList<ROI> rois = new ArrayList<ROI>();
        Rectangle5D.Double bounds = new Rectangle5D.Double();
        boolean bl = canMerge = !label;
        if (canMerge) {
            try {
                ROI roi = ROIUtil.merge(inputRois, ShapeUtil.BooleanOperator.OR);
                bounds.add(roi.getBounds5D());
                rois.add(roi);
            }
            catch (Exception e) {
                canMerge = false;
            }
        }
        if (!canMerge) {
            for (ROI roi : inputRois) {
                if (roi == null) continue;
                bounds.add(roi.getBounds5D());
                rois.add(roi);
            }
        }
        int sX = sizeX;
        int sY = sizeY;
        int sC = sizeC;
        int sZ = sizeZ;
        int sT = sizeT;
        if (sX == 0) {
            sX = (int)((Rectangle5D)bounds).getSizeX();
        }
        if (sY == 0) {
            sY = (int)((Rectangle5D)bounds).getSizeY();
        }
        if (sC == 0) {
            int n = sC = bounds.isInfiniteC() ? 1 : (int)((Rectangle5D)bounds).getSizeC();
        }
        if (sZ == 0) {
            int n = sZ = bounds.isInfiniteZ() ? 1 : (int)((Rectangle5D)bounds).getSizeZ();
        }
        if (sT == 0) {
            int n = sT = bounds.isInfiniteT() ? 1 : (int)((Rectangle5D)bounds).getSizeT();
        }
        if (sX == 0) {
            sX = 320;
        }
        if (sY == 0) {
            sY = 240;
        }
        if (sC == 0) {
            sC = 1;
        }
        if (sZ == 0) {
            sZ = 1;
        }
        if (sT == 0) {
            sT = 1;
        }
        Sequence out = new Sequence("ROI conversion");
        out.beginUpdate();
        try {
            int t = 0;
            while (t < sT) {
                int z = 0;
                while (z < sZ) {
                    out.setImage(t, z, (BufferedImage)new IcyBufferedImage(sX, sY, sC, dataType));
                    ++z;
                }
                ++t;
            }
            double fillValue = 1.0;
            for (ROI roi : rois) {
                if (!roi.getBounds5D().isEmpty()) {
                    DataIteratorUtil.set(new SequenceDataIterator(out, roi), fillValue);
                }
                if (!label) continue;
                fillValue += 1.0;
            }
            out.dataChanged();
        }
        finally {
            out.endUpdate();
        }
        return out;
    }

    public static Sequence convertToSequence(List<ROI> inputRois, Sequence sequence, boolean label) throws InterruptedException {
        if (sequence == null) {
            return ROIUtil.convertToSequence(inputRois, 0, 0, 0, 0, 0, label ? (inputRois.size() > 255 ? DataType.USHORT : DataType.UBYTE) : DataType.UBYTE, label);
        }
        return ROIUtil.convertToSequence(inputRois, sequence.getSizeX(), sequence.getSizeY(), 1, sequence.getSizeZ(), sequence.getSizeT(), sequence.getDataType_(), label);
    }

    public static Sequence convertToSequence(ROI inputRoi, Sequence sequence) throws InterruptedException {
        return ROIUtil.convertToSequence(CollectionUtil.createArrayList(inputRoi), sequence, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void scale(ROI roi, double scaleX, double scaleY, double scaleZ) throws UnsupportedOperationException {
        if (roi instanceof ROI2DRectShape) {
            ROI2DRectShape roi2DRectShape = (ROI2DRectShape)roi;
            roi2DRectShape.beginUpdate();
            try {
                Rectangle2D bounds = roi2DRectShape.getBounds2D();
                bounds.setFrame(bounds.getX() * scaleX, bounds.getY() * scaleY, bounds.getWidth() * scaleX, bounds.getHeight() * scaleY);
                roi2DRectShape.setBounds2D(bounds);
                int z = roi2DRectShape.getZ();
                if (z == -1 || scaleZ == 1.0) return;
                roi2DRectShape.setZ((int)((double)z * scaleZ));
                return;
            }
            finally {
                roi2DRectShape.endUpdate();
            }
        }
        if (roi instanceof ROI2DShape) {
            ROI2DShape roi2DShape = (ROI2DShape)roi;
            roi2DShape.beginUpdate();
            try {
                for (Anchor2D pt : roi2DShape.getControlPoints()) {
                    Point2D pos = pt.getPosition();
                    pt.setPosition(pos.getX() * scaleX, pos.getY() * scaleY);
                }
                int z = roi2DShape.getZ();
                if (z == -1 || scaleZ == 1.0) return;
                roi2DShape.setZ((int)((double)z * scaleZ));
                return;
            }
            finally {
                roi2DShape.endUpdate();
            }
        }
        if (!(roi instanceof ROI3DShape)) throw new UnsupportedOperationException("ROIUtil.scale: cannot rescale " + roi.getSimpleClassName() + " !");
        ROI3DShape roi3DShape = (ROI3DShape)roi;
        roi3DShape.beginUpdate();
        try {
            for (Anchor3D pt : roi3DShape.getControlPoints()) {
                Point3D pos = pt.getPosition();
                pt.setPosition(pos.getX() * scaleX, pos.getY() * scaleY, pos.getZ() * scaleZ);
            }
            return;
        }
        finally {
            roi3DShape.endUpdate();
        }
    }

    public static void scale(ROI roi, double scaleX, double scaleY) throws UnsupportedOperationException {
        ROIUtil.scale(roi, scaleX, scaleY, 1.0);
    }

    public static void scale(ROI roi, double scale) throws UnsupportedOperationException {
        ROIUtil.scale(roi, scale, scale, scale);
    }

    public static ROI get2XScaled(ROI roi, boolean scaleOnZ, boolean down) throws UnsupportedOperationException, InterruptedException {
        if (roi == null) {
            return null;
        }
        double scaling = down ? 0.5 : 2.0;
        ROI result = roi.getCopy();
        if (result instanceof ROI2DShape || result instanceof ROI3DShape) {
            ROIUtil.scale(result, scaling, scaling, scaleOnZ ? scaling : 1.0);
        } else if (result instanceof ROI2D) {
            if (result instanceof ROI2DArea) {
                ROI2DArea roi2DArea = (ROI2DArea)result;
                if (down) {
                    roi2DArea.downscale();
                } else {
                    roi2DArea.upscale();
                }
                if (roi2DArea.getZ() != -1 && scaleOnZ) {
                    roi2DArea.setZ((int)((double)roi2DArea.getZ() * scaling));
                }
            } else {
                BooleanMask2D bm = ((ROI2D)result).getBooleanMask(true);
                ROI2DArea roi2DArea = down ? new ROI2DArea(bm.downscale()) : new ROI2DArea(bm.upscale());
                Point5D pos = result.getPosition5D();
                if (Double.isInfinite(pos.getZ())) {
                    roi2DArea.setZ(-1);
                } else {
                    roi2DArea.setZ((int)(pos.getZ() * (scaleOnZ ? scaling : 1.0)));
                }
                if (Double.isInfinite(pos.getT())) {
                    roi2DArea.setT(-1);
                } else {
                    roi2DArea.setT((int)pos.getT());
                }
                if (Double.isInfinite(pos.getC())) {
                    roi2DArea.setC(-1);
                } else {
                    roi2DArea.setC((int)pos.getC());
                }
                ROIUtil.copyROIProperties(result, roi2DArea, true);
                result = roi2DArea;
            }
        } else if (result instanceof ROI3D) {
            if (result instanceof ROI3DArea) {
                ROI3DArea roi3DArea = (ROI3DArea)result;
                if (down) {
                    if (scaleOnZ) {
                        roi3DArea.downscale();
                    } else {
                        roi3DArea.downscale2D();
                    }
                } else if (scaleOnZ) {
                    roi3DArea.upscale();
                } else {
                    roi3DArea.upscale2D();
                }
            } else {
                BooleanMask3D bm = ((ROI3D)result).getBooleanMask(true);
                ROI3DArea roi3DArea = down ? (scaleOnZ ? new ROI3DArea(bm.downscale()) : new ROI3DArea(bm.downscale2D())) : (scaleOnZ ? new ROI3DArea(bm.upscale()) : new ROI3DArea(bm.upscale2D()));
                Point5D pos = result.getPosition5D();
                if (Double.isInfinite(pos.getT())) {
                    roi3DArea.setT(-1);
                } else {
                    roi3DArea.setT((int)pos.getT());
                }
                if (Double.isInfinite(pos.getC())) {
                    roi3DArea.setC(-1);
                } else {
                    roi3DArea.setC((int)pos.getC());
                }
                ROIUtil.copyROIProperties(result, roi3DArea, true);
                result = roi3DArea;
            }
        } else {
            throw new UnsupportedOperationException("ROIUtil.get2XScaled: cannot rescale ROI4D or ROI5D !");
        }
        return result;
    }

    public static ROI getUpscaled(ROI roi, boolean scaleOnZ) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.get2XScaled(roi, scaleOnZ, false);
    }

    public static ROI getDownscaled(ROI roi, boolean scaleOnZ) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.get2XScaled(roi, scaleOnZ, true);
    }

    /*
     * Unable to fully structure code
     */
    public static ROI adjustToSequence(ROI roi, Sequence source, Sequence destination, boolean translate, boolean scale, boolean ignoreErrorOnScale) throws UnsupportedOperationException, InterruptedException {
        block21: {
            block22: {
                if (roi == null) {
                    return null;
                }
                result = roi.getCopy();
                if (!scale) break block21;
                scaleX = source.getPixelSizeX() / destination.getPixelSizeX();
                scaleY = source.getPixelSizeY() / destination.getPixelSizeY();
                scaleZ = source.getPixelSizeZ() / destination.getPixelSizeZ();
                if (!(result instanceof ROI2DShape) && !(result instanceof ROI3DShape)) break block22;
                ROIUtil.scale(result, scaleX, scaleY, scaleZ);
                break block21;
            }
            doRescale = true;
            doRescaleZ = true;
            if (MathUtil.round(scaleX / scaleY, 3) != 1.0) {
                doRescale = false;
                if (ignoreErrorOnScale) {
                    System.out.println("[Warning] ROIUtil.adjustToSequence: cannot rescale ROI with different X/Y scale ratio.");
                } else {
                    throw new UnsupportedOperationException("ROIUtil.adjustToSequence: cannot rescale ROI (different X/Y scale ratio) !");
                }
            }
            if ((double)Math.round(resDelta = MathUtil.round(Math.log(scaleX) / Math.log(2.0), 1)) != resDelta) {
                doRescale = false;
                if (ignoreErrorOnScale) {
                    System.out.println("[Warning] ROIUtil.adjustToSequence: cannot rescale ROI with scale XY = " + scaleX);
                } else {
                    throw new UnsupportedOperationException("ROIUtil.adjustToSequence: cannot rescale ROI (scale XY = " + scaleX + ") !");
                }
            }
            if ((double)Math.round(resDeltaZ = MathUtil.round(Math.log(scaleZ) / Math.log(2.0), 1)) != resDeltaZ) {
                doRescaleZ = false;
                if (ignoreErrorOnScale) {
                    System.out.println("[Warning] ROIUtil.adjustToSequence: ignoring ROI Z rescaling (scale Z = " + scaleZ + ")");
                } else {
                    throw new UnsupportedOperationException("ROIUtil.adjustToSequence: cannot rescale ROI (scale Z = " + scaleZ + ") !");
                }
            }
            v0 = zScaling = resDeltaZ != 0.0;
            if (zScaling && MathUtil.round(resDeltaZ / resDelta, 3) != 1.0) {
                doRescaleZ = false;
                if (ignoreErrorOnScale) {
                    System.out.println("[Warning] ROIUtil.adjustToSequence: ignoring ROI Z rescaling (scale XY = " + scaleX + " while scale Z = " + scaleZ + ")");
                } else {
                    throw new UnsupportedOperationException("ROIUtil.adjustToSequence: cannot rescale ROI (scale XY = " + scaleX + " while scale Z = " + scaleZ + ") !");
                }
            }
            try {
                if (!doRescale) break block21;
                i = (int)resDelta;
                if (!(resDelta > 0.0)) ** GOTO lbl48
                while (i-- > 0) {
                    result = ROIUtil.getUpscaled(result, zScaling != false && doRescaleZ != false);
                }
                break block21;
lbl-1000:
                // 1 sources

                {
                    result = ROIUtil.getDownscaled(result, zScaling != false && doRescaleZ != false);
lbl48:
                    // 2 sources

                    ** while (i++ < 0)
                }
lbl49:
                // 1 sources

            }
            catch (UnsupportedOperationException e) {
                if (ignoreErrorOnScale) break block21;
                throw e;
            }
        }
        if (translate && result.canSetPosition()) {
            pos = result.getPosition5D();
            if (!Double.isInfinite(pos.getZ())) {
                offset = SequenceUtil.convertPoint(new Point3D.Double(), source, destination);
                pos.setX(pos.getX() + offset.getX());
                pos.setY(pos.getY() + offset.getY());
                pos.setZ(pos.getZ() + offset.getZ());
            } else {
                offset = SequenceUtil.convertPoint((Point2D)new Point2D.Double(), source, destination);
                pos.setX(pos.getX() + offset.getX());
                pos.setY(pos.getY() + offset.getY());
            }
            if (!Double.isInfinite(pos.getT()) && (timeIntervalMs = destination.getTimeInterval() * 1000.0) > 0.0 && (tOffset = (deltaT = (double)(source.getPositionT() - destination.getPositionT())) / timeIntervalMs) > -1000.0 && tOffset < 1000.0) {
                pos.setT(Math.min(999.0, Math.max(0.0, pos.getT() + tOffset)));
            }
            result.setPosition5D(pos);
        }
        return result;
    }

    public static ROI adjustToSequence(ROI roi, Sequence source, Sequence destination, boolean translate, boolean scale) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.adjustToSequence(roi, source, destination, translate, scale, false);
    }

    public static ROI adjustToSequence(ROI roi, Sequence source, Sequence destination) throws UnsupportedOperationException, InterruptedException {
        return ROIUtil.adjustToSequence(roi, source, destination, true, true);
    }

    public static void copyROIProperties(ROI source, ROI destination, boolean copyName) {
        if (source == null || destination == null) {
            return;
        }
        if (copyName) {
            destination.setName(source.getName());
        }
        destination.setColor(source.getColor());
        destination.setOpacity(source.getOpacity());
        destination.setStroke(source.getStroke());
        destination.setReadOnly(source.isReadOnly());
        destination.setSelected(source.isSelected());
        destination.setShowName(source.getShowName());
        for (Map.Entry<String, String> propertyEntry : source.getProperties().entrySet()) {
            destination.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
        }
    }

    public static Sequence computeDistanceMap(ROI roi, Dimension5D imageSize, Dimension3D pixelSize, boolean constrainBorders) throws InterruptedException {
        ROIDistanceTransformCalculator dt = new ROIDistanceTransformCalculator(imageSize, pixelSize, constrainBorders);
        dt.addROI(roi);
        return dt.getDistanceMap();
    }

    public static Sequence computeDistanceMap(Collection<? extends ROI> selectedROIs, Dimension5D imageSize, Dimension3D pixelSize, boolean constrainBorders) throws InterruptedException {
        ROIDistanceTransformCalculator dt = new ROIDistanceTransformCalculator(imageSize, pixelSize, constrainBorders);
        dt.addAll(selectedROIs);
        return dt.getDistanceMap();
    }

    public static List<ROI> computeWatershedSeparation(Collection<? extends ROI> selectedRois, List<? extends ROI> seedRois, Dimension5D imageSize, Dimension3D pixelSize) throws InterruptedException {
        ROIWatershedCalculator.Builder wsBuilder = new ROIWatershedCalculator.Builder(imageSize, pixelSize);
        wsBuilder.addObjects(selectedRois);
        wsBuilder.addSeeds(seedRois);
        wsBuilder.setNewBasinsAllowed(false);
        ROIWatershedCalculator wsCalculator = wsBuilder.build();
        try {
            wsCalculator.call();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error computing watershed: " + e.getMessage(), e);
        }
        return wsCalculator.getLabelRois();
    }

    public static List<ROI> computeWatershedSeparation(Collection<? extends ROI> selectedRois, Dimension5D imageSize, Dimension3D pixelSize, List<ROI> usedSeedRois) throws InterruptedException {
        ROIWatershedCalculator.Builder wsBuilder = new ROIWatershedCalculator.Builder(imageSize, pixelSize);
        wsBuilder.addObjects(selectedRois);
        wsBuilder.addSeeds(usedSeedRois);
        wsBuilder.setNewBasinsAllowed(false);
        ROIWatershedCalculator wsCalculator = wsBuilder.build();
        try {
            wsCalculator.call();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error computing watershed: " + e.getMessage(), e);
        }
        usedSeedRois.clear();
        usedSeedRois.addAll(wsCalculator.getSeeds());
        return wsCalculator.getLabelRois();
    }

    public static List<ROI> computeSkeleton(List<ROI2D> selectedROIs, Dimension3D pixelSize, double distance) throws InterruptedException {
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (ROI rOI : selectedROIs) {
            if (rOI.getBounds5D().getSizeX() == 0.0) continue;
            Point5D.Double oldPosition = new Point5D.Double();
            oldPosition.setLocation(rOI.getPosition5D());
            rOI.setPosition5D(new Point5D.Double());
            try {
                ROISkeletonCalculator skeletonizer = new ROISkeletonCalculator(rOI, pixelSize);
                ROI skeletonRoi = skeletonizer.getSkeletonROI();
                if (skeletonRoi == null || !(skeletonRoi.getBounds5D().getSizeX() > 0.0)) continue;
                Point5D skeletonPosition = skeletonRoi.getPosition5D();
                skeletonPosition.setX(skeletonPosition.getX() + ((Point5D)oldPosition).getX());
                skeletonPosition.setY(skeletonPosition.getY() + ((Point5D)oldPosition).getY());
                skeletonPosition.setZ(skeletonPosition.getZ() + ((Point5D)oldPosition).getZ());
                skeletonRoi.setPosition5D(skeletonPosition);
                result.add(skeletonRoi);
            }
            finally {
                rOI.setPosition5D(oldPosition);
            }
        }
        return result;
    }

    public static List<ROI> computeDilation(List<? extends ROI> selectedROIs, Dimension3D pixelSize, double distance) throws InterruptedException {
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (ROI rOI : selectedROIs) {
            if (rOI.getBounds5D().getSizeX() == 0.0) continue;
            Rectangle5D.Double oldBounds = new Rectangle5D.Double(rOI.getBounds5D());
            Rectangle5D.Double processingBounds = new Rectangle5D.Double(rOI.getBounds5D());
            ((Rectangle5D)processingBounds).setX(0.0);
            ((Rectangle5D)processingBounds).setY(0.0);
            ((Rectangle5D)processingBounds).setZ(0.0);
            ((Rectangle5D)processingBounds).setC(0.0);
            ((Rectangle5D)processingBounds).setT(0.0);
            ((Rectangle5D)processingBounds).setSizeX(((Rectangle5D)oldBounds).getSizeX());
            ((Rectangle5D)processingBounds).setSizeY(((Rectangle5D)oldBounds).getSizeY());
            ((Rectangle5D)processingBounds).setSizeZ(1.0);
            ((Rectangle5D)processingBounds).setSizeC(1.0);
            ((Rectangle5D)processingBounds).setSizeT(1.0);
            if (rOI.getBounds5D().getSizeZ() > 1.0 && Double.isFinite(rOI.getBounds5D().getSizeZ())) {
                ((Rectangle5D)processingBounds).setZ(0.0);
                ((Rectangle5D)processingBounds).setSizeZ(((Rectangle5D)oldBounds).getSizeZ());
            }
            rOI.setBounds5D(processingBounds);
            if (rOI instanceof ROI2DArea) {
                ((ROI2DArea)rOI).setPosition2D(new Point2D.Double(0.0, 0.0));
            }
            try {
                ROIDilationCalculator dilator = new ROIDilationCalculator(rOI, pixelSize, distance);
                ROI dilationRoi = dilator.getDilation();
                Rectangle5D dilationBounds = dilationRoi.getBounds5D();
                if (dilationBounds.getSizeX() > 0.0) {
                    Point5D dPos = dilationBounds.getPosition();
                    Point5D oPos = ((Rectangle5D)oldBounds).getPosition();
                    dilationBounds.setX(dPos.getX() + oPos.getX());
                    dilationBounds.setY(dPos.getY() + oPos.getY());
                    if (Double.isFinite(((Rectangle5D)oldBounds).getSizeZ())) {
                        dilationBounds.setZ(dPos.getZ() + oPos.getZ());
                        if (Double.isFinite(((Rectangle5D)oldBounds).getSizeZ()) && Double.isInfinite(dilationBounds.getSizeZ())) {
                            dilationBounds.setSizeZ(((Rectangle5D)oldBounds).getSizeZ());
                        }
                    }
                    if (Double.isFinite(((Rectangle5D)oldBounds).getSizeT())) {
                        dilationBounds.setT(oPos.getT());
                        dilationBounds.setSizeT(((Rectangle5D)oldBounds).getSizeT());
                    }
                    if (dilationRoi.canSetBounds()) {
                        dilationRoi.setBounds5D(dilationBounds);
                    } else if (dilationRoi instanceof ROI2DArea) {
                        ROI2DArea areaRoi = (ROI2DArea)dilationRoi;
                        areaRoi.setC(Double.isFinite(dilationBounds.getC()) ? (int)dilationBounds.getC() : -1);
                        areaRoi.setZ(Double.isFinite(dilationBounds.getZ()) ? (int)dilationBounds.getZ() : -1);
                        areaRoi.setT(Double.isFinite(dilationBounds.getT()) ? (int)dilationBounds.getT() : -1);
                        Rectangle2D bounds = areaRoi.getBounds2D();
                        areaRoi.translate(dilationBounds.getX() - bounds.getX(), dilationBounds.getY() - bounds.getY());
                    }
                }
                result.add(dilationRoi);
            }
            finally {
                rOI.setBounds5D(oldBounds);
                if (rOI instanceof ROI2DArea) {
                    ((ROI2DArea)rOI).setPosition2D(new Point2D.Double(((Rectangle5D)oldBounds).getX(), ((Rectangle5D)oldBounds).getY()));
                }
            }
        }
        return result;
    }

    public static List<ROI> computeErosion(List<? extends ROI> selectedROIs, Dimension3D pixelSize, double distance) throws InterruptedException {
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (ROI rOI : selectedROIs) {
            if (rOI.getBounds5D().getSizeX() == 0.0) continue;
            Point5D.Double oldPosition = new Point5D.Double();
            oldPosition.setLocation(rOI.getPosition5D());
            rOI.setPosition5D(new Point5D.Double());
            try {
                ROIErosionCalculator eroder = new ROIErosionCalculator(rOI, pixelSize, distance);
                ROI erosionRoi = eroder.getErosion();
                if (!(erosionRoi.getBounds5D().getSizeX() > 0.0)) continue;
                Point5D erosionPosition = erosionRoi.getPosition5D();
                erosionPosition.setX(erosionPosition.getX() + ((Point5D)oldPosition).getX());
                erosionPosition.setY(erosionPosition.getY() + ((Point5D)oldPosition).getY());
                erosionPosition.setZ(erosionPosition.getZ() + ((Point5D)oldPosition).getZ());
                erosionRoi.setPosition5D(erosionPosition);
                result.add(erosionRoi);
            }
            finally {
                rOI.setPosition5D(oldPosition);
            }
        }
        return result;
    }
}

