/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import plugins.kernel.roi.descriptor.property.ROIPositionCDescriptor;
import plugins.kernel.roi.descriptor.property.ROIPositionTDescriptor;
import plugins.kernel.roi.descriptor.property.ROIPositionXDescriptor;
import plugins.kernel.roi.descriptor.property.ROIPositionYDescriptor;
import plugins.kernel.roi.descriptor.property.ROIPositionZDescriptor;

public class ROIPositionDescriptorsPlugin
extends Plugin
implements PluginROIDescriptor {
    public static final String ID_POSITION_X = "Position X";
    public static final String ID_POSITION_Y = "Position Y";
    public static final String ID_POSITION_Z = "Position Z";
    public static final String ID_POSITION_T = "Position T";
    public static final String ID_POSITION_C = "Position C";
    public static final ROIPositionXDescriptor positionXDescriptor = new ROIPositionXDescriptor();
    public static final ROIPositionYDescriptor positionYDescriptor = new ROIPositionYDescriptor();
    public static final ROIPositionZDescriptor positionZDescriptor = new ROIPositionZDescriptor();
    public static final ROIPositionTDescriptor positionTDescriptor = new ROIPositionTDescriptor();
    public static final ROIPositionCDescriptor positionCDescriptor = new ROIPositionCDescriptor();

    @Override
    public List<ROIDescriptor> getDescriptors() {
        ArrayList<ROIDescriptor> result = new ArrayList<ROIDescriptor>();
        result.add(positionXDescriptor);
        result.add(positionYDescriptor);
        result.add(positionZDescriptor);
        result.add(positionTDescriptor);
        result.add(positionCDescriptor);
        return result;
    }

    @Override
    public Map<ROIDescriptor, Object> compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        HashMap<ROIDescriptor, Object> result = new HashMap<ROIDescriptor, Object>();
        try {
            Point5D position = roi.getPosition5D();
            result.put(positionXDescriptor, ROIPositionXDescriptor.getPositionX(position));
            result.put(positionYDescriptor, ROIPositionYDescriptor.getPositionY(position));
            result.put(positionZDescriptor, ROIPositionZDescriptor.getPositionZ(position));
            result.put(positionTDescriptor, ROIPositionTDescriptor.getPositionT(position));
            result.put(positionCDescriptor, ROIPositionCDescriptor.getPositionC(position));
        }
        catch (Exception e) {
            String mess = String.valueOf(this.getClass().getSimpleName()) + ": cannot compute descriptors for '" + roi.getName() + "'";
            throw new UnsupportedOperationException(mess, e);
        }
        return result;
    }
}

