/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker;

import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.util.XMLUtil;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackSegment;
import plugins.nchenouard.spot.Detection;

public class KymographTrackingResults {
    ArrayList<ArrayList<double[]>> tracks1D;
    TrackGroup tracks2D;
    public static String KYMO_TRACKING_RESULTS = "KymographTrackingResults";
    public static String KYMO_TRACK = "KymographTrack";
    public static String TRACKS = "Tracks";
    public static String TIME_LIST = "TimeList";
    public static String POSITION_LIST = "PositionList";
    public static String POSITION_LISTX = "PositionListX";
    public static String POSITION_LISTY = "PositionListY";

    public static void generateDefaultNode(Element node) {
        XMLUtil.setElement((Node)node, (String)KYMO_TRACKING_RESULTS);
    }

    public void saveToXML(Element node) {
        Element nodeKymoResults = XMLUtil.setElement((Node)node, (String)KYMO_TRACKING_RESULTS);
        for (int i = 0; i < this.tracks1D.size(); ++i) {
            Element nodeTrack = XMLUtil.addElement((Node)nodeKymoResults, (String)KYMO_TRACK);
            String timeString = "";
            String positionString = "";
            for (int j = 0; j < this.tracks1D.get(i).size(); ++j) {
                timeString = timeString.concat(this.tracks1D.get(i).get(j)[0] + ", ");
                positionString = positionString.concat(this.tracks1D.get(i).get(j)[1] + ", ");
            }
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)TIME_LIST, (String)timeString);
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)POSITION_LIST, (String)positionString);
            String positionStringX = "";
            String positionStringY = "";
            for (int j = 0; j < ((TrackSegment)this.tracks2D.getTrackSegmentList().get(i)).getDetectionList().size(); ++j) {
                positionStringX = positionStringX.concat(((TrackSegment)this.tracks2D.getTrackSegmentList().get(i)).getDetectionAt(j).getX() + ", ");
                positionStringY = positionStringY.concat(((TrackSegment)this.tracks2D.getTrackSegmentList().get(i)).getDetectionAt(j).getY() + ", ");
            }
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)POSITION_LISTX, (String)positionStringX);
            XMLUtil.setAttributeValue((Element)nodeTrack, (String)POSITION_LISTY, (String)positionStringY);
        }
    }

    public static KymographTrackingResults loadFromXML(Element node, Sequence sourceSequence, String trackGroupName) {
        Element e = XMLUtil.getElement((Node)node, (String)KYMO_TRACKING_RESULTS);
        if (e == null) {
            return null;
        }
        KymographTrackingResults r = new KymographTrackingResults();
        r.tracks1D = new ArrayList();
        r.tracks2D = new TrackGroup(sourceSequence);
        r.tracks2D.setDescription(trackGroupName);
        ArrayList trackElements = XMLUtil.getElements((Node)e, (String)KYMO_TRACK);
        for (Element te : trackElements) {
            String s = XMLUtil.getAttributeValue((Element)te, (String)TIME_LIST, (String)"");
            String[] ss = s.split(",");
            ArrayList<Double> tList = new ArrayList<Double>();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].trim().isEmpty()) continue;
                tList.add(Double.valueOf(ss[i]));
            }
            s = XMLUtil.getAttributeValue((Element)te, (String)POSITION_LIST, (String)"");
            ss = s.split(",");
            ArrayList<Double> pList = new ArrayList<Double>();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].trim().isEmpty()) continue;
                pList.add(Double.valueOf(ss[i]));
            }
            ArrayList<double[]> trk1D = new ArrayList<double[]>();
            for (int i = 0; i < tList.size(); ++i) {
                trk1D.add(new double[]{(Double)tList.get(i), (Double)pList.get(i)});
            }
            r.tracks1D.add(trk1D);
            s = XMLUtil.getAttributeValue((Element)te, (String)POSITION_LISTX, (String)"");
            ss = s.split(",");
            ArrayList<Double> xList = new ArrayList<Double>();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].trim().isEmpty()) continue;
                xList.add(Double.valueOf(ss[i]));
            }
            s = XMLUtil.getAttributeValue((Element)te, (String)POSITION_LISTY, (String)"");
            ss = s.split(",");
            ArrayList<Double> yList = new ArrayList<Double>();
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].trim().isEmpty()) continue;
                yList.add(Double.valueOf(ss[i]));
            }
            TrackSegment ts = new TrackSegment();
            for (int i = 0; i < xList.size(); ++i) {
                ts.addDetection(new Detection(((Double)xList.get(i)).doubleValue(), ((Double)yList.get(i)).doubleValue(), 0.0, ((Double)tList.get(i)).intValue()));
            }
            r.tracks2D.addTrackSegment(ts);
        }
        Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)r.tracks2D));
        return r;
    }
}

