/*
 * Decompiled with CFR 0.152.
 */
package mitiv.conv;

import mitiv.array.ArrayUtils;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.ConvolutionDouble1D;
import mitiv.conv.ConvolutionDouble2D;
import mitiv.conv.ConvolutionDouble3D;
import mitiv.conv.ConvolutionFloat1D;
import mitiv.conv.ConvolutionFloat2D;
import mitiv.conv.ConvolutionFloat3D;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.ShapedLinearOperator;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.FFTUtils;
import mitiv.utils.Timer;

public abstract class Convolution
extends ShapedLinearOperator {
    protected final int rank;
    protected final int type;
    protected final Shape workShape;
    protected final int[] inputOffsets;
    protected final boolean fastInput;
    protected final int[] outputOffsets;
    protected final boolean fastOutput;
    protected Timer timerForFFT = new Timer();
    protected Timer timer = new Timer();

    protected Convolution(ShapedVectorSpace space) {
        this(null, space, space);
    }

    protected Convolution(ShapedVectorSpace inp, ShapedVectorSpace out) {
        this(null, inp, out);
    }

    protected Convolution(Shape wrk, ShapedVectorSpace inp, ShapedVectorSpace out) {
        this(wrk, inp, null, out, null);
    }

    protected Convolution(Shape wrk, ShapedVectorSpace inp, int[] inpOff, ShapedVectorSpace out, int[] outOff) {
        super(inp, out);
        int k;
        this.type = inp.getType();
        if (this.type != 4 && this.type != 5) {
            throw new IllegalArgumentException("Expecting a floating-point type");
        }
        if (out.getType() != this.type) {
            throw new IllegalTypeException("Input and output spaces must have the same element type");
        }
        this.rank = inp.getRank();
        if (out.getShape().rank() != this.rank) {
            throw new IllegalTypeException("Input and output spaces must have the same rank");
        }
        if (wrk == null) {
            int[] dims = new int[this.rank];
            for (k = 0; k < this.rank; ++k) {
                dims[k] = FFTUtils.bestDimension(Math.max(inp.getDimension(k), out.getDimension(k)));
            }
            wrk = new Shape(dims);
        } else {
            if (wrk.rank() != this.rank) {
                throw new IllegalArgumentException("Bad number of work space dimensions");
            }
            for (int k2 = 0; k2 < this.rank; ++k2) {
                if (wrk.dimension(k2) >= Math.max(inp.getDimension(k2), out.getDimension(k2))) continue;
                throw new IllegalArgumentException("Work space dimension(s) too small");
            }
        }
        this.workShape = wrk;
        boolean sameDims = true;
        this.inputOffsets = new int[this.rank];
        if (inpOff == null) {
            for (k = 0; k < this.rank; ++k) {
                this.inputOffsets[k] = wrk.dimension(k) / 2 - inp.getDimension(k) / 2;
                if (inp.getDimension(k) == wrk.dimension(k)) continue;
                sameDims = false;
            }
        } else {
            if (inpOff.length != this.rank) {
                throw new IllegalArgumentException("Bad number of input offsets");
            }
            for (k = 0; k < this.rank; ++k) {
                if (inpOff[k] < 0 || inpOff[k] + inp.getDimension(k) > wrk.dimension(k)) {
                    throw new IllegalArgumentException("Out of bound input offset(s)");
                }
                this.inputOffsets[k] = inpOff[k];
                if (inp.getDimension(k) == wrk.dimension(k)) continue;
                sameDims = false;
            }
        }
        this.fastInput = sameDims;
        sameDims = true;
        this.outputOffsets = new int[this.rank];
        if (outOff == null) {
            for (k = 0; k < this.rank; ++k) {
                this.outputOffsets[k] = wrk.dimension(k) / 2 - out.getDimension(k) / 2;
                if (out.getDimension(k) == wrk.dimension(k)) continue;
                sameDims = false;
            }
        } else {
            if (outOff.length != this.rank) {
                throw new IllegalArgumentException("Bad number of output offsets");
            }
            for (k = 0; k < this.rank; ++k) {
                if (outOff[k] < 0 || outOff[k] + out.getDimension(k) > wrk.dimension(k)) {
                    throw new IllegalArgumentException("Out of bound output offset(s)");
                }
                this.outputOffsets[k] = outOff[k];
                if (out.getDimension(k) == wrk.dimension(k)) continue;
                sameDims = false;
            }
        }
        this.fastOutput = sameDims;
    }

    public final int getRank() {
        return this.rank;
    }

    public final int getType() {
        return this.type;
    }

    public final int getNumberOfFrequencies() {
        long number = this.workShape.number();
        if (2L * number > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many frequencies for 32-bit integers");
        }
        return (int)number;
    }

    public final Shape getWorkShape() {
        return this.workShape;
    }

    public static Convolution build(ShapedVectorSpace space) {
        return Convolution.build(space, space);
    }

    public static Convolution build(ShapedVectorSpace inp, ShapedVectorSpace out) {
        return Convolution.build(null, inp, null, out, null);
    }

    public static Convolution build(Shape wrk, ShapedVectorSpace inp, ShapedVectorSpace out) {
        return Convolution.build(wrk, inp, null, out, null);
    }

    public static Convolution build(Shape wrk, ShapedVectorSpace inp, int[] inpOff, ShapedVectorSpace out, int[] outOff) {
        int type = inp.getType();
        int rank = inp.getRank();
        switch (type) {
            case 4: {
                switch (rank) {
                    case 1: {
                        return new ConvolutionFloat1D(wrk, inp, inpOff, out, outOff);
                    }
                    case 2: {
                        return new ConvolutionFloat2D(wrk, inp, inpOff, out, outOff);
                    }
                    case 3: {
                        return new ConvolutionFloat3D(wrk, inp, inpOff, out, outOff);
                    }
                }
                break;
            }
            case 5: {
                switch (rank) {
                    case 1: {
                        return new ConvolutionDouble1D(wrk, inp, inpOff, out, outOff);
                    }
                    case 2: {
                        return new ConvolutionDouble2D(wrk, inp, inpOff, out, outOff);
                    }
                    case 3: {
                        return new ConvolutionDouble3D(wrk, inp, inpOff, out, outOff);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException("Only float and double types are implemented");
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D and 3D convolution are implemented");
    }

    public abstract void forwardFFT();

    public abstract void backwardFFT();

    public abstract void push(ShapedVector var1, boolean var2);

    public abstract void pull(ShapedVector var1, boolean var2);

    public abstract void convolve(boolean var1);

    public static int[] center(Shape shape) {
        int rank = shape.rank();
        int[] off = new int[rank];
        for (int k = 0; k < rank; ++k) {
            off[k] = shape.dimension(k) / 2;
        }
        return off;
    }

    public abstract void setPSF(ShapedVector var1);

    public void setPSF(ShapedArray psf) {
        this.setPSF(psf, null, false);
    }

    public void setPSF(ShapedArray psf, int[] off) {
        this.setPSF(psf, off, false);
    }

    public void setPSF(ShapedArray psf, boolean normalize) {
        this.setPSF(psf, null, normalize);
    }

    public abstract void setPSF(ShapedArray var1, int[] var2, boolean var3);

    protected ShapedArray adjustPSF(ShapedArray psf, int[] off) {
        Shape psfShape = psf.getShape();
        Shape inpShape = this.getInputSpace().getShape();
        int rank = inpShape.rank();
        if (psfShape.rank() != rank) {
            throw new IllegalArgumentException("PSF rank not conformable");
        }
        if (off == null) {
            off = Convolution.center(psfShape);
        }
        if (off.length != rank) {
            throw new IllegalArgumentException("Number of coordinates not conformable");
        }
        int[] shift = new int[rank];
        for (int k = 0; k < rank; ++k) {
            int inpDim;
            int psfDim = psfShape.dimension(k);
            if (psfDim > (inpDim = inpShape.dimension(k))) {
                throw new IllegalArgumentException("PSF dimension(s) too large");
            }
            int margin = inpDim / 2 - psfDim / 2;
            shift[k] = -(margin + off[k]);
        }
        return ArrayUtils.roll(ArrayUtils.pad(psf, inpShape), shift);
    }

    @Override
    protected void _apply(Vector dst, Vector src, int job) {
        if (job != DIRECT && job != ADJOINT) {
            throw new NotImplementedException("For now we do not implement inverse convolution operations (talk to a specialist if you ignore the dangers of doing that!)");
        }
        boolean adjoint = job == ADJOINT;
        this.push((ShapedVector)src, adjoint);
        this.convolve(adjoint);
        this.pull((ShapedVector)dst, adjoint);
    }

    protected static boolean checkPushPullArguments(int rank, Shape wrk, Shape usr, int[] off) {
        boolean sameDims = true;
        if (wrk == null || wrk.rank() != rank) {
            throw new IllegalArgumentException(String.format("The work space must have %d dimension(s)", rank));
        }
        if (usr == null || usr.rank() != rank) {
            throw new IllegalArgumentException(String.format("The user space must have %d dimension(s)", rank));
        }
        if (off == null) {
            for (int k = 0; k < rank; ++k) {
                int wrkDim = wrk.dimension(k);
                int usrDim = usr.dimension(k);
                if (usrDim > wrkDim) {
                    throw new IllegalArgumentException("User region is too large");
                }
                if (usrDim == wrkDim) continue;
                sameDims = false;
            }
        } else {
            if (off.length != rank) {
                throw new IllegalArgumentException(String.format("The offsets must have %d element(s)", rank));
            }
            for (int k = 0; k < rank; ++k) {
                int wrkDim = wrk.dimension(k);
                int usrDim = usr.dimension(k);
                if (off[k] < 0 || off[k] >= wrkDim) {
                    throw new IllegalArgumentException("Out of range offset");
                }
                if (off[k] + usrDim > wrkDim) {
                    throw new IllegalArgumentException("User region beyond limits");
                }
                if (usrDim == wrkDim) continue;
                sameDims = false;
            }
        }
        return sameDims;
    }

    public void resetTimers() {
        this.timerForFFT.stop();
        this.timerForFFT.reset();
        this.timer.stop();
        this.timer.reset();
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public double getElapsedTimeInFFT() {
        return this.timerForFFT.getElapsedTime();
    }
}

