/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class DoubleShapedVectorSpace
extends ShapedVectorSpace {
    public DoubleShapedVectorSpace(Shape shape) {
        super(5, shape);
    }

    public DoubleShapedVectorSpace(int ... dims) {
        super(5, dims);
    }

    private double[] getData(Vector v) {
        return ((DoubleShapedVector)v).getData();
    }

    @Override
    public DoubleShapedVector create() {
        return new DoubleShapedVector(this);
    }

    @Override
    public DoubleShapedVector create(double value) {
        DoubleShapedVector v = new DoubleShapedVector(this);
        ArrayOps.fill(v.getData(), this.number, value);
        return v;
    }

    @Override
    public DoubleShapedVector create(ShapedArray arr) {
        return this.create(arr, false);
    }

    @Override
    public DoubleShapedVector create(ShapedArray arr, boolean forceCopy) {
        this.checkShape(arr);
        DoubleArray tmp = arr.toDouble();
        return new DoubleShapedVector(this, tmp.flatten(forceCopy && tmp == arr));
    }

    public DoubleShapedVector create(DoubleArray arr) {
        return this.create(arr, false);
    }

    public DoubleShapedVector create(DoubleArray arr, boolean forceCopy) {
        this.checkShape(arr);
        return new DoubleShapedVector(this, arr.flatten(forceCopy));
    }

    public DoubleShapedVector clone(DoubleShapedVector vec) {
        this.check(vec);
        return this._clone(vec);
    }

    protected DoubleShapedVector _clone(DoubleShapedVector vec) {
        DoubleShapedVector cpy = new DoubleShapedVector(this);
        this._copy(cpy, vec);
        return cpy;
    }

    @Override
    protected DoubleShapedVector _clone(Vector vec) {
        return this._clone((DoubleShapedVector)vec);
    }

    public DoubleShapedVector wrap(double[] x) {
        return new DoubleShapedVector(this, x);
    }

    public void copy(Vector dst, double[] src) {
        this.check(dst);
        ArrayOps.copy(this.getData(dst), src);
    }

    @Override
    protected void _copy(Vector dst, Vector src) {
        if (dst != src) {
            System.arraycopy(this.getData(src), 0, this.getData(dst), 0, this.number);
        }
    }

    @Override
    protected void _swap(Vector vx, Vector vy) {
        double[] x = this.getData(vx);
        double[] y = this.getData(vy);
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            double xi = x[i];
            x[i] = y[i];
            y[i] = xi;
        }
    }

    @Override
    protected void _fill(Vector vec, double alpha) {
        double[] x = this.getData(vec);
        for (int i = 0; i < this.number; ++i) {
            x[i] = alpha;
        }
    }

    @Override
    protected double _dot(Vector x, Vector y) {
        return ArrayOps.dot(this.number, this.getData(x), this.getData(y));
    }

    @Override
    protected double _dot(Vector w, Vector x, Vector y) {
        return ArrayOps.dot(this.number, this.getData(w), this.getData(x), this.getData(y));
    }

    @Override
    protected double _norm2(Vector x) {
        return ArrayOps.norm2(this.getData(x));
    }

    @Override
    protected double _norm1(Vector x) {
        return ArrayOps.norm1(this.getData(x));
    }

    @Override
    protected double _normInf(Vector x) {
        return ArrayOps.normInf(this.getData(x));
    }

    @Override
    protected void _scale(Vector vec, double alpha) {
        if (alpha == 0.0) {
            this._fill(vec, 0.0);
        } else if (alpha != 1.0) {
            double[] x = this.getData(vec);
            int i = 0;
            while (i < this.number) {
                int n = i++;
                x[n] = x[n] * alpha;
            }
        }
    }

    @Override
    protected void _scale(Vector dst, double alpha, Vector src) {
        if (alpha == 0.0) {
            this._fill(dst, 0.0);
        } else if (alpha == 1.0) {
            this._copy(dst, src);
        } else {
            double[] x = this.getData(src);
            double[] y = this.getData(dst);
            for (int i = 0; i < this.number; ++i) {
                y[i] = alpha * x[i];
            }
        }
    }

    @Override
    protected void _combine(Vector dst, double alpha, Vector x, double beta, Vector y) {
        ArrayOps.combine(this.getData(dst), this.number, alpha, this.getData(x), beta, this.getData(y));
    }

    @Override
    protected void _combine(Vector dst, double alpha, Vector x, double beta, Vector y, double gamma, Vector z) {
        ArrayOps.combine(this.getData(dst), this.number, alpha, this.getData(x), beta, this.getData(y), gamma, this.getData(z));
    }

    @Override
    protected void _multiply(Vector dst, Vector vx, Vector vy) {
        double[] x = this.getData(vx);
        double[] y = this.getData(vy);
        double[] z = this.getData(dst);
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            z[i] = x[i] * y[i];
        }
    }
}

