/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.variants;

import plugins.ylemontag.mathoperations.Variant;

public class SequenceIterators {

    public static abstract class Write
    extends Base
    implements Variant.WriteIterator {
        protected Write(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
            super(sizeX, sizeY, sizeZ, sizeT, sizeC);
        }

        @Override
        public void set(double value) {
            this._buffer[this._xy] = value;
        }
    }

    public static abstract class Read
    extends Base
    implements Variant.ReadIterator {
        protected Read(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
            super(sizeX, sizeY, sizeZ, sizeT, sizeC);
        }

        @Override
        public double get() {
            return this._buffer[this._xy];
        }
    }

    public static abstract class Base
    implements Variant.Iterator {
        protected double[] _buffer;
        protected int _sizeXY;
        protected int _sizeC;
        protected int _sizeZ;
        protected int _sizeT;
        protected int _xy;
        protected int _c;
        protected int _z;
        protected int _t;

        protected Base(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
            this._sizeXY = sizeX * sizeY;
            this._sizeC = sizeC;
            this._sizeZ = sizeZ;
            this._sizeT = sizeT;
            this._xy = 0;
            this._c = 0;
            this._z = 0;
            this._t = 0;
        }

        protected abstract void refreshBuffer();

        protected void invalidateBuffer() {
            this._buffer = null;
        }

        @Override
        public boolean valid() {
            return this._buffer != null;
        }

        @Override
        public void next() {
            ++this._xy;
            if (this._xy >= this._sizeXY) {
                this._xy = 0;
                ++this._c;
                if (this._c >= this._sizeC) {
                    this._c = 0;
                    ++this._z;
                    if (this._z >= this._sizeZ) {
                        this._z = 0;
                        ++this._t;
                        if (this._t >= this._sizeT) {
                            this.invalidateBuffer();
                            return;
                        }
                    }
                }
                this.refreshBuffer();
            }
        }

        @Override
        public void startAt(long num) {
            if (this._sizeXY == 0 || this._sizeZ == 0 || this._sizeT == 0 || this._sizeC == 0) {
                this.invalidateBuffer();
                return;
            }
            int carry = 0;
            if (num > 0L || carry != 0) {
                this._xy = (int)((long)this._xy + (num % (long)this._sizeXY + (long)carry));
                num /= (long)this._sizeXY;
                if (this._xy >= this._sizeXY) {
                    carry = 1;
                    this._xy -= this._sizeXY;
                } else {
                    carry = 0;
                }
                if (num > 0L || carry != 0) {
                    this._c = (int)((long)this._c + (num % (long)this._sizeC + (long)carry));
                    num /= (long)this._sizeC;
                    if (this._c >= this._sizeC) {
                        carry = 1;
                        this._c -= this._sizeC;
                    } else {
                        carry = 0;
                    }
                    if (num > 0L || carry != 0) {
                        this._z = (int)((long)this._z + (num % (long)this._sizeZ + (long)carry));
                        num /= (long)this._sizeZ;
                        if (this._z >= this._sizeZ) {
                            carry = 1;
                            this._z -= this._sizeZ;
                        } else {
                            carry = 0;
                        }
                        if (num > 0L || carry != 0) {
                            this._t = (int)((long)this._t + (num % (long)this._sizeT + (long)carry));
                            num /= (long)this._sizeT;
                            if (this._t >= this._sizeT) {
                                carry = 1;
                                this._t -= this._sizeT;
                            } else {
                                carry = 0;
                            }
                            if (num > 0L || carry != 0) {
                                this.invalidateBuffer();
                                return;
                            }
                        }
                    }
                }
            }
            this.refreshBuffer();
        }
    }
}

