/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.livebar;

import icy.network.NetworkUtil;
import icy.search.OnlineSearchResultProducer;
import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.livebar.ProtocolDescriptor;
import plugins.adufour.protocols.livebar.ProtocolRichToolTip;

public class OnlineProtocolProducer
extends OnlineSearchResultProducer {
    private static final String ID_TEXT = "string";
    private static final String ID_SEARCH_RESULT = "searchresult";
    private static final String ID_PROTOCOL = "protocol";

    public void doSearch(Document doc, String[] words, SearchResultConsumer consumer) {
        if (doc == null) {
            return;
        }
        if (((Object)((Object)this)).getClass().getClassLoader() != SystemUtil.getSystemClassLoader() && this.hasWaitingSearch()) {
            return;
        }
        Element resultElement = XMLUtil.getElement((Node)doc.getDocumentElement(), (String)ID_SEARCH_RESULT);
        if (resultElement == null) {
            return;
        }
        ArrayList<OnlineProtocolResult> tmpResults = new ArrayList<OnlineProtocolResult>();
        for (Element protocol : XMLUtil.getElements((Node)resultElement, (String)ID_PROTOCOL)) {
            if (((Object)((Object)this)).getClass().getClassLoader() != SystemUtil.getSystemClassLoader() && this.hasWaitingSearch()) {
                return;
            }
            ProtocolDescriptor onlineProtocol = new ProtocolDescriptor(protocol);
            String text = XMLUtil.getElementValue((Node)protocol, (String)ID_TEXT, (String)"");
            OnlineProtocolResult result = new OnlineProtocolResult((SearchResultProducer)this, onlineProtocol, text, words);
            if (result == null) continue;
            tmpResults.add(result);
        }
        this.results = tmpResults;
        consumer.resultsChanged((SearchResultProducer)this);
    }

    public String getName() {
        return "Online Protocols";
    }

    private class OnlineProtocolResult
    extends SearchResult {
        final ProtocolDescriptor protocol;
        private String description;

        public OnlineProtocolResult(SearchResultProducer provider, ProtocolDescriptor protocol, String text, String[] searchWords) {
            super(provider);
            this.protocol = protocol;
            this.description = "";
            for (int wi = 0; StringUtil.isEmpty((String)this.description) && wi < searchWords.length; ++wi) {
                this.description = StringUtil.trunc((String)text, (String)searchWords[wi], (int)80);
            }
            if (!StringUtil.isEmpty((String)this.description)) {
                this.description = this.description.replace("\n", "");
                if (searchWords.length > 1 || searchWords[0].length() > 2) {
                    for (String word : searchWords) {
                        this.description = StringUtil.htmlBoldSubstring((String)this.description, (String)word, (boolean)true);
                    }
                }
            }
        }

        public String getTitle() {
            return this.protocol.getName();
        }

        public Image getImage() {
            ImageIcon icon = this.protocol.getIcon();
            if (icon != null) {
                return icon.getImage();
            }
            return null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTooltip() {
            return "Left click: Open   -   Right click: Online documentation";
        }

        public void execute() {
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Protocols.loadWorkFlow(OnlineProtocolResult.this.protocol.getFile());
                }
            });
        }

        public void executeAlternate() {
            NetworkUtil.openBrowser((String)this.protocol.getWeb());
        }

        public RichTooltip getRichToolTip() {
            return new ProtocolRichToolTip(this.protocol);
        }
    }
}

