/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.morphology;

import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi3d.ROI3DArea;

public class ROIErosionCalculator {
    private ROI roi;
    private Dimension3D pixelSize;
    private double distance;
    private ROI erosionRoi;
    private static Point5D positionZero = new Point5D.Double();

    public ROIErosionCalculator(ROI roi, Dimension3D pixelSize, double distance) {
        this.roi = roi;
        this.pixelSize = pixelSize;
        this.distance = distance;
    }

    public ROI getErosion() throws InterruptedException {
        if (this.erosionRoi == null) {
            this.compute();
        }
        return this.erosionRoi;
    }

    public void compute() throws InterruptedException {
        Rectangle5D roiBounds = this.roi.getBounds5D();
        if (roiBounds.getSizeZ() == 1.0 || Double.isInfinite(roiBounds.getSizeZ())) {
            Dimension5D roiDims = roiBounds.getDimension();
            Dimension5D.Integer dims = new Dimension5D.Integer();
            ((Dimension5D)dims).setSizeX(Math.ceil(roiDims.getSizeX()));
            ((Dimension5D)dims).setSizeY(Math.ceil(roiDims.getSizeY()));
            ((Dimension5D)dims).setSizeZ(Double.isInfinite(roiBounds.getSizeZ()) ? 1.0 : Math.ceil(roiDims.getSizeZ()));
            ((Dimension5D)dims).setSizeT(Double.isInfinite(roiBounds.getSizeT()) ? 1.0 : Math.ceil(roiDims.getSizeT()));
            ((Dimension5D)dims).setSizeC(Double.isInfinite(roiBounds.getSizeC()) ? 1.0 : Math.ceil(roiDims.getSizeC()));
            this.roi.setPosition5D(positionZero);
            Sequence dt = ROIUtil.computeDistanceMap(this.roi, (Dimension5D)dims, this.pixelSize, true);
            ROI2DArea erosionRoi = new ROI2DArea();
            SequenceDataIterator dtIt = new SequenceDataIterator(dt, this.roi);
            erosionRoi.beginUpdate();
            try {
                while (!dtIt.done()) {
                    double pixelValue = dtIt.get();
                    if (pixelValue > this.distance) {
                        erosionRoi.addPoint(dtIt.getPositionX(), dtIt.getPositionY());
                    }
                    dtIt.next();
                }
            }
            finally {
                erosionRoi.endUpdate();
            }
            this.roi.setPosition5D(roiBounds.getPosition());
            Point2D erosionPosition = erosionRoi.getPosition2D();
            erosionPosition.setLocation(erosionPosition.getX() + roiBounds.getX(), erosionPosition.getY() + roiBounds.getY());
            this.erosionRoi = erosionRoi;
        } else if (this.roi.getBounds5D().getSizeZ() > 1.0) {
            ArrayList<ROI> listRois = new ArrayList<ROI>();
            listRois.add(this.roi);
            Sequence dt = ROIUtil.computeDistanceMap(listRois, this.roi.getBounds5D().getDimension(), this.pixelSize, true);
            ROI3DArea erosionRoi = new ROI3DArea();
            SequenceDataIterator dtIt = new SequenceDataIterator(dt, this.roi);
            while (!dtIt.done()) {
                double pixelValue = dtIt.get();
                if (pixelValue > this.distance) {
                    erosionRoi.addPoint(dtIt.getPositionX(), dtIt.getPositionY(), dtIt.getPositionZ());
                }
                dtIt.next();
            }
            this.erosionRoi = erosionRoi;
        } else {
            this.erosionRoi = null;
        }
    }
}

