/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.canvas.IcyCanvas;
import icy.math.Line3DIterator;
import icy.painter.Anchor3D;
import icy.resource.ResourceUtil;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.type.geom.Line3D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import plugins.kernel.roi.roi3d.ROI3DShape;
import vtk.vtkDataObject;
import vtk.vtkTubeFilter;

public class ROI3DLine
extends ROI3DShape {
    public static final String ID_PT1 = "pt1";
    public static final String ID_PT2 = "pt2";
    protected final Anchor3D pt1;
    protected final Anchor3D pt2;

    public ROI3DLine(Point3D pt1, Point3D pt2) {
        super(new Line3D());
        this.pt1 = this.createAnchor(pt1);
        this.pt2 = this.createAnchor(pt2);
        this.pt2.setSelected(true);
        this.addPoint(this.pt1);
        this.addPoint(this.pt2);
        this.setIcon(ResourceUtil.ICON_ROI_LINE);
    }

    public ROI3DLine(Line3D line) {
        this(line.getP1(), line.getP2());
    }

    public ROI3DLine(Point3D pt) {
        this(new Point3D.Double(pt.getX(), pt.getY(), pt.getZ()), pt);
    }

    public ROI3DLine(Point5D pt) {
        this(pt.toPoint3D());
    }

    public ROI3DLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        this(new Point3D.Double(x1, y1, z1), new Point3D.Double(x2, y2, z2));
    }

    public ROI3DLine() {
        this(new Point3D.Double(), new Point3D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Line3D";
    }

    @Override
    protected ROI3DShape.ROI3DShapePainter createPainter() {
        return new ROI3DLinePainter();
    }

    public Line3D getLine() {
        return (Line3D)this.shape;
    }

    @Override
    protected void updateShape() {
        this.getLine().setLine(this.pt1.getPosition(), this.pt2.getPosition());
        super.updateShape();
    }

    @Override
    public boolean canAddPoint() {
        return false;
    }

    @Override
    public boolean canRemovePoint() {
        return false;
    }

    @Override
    protected boolean removePoint(IcyCanvas canvas, Anchor3D pt) {
        return false;
    }

    @Override
    public boolean canSetBounds() {
        return true;
    }

    @Override
    public void setBounds3D(Rectangle3D bounds) {
        this.beginUpdate();
        try {
            this.pt1.setPosition(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
            this.pt2.setPosition(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        }
        finally {
            this.endUpdate();
        }
    }

    public void setLine(Line3D line) {
        this.setBounds3D(line.getBounds());
    }

    @Override
    protected double getTotalDistance(List<Point3D> points, double factorX, double factorY, double factorZ) {
        return Point3D.getTotalDistance(points, factorX, factorY, factorZ, false);
    }

    @Override
    public boolean[] getBooleanMask2D(int x, int y, int width, int height, int z, boolean inclusive) {
        if (width <= 0 || height <= 0) {
            return new boolean[0];
        }
        boolean[] result = new boolean[width * height];
        Rectangle bounds2d = new Rectangle(x, y, width, height);
        ROI3DLine.drawLine3DInBooleanMask2D(bounds2d, result, z, this.pt1.getPositionInternal(), this.pt2.getPositionInternal());
        return result;
    }

    public static void drawLine3DInBooleanMask2D(Rectangle bounds2d, boolean[] result, int z, Point3D p1, Point3D p2) {
        Line2D.Double l = new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
        if (l.intersects(bounds2d) && (p1.getZ() <= (double)z && p2.getZ() >= (double)z || p2.getZ() <= (double)z && p1.getZ() >= (double)z)) {
            int bx = bounds2d.x;
            int by = bounds2d.y;
            int pitch = bounds2d.width;
            Line3DIterator it = new Line3DIterator(new Line3D(p1, p2), 1.0);
            while (it.hasNext()) {
                int y;
                int x;
                Point3D pt = it.next();
                if (Math.floor(pt.getZ()) != (double)z || !bounds2d.contains(x = (int)Math.floor(pt.getX()), y = (int)Math.floor(pt.getY()))) continue;
                result[x - bx + (y - by) * pitch] = true;
            }
        }
    }

    @Override
    public double computeNumberOfPoints() {
        return 0.0;
    }

    @Override
    public boolean contains(ROI roi) {
        return false;
    }

    @Override
    public boolean intersects(ROI r) throws InterruptedException {
        if (r instanceof ROI3DLine) {
            return this.onSamePos((ROI3DLine)r, false) && ((ROI3DLine)r).getLine().intersectsLine(this.getLine());
        }
        return super.intersects(r);
    }

    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                return false;
            }
            this.pt1.loadPositionFromXML(XMLUtil.getElement(node, ID_PT1));
            this.pt2.loadPositionFromXML(XMLUtil.getElement(node, ID_PT2));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        this.pt1.savePositionToXML(XMLUtil.setElement(node, ID_PT1));
        this.pt2.savePositionToXML(XMLUtil.setElement(node, ID_PT2));
        return true;
    }

    public class ROI3DLinePainter
    extends ROI3DShape.ROI3DShapePainter {
        protected vtkTubeFilter tubeFilter;

        public ROI3DLinePainter() {
            super(ROI3DLine.this);
            this.tubeFilter = null;
        }

        @Override
        protected void finalize() throws Throwable {
            super.finalize();
            if (this.tubeFilter != null) {
                this.tubeFilter.Delete();
            }
        }

        @Override
        protected void initVtkObjects() {
            super.initVtkObjects();
            this.tubeFilter = new vtkTubeFilter();
            this.tubeFilter.SetInputData((vtkDataObject)this.polyData);
            this.tubeFilter.SetRadius(1.0);
            this.tubeFilter.CappingOn();
            this.tubeFilter.SetNumberOfSides(8);
            this.polyMapper.SetInputConnection(this.tubeFilter.GetOutputPort());
        }

        @Override
        protected boolean isTiny(Rectangle2D bounds, Graphics2D g, IcyCanvas canvas) {
            if (ROI3DLine.this.isSelected()) {
                return false;
            }
            return super.isTiny(bounds, g, canvas);
        }

        @Override
        protected void rebuildVtkObjects() {
            super.rebuildVtkObjects();
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel2 = canvas.getVtkPanel();
            if (vtkPanel2 == null) {
                return;
            }
            if (this.tubeFilter == null) {
                return;
            }
            vtkPanel2.lock();
            try {
                this.tubeFilter.Update();
            }
            finally {
                vtkPanel2.unlock();
            }
        }

        protected void updateVtkTubeRadius() {
            VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
            if (canvas == null) {
                return;
            }
            IcyVtkPanel vtkPanel2 = canvas.getVtkPanel();
            if (vtkPanel2 == null) {
                return;
            }
            if (this.tubeFilter == null) {
                return;
            }
            double radius = canvas.canvasToImageLogDeltaX((int)this.getStroke()) * this.scaling[0];
            if (this.tubeFilter.GetRadius() != radius) {
                vtkPanel2.lock();
                try {
                    this.tubeFilter.SetRadius(radius);
                    this.tubeFilter.Update();
                }
                finally {
                    vtkPanel2.unlock();
                }
                this.painterChanged();
            }
        }

        @Override
        public void drawROI(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            super.drawROI(g, sequence, canvas);
            if (canvas instanceof VtkCanvas) {
                this.updateVtkTubeRadius();
            }
        }

        @Override
        protected void drawShape(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
            this.drawShape(g, sequence, canvas, simplified, false);
        }
    }
}

