/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonFrame;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonFrameTitlePane;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonUI;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;

public class SubstanceRibbonRootPaneUI
extends SubstanceRootPaneUI {
    protected Set lafWidgets;
    protected JRibbonApplicationMenuButton applicationMenuButton;
    protected HierarchyListener substanceRibbonHierarchyListener;

    @Override
    protected void installComponents(JRootPane jRootPane) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installComponents(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installDefaults(JRootPane jRootPane) {
        super.installDefaults(jRootPane);
    }

    @Override
    protected void installDefaults(JRootPane jRootPane) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installDefaults(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installListeners(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallListeners(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    protected void uninstallComponents(JRootPane jRootPane) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallComponents(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallDefaults(JRootPane jRootPane) {
        super.uninstallDefaults(jRootPane);
    }

    @Override
    protected void uninstallDefaults(JRootPane jRootPane) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallDefaults(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceRibbonRootPaneUI();
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installComponents(JRootPane root) {
        super.installComponents(root);
        this.createAppMenuButton(root);
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__installListeners(final JRootPane root) {
        super.installListeners(root);
        this.substanceRibbonHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SubstanceRibbonRootPaneUI.this.createAppMenuButton(root);
                    }
                });
            }
        };
        root.addHierarchyListener(this.substanceRibbonHierarchyListener);
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallListeners(JRootPane root) {
        root.removeHierarchyListener(this.substanceRibbonHierarchyListener);
        this.substanceRibbonHierarchyListener = null;
        super.uninstallListeners(root);
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonRootPaneUI__uninstallComponents(JRootPane root) {
        root.getLayeredPane().remove(this.applicationMenuButton);
        this.applicationMenuButton = null;
        super.uninstallComponents(root);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceRibbonRootLayout();
    }

    @Override
    protected JComponent createTitlePane(JRootPane root) {
        return new SubstanceRibbonFrameTitlePane(root, this);
    }

    public void syncApplicationMenuTips() {
        if (this.applicationMenuButton == null || !this.applicationMenuButton.isVisible()) {
            return;
        }
        JRibbonRootPane ribbonRootPane = (JRibbonRootPane)this.root;
        if (ribbonRootPane == null) {
            return;
        }
        JRibbonFrame ribbonFrame = (JRibbonFrame)ribbonRootPane.getParent();
        JRibbon ribbon = ribbonFrame.getRibbon();
        if (ribbon != null) {
            this.applicationMenuButton.setPopupRichTooltip(ribbon.getApplicationMenuRichTooltip());
            this.applicationMenuButton.setPopupKeyTip(ribbon.getApplicationMenuKeyTip());
        }
    }

    private void createAppMenuButton(JRootPane root) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(root);
        if (this.applicationMenuButton == null && windowAncestor instanceof JRibbonFrame) {
            JRibbonFrame ribbonFrame = (JRibbonFrame)windowAncestor;
            this.applicationMenuButton = new JRibbonApplicationMenuButton(ribbonFrame.getRibbon());
            this.applicationMenuButton.applyComponentOrientation(ribbonFrame.getRibbon().getComponentOrientation());
            root.getLayeredPane().add(this.applicationMenuButton);
            root.getLayeredPane().setLayer(this.applicationMenuButton, JRibbonRootPane.RIBBON_SPECIAL_LAYER);
            FlamingoUtilities.updateRibbonFrameIconImages(ribbonFrame);
            JComponent titlePane = this.getTitlePane();
            if (titlePane != null) {
                this.getTitlePane().doLayout();
            }
        }
    }

    protected class SubstanceRibbonRootLayout
    extends SubstanceRootPaneUI.SubstanceRootLayout {
        protected SubstanceRibbonRootLayout() {
            super(SubstanceRibbonRootPaneUI.this);
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            if (SubstanceRibbonRootPaneUI.this.applicationMenuButton == null) {
                return;
            }
            JRibbonRootPane ribbonRootPane = (JRibbonRootPane)SubstanceRibbonRootPaneUI.this.root;
            JRibbonFrame ribbonFrame = (JRibbonFrame)ribbonRootPane.getParent();
            boolean ltr = ribbonFrame.getRibbon().getComponentOrientation().isLeftToRight();
            SubstanceRibbonUI ribbonUI = (SubstanceRibbonUI)ribbonFrame.getRibbon().getUI();
            int appMenuButtonSize = SubstanceRibbonRootPaneUI.this.getTitlePane().getHeight() + ribbonUI.getTaskToggleButtonHeight();
            SubstanceRibbonRootPaneUI.this.applicationMenuButton.setVisible(ribbonFrame.getRibbon().getApplicationMenu() != null);
            if (ltr) {
                SubstanceRibbonRootPaneUI.this.applicationMenuButton.setBounds(3, 3, appMenuButtonSize - 6, appMenuButtonSize - 6);
            } else {
                SubstanceRibbonRootPaneUI.this.applicationMenuButton.setBounds(parent.getWidth() - 3 - appMenuButtonSize, 3, appMenuButtonSize - 6, appMenuButtonSize - 6);
            }
            SubstanceRibbonRootPaneUI.this.syncApplicationMenuTips();
            SubstanceRibbonRootPaneUI.this.getTitlePane().doLayout();
            ribbonFrame.getRibbon().doLayout();
        }
    }
}

