/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.importer.xuggler;

import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import icy.common.exception.UnsupportedFormatException;
import icy.file.FileUtil;
import icy.image.AbstractImageProvider;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageUtil;
import icy.plugin.abstract_.PluginSequenceFileImporter;
import icy.sequence.MetaDataUtil;
import icy.type.DataType;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import loci.formats.gui.ExtensionFileFilter;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.OMEXMLMetadata;
import plugins.stef.importer.xuggler.Util;
import plugins.stef.library.XugglerPlugin;

public class VideoImporter
extends PluginSequenceFileImporter {
    @Deprecated
    public static final int FAST_METADATA = 1;
    protected IContainer container;
    protected IStream stream;
    protected List<FrameIndex> frameIndexes;
    protected IStreamCoder videoCoder;
    protected IPacket decodePacket;
    protected IVideoResampler resampler;
    protected IConverter converter;
    protected int streamInd;
    protected int numFrame;
    protected int numChannel;
    protected long lastDecodedFrame;
    protected long lastTimeStamp;

    public VideoImporter() {
        XugglerPlugin.init();
        Global.setFFmpegLoggingLevel((int)-1);
        this.container = null;
        this.stream = null;
        this.frameIndexes = null;
        this.videoCoder = null;
        this.decodePacket = null;
        this.resampler = null;
        this.converter = null;
        this.streamInd = -1;
        this.numFrame = 0;
        this.numChannel = 0;
        this.lastDecodedFrame = -1L;
        this.lastTimeStamp = 0L;
    }

    protected void buildIndexes() throws IOException {
        ArrayList<FrameIndex> result = new ArrayList<FrameIndex>();
        IPacket packet = IPacket.make();
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
        int frame = 0;
        long lastPos = -1L;
        long lastKeyFrame = 0L;
        block0: while (this.container.readNextPacket(packet) >= 0) {
            if (!packet.isComplete() || packet.getStreamIndex() != this.streamInd) continue;
            long currentPos = Math.max(0L, packet.getTimeStamp());
            if (lastPos == -1L) {
                lastPos = currentPos;
            }
            if (packet.isKey()) {
                lastKeyFrame = currentPos;
            }
            int offset = 0;
            while (offset < packet.getSize()) {
                int bytesDecoded = this.videoCoder.decodeVideo(picture, packet, offset);
                if (bytesDecoded < 0) {
                    System.out.println("Warning: can't decode packet " + packet.getTimeStamp());
                    continue block0;
                }
                offset += bytesDecoded;
                if (!picture.isComplete()) continue;
                result.add(new FrameIndex(frame, lastPos, currentPos, lastKeyFrame));
                lastPos = currentPos + 1L;
                ++frame;
                picture.delete();
                picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
            }
        }
        picture.delete();
        packet.delete();
        this.frameIndexes = result;
        this.numFrame = result.size();
        this.lastTimeStamp = ((FrameIndex)result.get((int)(result.size() - 1))).endStamp;
    }

    public synchronized boolean seek(long timestamp) throws IOException {
        if (this.getOpened() == null) {
            return false;
        }
        this.videoCoder.close();
        if (this.videoCoder.open(null, null) < 0) {
            throw new IOException("Could not open video stream of " + this.getOpened());
        }
        if (this.container.seekKeyFrame(this.streamInd, 0L, timestamp, this.lastTimeStamp, 0) < 0) {
            throw new IOException("Can't seek to frame '" + timestamp + "'  in file: " + this.getOpened());
        }
        return true;
    }

    public synchronized boolean isOpen(String path) {
        return !StringUtil.isEmpty((String)path) && StringUtil.equals((String)this.getOpened(), (String)FileUtil.getGenericPath((String)path));
    }

    public synchronized String getOpened() {
        if (this.container != null && this.container.isOpened()) {
            return FileUtil.getGenericPath((String)this.container.getURL());
        }
        return null;
    }

    public synchronized boolean open(String path, int flags) throws UnsupportedFormatException, IOException {
        if (StringUtil.isEmpty((String)path)) {
            throw new IOException("Empty path !");
        }
        if (this.isOpen(path)) {
            return true;
        }
        this.close();
        IContainer result = Util.open(path);
        if (result.getBitRate() <= 0) {
            result.close();
            result.delete();
            throw new UnsupportedFormatException("No video stream found in: " + this.getOpened());
        }
        this.streamInd = Util.getVideoStreamIndex(result);
        if (this.streamInd == -1) {
            result.close();
            result.delete();
            throw new UnsupportedFormatException("No video stream found in: " + this.getOpened());
        }
        this.container = result;
        this.stream = this.container.getStream((long)this.streamInd);
        IStreamCoder streamCoder = this.stream.getStreamCoder();
        if (streamCoder.open(null, null) < 0) {
            this.close();
            throw new IOException("Could not open video stream of " + this.getOpened());
        }
        if (streamCoder.getPixelType() != IPixelFormat.Type.BGR24) {
            this.resampler = IVideoResampler.make((int)streamCoder.getWidth(), (int)streamCoder.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)streamCoder.getWidth(), (int)streamCoder.getHeight(), (IPixelFormat.Type)streamCoder.getPixelType());
            if (this.resampler == null) {
                this.close();
                throw new UnsupportedFormatException("Could not create color space resampler for: " + this.getOpened());
            }
        } else {
            this.resampler = null;
        }
        this.converter = ConverterFactory.createConverter((String)"XUGGLER-BGR-24", (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)streamCoder.getWidth(), (int)streamCoder.getHeight());
        if (this.converter == null) {
            this.close();
            throw new UnsupportedFormatException("Could not create image converter for: " + this.getOpened());
        }
        this.videoCoder = streamCoder;
        this.buildIndexes();
        this.numChannel = 3;
        int step = this.numFrame / 5;
        if (step > 0) {
            boolean gray = true;
            for (int i = 1; gray && i < 5; gray &= ImageUtil.isGray((BufferedImage)this.getBufferedImage(i * step)), ++i) {
            }
            if (gray) {
                this.numChannel = 1;
            }
        }
        return true;
    }

    public boolean acceptFile(String path) {
        return Util.canOpenFile(path);
    }

    public List<FileFilter> getFileFilters() {
        ArrayList<FileFilter> result = new ArrayList<FileFilter>();
        result.add(XugglerAllFileFilter.instance);
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"avi"}, "AVI video / Xuggler"));
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"mp4"}, "MPEG-4 video / Xuggler"));
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"mov"}, "Quicktime Movie / Xuggler"));
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"wmv"}, "Windows Media Video / Xuggler"));
        result.add((FileFilter)new ExtensionFileFilter(new String[]{"mpg", "mpeg"}, "MPEG video / Xuggler"));
        return result;
    }

    public synchronized void close() throws IOException {
        if (this.resampler != null) {
            this.resampler.delete();
            this.resampler = null;
        }
        if (this.converter != null) {
            this.converter.delete();
            this.converter = null;
        }
        if (this.videoCoder != null) {
            this.videoCoder.delete();
            this.videoCoder = null;
        }
        if (this.decodePacket != null) {
            this.decodePacket.delete();
            this.decodePacket = null;
        }
        if (this.stream != null) {
            this.stream.delete();
            this.stream = null;
        }
        if (this.container != null) {
            this.container.delete();
            this.container = null;
        }
        this.streamInd = -1;
        this.numFrame = 0;
        this.numChannel = 0;
        this.lastDecodedFrame = -1L;
        this.lastTimeStamp = 0L;
        this.frameIndexes = null;
    }

    public synchronized OMEXMLMetadata getOMEXMLMetaData() throws UnsupportedFormatException, IOException {
        if (this.getOpened() == null) {
            return null;
        }
        OMEXMLMetadata result = OMEUtil.createOMEXMLMetadata();
        MetaDataUtil.setNumSeries((OMEXMLMetadata)result, (int)1);
        MetaDataUtil.setDataType((OMEXMLMetadata)result, (int)0, (DataType)DataType.UBYTE);
        MetaDataUtil.setSizeX((OMEXMLMetadata)result, (int)0, (int)this.videoCoder.getWidth());
        MetaDataUtil.setSizeY((OMEXMLMetadata)result, (int)0, (int)this.videoCoder.getHeight());
        MetaDataUtil.setSizeC((OMEXMLMetadata)result, (int)0, (int)this.numChannel);
        MetaDataUtil.setSizeZ((OMEXMLMetadata)result, (int)0, (int)1);
        MetaDataUtil.setSizeT((OMEXMLMetadata)result, (int)0, (int)this.numFrame);
        double timeInterval = Util.getTimeInterval(this.stream, this.videoCoder);
        MetaDataUtil.setTimeInterval((OMEXMLMetadata)result, (int)0, (double)(timeInterval * (double)this.stream.getNumFrames() / (double)this.numFrame));
        return result;
    }

    @Deprecated
    public OMEXMLMetadataImpl getMetaData() throws UnsupportedFormatException, IOException {
        return (OMEXMLMetadataImpl)this.getOMEXMLMetaData();
    }

    protected static IcyBufferedImage downScale(IcyBufferedImage source, int downScaleLevel) {
        IcyBufferedImage result = source;
        int it = downScaleLevel;
        while (it-- > 0) {
            result = IcyBufferedImageUtil.downscaleBy2((IcyBufferedImage)result, (boolean)true);
        }
        return result;
    }

    protected IVideoPicture getPicture(FrameIndex index) throws IOException {
        long frame = index.startStamp;
        long keyFrame = index.keyStamp;
        boolean doSeek = true;
        if (this.decodePacket == null) {
            this.decodePacket = IPacket.make();
        }
        if (this.lastDecodedFrame != -1L) {
            if (this.lastDecodedFrame + 1L == frame) {
                doSeek = false;
            } else if (this.lastDecodedFrame < frame && this.lastDecodedFrame >= keyFrame) {
                doSeek = false;
            }
        }
        if (doSeek) {
            this.seek(keyFrame);
        }
        IVideoPicture picture = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
        block0: while (this.container.readNextPacket(this.decodePacket) >= 0) {
            int bytesDecoded;
            if (!this.decodePacket.isComplete() || this.decodePacket.getStreamIndex() != this.streamInd) continue;
            for (int offset = 0; offset < this.decodePacket.getSize(); offset += bytesDecoded) {
                bytesDecoded = this.videoCoder.decodeVideo(picture, this.decodePacket, offset);
                if (bytesDecoded >= 0) continue;
                System.out.println("Warning: can't decode packet " + this.decodePacket.getTimeStamp());
                continue block0;
            }
        }
        picture.delete();
        return null;
    }

    protected IVideoPicture getPicture(int t) throws IOException {
        if (this.getOpened() == null) {
            return null;
        }
        if (t >= this.frameIndexes.size()) {
            return null;
        }
        IVideoPicture result = this.getPicture(this.frameIndexes.get(t));
        if (result == null) {
            int pos = t;
            for (int offset = 1; result == null && offset < 10 && pos - offset >= 0; offset += 2) {
                result = this.getPicture(this.frameIndexes.get(pos - offset));
            }
            if (result == null) {
                throw new IOException("Error while retrieving image at frame " + t + " of " + this.getOpened());
            }
        }
        return result;
    }

    public synchronized BufferedImage getBufferedImage(int t) throws IOException {
        IVideoPicture newPic;
        IVideoPicture picture = this.getPicture(t);
        if (picture == null) {
            return null;
        }
        if (this.resampler != null) {
            newPic = IVideoPicture.make((IPixelFormat.Type)this.resampler.getOutputPixelFormat(), (int)picture.getWidth(), (int)picture.getHeight());
            if (this.resampler.resample(newPic, picture) < 0) {
                throw new RuntimeException("Could not resample video (" + this.getOpened() + ")");
            }
        } else {
            newPic = picture;
        }
        if (newPic.getPixelType() != IPixelFormat.Type.BGR24) {
            throw new RuntimeException("Could not decode video as BGR 24 bit data (" + this.getOpened() + ")");
        }
        BufferedImage result = this.converter.toImage(newPic);
        if (newPic != picture) {
            newPic.delete();
        }
        picture.delete();
        return result;
    }

    public IcyBufferedImage getImage(int z, int t) throws UnsupportedFormatException, IOException {
        if (z != 0) {
            return null;
        }
        BufferedImage image = this.getBufferedImage(t);
        if (image == null) {
            return null;
        }
        if (this.numChannel == 1) {
            return Util.getFirstChannelImage(image);
        }
        return IcyBufferedImage.createFrom((BufferedImage)image);
    }

    public IcyBufferedImage getImage(int serie, int resolution, Rectangle rectangle, int z, int t, int c) throws UnsupportedFormatException, IOException {
        if (serie != 0) {
            return null;
        }
        IcyBufferedImage result = this.getImage(z, t);
        if (resolution != 0) {
            result = VideoImporter.downScale(result, resolution);
        }
        if (rectangle != null) {
            result = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)result, (Rectangle)rectangle, (int)0, (int)result.getSizeC());
        }
        if (c != -1 && result.getSizeC() > 1) {
            result = IcyBufferedImageUtil.extractChannel((IcyBufferedImage)result, (int)c);
        }
        return result;
    }

    public IcyBufferedImage getThumbnail(int serie) throws UnsupportedFormatException, IOException {
        OMEXMLMetadata meta = this.getOMEXMLMetaData();
        int sx = MetaDataUtil.getSizeX((OMEXMLMetadata)meta, (int)serie);
        int sy = MetaDataUtil.getSizeY((OMEXMLMetadata)meta, (int)serie);
        int st = MetaDataUtil.getSizeT((OMEXMLMetadata)meta, (int)serie);
        if (sx == 0 || sy == 0 || st == 0) {
            return null;
        }
        double ratio = Math.min(160.0 / (double)sx, 160.0 / (double)sy);
        int tnx = (int)Math.round((double)sx * ratio);
        int tny = (int)Math.round((double)sy * ratio);
        int resolution = AbstractImageProvider.getResolutionFactor((int)sx, (int)sy, (int)160);
        IcyBufferedImage result = this.getImage(serie, resolution, 0, Math.min(st / 2, 50));
        return IcyBufferedImageUtil.scale((IcyBufferedImage)result, (int)tnx, (int)tny, (IcyBufferedImageUtil.FilterType)IcyBufferedImageUtil.FilterType.BILINEAR);
    }

    protected static class FrameIndex {
        int frame;
        long startStamp;
        long endStamp;
        long keyStamp;

        public FrameIndex(int frame, long startStamp, long endStamp, long keyStamp) {
            this.frame = frame;
            this.startStamp = startStamp;
            this.endStamp = endStamp;
            this.keyStamp = keyStamp;
        }

        public String toString() {
            return "frame: " + this.frame + "  startStamp: " + this.startStamp + "  endStamp: " + this.endStamp + "  keyStamp: " + this.keyStamp;
        }
    }

    protected static class XugglerAllFileFilter
    extends FileFilter {
        static final XugglerAllFileFilter instance = new XugglerAllFileFilter();

        protected XugglerAllFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return Util.canOpenFile(file.getAbsolutePath());
        }

        @Override
        public String getDescription() {
            return "All video files / Xuggler";
        }
    }
}

