/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.collide;

import net.phys2d.math.MathUtil;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.Body;
import net.phys2d.raw.Contact;
import net.phys2d.raw.collide.BoxCircleCollider;
import net.phys2d.raw.shapes.Circle;

public strictfp class CircleBoxCollider
extends BoxCircleCollider {
    private static CircleBoxCollider single = new CircleBoxCollider();

    public static CircleBoxCollider createCircleBoxCollider() {
        return single;
    }

    private CircleBoxCollider() {
    }

    @Override
    public int collide(Contact[] contacts, Body circleBody, Body boxBody) {
        int count = super.collide(contacts, boxBody, circleBody);
        for (int i = 0; i < count; ++i) {
            Vector2f vec = MathUtil.scale(contacts[i].getNormal(), -1.0f);
            contacts[i].setNormal(vec);
            Vector2f pt = MathUtil.sub(contacts[i].getPosition(), circleBody.getPosition());
            pt.normalise();
            pt.scale(((Circle)circleBody.getShape()).getRadius());
            pt.add(circleBody.getPosition());
            contacts[i].setPosition(pt);
        }
        return count;
    }
}

