/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.MiceProfiler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.IVideoResampler;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import javax.media.Time;

public class XugglerAviFile {
    private final String filename;
    private IContainer container;
    private int streamId;
    private long startFrame;
    private long numFrames;
    private double frameRate;
    private final long[] keyFrames;
    private IStreamCoder videoCoder;
    private IVideoResampler resampler;
    private final IConverter converter;
    private final IPacket packet;
    private int offset;
    private final boolean fast;

    public XugglerAviFile(String filename, boolean fast) throws IOException, IllegalArgumentException {
        this.filename = filename;
        this.fast = fast;
        this.container = null;
        this.videoCoder = null;
        this.container = this.getContainerAndCoder();
        if (this.videoCoder.getPixelType() != IPixelFormat.Type.BGR24) {
            this.resampler = IVideoResampler.make((int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight(), (IPixelFormat.Type)this.videoCoder.getPixelType());
            if (this.resampler == null) {
                throw new RuntimeException("Could not create color space resampler for: " + filename);
            }
        }
        this.converter = ConverterFactory.createConverter((String)"XUGGLER-BGR-24", (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
        this.packet = IPacket.make();
        ArrayList<Long> keys = new ArrayList<Long>();
        while (this.container.readNextPacket(this.packet) >= 0) {
            if (this.packet.getStreamIndex() != this.streamId || !this.packet.isKey()) continue;
            keys.add(this.packet.getTimeStamp());
        }
        int size = keys.size();
        this.keyFrames = new long[size];
        for (int i = 0; i < size; ++i) {
            this.keyFrames[i] = (Long)keys.get(i);
        }
        this.startFrame = size > 0 ? this.keyFrames[0] : 0L;
    }

    private IContainer getContainerAndCoder() throws IOException {
        IContainer result;
        if (this.videoCoder != null) {
            this.videoCoder.close();
        }
        if (this.container != null) {
            this.container.close();
        }
        if ((result = IContainer.make()).open(this.filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("Could not open file.");
        }
        int numStreams = result.getNumStreams();
        this.videoCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = result.getStream((long)i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodec().getType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            this.streamId = i;
            this.frameRate = stream.getFrameRate().getValue();
            this.numFrames = stream.getNumFrames();
            this.videoCoder = coder;
            break;
        }
        if (this.videoCoder == null) {
            throw new IllegalArgumentException("File format not supported.");
        }
        if (this.videoCoder.open(null, null) < 0) {
            throw new IOException("Could not open the file.");
        }
        return result;
    }

    private long getKeyFrame(long frame) {
        if (this.keyFrames.length == 0) {
            return frame;
        }
        int index = Arrays.binarySearch(this.keyFrames, frame);
        if (index < 0) {
            if (index == -1) {
                return this.keyFrames[0];
            }
            return this.keyFrames[-(index + 2)];
        }
        return this.keyFrames[index];
    }

    private boolean seek(long frame) {
        long adjustedFrame = frame + this.startFrame;
        if (this.container.seekKeyFrame(this.streamId, this.getKeyFrame(adjustedFrame), 0) < 0) {
            try {
                this.container = this.getContainerAndCoder();
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    private boolean readNext() {
        if (this.container.readNextPacket(this.packet) < 0) {
            return false;
        }
        this.offset = 0;
        return true;
    }

    private boolean decodeNext(IVideoPicture picture) {
        if (this.offset >= this.packet.getSize()) {
            return this.readNext();
        }
        int bytesDecoded = this.videoCoder.decodeVideo(picture, this.packet, this.offset);
        if (bytesDecoded < 0) {
            throw new RuntimeException("Error while decoding video");
        }
        this.offset += bytesDecoded;
        return true;
    }

    private IVideoPicture getNextPicture() {
        IVideoPicture result = IVideoPicture.make((IPixelFormat.Type)this.videoCoder.getPixelType(), (int)this.videoCoder.getWidth(), (int)this.videoCoder.getHeight());
        while (!result.isComplete()) {
            if (!(this.packet.getStreamIndex() == this.streamId ? !this.decodeNext(result) : !this.readNext())) continue;
            return null;
        }
        return result;
    }

    private BufferedImage convertPicture(IVideoPicture picture) {
        IVideoPicture newPicture;
        if (picture == null) {
            return null;
        }
        if (this.resampler != null) {
            newPicture = IVideoPicture.make((IPixelFormat.Type)this.resampler.getOutputPixelFormat(), (int)picture.getWidth(), (int)picture.getHeight());
            if (this.resampler.resample(newPicture, picture) < 0) {
                throw new RuntimeException("Could not resample video");
            }
        } else {
            newPicture = picture;
        }
        if (newPicture.getPixelType() != IPixelFormat.Type.BGR24) {
            throw new RuntimeException("Could not decode video as BGR 24 bit data");
        }
        return this.converter.toImage(newPicture);
    }

    private synchronized BufferedImage getImageInternal(int frame) {
        if (!this.fast) {
            try {
                this.container = this.getContainerAndCoder();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            if (!this.seek(frame)) {
                return null;
            }
            if (!this.readNext()) {
                return null;
            }
        }
        IVideoPicture picture = null;
        long adjustedFrame = (long)frame + this.startFrame;
        boolean done = false;
        int retry = 0;
        while (!done && retry < 50) {
            long pictureFrame;
            while (!done && (picture = this.getNextPicture()) != null && (pictureFrame = Math.round((double)picture.getTimeStamp() * picture.getTimeBase().getValue() * this.frameRate)) <= adjustedFrame) {
                done = pictureFrame == adjustedFrame;
            }
            if (done) continue;
            if (!this.seek(frame)) {
                return null;
            }
            if (!this.readNext()) {
                return null;
            }
            ++retry;
        }
        return this.convertPicture(picture);
    }

    public long getTotalNumberOfFrame() {
        return this.numFrames;
    }

    public String getTimeForFrame(int frame) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        if (this.frameRate != 0.0) {
            cal.set(13, (int)((double)frame / this.frameRate));
        } else {
            cal.set(13, 0);
        }
        cal.set(14, 0);
        return "" + DateFormat.getTimeInstance().format(cal.getTime());
    }

    public BufferedImage getImage(Time time) {
        if (this.frameRate != 0.0) {
            return this.getImage((int)(time.getSeconds() * this.frameRate));
        }
        return null;
    }

    public BufferedImage getImage(int frame) {
        return this.getImageInternal(frame);
    }

    public ArrayList<BufferedImage> getImages(int index, int num) {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        int frameEnd = index + num;
        for (int i = index; i < frameEnd; ++i) {
            result.add(this.getImageInternal(i));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BufferedImage> getImages(Sequence sequence, int index, int num) {
        ArrayList<BufferedImage> result = this.getImages(index, num);
        sequence.beginUpdate();
        try {
            int i = index;
            for (BufferedImage img : result) {
                sequence.setImage(i, 0, img);
                ++i;
            }
        }
        finally {
            sequence.endUpdate();
        }
        return result;
    }
}

