import ij.plugin.*;
import ij.*;
import ij.io.*;
import ij.process.*;
import java.io.*;
import java.lang.Float;


/* DeltaVision File Opener by Fabrice Cordelires  & Sebastien HUART
   Institut Curie
   UMR146
   ORSAY
   FRANCE
*/




public class Deltavision_Opener implements PlugIn {
    

    /* IJ plugin methods */
    public void run(String arg) {
	//Get image's path
	OpenDialog od = new OpenDialog ("Open DeltaVision...", arg);
	String directory = od.getDirectory();
	String name = od.getFileName();
	if (name==null)
	    return;
	IJ.showStatus ("Opening: "+ directory + name);
	//Launch the open procedure
	open (directory, name, arg);
    }
    
         
    public void open(String directory, String name, String arg){
	
	DVFile dv;
	try 
	    {
	    dv=new DVFile(directory,name);
	    }
	
	catch (IOException e) 
	    {
		IJ.error(e.getMessage());
		return;
	    }
	
	FileInfo fi = new FileInfo();
	fi.fileFormat = fi.RAW;
	fi.fileName = name;
	fi.directory = directory;
	fi.width=dv.getImageWidth();
	fi.height=dv.getImageHeight();
	fi.nImages=dv.getNumOfImages();
	fi.intelByteOrder = dv.intelByteOrder();
	fi.pixelWidth=dv.getPixelWidth();
	fi.pixelHeight=dv.getPixelHeight();
	fi.pixelDepth=dv.getPixelDepth();
	fi.offset = dv.getImageDataOffset();
	int pixType=dv.getPixelType();
	switch (pixType) 
	    {
	    case 0:
		 fi.fileType=FileInfo.GRAY8 ; 
		 break;
	    case 1:
		fi.fileType=FileInfo.GRAY16_SIGNED;
		break;
	    case 2:
		fi.fileType=FileInfo.GRAY32_FLOAT;
		break;
	    case 5:
		fi.fileType=FileInfo.GRAY16_SIGNED;
		break;
	    case 6:
		fi.fileType = FileInfo.GRAY16_UNSIGNED;
		break;
	    case 7:
		fi.fileType=FileInfo.GRAY32_INT;
		break;
	    default:
		{
		    IJ.error("unsupported pixel type:"+dv.getPixelTypeString());
		    return;
		}
	    }
	fi.unit="um";
	fi.info=dv.getMetaDataString();
	if (fi!=null) {
            FileOpener fo = new FileOpener(fi);
	    ImagePlus imp = fo.open(false);
	    if (imp==null)
                return;
	    //Show the image    
            imp.show();
        }
    }
}
