/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.util;

public class TypeUtil {
    public static Class<?> toBoxedType(Class<?> primitiveType) {
        if (!primitiveType.isPrimitive()) {
            return primitiveType;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Void.TYPE) {
            return Void.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(primitiveType.getName());
    }

    public static String toFriendlyString(Class<?> type) {
        if (type == null) {
            return "no type";
        }
        if (type.isPrimitive()) {
            return TypeUtil.toFriendlyString(TypeUtil.toBoxedType(type));
        }
        if (type.isArray()) {
            return "List of " + TypeUtil.toFriendlyString(type.getComponentType()).toLowerCase() + "s";
        }
        if (type == Double.class) {
            return "Decimal";
        }
        if (type == String.class) {
            return "Text";
        }
        return type.getSimpleName();
    }
}

