/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import pl.edu.icm.jlargearrays.ByteLargeArray;
import pl.edu.icm.jlargearrays.DoubleLargeArray;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;

public class Benchmark {
    public static void writeToFile(long[] lArray, int[] nArray, double[][] dArray, String string) {
        try {
            int n;
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            bufferedWriter.write(System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
            bufferedWriter.newLine();
            bufferedWriter.write(System.getProperty("java.vendor") + " " + System.getProperty("java.version"));
            bufferedWriter.newLine();
            bufferedWriter.write("Available processors (cores): " + Runtime.getRuntime().availableProcessors());
            bufferedWriter.newLine();
            bufferedWriter.write("Total memory (bytes): " + Runtime.getRuntime().totalMemory());
            bufferedWriter.newLine();
            bufferedWriter.write("Number of threads: {");
            for (n = 0; n < nArray.length; ++n) {
                if (n < nArray.length - 1) {
                    bufferedWriter.write(nArray[n] + ",");
                    continue;
                }
                bufferedWriter.write(nArray[nArray.length - 1] + "}");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("Sizes: {");
            for (n = 0; n < lArray.length; ++n) {
                if (n < lArray.length - 1) {
                    bufferedWriter.write(lArray[n] + ",");
                    continue;
                }
                bufferedWriter.write(lArray[lArray.length - 1] + "}");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("Timings: {");
            for (n = 0; n < nArray.length; ++n) {
                int n2;
                bufferedWriter.write("{");
                if (n < nArray.length - 1) {
                    for (n2 = 0; n2 < lArray.length; ++n2) {
                        if (n2 < lArray.length - 1) {
                            bufferedWriter.write(dArray[n][n2] + ",");
                            continue;
                        }
                        bufferedWriter.write(dArray[n][n2] + "},");
                    }
                    bufferedWriter.newLine();
                    continue;
                }
                for (n2 = 0; n2 < lArray.length; ++n2) {
                    if (n2 < lArray.length - 1) {
                        bufferedWriter.write(dArray[n][n2] + ",");
                        continue;
                    }
                    bufferedWriter.write(dArray[n][n2] + "}}");
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static double[][] benchmarkJavaArraysByteSequential(long[] lArray, int[] nArray, int n, String string) {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0x7FFFFFFBL) continue;
            return null;
        }
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking java arrays (bytes, sequentual)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final byte[] byArray = new byte[(int)lArray[j]];
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final int n4 = (int)((long)n3 * l);
                        final int n5 = (int)(n3 == n2 - 1 ? lArray[j] : (long)n4 + l);
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int n = n4;
                                while (n < n5) {
                                    byArray[n] = 1;
                                    int n2 = n++;
                                    byArray[n2] = (byte)(byArray[n2] + 1);
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJavaArraysDoubleSequential(long[] lArray, int[] nArray, int n, String string) {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0x7FFFFFFBL) continue;
            return null;
        }
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking java arrays (doubles, sequentual)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final double[] dArray2 = new double[(int)lArray[j]];
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final int n4 = (int)((long)n3 * l);
                        final int n5 = (int)(n3 == n2 - 1 ? lArray[j] : (long)n4 + l);
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                int n = n4;
                                while (n < n5) {
                                    dArray2[n] = 1.0;
                                    int n2 = n++;
                                    dArray2[n2] = dArray2[n2] + 1.0;
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJavaArraysByteRandom(long[] lArray, int[] nArray, int n, String string) {
        int n2;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0x7FFFFFFBL) continue;
            return null;
        }
        final int[] nArray2 = new int[(int)lArray[lArray.length - 1]];
        double[][] dArray = new double[nArray.length][lArray.length];
        Random random = new Random(0L);
        System.out.println("generating random indices.");
        int n3 = (int)lArray[lArray.length - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = (int)(random.nextDouble() * (double)(n3 - 1));
        }
        System.out.println("Benchmarking java arrays (bytes, random)");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            Thread[] threadArray = new Thread[n4];
            System.out.println("\tNumber of threads = " + n4);
            for (int i = 0; i < lArray.length; ++i) {
                System.out.print("\tSize = " + lArray[i]);
                final byte[] byArray = new byte[(int)lArray[i]];
                final long l = lArray[i];
                double d = System.nanoTime();
                for (int j = 0; j < n; ++j) {
                    int n5;
                    long l2 = lArray[i] / (long)n4;
                    for (n5 = 0; n5 < n4; ++n5) {
                        final int n6 = (int)((long)n5 * l2);
                        final int n7 = (int)(n5 == n4 - 1 ? l : (long)n6 + l2);
                        threadArray[n5] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = n6; i < n7; ++i) {
                                    int n = (int)((long)nArray2[i] % l);
                                    byArray[n] = 1;
                                    int n2 = n;
                                    byArray[n2] = (byte)(byArray[n2] + 1);
                                }
                            }
                        });
                        threadArray[n5].start();
                    }
                    try {
                        for (n5 = 0; n5 < n4; ++n5) {
                            threadArray[n5].join();
                            threadArray[n5] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[n2][i] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[n2][i]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJavaArraysDoubleRandom(long[] lArray, int[] nArray, int n, String string) {
        int n2;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] <= 0x7FFFFFFBL) continue;
            return null;
        }
        final int[] nArray2 = new int[(int)lArray[lArray.length - 1]];
        double[][] dArray = new double[nArray.length][lArray.length];
        Random random = new Random(0L);
        System.out.println("generating random indices.");
        int n3 = (int)lArray[lArray.length - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = (int)(random.nextDouble() * (double)(n3 - 1));
        }
        System.out.println("Benchmarking java arrays (double, random)");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            Thread[] threadArray = new Thread[n4];
            System.out.println("\tNumber of threads = " + n4);
            for (int i = 0; i < lArray.length; ++i) {
                System.out.print("\tSize = " + lArray[i]);
                final double[] dArray2 = new double[(int)lArray[i]];
                final long l = lArray[i];
                double d = System.nanoTime();
                for (int j = 0; j < n; ++j) {
                    int n5;
                    long l2 = lArray[i] / (long)n4;
                    for (n5 = 0; n5 < n4; ++n5) {
                        final int n6 = (int)((long)n5 * l2);
                        final int n7 = (int)(n5 == n4 - 1 ? l : (long)n6 + l2);
                        threadArray[n5] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = n6; i < n7; ++i) {
                                    int n = (int)((long)nArray2[i] % l);
                                    dArray2[n] = 1.0;
                                    int n2 = n;
                                    dArray2[n2] = dArray2[n2] + 1.0;
                                }
                            }
                        });
                        threadArray[n5].start();
                    }
                    try {
                        for (n5 = 0; n5 < n4; ++n5) {
                            threadArray[n5].join();
                            threadArray[n5] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[n2][i] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[n2][i]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysByteSequentual(long[] lArray, int[] nArray, int n, String string) {
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking JLargeArrays (bytes, sequentual)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final ByteLargeArray byteLargeArray = new ByteLargeArray(lArray[j]);
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final long l2 = (long)n3 * l;
                        final long l3 = n3 == n2 - 1 ? lArray[j] : l2 + l;
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    byteLargeArray.setByte(i, (byte)1);
                                    byteLargeArray.setByte(i, (byte)(byteLargeArray.getByte(i) + 1));
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysByteSequentualNative(long[] lArray, int[] nArray, int n, String string) {
        LargeArray.setMaxSizeOf32bitArray(1);
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking JLargeArrays (bytes, sequentual, native)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final ByteLargeArray byteLargeArray = new ByteLargeArray(lArray[j]);
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final long l2 = (long)n3 * l;
                        final long l3 = n3 == n2 - 1 ? lArray[j] : l2 + l;
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    byteLargeArray.setToNative(i, (byte)1);
                                    byteLargeArray.setToNative(i, (byte)(byteLargeArray.getFromNative(i) + 1));
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysByteSequentual_safe(long[] lArray, int[] nArray, int n, String string) {
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking JLargeArrays (bytes, sequentual, with bounds checking)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final ByteLargeArray byteLargeArray = new ByteLargeArray(lArray[j]);
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final long l2 = (long)n3 * l;
                        final long l3 = n3 == n2 - 1 ? lArray[j] : l2 + l;
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    byteLargeArray.setByte_safe(i, (byte)1);
                                    byteLargeArray.setByte_safe(i, (byte)(byteLargeArray.getByte_safe(i) + 1));
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysDoubleSequentual(long[] lArray, int[] nArray, int n, String string) {
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking JLargeArrays (doubles, sequentual)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final DoubleLargeArray doubleLargeArray = new DoubleLargeArray(lArray[j]);
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final long l2 = (long)n3 * l;
                        final long l3 = n3 == n2 - 1 ? lArray[j] : l2 + l;
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    doubleLargeArray.setDouble(i, 1.0);
                                    doubleLargeArray.setDouble(i, doubleLargeArray.getDouble(i) + 1.0);
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysDoubleSequentualNative(long[] lArray, int[] nArray, int n, String string) {
        LargeArray.setMaxSizeOf32bitArray(1);
        double[][] dArray = new double[nArray.length][lArray.length];
        System.out.println("Benchmarking JLargeArrays (doubles, sequentual, native)");
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Thread[] threadArray = new Thread[n2];
            System.out.println("\tNumber of threads = " + n2);
            for (int j = 0; j < lArray.length; ++j) {
                System.out.print("\tSize = " + lArray[j]);
                final DoubleLargeArray doubleLargeArray = new DoubleLargeArray(lArray[j]);
                double d = System.nanoTime();
                for (int k = 0; k < n; ++k) {
                    int n3;
                    long l = lArray[j] / (long)n2;
                    for (n3 = 0; n3 < n2; ++n3) {
                        final long l2 = (long)n3 * l;
                        final long l3 = n3 == n2 - 1 ? lArray[j] : l2 + l;
                        threadArray[n3] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    doubleLargeArray.setToNative(i, 1.0);
                                    doubleLargeArray.setToNative(i, doubleLargeArray.getFromNative(i) + 1.0);
                                }
                            }
                        });
                        threadArray[n3].start();
                    }
                    try {
                        for (n3 = 0; n3 < n2; ++n3) {
                            threadArray[n3].join();
                            threadArray[n3] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[i][j] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[i][j]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysByteRandom(long[] lArray, int[] nArray, int n, String string) {
        int n2;
        final int[] nArray2 = new int[(int)lArray[lArray.length - 1]];
        double[][] dArray = new double[nArray.length][lArray.length];
        Random random = new Random(0L);
        System.out.println("generating random indices.");
        int n3 = (int)lArray[lArray.length - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = (int)(random.nextDouble() * (double)(n3 - 1));
        }
        System.out.println("Benchmarking JLargeArrays (bytes, random)");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            Thread[] threadArray = new Thread[n4];
            System.out.println("\tNumber of threads = " + n4);
            for (int i = 0; i < lArray.length; ++i) {
                System.out.print("\tSize = " + lArray[i]);
                final ByteLargeArray byteLargeArray = new ByteLargeArray(lArray[i]);
                final int n5 = (int)lArray[i];
                double d = System.nanoTime();
                for (int j = 0; j < n; ++j) {
                    int n6;
                    long l = lArray[i] / (long)n4;
                    for (n6 = 0; n6 < n4; ++n6) {
                        final long l2 = (long)n6 * l;
                        final long l3 = n6 == n4 - 1 ? lArray[i] : l2 + l;
                        threadArray[n6] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    long l = nArray2[(int)i] % n5;
                                    byteLargeArray.setByte(l, (byte)1);
                                    byteLargeArray.setByte(l, (byte)(byteLargeArray.getByte(l) + 1));
                                }
                            }
                        });
                        threadArray[n6].start();
                    }
                    try {
                        for (n6 = 0; n6 < n4; ++n6) {
                            threadArray[n6].join();
                            threadArray[n6] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[n2][i] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[n2][i]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static double[][] benchmarkJLargeArraysDoubleRandom(long[] lArray, int[] nArray, int n, String string) {
        int n2;
        final int[] nArray2 = new int[(int)lArray[lArray.length - 1]];
        double[][] dArray = new double[nArray.length][lArray.length];
        Random random = new Random(0L);
        System.out.println("generating random indices.");
        int n3 = (int)lArray[lArray.length - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            nArray2[n2] = (int)(random.nextDouble() * (double)(n3 - 1));
        }
        System.out.println("Benchmarking JLargeArrays (doubles, random)");
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = nArray[n2];
            Thread[] threadArray = new Thread[n4];
            System.out.println("\tNumber of threads = " + n4);
            for (int i = 0; i < lArray.length; ++i) {
                System.out.print("\tSize = " + lArray[i]);
                final DoubleLargeArray doubleLargeArray = new DoubleLargeArray(lArray[i]);
                final int n5 = (int)lArray[i];
                double d = System.nanoTime();
                for (int j = 0; j < n; ++j) {
                    int n6;
                    long l = lArray[i] / (long)n4;
                    for (n6 = 0; n6 < n4; ++n6) {
                        final long l2 = (long)n6 * l;
                        final long l3 = n6 == n4 - 1 ? lArray[i] : l2 + l;
                        threadArray[n6] = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (long i = l2; i < l3; ++i) {
                                    long l = nArray2[(int)i] % n5;
                                    doubleLargeArray.setDouble(l, 1.0);
                                    doubleLargeArray.setDouble(l, doubleLargeArray.getDouble(l) + 1.0);
                                }
                            }
                        });
                        threadArray[n6].start();
                    }
                    try {
                        for (n6 = 0; n6 < n4; ++n6) {
                            threadArray[n6].join();
                            threadArray[n6] = null;
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                dArray[n2][i] = ((double)System.nanoTime() - d) / 1.0E9 / (double)n;
                System.out.println(" : " + String.format("%.7f sec", dArray[n2][i]));
            }
        }
        Benchmark.writeToFile(lArray, nArray, dArray, string);
        return dArray;
    }

    public static void benchmarkByteSequential(long[] lArray, int[] nArray, int n, String string) {
        Benchmark.benchmarkJavaArraysByteSequential(lArray, nArray, n, string + System.getProperty("file.separator") + "java_arrays_byte_sequential.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysByteSequentual(lArray, nArray, n, string + System.getProperty("file.separator") + "jlargearrays_byte_sequentual.txt");
    }

    public static void benchmarkDoubleSequential(long[] lArray, int[] nArray, int n, String string) {
        Benchmark.benchmarkJavaArraysDoubleSequential(lArray, nArray, n, string + System.getProperty("file.separator") + "java_arrays_double_sequential.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysDoubleSequentual(lArray, nArray, n, string + System.getProperty("file.separator") + "jlargearrays_double_sequentual.txt");
    }

    public static void benchmarkByteRandom(long[] lArray, int[] nArray, int n, String string) {
        Benchmark.benchmarkJavaArraysByteRandom(lArray, nArray, n, string + System.getProperty("file.separator") + "java_arrays_byte_random.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysByteRandom(lArray, nArray, n, string + System.getProperty("file.separator") + "jlargearrays_byte_random.txt");
    }

    public static void benchmarkDoubleRandom(long[] lArray, int[] nArray, int n, String string) {
        Benchmark.benchmarkJavaArraysDoubleRandom(lArray, nArray, n, string + System.getProperty("file.separator") + "java_arrays_double_random.txt");
        System.gc();
        Benchmark.benchmarkJLargeArraysDoubleRandom(lArray, nArray, n, string + System.getProperty("file.separator") + "jlargearrays_double_random.txt");
    }

    public static void benchmarkByteLargeArray() {
        System.out.println("Benchmarking ByteLargeArray.");
        long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        ByteLargeArray byteLargeArray = new ByteLargeArray(l);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        int n = 5;
        byte by = 1;
        for (int i = 0; i < n; ++i) {
            l2 = System.nanoTime();
            for (long j = 0L; j < l; ++j) {
                byteLargeArray.getByte(j);
                byteLargeArray.setByte(j, by);
                byteLargeArray.setByte(j, (byte)(byteLargeArray.getByte(j) + by));
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + "sec");
        }
    }

    public static void benchmarkByteLargeArrayInANewThread() {
        System.out.println("Benchmarking ByteLargeArray in a new thread.");
        final long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        final ByteLargeArray byteLargeArray = new ByteLargeArray(l);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        for (int i = 0; i < 5; ++i) {
            l2 = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long i = 0L; i < l; ++i) {
                        byteLargeArray.setByte(i, (byte)1);
                        byteLargeArray.setByte(i, (byte)(byteLargeArray.getByte(i) + 1));
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkFloatLargeArray() {
        System.out.println("Benchmarking FloatLargeArray.");
        long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        FloatLargeArray floatLargeArray = new FloatLargeArray(l);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        int n = 5;
        for (int i = 0; i < n; ++i) {
            l2 = System.nanoTime();
            for (long j = 0L; j < l; ++j) {
                floatLargeArray.getFloat(j);
                floatLargeArray.setFloat(j, 1.0f);
                floatLargeArray.setFloat(j, floatLargeArray.getFloat(j) + 1.0f);
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + "sec");
        }
    }

    public static void benchmarkFloatLargeArrayInANewThread() {
        System.out.println("Benchmarking FloatLargeArray in a new thread.");
        final long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        final FloatLargeArray floatLargeArray = new FloatLargeArray(l);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        for (int i = 0; i < 5; ++i) {
            l2 = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long i = 0L; i < l; ++i) {
                        floatLargeArray.setFloat(i, 1.0f);
                        floatLargeArray.setFloat(i, floatLargeArray.getFloat(i) + 1.0f);
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkByteLargeArrayNative() {
        System.out.println("Benchmarking ByteLargeArray native.");
        long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        ByteLargeArray byteLargeArray = new ByteLargeArray(l, false);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        int n = 5;
        byte by = 1;
        if (byteLargeArray.isLarge()) {
            for (int i = 0; i < n; ++i) {
                l2 = System.nanoTime();
                for (long j = 0L; j < l; ++j) {
                    byteLargeArray.getFromNative(j);
                    byteLargeArray.setToNative(j, by);
                    byteLargeArray.setToNative(j, (byte)(byteLargeArray.getFromNative(j) + by));
                }
                System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
            }
        }
    }

    public static void benchmarkByteLargeArrayNativeInANewThread() {
        System.out.println("Benchmarking ByteLargeArray native in a new thread.");
        final long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        final ByteLargeArray byteLargeArray = new ByteLargeArray(l);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        for (int i = 0; i < 5; ++i) {
            l2 = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long i = 0L; i < l; ++i) {
                        byteLargeArray.setToNative(i, (byte)1);
                        byteLargeArray.setToNative(i, (byte)(byteLargeArray.getFromNative(i) + 1));
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        }
    }

    public static void benchmarkFloatLargeArrayNative() {
        System.out.println("Benchmarking FloatLargeArray native.");
        long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        FloatLargeArray floatLargeArray = new FloatLargeArray(l, false);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        int n = 5;
        if (floatLargeArray.isLarge()) {
            for (int i = 0; i < n; ++i) {
                l2 = System.nanoTime();
                for (long j = 0L; j < l; ++j) {
                    floatLargeArray.getFromNative(j);
                    floatLargeArray.setToNative(j, Float.valueOf(1.0f));
                    floatLargeArray.setToNative(j, Float.valueOf(floatLargeArray.getFromNative(j).floatValue() + 1.0f));
                }
                System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
            }
        }
    }

    public static void benchmarkFloatLargeArrayNativeInANewThread() {
        System.out.println("Benchmarking FloatLargeArray native in a new thread.");
        final long l = (long)Math.pow(2.0, 32.0);
        long l2 = System.nanoTime();
        final FloatLargeArray floatLargeArray = new FloatLargeArray(l);
        System.out.println("Constructor time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        for (int i = 0; i < 5; ++i) {
            l2 = System.nanoTime();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (long i = 0L; i < l; ++i) {
                        floatLargeArray.setToNative(i, Float.valueOf(1.0f));
                        floatLargeArray.setToNative(i, Float.valueOf(floatLargeArray.getFromNative(i).floatValue() + 1.0f));
                    }
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("Computation time: " + (double)(System.nanoTime() - l2) / 1.0E9 + " sec");
        }
    }

    public static void main(String[] stringArray) {
        int n = 27;
        int n2 = 32;
        int n3 = n2 - n + 1;
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = n + i == 31 ? (long)Math.pow(2.0, 31.0) - 4L : (long)Math.pow(2.0, n + i);
        }
        n = 32;
        n2 = 35;
        n3 = n2 - n + 1;
        long[] lArray2 = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray2[i] = (long)Math.pow(2.0, n + i);
        }
        int[] nArray = new int[]{1, 2, 4, 8, 16};
        LargeArray.setMaxSizeOf32bitArray(1);
        Benchmark.benchmarkByteSequential(lArray, nArray, 10, "/tmp/");
        Benchmark.benchmarkDoubleSequential(lArray, nArray, 10, "/tmp/");
        Benchmark.benchmarkByteRandom(lArray, nArray, 10, "/tmp/");
        Benchmark.benchmarkDoubleRandom(lArray, nArray, 10, "/tmp/");
    }
}

