/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.sequence.Sequence;

public class SubSequence {
    private Sequence _sequence;
    private int[] _t;
    private int[] _z;
    private int[] _c;

    public String toString() {
        return this._sequence.getName() + this.getSubRangeAsString();
    }

    public SubSequence(Sequence sequence) {
        this(sequence, null, null, null);
    }

    public SubSequence(Sequence sequence, int[] t, int[] z, int[] c) {
        if (sequence == null) {
            throw new IllegalArgumentException("Illegal null sequence in sub-sequence constructor.");
        }
        this._sequence = sequence;
        this._t = t;
        this._z = z;
        this._c = c;
    }

    public Sequence getSequence() {
        return this._sequence;
    }

    public int[] getT() {
        return this._t;
    }

    public int[] getZ() {
        return this._z;
    }

    public int[] getC() {
        return this._c;
    }

    public void setT(int[] t) {
        this._t = t;
    }

    public void setZ(int[] z) {
        this._z = z;
    }

    public void setC(int[] c) {
        this._c = c;
    }

    public int getSizeX() {
        return this._sequence.getSizeX();
    }

    public int getSizeY() {
        return this._sequence.getSizeY();
    }

    public int getSizeZ() {
        return this._z == null ? this._sequence.getSizeZ() : this._z.length;
    }

    public int getSizeT() {
        return this._t == null ? this._sequence.getSizeT() : this._t.length;
    }

    public int getSizeC() {
        return this._c == null ? this._sequence.getSizeC() : this._c.length;
    }

    public boolean isFullySelected() {
        return this.getSubRangeTypeT() == SubRangeType.FULL && this.getSubRangeTypeZ() == SubRangeType.FULL && this.getSubRangeTypeC() == SubRangeType.FULL;
    }

    public SubRangeType getSubRangeTypeT() {
        return SubSequence.getSubRangeType(this._t, this._sequence.getSizeT());
    }

    public SubRangeType getSubRangeTypeZ() {
        return SubSequence.getSubRangeType(this._z, this._sequence.getSizeZ());
    }

    public SubRangeType getSubRangeTypeC() {
        return SubSequence.getSubRangeType(this._c, this._sequence.getSizeC());
    }

    public static SubRangeType getSubRangeType(int[] subRange, int sequenceSize) {
        if (subRange == null) {
            return SubRangeType.FULL;
        }
        if (subRange.length == 0) {
            return sequenceSize == 0 ? SubRangeType.FULL : SubRangeType.EMPTY;
        }
        int prevIdx = subRange[0];
        if (prevIdx < 0 || prevIdx >= sequenceSize) {
            return SubRangeType.INVALID;
        }
        if (subRange.length == 1) {
            return sequenceSize == 1 ? SubRangeType.FULL : SubRangeType.SINGLETON;
        }
        boolean admissibleForInterval = true;
        for (int k = 1; k < subRange.length; ++k) {
            int currIdx = subRange[k];
            if (currIdx < 0 || currIdx >= sequenceSize) {
                return SubRangeType.INVALID;
            }
            if (currIdx != prevIdx + 1) {
                admissibleForInterval = false;
            }
            prevIdx = currIdx;
        }
        if (admissibleForInterval) {
            return subRange[0] == 0 && subRange.length == sequenceSize ? SubRangeType.FULL : SubRangeType.INTERVAL;
        }
        return SubRangeType.OTHER;
    }

    public boolean isValid() {
        return SubSequence.isSubRangeValid(this._t, this._sequence.getSizeT()) && SubSequence.isSubRangeValid(this._z, this._sequence.getSizeZ()) && SubSequence.isSubRangeValid(this._c, this._sequence.getSizeC());
    }

    public static boolean isSubRangeValid(int[] subRange, int sequenceSize) {
        if (subRange == null) {
            return true;
        }
        for (int i : subRange) {
            if (i >= 0 && i < sequenceSize) continue;
            return false;
        }
        return true;
    }

    public String getSubRangeAsString() {
        SubRangeType typeRangeT = this.getSubRangeTypeT();
        SubRangeType typeRangeZ = this.getSubRangeTypeZ();
        SubRangeType typeRangeC = this.getSubRangeTypeC();
        if (typeRangeT == SubRangeType.INVALID || typeRangeZ == SubRangeType.INVALID || typeRangeC == SubRangeType.INVALID) {
            return "[invalid]";
        }
        String indexString = SubSequence.concatenateSubRangeStrings(SubSequence.getSubRangeAsString("t", typeRangeT, this._t), SubSequence.getSubRangeAsString("z", typeRangeZ, this._z), SubSequence.getSubRangeAsString("c", typeRangeC, this._c));
        return indexString == null ? "" : "[" + indexString + "]";
    }

    private static String getSubRangeAsString(String dimName, SubRangeType type, int[] subRange) {
        switch (type) {
            case INVALID: {
                return null;
            }
            case FULL: {
                return null;
            }
            case EMPTY: {
                return "no " + dimName;
            }
            case SINGLETON: {
                return dimName + "=" + subRange[0];
            }
            case INTERVAL: {
                return dimName + " in " + subRange[0] + "..." + subRange[subRange.length - 1];
            }
            case OTHER: {
                String retVal = dimName + " in ";
                for (int k = 0; k < subRange.length; ++k) {
                    if (k > 0) {
                        retVal = retVal + ",";
                    }
                    retVal = retVal + subRange[k];
                }
                return retVal;
            }
        }
        throw new RuntimeException("Unreachable code point");
    }

    private static String concatenateSubRangeStrings(String ... subRangeStrings) {
        String retVal = null;
        for (String s : subRangeStrings) {
            if (retVal == null) {
                retVal = s;
                continue;
            }
            if (s == null) continue;
            retVal = retVal + " ; " + s;
        }
        return retVal;
    }

    public static enum SubRangeType {
        INVALID,
        FULL,
        EMPTY,
        SINGLETON,
        INTERVAL,
        OTHER;

    }
}

