/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.expressions;

import java.util.SortedSet;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.expressions.CompositionOperator;
import plugins.ylemontag.mathoperations.expressions.ExpressionOpposite;

public class ExpressionComposition
extends Expression {
    private CompositionOperator _operator;
    private Expression _lhs;
    private Expression _rhs;

    public ExpressionComposition(CompositionOperator operator, Expression lhs, Expression rhs) {
        this._operator = operator;
        this._lhs = lhs;
        this._rhs = rhs;
    }

    public CompositionOperator getOperator() {
        return this._operator;
    }

    public Expression getLhs() {
        return this._lhs;
    }

    public Expression getRhs() {
        return this._rhs;
    }

    @Override
    public boolean equals(Expression expr) {
        if (!(expr instanceof ExpressionComposition)) {
            return false;
        }
        ExpressionComposition e = (ExpressionComposition)expr;
        return this._operator == e._operator && this._lhs.equals(e._lhs) && this._rhs.equals(e._rhs);
    }

    @Override
    public String getRepresentation(boolean smartParenthesis) {
        String representationL = this._lhs.getRepresentation(smartParenthesis);
        String representationR = this._rhs.getRepresentation(smartParenthesis);
        representationL = this.addParenthesisIfNecessary(representationL, false, smartParenthesis);
        representationR = this.addParenthesisIfNecessary(representationR, true, smartParenthesis);
        return representationL + this._operator.getToken().getName() + representationR;
    }

    private String addParenthesisIfNecessary(String in, boolean rhs, boolean smartParenthesis) {
        Expression e = rhs ? this._rhs : this._lhs;
        String retVal = in;
        if (e instanceof ExpressionOpposite) {
            int myPriority = this._operator.getPriority();
            if (!smartParenthesis || myPriority > 0 || rhs && myPriority == 0) {
                retVal = "(" + retVal + ")";
            }
        } else if (e instanceof ExpressionComposition) {
            int myPriority = this._operator.getPriority();
            int exprPriority = ((ExpressionComposition)e).getOperator().getPriority();
            if (!smartParenthesis || exprPriority < myPriority || rhs && exprPriority == myPriority) {
                retVal = "(" + retVal + ")";
            }
        }
        return retVal;
    }

    @Override
    public SortedSet<String> getVariables() {
        SortedSet<String> retVal = this._lhs.getVariables();
        retVal.addAll(this._rhs.getVariables());
        return retVal;
    }

    @Override
    public boolean isValidFunctor(String[] variables) {
        return this._lhs.isValidFunctor(variables) && this._rhs.isValidFunctor(variables);
    }

    @Override
    public Functor getFunctor(String[] variables) {
        Functor functorL = this._lhs.getFunctor(variables);
        Functor functorR = this._rhs.getFunctor(variables);
        String patternL = this.addParenthesisIfNecessary(functorL.getFormatPattern(), false, true);
        String patternR = this.addParenthesisIfNecessary(functorR.getFormatPattern(), true, true);
        final Functor.FunPtr funPtrL = functorL.getFunctionPointer();
        final Functor.FunPtr funPtrR = functorR.getFunctionPointer();
        switch (this._operator) {
            case ADD: {
                return new Functor(variables.length, patternL + " + " + patternR, new Functor.FunPtr(){

                    @Override
                    public double apply(double[] in) {
                        return funPtrL.apply(in) + funPtrR.apply(in);
                    }
                });
            }
            case SUBTRACT: {
                return new Functor(variables.length, patternL + " - " + patternR, new Functor.FunPtr(){

                    @Override
                    public double apply(double[] in) {
                        return funPtrL.apply(in) - funPtrR.apply(in);
                    }
                });
            }
            case MULTIPLY: {
                return new Functor(variables.length, patternL + "\u00d7" + patternR, new Functor.FunPtr(){

                    @Override
                    public double apply(double[] in) {
                        return funPtrL.apply(in) * funPtrR.apply(in);
                    }
                });
            }
            case DIVIDE: {
                return new Functor(variables.length, patternL + "\u00f7" + patternR, new Functor.FunPtr(){

                    @Override
                    public double apply(double[] in) {
                        return funPtrL.apply(in) / funPtrR.apply(in);
                    }
                });
            }
            case POWER: {
                return new Functor(variables.length, patternL + "^" + patternR, new Functor.FunPtr(){

                    @Override
                    public double apply(double[] in) {
                        return Math.pow(funPtrL.apply(in), funPtrR.apply(in));
                    }
                });
            }
        }
        throw new RuntimeException("Unreachable code point");
    }
}

