/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.model;

import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTreeModel
implements TreeModel {
    protected Document document;
    protected EventListenerList listeners = new EventListenerList();

    public XMLTreeModel(Document doc) {
        if (doc == null) {
            throw new NullPointerException();
        }
        this.document = doc;
    }

    @Override
    public Object getRoot() {
        if (this.document.getDocumentElement() == null) {
            return null;
        }
        return new XMLAdapterNode(this.document.getDocumentElement());
    }

    @Override
    public Object getChild(Object parent, int index) {
        return ((XMLAdapterNode)parent).child(index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ((XMLAdapterNode)parent).index((XMLAdapterNode)child);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((XMLAdapterNode)parent).childCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((XMLAdapterNode)node).childCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(TreeModelListener.class, l);
    }

    public void fireTreeNodesChanged(TreeModelEvent e) {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
        int n = treeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeModelListener listener = treeModelListenerArray[n2];
            listener.treeNodesChanged(e);
            ++n2;
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent e) {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
        int n = treeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeModelListener listener = treeModelListenerArray[n2];
            listener.treeNodesInserted(e);
            ++n2;
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent e) {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
        int n = treeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeModelListener listener = treeModelListenerArray[n2];
            listener.treeNodesRemoved(e);
            ++n2;
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent e) {
        TreeModelListener[] treeModelListenerArray = (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class);
        int n = treeModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeModelListener listener = treeModelListenerArray[n2];
            listener.treeStructureChanged(e);
            ++n2;
        }
    }

    public static class XMLAdapterNode {
        public Node node;

        public XMLAdapterNode(Node node) {
            this.node = node;
        }

        public List<Node> getChildren() {
            int i;
            int count;
            ArrayList<Node> result = new ArrayList<Node>();
            if (this.node.hasAttributes()) {
                NamedNodeMap attributes = this.node.getAttributes();
                count = attributes.getLength();
                i = 0;
                while (i < count) {
                    result.add(attributes.item(i));
                    ++i;
                }
            }
            NodeList nodes = this.node.getChildNodes();
            count = nodes.getLength();
            i = 0;
            while (i < count) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    result.add(node);
                }
                ++i;
            }
            return result;
        }

        public int index(XMLAdapterNode child) {
            int result = 0;
            for (Node node : this.getChildren()) {
                if (child.node == node) {
                    return result;
                }
                ++result;
            }
            return -1;
        }

        public XMLAdapterNode child(int index) {
            Node n = this.getChildren().get(index);
            if (n == null) {
                return null;
            }
            return new XMLAdapterNode(n);
        }

        public int childCount() {
            return this.getChildren().size();
        }

        protected String getValue() {
            NodeList nodes = this.node.getChildNodes();
            int count = nodes.getLength();
            String result = "";
            int i = 0;
            while (i < count) {
                String value;
                Node node = nodes.item(i);
                if (!(node instanceof Element) && (value = node.getNodeValue()) != null && !StringUtil.equals(value, "null")) {
                    result = String.valueOf(result) + value + " ";
                }
                ++i;
            }
            return result.trim();
        }

        public String toString() {
            String nodeName = this.node.getNodeName();
            String nodeValue = this.node.getNodeValue();
            if (!StringUtil.isEmpty(nodeValue) && !StringUtil.equals(nodeValue, "null")) {
                return String.valueOf(nodeName) + " = " + nodeValue;
            }
            return nodeName;
        }
    }
}

