/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.action.CanvasActions;
import icy.canvas.CanvasLayerEvent;
import icy.canvas.CanvasLayerListener;
import icy.canvas.IcyCanvas;
import icy.canvas.Layer;
import icy.gui.component.IcyTextField;
import icy.gui.component.editor.VisibleCellEditor;
import icy.gui.component.renderer.VisibleCellRenderer;
import icy.gui.inspector.LayerControlPanel;
import icy.gui.main.ActiveViewerListener;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;

public class LayersPanel
extends JPanel
implements ActiveViewerListener,
CanvasLayerListener,
IcyTextField.TextChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = 4550426171735455449L;
    static final String[] columnNames = new String[]{"Name", ""};
    List<Layer> layers;
    IcyCanvas canvas = null;
    AbstractTableModel tableModel;
    ListSelectionModel tableSelectionModel;
    JXTable table;
    IcyTextField nameFilter;
    JToggleButton tglbtnLayerVisibility;
    ActionListener visibilityToggleActionListener;
    LayerControlPanel controlPanel;
    boolean isSelectionAdjusting = false;
    boolean isLayerEditing = false;
    boolean isLayerPropertiesAdjusting = false;
    final Runnable layersRefresher;
    final Runnable tableDataRefresher;
    final Runnable controlPanelRefresher;
    final CanvasRefresher canvasRefresher;
    private IcyIcon visibleIcon = new IcyIcon(ResourceUtil.ICON_VISIBLE, 15);
    private IcyIcon notVisibleIcon = new IcyIcon(ResourceUtil.ICON_NOT_VISIBLE, 15);

    public LayersPanel() {
        this.layers = new ArrayList<Layer>();
        this.layersRefresher = new Runnable(){

            @Override
            public void run() {
                LayersPanel.this.refreshLayersInternal();
            }
        };
        this.tableDataRefresher = new Runnable(){

            @Override
            public void run() {
                LayersPanel.this.refreshTableData();
            }
        };
        this.controlPanelRefresher = new Runnable(){

            @Override
            public void run() {
                LayersPanel.this.controlPanel.refresh();
            }
        };
        this.canvasRefresher = new CanvasRefresher();
        this.initialize();
        this.initVisibilityToggleListener();
        this.tglbtnLayerVisibility.addActionListener(this.visibilityToggleActionListener);
        this.tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -8573364273165723214L;

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                return LayersPanel.this.layers.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row >= LayersPanel.this.layers.size()) {
                    return null;
                }
                Layer layer = LayersPanel.this.layers.get(row);
                switch (column) {
                    case 0: {
                        return layer.getName();
                    }
                    case 1: {
                        return layer.isVisible();
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                if (row >= LayersPanel.this.layers.size()) {
                    return;
                }
                LayersPanel.this.isLayerEditing = true;
                try {
                    Layer layer = LayersPanel.this.layers.get(row);
                    switch (column) {
                        case 0: {
                            layer.setName((String)value);
                            break;
                        }
                        case 1: {
                            layer.setVisible((Boolean)value);
                            LayersPanel.this.setToggleButtonState((Boolean)value);
                        }
                    }
                }
                finally {
                    LayersPanel.this.isLayerEditing = false;
                }
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                Layer layer;
                if (row >= LayersPanel.this.layers.size()) {
                    return false;
                }
                boolean editable = column == 0 ? ((layer = LayersPanel.this.layers.get(row)) != null ? !layer.isReadOnly() : false) : true;
                return editable;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    default: {
                        return String.class;
                    }
                    case 1: 
                }
                return Boolean.class;
            }
        };
        this.table.setModel((TableModel)this.tableModel);
        this.table.setHighlighters(new Highlighter[]{HighlighterFactory.createSimpleStriping()});
        ((ColumnControlButton)this.table.getColumnControl()).setAdditionalActionsVisible(false);
        this.table.getActionMap().remove("find");
        TableColumnExt col = this.table.getColumnExt(0);
        col.setPreferredWidth(140);
        col.setToolTipText("Layer name (double click in a cell to edit)");
        col = this.table.getColumnExt(1);
        col.setPreferredWidth(20);
        col.setMinWidth(20);
        col.setMaxWidth(20);
        col.setCellEditor((TableCellEditor)new VisibleCellEditor(18));
        col.setCellRenderer((TableCellRenderer)new VisibleCellRenderer(18));
        col.setToolTipText("Make the layer visible or not");
        col.setResizable(false);
        this.tableSelectionModel = this.table.getSelectionModel();
        this.tableSelectionModel.addListSelectionListener(this);
        this.tableSelectionModel.setSelectionMode(2);
        this.buildActionMap();
        this.refreshLayers();
    }

    private void initialize() {
        JPanel panelNorth = new JPanel();
        GridBagLayout gbl_panelNorth = new GridBagLayout();
        int[] nArray = new int[3];
        nArray[0] = 46;
        nArray[1] = 22;
        gbl_panelNorth.columnWidths = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 23;
        gbl_panelNorth.rowHeights = nArray2;
        gbl_panelNorth.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panelNorth.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelNorth.setLayout(gbl_panelNorth);
        this.nameFilter = new IcyTextField();
        this.nameFilter.setToolTipText("Enter a string sequence to filter Layer on name");
        this.nameFilter.addTextChangeListener(this);
        GridBagConstraints gbc_nameFilter = new GridBagConstraints();
        gbc_nameFilter.fill = 2;
        gbc_nameFilter.insets = new Insets(0, 0, 0, 5);
        gbc_nameFilter.gridx = 0;
        gbc_nameFilter.gridy = 0;
        panelNorth.add((Component)this.nameFilter, gbc_nameFilter);
        this.tglbtnLayerVisibility = new JToggleButton();
        this.tglbtnLayerVisibility.setFocusable(false);
        this.tglbtnLayerVisibility.setToolTipText("Change visibility for selected layer(s)");
        GridBagConstraints gbc_tglbtnLayerVisibility = new GridBagConstraints();
        gbc_tglbtnLayerVisibility.anchor = 17;
        gbc_tglbtnLayerVisibility.gridx = 1;
        gbc_tglbtnLayerVisibility.gridy = 0;
        panelNorth.add((Component)this.tglbtnLayerVisibility, gbc_tglbtnLayerVisibility);
        this.table = new JXTable();
        this.table.setAutoStartEditOnKeyStroke(false);
        this.table.setRowHeight(24);
        this.table.setShowVerticalLines(false);
        this.table.setColumnControlVisible(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoCreateRowSorter(true);
        this.controlPanel = new LayerControlPanel(this);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)panelNorth, "North");
        this.add((Component)new JScrollPane((Component)this.table, 22, 31), "Center");
        this.add((Component)this.controlPanel, "South");
        this.validate();
    }

    private void initVisibilityToggleListener() {
        this.visibilityToggleActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean visibilityValue = LayersPanel.this.tglbtnLayerVisibility.isSelected();
                for (Layer l : LayersPanel.this.getSelectedLayers()) {
                    l.setVisible(visibilityValue);
                }
            }
        };
    }

    void buildActionMap() {
        InputMap imap = this.table.getInputMap(0);
        ActionMap amap = this.table.getActionMap();
        imap.put(CanvasActions.unselectAction.getKeyStroke(), CanvasActions.unselectAction.getName());
        imap.put(CanvasActions.deleteLayersAction.getKeyStroke(), CanvasActions.deleteLayersAction.getName());
        imap.put(KeyStroke.getKeyStroke(8, 0), CanvasActions.deleteLayersAction.getName());
        amap.remove("find");
        amap.put(CanvasActions.unselectAction.getName(), CanvasActions.unselectAction);
        amap.put(CanvasActions.deleteLayersAction.getName(), CanvasActions.deleteLayersAction);
    }

    public void setNameFilter(String name) {
        this.nameFilter.setText(name);
    }

    protected void refreshLayers() {
        ThreadUtil.runSingle(this.layersRefresher);
    }

    void refreshLayersInternal() {
        if (this.canvas != null) {
            this.layers = this.filterList(this.canvas.getLayers(false), this.nameFilter.getText());
        } else {
            this.layers.clear();
        }
        ThreadUtil.runSingle(this.tableDataRefresher);
    }

    protected int getLayerIndex(Layer layer) {
        return this.layers.indexOf(layer);
    }

    protected int getLayerModelIndex(Layer layer) {
        return this.getLayerIndex(layer);
    }

    protected int getLayerTableIndex(Layer layer) {
        int ind = this.getLayerModelIndex(layer);
        if (ind == -1) {
            return ind;
        }
        try {
            return this.table.convertRowIndexToView(ind);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    public ArrayList<Layer> getSelectedLayers() {
        ArrayList<Layer> result = new ArrayList<Layer>();
        int[] nArray = this.table.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            int index = -1;
            if (rowIndex != -1) {
                try {
                    index = this.table.convertRowIndexToModel(rowIndex);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (index >= 0 && index < this.layers.size()) {
                result.add(this.layers.get(index));
            }
            ++n2;
        }
        return result;
    }

    public void clearSelected() {
        this.setSelectedLayersInternal(new ArrayList<Layer>());
    }

    void setSelectedLayersInternal(List<Layer> newSelected) {
        this.isSelectionAdjusting = true;
        try {
            this.table.clearSelection();
            if (newSelected != null) {
                boolean allHidden = newSelected.size() > 0;
                for (Layer layer : newSelected) {
                    int index = this.getLayerTableIndex(layer);
                    if (index <= -1) continue;
                    this.tableSelectionModel.addSelectionInterval(index, index);
                    boolean bl = allHidden = allHidden && !layer.isVisible();
                }
                this.setToggleButtonState(!allHidden);
            }
        }
        finally {
            this.isSelectionAdjusting = false;
        }
        this.selectionChanged();
    }

    private void setToggleButtonState(boolean active) {
        if (active) {
            this.tglbtnLayerVisibility.setIcon((Icon)((Object)this.visibleIcon));
        } else {
            this.tglbtnLayerVisibility.setIcon((Icon)((Object)this.notVisibleIcon));
        }
        this.tglbtnLayerVisibility.setSelected(active);
    }

    List<Layer> filterList(List<Layer> list, String nameFilterText) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        boolean nameEmpty = StringUtil.isEmpty(nameFilterText, true);
        String nameFilterUp = !nameEmpty ? nameFilterText.trim().toLowerCase() : "";
        for (Layer layer : list) {
            if (!nameEmpty && layer.getName().toLowerCase().indexOf(nameFilterUp) == -1) continue;
            result.add(layer);
        }
        return result;
    }

    protected void refreshTableData() {
        final ArrayList<Layer> save = this.getSelectedLayers();
        ThreadUtil.invokeNow(new Runnable(){

            @Override
            public void run() {
                LayersPanel.this.isSelectionAdjusting = true;
                try {
                    LayersPanel.this.tableModel.fireTableDataChanged();
                }
                finally {
                    LayersPanel.this.isSelectionAdjusting = false;
                }
                LayersPanel.this.setSelectedLayersInternal(save);
            }
        });
    }

    protected void selectionChanged() {
        ArrayList<Layer> newSelected = this.getSelectedLayers();
        boolean allHidden = newSelected.size() > 0;
        for (Layer layer : newSelected) {
            int index = this.getLayerTableIndex(layer);
            if (index <= -1) continue;
            boolean bl = allHidden = allHidden && !layer.isVisible();
        }
        this.setToggleButtonState(!allHidden);
        ThreadUtil.runSingle(this.controlPanelRefresher);
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        if (source == this.nameFilter) {
            this.refreshLayers();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.isSelectionAdjusting || e.getValueIsAdjusting()) {
            return;
        }
        this.selectionChanged();
    }

    @Override
    public void viewerActivated(Viewer viewer) {
        this.canvasRefresher.newCanvas = viewer != null ? viewer.getCanvas() : null;
        ThreadUtil.runSingle(this.canvasRefresher);
    }

    @Override
    public void viewerDeactivated(Viewer viewer) {
    }

    @Override
    public void activeViewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.CANVAS_CHANGED) {
            this.canvasRefresher.newCanvas = event.getSource().getCanvas();
            ThreadUtil.runSingle(this.canvasRefresher);
        }
    }

    @Override
    public void canvasLayerChanged(CanvasLayerEvent event) {
        if (this.isLayerEditing) {
            return;
        }
        switch (event.getType()) {
            case ADDED: 
            case REMOVED: {
                this.refreshLayers();
                break;
            }
            case CHANGED: {
                String property = event.getProperty();
                if (!"name".equals(property) && !"opacity".equals(property) && !"visible".equals(property)) break;
                ThreadUtil.runSingle(this.tableDataRefresher);
            }
        }
    }

    private class CanvasRefresher
    implements Runnable {
        IcyCanvas newCanvas;

        @Override
        public void run() {
            IcyCanvas c = this.newCanvas;
            if (LayersPanel.this.canvas != c) {
                if (LayersPanel.this.canvas != null) {
                    LayersPanel.this.canvas.removeLayerListener(LayersPanel.this);
                }
                LayersPanel.this.canvas = c;
                if (LayersPanel.this.canvas != null) {
                    LayersPanel.this.canvas.addLayerListener(LayersPanel.this);
                }
            }
            LayersPanel.this.refreshLayersInternal();
        }
    }
}

