/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.dialog.ActionDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.sequence.tools.SequenceDimensionAdjustPanel;
import icy.gui.util.ComponentUtil;
import icy.sequence.AbstractSequenceModel;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;

public class SequenceDimensionAdjustFrame
extends ActionDialog {
    private static final long serialVersionUID = -383226926743211242L;
    final Sequence sequence;
    final SequenceDimensionAdjustPanel rangePanel;
    final DimensionId dim;

    public SequenceDimensionAdjustFrame(Sequence sequence, DimensionId dim) {
        super("Adjust " + dim.toString() + " dimension");
        this.sequence = sequence;
        this.dim = dim;
        this.rangePanel = new SequenceDimensionAdjustPanel(dim);
        this.rangePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.mainPanel.add((Component)this.rangePanel, "Center");
        this.validate();
        this.rangePanel.setModel(new SequenceDimensionAdjustFrameModel());
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        DimensionId dim = (this).SequenceDimensionAdjustFrame.this.dim;
                        ProgressFrame pf = dim == DimensionId.Z ? new ProgressFrame("Removing slices...") : new ProgressFrame("Removing frames...");
                        Sequence seq = (this).SequenceDimensionAdjustFrame.this.sequence;
                        Sequence tmp = new Sequence();
                        int sizeT = seq.getSizeT();
                        int sizeZ = seq.getSizeZ();
                        tmp.beginUpdate();
                        seq.beginUpdate();
                        try {
                            int z;
                            int i = 0;
                            int t = 0;
                            while (t < sizeT) {
                                if (dim == DimensionId.Z) {
                                    i = 0;
                                }
                                z = 0;
                                while (z < sizeZ) {
                                    if (dim == DimensionId.Z) {
                                        if ((this).SequenceDimensionAdjustFrame.this.rangePanel.isIndexSelected(z)) {
                                            tmp.setImage(t, i++, (BufferedImage)seq.getImage(t, z));
                                        }
                                    } else if ((this).SequenceDimensionAdjustFrame.this.rangePanel.isIndexSelected(t)) {
                                        tmp.setImage(i, z, (BufferedImage)seq.getImage(t, z));
                                    }
                                    ++z;
                                }
                                if (dim == DimensionId.T && (this).SequenceDimensionAdjustFrame.this.rangePanel.isIndexSelected(t)) {
                                    ++i;
                                }
                                ++t;
                            }
                            sizeT = tmp.getSizeT();
                            sizeZ = tmp.getSizeZ();
                            seq.removeAllImages();
                            t = 0;
                            while (t < sizeT) {
                                z = 0;
                                while (z < sizeZ) {
                                    seq.setImage(t, z, (BufferedImage)tmp.getImage(t, z));
                                    ++z;
                                }
                                ++t;
                            }
                        }
                        finally {
                            seq.endUpdate();
                            tmp.endUpdate();
                            pf.close();
                        }
                    }
                });
            }
        });
        this.setSize(320, 360);
        ComponentUtil.center(this);
        this.setVisible(true);
    }

    SequenceDimensionAdjustFrame() {
        this(new Sequence(), DimensionId.Z);
    }

    private class SequenceDimensionAdjustFrameModel
    extends AbstractSequenceModel {
        @Override
        public int getSizeX() {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getSizeX();
            }
            return 0;
        }

        @Override
        public int getSizeY() {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getSizeY();
            }
            return 0;
        }

        @Override
        public int getSizeZ() {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getSizeZ();
            }
            return 0;
        }

        @Override
        public int getSizeT() {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getSizeT();
            }
            return 0;
        }

        @Override
        public int getSizeC() {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getSizeC();
            }
            return 0;
        }

        @Override
        public BufferedImage getImage(int t, int z) {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getImage(t, z);
            }
            return null;
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            if (SequenceDimensionAdjustFrame.this.sequence != null) {
                return SequenceDimensionAdjustFrame.this.sequence.getImage(t, z, c);
            }
            return null;
        }
    }
}

