/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.painter.Painter;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class OverlayWrapper
extends Overlay {
    private final Painter painter;

    public OverlayWrapper(Painter painter, String name) {
        super(name);
        this.painter = painter;
    }

    public Painter getPainter() {
        return this.painter;
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        this.painter.paint(g, sequence, canvas);
    }

    @Override
    public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.mouseClick(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.mouseClick(e, null, canvas);
        }
    }

    @Override
    public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.mousePressed(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.mousePressed(e, null, canvas);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.mouseReleased(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.mouseReleased(e, null, canvas);
        }
    }

    @Override
    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.mouseMove(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.mouseMove(e, null, canvas);
        }
    }

    @Override
    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.mouseDrag(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.mouseDrag(e, null, canvas);
        }
    }

    @Override
    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.keyPressed(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.keyPressed(e, null, canvas);
        }
    }

    @Override
    public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (imagePoint != null) {
            this.painter.keyReleased(e, imagePoint.toPoint2D(), canvas);
        } else {
            this.painter.keyReleased(e, null, canvas);
        }
    }
}

