/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin;

import icy.file.Loader;
import icy.gui.frame.progress.ProgressFrame;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.abstract_.Plugin;
import icy.plugin.classloader.JarClassLoader;
import icy.plugin.interface_.PluginDaemon;
import icy.preferences.PluginPreferences;
import icy.system.IcyExceptionHandler;
import icy.system.thread.SingleProcessor;
import icy.system.thread.ThreadUtil;
import icy.util.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class PluginLoader {
    public static final String PLUGIN_PACKAGE = "plugins";
    public static final String PLUGIN_KERNEL_PACKAGE = "plugins.kernel";
    public static final String PLUGIN_PATH = "plugins";
    public static final String NEWER_JAVA_REQUIRED = "Newer java version required";
    private static final PluginLoader instance = new PluginLoader();
    private ClassLoader loader = new PluginClassLoader();
    private List<PluginDaemon> activeDaemons = new ArrayList<PluginDaemon>();
    private List<PluginDescriptor> plugins = new ArrayList<PluginDescriptor>();
    private final EventListenerList listeners = new EventListenerList();
    protected boolean JCLDisabled = false;
    private final Runnable reloader = new Runnable(){

        @Override
        public void run() {
            PluginLoader.this.reloadInternal();
        }
    };
    final SingleProcessor processor = new SingleProcessor(true, "Local Plugin Loader");
    private boolean initialized = false;
    private boolean loading = false;

    private PluginLoader() {
    }

    static void prepare() {
        if (!PluginLoader.instance.initialized) {
            if (PluginLoader.isLoading()) {
                PluginLoader.waitWhileLoading();
            } else {
                PluginLoader.reload();
            }
        }
    }

    public static void reloadAsynch() {
        PluginLoader.instance.processor.submit(PluginLoader.instance.reloader);
    }

    public static void reload() {
        PluginLoader.instance.processor.submit(PluginLoader.instance.reloader);
        ThreadUtil.sleep(500);
        PluginLoader.waitWhileLoading();
    }

    @Deprecated
    public static void reload(boolean forceNow) {
        PluginLoader.reload();
    }

    public static synchronized void resetDaemons() {
        if (PluginLoader.isLoading()) {
            return;
        }
        PluginLoader.stopDaemons();
        PluginLoader.startDaemons();
    }

    void reloadInternal() {
        ClassLoader newLoader;
        this.loading = true;
        PluginLoader.stopDaemons();
        ArrayList<PluginDescriptor> newPlugins = new ArrayList<PluginDescriptor>();
        if (this.JCLDisabled) {
            newLoader = PluginLoader.class.getClassLoader();
        } else {
            newLoader = new PluginClassLoader();
            ((PluginClassLoader)newLoader).add("plugins");
        }
        if (this.processor.hasWaitingTasks()) {
            return;
        }
        HashSet<String> classes = new HashSet<String>();
        try {
            ClassUtil.findClassNamesInPackage("plugins", true, classes);
            ClassUtil.findClassNamesInPath("plugins", "plugins", true, classes);
        }
        catch (IOException e) {
            System.err.println("Error loading plugins :");
            IcyExceptionHandler.showErrorMessage(e, true);
        }
        for (String className : classes) {
            if (!className.startsWith("plugins") || className.contains("$")) continue;
            if (this.processor.hasWaitingTasks()) {
                return;
            }
            try {
                Class<Plugin> pluginClass = newLoader.loadClass(className).asSubclass(Plugin.class);
                newPlugins.add(new PluginDescriptor(pluginClass));
            }
            catch (NoClassDefFoundError e) {
                System.err.println("Class '" + className + "' cannot be loaded :");
                System.err.println("Required class '" + ClassUtil.getQualifiedNameFromPath(e.getMessage()) + "' not found.");
            }
            catch (OutOfMemoryError e) {
                IcyExceptionHandler.showErrorMessage(e, false);
                System.err.println("Class '" + className + "' is discarded");
            }
            catch (UnsupportedClassVersionError e) {
                System.err.println("Newer java version required for class '" + className + "' (discarded)");
            }
            catch (Error e) {
                IcyExceptionHandler.showErrorMessage(e, false);
                System.err.println("Class '" + className + "' is discarded");
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage(e, false);
                System.err.println("Class '" + className + "' is discarded");
            }
        }
        Collections.sort(newPlugins, PluginDescriptor.PluginKernelNameSorter.instance);
        if (this.loader instanceof JarClassLoader) {
            ((JarClassLoader)this.loader).unloadAll();
        }
        this.loader = newLoader;
        this.plugins = newPlugins;
        this.loading = false;
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginDescriptor> getDaemonPlugins() {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        List<PluginDescriptor> list = PluginLoader.instance.plugins;
        synchronized (list) {
            for (PluginDescriptor pluginDescriptor : PluginLoader.instance.plugins) {
                if (!pluginDescriptor.isInstanceOf(PluginDaemon.class) || pluginDescriptor.isAbstract() || pluginDescriptor.isInterface()) continue;
                result.add(pluginDescriptor);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginDaemon> getActiveDaemons() {
        List<PluginDaemon> list = PluginLoader.instance.activeDaemons;
        synchronized (list) {
            return new ArrayList<PluginDaemon>(PluginLoader.instance.activeDaemons);
        }
    }

    static synchronized void startDaemons() {
        if (!PluginLoader.instance.activeDaemons.isEmpty()) {
            PluginLoader.stopDaemons();
        }
        ArrayList<String> inactives = PluginPreferences.getInactiveDaemons();
        ArrayList<PluginDaemon> newDaemons = new ArrayList<PluginDaemon>();
        for (PluginDescriptor pluginDesc : PluginLoader.getDaemonPlugins()) {
            if (inactives.indexOf(pluginDesc.getClassName()) != -1) continue;
            try {
                PluginDaemon plugin = (PluginDaemon)((Object)pluginDesc.getPluginClass().newInstance());
                Thread thread = new Thread((Runnable)plugin, pluginDesc.getName());
                thread.setName(pluginDesc.getName());
                thread.setDaemon(true);
                plugin.init();
                thread.start();
                Icy.getMainInterface().registerPlugin((Plugin)((Object)plugin));
                newDaemons.add(plugin);
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException(pluginDesc, t, true);
            }
        }
        PluginLoader.instance.activeDaemons = newDaemons;
    }

    public static synchronized void stopDaemons() {
        for (PluginDaemon daemonPlug : PluginLoader.getActiveDaemons()) {
            try {
                daemonPlug.stop();
            }
            catch (Throwable t) {
                IcyExceptionHandler.handleException(((Plugin)((Object)daemonPlug)).getDescriptor(), t, true);
            }
        }
        PluginLoader.instance.activeDaemons = new ArrayList<PluginDaemon>();
    }

    public static ClassLoader getLoader() {
        return PluginLoader.instance.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, URL> getAllResources() {
        PluginLoader.prepare();
        ClassLoader classLoader = PluginLoader.instance.loader;
        synchronized (classLoader) {
            if (PluginLoader.instance.loader instanceof JarClassLoader) {
                return ((JarClassLoader)PluginLoader.instance.loader).getResources();
            }
        }
        return new HashMap<String, URL>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, byte[]> getLoadedResources() {
        PluginLoader.prepare();
        ClassLoader classLoader = PluginLoader.instance.loader;
        synchronized (classLoader) {
            if (PluginLoader.instance.loader instanceof JarClassLoader) {
                return ((JarClassLoader)PluginLoader.instance.loader).getLoadedResources();
            }
        }
        return new HashMap<String, byte[]>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Class<?>> getLoadedClasses() {
        PluginLoader.prepare();
        ClassLoader classLoader = PluginLoader.instance.loader;
        synchronized (classLoader) {
            if (PluginLoader.instance.loader instanceof JarClassLoader) {
                HashMap result = new HashMap();
                Map<String, Class> classes = ((JarClassLoader)PluginLoader.instance.loader).getLoadedClasses();
                for (Map.Entry<String, Class> entry : classes.entrySet()) {
                    result.put(entry.getKey(), entry.getValue());
                }
                return result;
            }
        }
        return new HashMap();
    }

    @Deprecated
    public static Map<String, Class<?>> getAllClasses() {
        return PluginLoader.getLoadedClasses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getResourceAsStream(String name) {
        PluginLoader.prepare();
        ClassLoader classLoader = PluginLoader.instance.loader;
        synchronized (classLoader) {
            return PluginLoader.instance.loader.getResourceAsStream(name);
        }
    }

    public static ArrayList<PluginDescriptor> getPlugins() {
        return PluginLoader.getPlugins(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginDescriptor> getPlugins(boolean wantBundled) {
        PluginLoader.prepare();
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        List<PluginDescriptor> list = PluginLoader.instance.plugins;
        synchronized (list) {
            for (PluginDescriptor plugin : PluginLoader.instance.plugins) {
                if (!wantBundled && plugin.isBundled()) continue;
                result.add(plugin);
            }
        }
        return result;
    }

    public static ArrayList<PluginDescriptor> getPlugins(Class<?> clazz) {
        return PluginLoader.getPlugins(clazz, true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginDescriptor> getPlugins(Class<?> clazz, boolean wantBundled, boolean wantAbstract, boolean wantInterface) {
        PluginLoader.prepare();
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        if (clazz != null) {
            List<PluginDescriptor> list = PluginLoader.instance.plugins;
            synchronized (list) {
                for (PluginDescriptor pluginDescriptor : PluginLoader.instance.plugins) {
                    if (!pluginDescriptor.isInstanceOf(clazz) || !wantAbstract && pluginDescriptor.isAbstract() || !wantInterface && pluginDescriptor.isInterface() || !wantBundled && pluginDescriptor.isBundled()) continue;
                    result.add(pluginDescriptor);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<PluginDescriptor> getActionablePlugins(boolean wantBundled) {
        PluginLoader.prepare();
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        List<PluginDescriptor> list = PluginLoader.instance.plugins;
        synchronized (list) {
            for (PluginDescriptor pluginDescriptor : PluginLoader.instance.plugins) {
                if (!pluginDescriptor.isActionable() || !wantBundled && pluginDescriptor.isBundled()) continue;
                result.add(pluginDescriptor);
            }
        }
        return result;
    }

    public static ArrayList<PluginDescriptor> getActionablePlugins() {
        return PluginLoader.getActionablePlugins(true);
    }

    public static boolean isLoading() {
        return PluginLoader.instance.processor.hasWaitingTasks() || PluginLoader.instance.loading;
    }

    public static void waitWhileLoading() {
        while (PluginLoader.isLoading()) {
            ThreadUtil.sleep(100);
        }
    }

    public static boolean isLoaded(PluginDescriptor plugin, boolean acceptNewer) {
        return PluginLoader.getPlugin(plugin.getIdent(), acceptNewer) != null;
    }

    public static boolean isLoaded(String className) {
        return PluginLoader.getPlugin(className) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginDescriptor getPlugin(PluginDescriptor.PluginIdent ident, boolean acceptNewer) {
        PluginLoader.prepare();
        List<PluginDescriptor> list = PluginLoader.instance.plugins;
        synchronized (list) {
            return PluginDescriptor.getPlugin(PluginLoader.instance.plugins, ident, acceptNewer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginDescriptor getPlugin(String className) {
        PluginLoader.prepare();
        List<PluginDescriptor> list = PluginLoader.instance.plugins;
        synchronized (list) {
            return PluginDescriptor.getPlugin(PluginLoader.instance.plugins, className);
        }
    }

    public static Class<? extends Plugin> getPluginClass(String className) {
        PluginLoader.prepare();
        PluginDescriptor descriptor = PluginLoader.getPlugin(className);
        if (descriptor != null) {
            return descriptor.getPluginClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        PluginLoader.prepare();
        ClassLoader classLoader = PluginLoader.instance.loader;
        synchronized (classLoader) {
            return PluginLoader.instance.loader.loadClass(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String verifyPlugin(PluginDescriptor plugin) {
        ClassLoader classLoader = PluginLoader.instance.loader;
        synchronized (classLoader) {
            try {
                PluginLoader.instance.loader.loadClass(plugin.getClassName()).asSubclass(Plugin.class);
            }
            catch (UnsupportedClassVersionError e) {
                return "Newer java version required.";
            }
            catch (Error e) {
                return e.toString();
            }
            catch (ClassCastException e) {
                return String.valueOf(IcyExceptionHandler.getErrorMessage(e, false)) + "Your plugin class should extends 'icy.plugin.abstract_.Plugin' class.";
            }
            catch (ClassNotFoundException e) {
                return String.valueOf(IcyExceptionHandler.getErrorMessage(e, false)) + "Verify you correctly set the class name in your plugin description.";
            }
            catch (Exception e) {
                return IcyExceptionHandler.getErrorMessage(e, false);
            }
            return "";
        }
    }

    public static boolean isJCLDisabled() {
        return PluginLoader.instance.JCLDisabled;
    }

    public static void setJCLDisabled(boolean value) {
        PluginLoader.instance.JCLDisabled = value;
    }

    @Deprecated
    public static boolean getLogError() {
        return false;
    }

    @Deprecated
    public static void setLogError(boolean value) {
    }

    protected void changed() {
        if (!this.initialized) {
            this.initialized = true;
            PluginLoader.checkPlugins(false);
        }
        PluginLoader.startDaemons();
        this.fireEvent(new PluginLoaderEvent());
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                if (!PluginInstaller.getInstallFIFO().isEmpty() || !PluginInstaller.getRemoveFIFO().isEmpty() || PluginLoader.isLoading()) {
                    return;
                }
                Loader.getSequenceFileImporters();
                Loader.getFileImporters();
                Loader.getImporters();
            }
        });
    }

    public static void checkPlugins(boolean showProgress) {
        ArrayList<PluginDescriptor> plugins = PluginLoader.getPlugins(false);
        ArrayList<PluginDescriptor> required = new ArrayList<PluginDescriptor>();
        ArrayList<PluginDescriptor> missings = new ArrayList<PluginDescriptor>();
        ArrayList<PluginDescriptor> faulties = new ArrayList<PluginDescriptor>();
        if (NetworkUtil.hasInternetAccess()) {
            ProgressFrame pf;
            if (showProgress) {
                pf = new ProgressFrame("Checking plugins...");
                pf.setLength(plugins.size());
                pf.setPosition(0.0);
            } else {
                pf = null;
            }
            PluginRepositoryLoader.waitLoaded();
            for (PluginDescriptor plugin : plugins) {
                if (!PluginInstaller.getDependencies(plugin, required, null, false)) {
                    faulties.add(PluginRepositoryLoader.getPlugin(plugin.getClassName()));
                }
                if (pf == null) continue;
                pf.incPosition();
            }
            if (pf != null) {
                pf.setLength(required.size());
            }
            for (PluginDescriptor plugin : required) {
                PluginDescriptor toInstall;
                if (!plugin.isInstalled() && (toInstall = PluginRepositoryLoader.getPlugin(plugin.getClassName())) != null) {
                    missings.add(toInstall);
                }
                if (pf == null) continue;
                pf.incPosition();
            }
            if (faulties.size() > 0 || missings.size() > 0) {
                if (pf != null) {
                    pf.setMessage("Installing missing plugins...");
                    pf.setPosition(0.0);
                    pf.setLength(faulties.size() + missings.size());
                }
                for (PluginDescriptor plugin : missings) {
                    PluginInstaller.install(plugin, true);
                    if (pf == null) continue;
                    pf.incPosition();
                }
                for (PluginDescriptor plugin : faulties) {
                    PluginInstaller.install(plugin, true);
                    if (pf == null) continue;
                    pf.incPosition();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(PluginLoaderListener listener) {
        EventListenerList eventListenerList = PluginLoader.instance.listeners;
        synchronized (eventListenerList) {
            PluginLoader.instance.listeners.add(PluginLoaderListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(PluginLoaderListener listener) {
        EventListenerList eventListenerList = PluginLoader.instance.listeners;
        synchronized (eventListenerList) {
            PluginLoader.instance.listeners.remove(PluginLoaderListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvent(PluginLoaderEvent e) {
        EventListenerList eventListenerList = this.listeners;
        synchronized (eventListenerList) {
            PluginLoaderListener[] pluginLoaderListenerArray = (PluginLoaderListener[])this.listeners.getListeners(PluginLoaderListener.class);
            int n = pluginLoaderListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                PluginLoaderListener listener = pluginLoaderListenerArray[n2];
                listener.pluginLoaderChanged(e);
                ++n2;
            }
        }
    }

    public static class PluginClassLoader
    extends JarClassLoader {
        public Class<?> getLoadedClass(String name) {
            return super.findLoadedClass(name);
        }

        public boolean isLoadedClass(String name) {
            return this.getLoadedClass(name) != null;
        }
    }

    public static class PluginLoaderEvent {
        public boolean equals(Object obj) {
            if (obj instanceof PluginLoaderEvent) {
                return true;
            }
            return super.equals(obj);
        }
    }

    public static interface PluginLoaderListener
    extends EventListener {
        public void pluginLoaderChanged(PluginLoaderEvent var1);
    }
}

