/*
 * Decompiled with CFR 0.152.
 */
package icy.search;

import icy.search.SearchResult;
import icy.search.SearchResultConsumer;
import icy.system.IcyExceptionHandler;
import icy.system.thread.SingleProcessor;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class SearchResultProducer
implements Comparable<SearchResultProducer> {
    protected List<SearchResult> results = new ArrayList<SearchResult>();
    protected final SingleProcessor processor = new SingleProcessor(true, this.getClass().getSimpleName());

    public static List<SearchWord> getSearchWords(String text) {
        List<String> words = StringUtil.split(text);
        ArrayList<SearchWord> result = new ArrayList<SearchWord>();
        for (String w : words) {
            SearchWord sw = new SearchWord(w);
            if (sw.isEmpty()) continue;
            result.add(sw);
        }
        return result;
    }

    public static boolean getShortSearch(List<SearchWord> words) {
        return words.size() == 1 && words.get(0).length() <= 2;
    }

    public int getOrder() {
        return 10;
    }

    public abstract String getName();

    public String getTooltipText() {
        return "Click to run";
    }

    public List<SearchResult> getResults() {
        return this.results;
    }

    @Deprecated
    public void search(String[] words, SearchResultConsumer consumer) {
        if (words.length > 0) {
            String t = words[0];
            int i = 1;
            while (i < words.length) {
                t = String.valueOf(t) + " " + words[i];
                ++i;
            }
            this.processor.submit(new SearchRunner(t, consumer));
        } else {
            this.processor.submit(new SearchRunner("", consumer));
        }
    }

    public void search(String text, SearchResultConsumer consumer) {
        this.processor.submit(new SearchRunner(text, consumer));
    }

    @Deprecated
    public void doSearch(String[] words, SearchResultConsumer consumer) {
    }

    public void doSearch(String text, SearchResultConsumer consumer) {
        this.doSearch(text.split(" "), consumer);
    }

    public void waitSearchComplete() {
        while (this.isSearching()) {
            ThreadUtil.sleep(1);
        }
    }

    public boolean isSearching() {
        return this.processor.isProcessing();
    }

    public boolean hasWaitingSearch() {
        return this.processor.hasWaitingTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResult(SearchResult result, SearchResultConsumer consumer) {
        if (result != null) {
            List<SearchResult> list = this.results;
            synchronized (list) {
                this.results.add(result);
            }
            if (consumer != null) {
                consumer.resultsChanged(this);
            }
        }
    }

    @Override
    public int compareTo(SearchResultProducer o) {
        return this.getOrder() - o.getOrder();
    }

    private class SearchRunner
    implements Runnable {
        private final String text;
        private final SearchResultConsumer consumer;

        public SearchRunner(String text, SearchResultConsumer consumer) {
            this.text = text;
            this.consumer = consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!StringUtil.isEmpty(this.text)) {
                try {
                    SearchResultProducer.this.doSearch(this.text, this.consumer);
                }
                catch (Throwable t) {
                    IcyExceptionHandler.showErrorMessage(t, true, true);
                }
            } else {
                boolean notEmpty;
                List<SearchResult> list = SearchResultProducer.this.results;
                synchronized (list) {
                    boolean bl = notEmpty = !SearchResultProducer.this.results.isEmpty();
                    if (notEmpty) {
                        SearchResultProducer.this.results.clear();
                    }
                }
                if (notEmpty) {
                    this.consumer.resultsChanged(SearchResultProducer.this);
                }
            }
            this.consumer.searchCompleted(SearchResultProducer.this);
        }
    }

    public static class SearchWord {
        public final String word;
        public final boolean mandatory;
        public final boolean reject;

        public SearchWord(String word) {
            if (word.startsWith("+")) {
                this.mandatory = true;
                this.reject = false;
                this.word = word.length() > 1 ? word.substring(1) : "";
            } else if (word.startsWith("-")) {
                this.mandatory = false;
                this.reject = true;
                this.word = word.length() > 1 ? word.substring(1) : "";
            } else {
                this.mandatory = false;
                this.reject = false;
                this.word = word;
            }
        }

        public boolean isEmpty() {
            return StringUtil.isEmpty(this.word);
        }

        public int length() {
            return this.word.length();
        }
    }
}

