/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.array;

import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;

public class Array2DUtil {
    public static int getTotalLength(byte[][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array1DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(short[][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array1DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(int[][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array1DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(long[][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array1DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(float[][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array1DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    public static int getTotalLength(double[][] array) {
        int result = 0;
        if (array != null) {
            int len = array.length;
            int i = 0;
            while (i < len) {
                result += Array1DUtil.getTotalLength(array[i]);
                ++i;
            }
        }
        return result;
    }

    @Deprecated
    public static int getTotalLenght(byte[][] array) {
        return Array2DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(short[][] array) {
        return Array2DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(int[][] array) {
        return Array2DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(float[][] array) {
        return Array2DUtil.getTotalLength(array);
    }

    @Deprecated
    public static int getTotalLenght(double[][] array) {
        return Array2DUtil.getTotalLength(array);
    }

    public static Object[] createArray(DataType dataType, int len) {
        switch (dataType.getJavaType()) {
            case BYTE: {
                return new byte[len][];
            }
            case SHORT: {
                return new short[len][];
            }
            case INT: {
                return new int[len][];
            }
            case LONG: {
                return new long[len][];
            }
            case FLOAT: {
                return new float[len][];
            }
            case DOUBLE: {
                return new double[len][];
            }
        }
        return null;
    }

    @Deprecated
    public static Object[] createArray(int dataType, int len) {
        return Array2DUtil.createArray(DataType.getDataType(dataType), len);
    }

    public static byte[][] allocIfNull(byte[][] out, int len) {
        if (out == null) {
            return new byte[len][];
        }
        return out;
    }

    public static short[][] allocIfNull(short[][] out, int len) {
        if (out == null) {
            return new short[len][];
        }
        return out;
    }

    public static int[][] allocIfNull(int[][] out, int len) {
        if (out == null) {
            return new int[len][];
        }
        return out;
    }

    public static long[][] allocIfNull(long[][] out, int len) {
        if (out == null) {
            return new long[len][];
        }
        return out;
    }

    public static float[][] allocIfNull(float[][] out, int len) {
        if (out == null) {
            return new float[len][];
        }
        return out;
    }

    public static double[][] allocIfNull(double[][] out, int len) {
        if (out == null) {
            return new double[len][];
        }
        return out;
    }

    public static boolean arrayByteCompare(byte[][] array1, byte[][] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Array1DUtil.arrayByteCompare(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayShortCompare(short[][] array1, short[][] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Array1DUtil.arrayShortCompare(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayIntCompare(int[][] array1, int[][] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Array1DUtil.arrayIntCompare(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayLongCompare(long[][] array1, long[][] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Array1DUtil.arrayLongCompare(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayFloatCompare(float[][] array1, float[][] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Array1DUtil.arrayFloatCompare(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayDoubleCompare(double[][] array1, double[][] array2) {
        int len = array1.length;
        if (len != array2.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Array1DUtil.arrayDoubleCompare(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] toByteArray1D(byte[][] in) {
        return Array2DUtil.toByteArray1D(in, null, 0);
    }

    public static short[] toShortArray1D(short[][] in) {
        return Array2DUtil.toShortArray1D(in, null, 0);
    }

    @Deprecated
    public static int[] toIntArray(int[][] in) {
        return Array2DUtil.toIntArray1D(in, null, 0);
    }

    public static int[] toIntArray1D(int[][] in) {
        return Array2DUtil.toIntArray1D(in, null, 0);
    }

    public static float[] toFloatArray1D(float[][] in) {
        return Array2DUtil.toFloatArray1D(in, null, 0);
    }

    public static double[] toDoubleArray1D(double[][] in) {
        return Array2DUtil.toDoubleArray1D(in, null, 0);
    }

    public static byte[] toByteArray1D(byte[][] in, byte[] out, int offset) {
        byte[] result = Array1DUtil.allocIfNull(out, offset + Array2DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                byte[] s_in = in[i];
                if (s_in != null) {
                    Array1DUtil.toByteArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static short[] toShortArray1D(short[][] in, short[] out, int offset) {
        short[] result = Array1DUtil.allocIfNull(out, offset + Array2DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                short[] s_in = in[i];
                if (s_in != null) {
                    Array1DUtil.toShortArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static int[] toIntArray1D(int[][] in, int[] out, int offset) {
        int[] result = Array1DUtil.allocIfNull(out, offset + Array2DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                int[] s_in = in[i];
                if (s_in != null) {
                    Array1DUtil.toIntArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static long[] toLongArray1D(long[][] in, long[] out, int offset) {
        long[] result = Array1DUtil.allocIfNull(out, offset + Array2DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                long[] s_in = in[i];
                if (s_in != null) {
                    Array1DUtil.toLongArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static float[] toFloatArray1D(float[][] in, float[] out, int offset) {
        float[] result = Array1DUtil.allocIfNull(out, offset + Array2DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                float[] s_in = in[i];
                if (s_in != null) {
                    Array1DUtil.toFloatArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static double[] toDoubleArray1D(double[][] in, double[] out, int offset) {
        double[] result = Array1DUtil.allocIfNull(out, offset + Array2DUtil.getTotalLength(in));
        if (in != null) {
            int len = in.length;
            int off = offset;
            int i = 0;
            while (i < len) {
                double[] s_in = in[i];
                if (s_in != null) {
                    Array1DUtil.toDoubleArray1D(s_in, result, off);
                    off += s_in.length;
                }
                ++i;
            }
        }
        return result;
    }

    public static Object arrayToArray(Object in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToArray((byte[][])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToArray((short[][])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.intArrayToArray((int[][])in, inOffset, out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.longArrayToArray((long[][])in, inOffset, out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToArray((float[][])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToArray((double[][])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static Object arrayToArray(Object in, Object out, boolean signed) {
        return Array2DUtil.arrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object doubleArrayToArray(double[][] in, int inOffset, Object out, int outOffset, int length) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.doubleArrayToByteArray(in, inOffset, (byte[][])out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.doubleArrayToShortArray(in, inOffset, (short[][])out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.doubleArrayToIntArray(in, inOffset, (int[][])out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.doubleArrayToLongArray(in, inOffset, (long[][])out, outOffset, length);
            }
            case FLOAT: {
                return Array2DUtil.doubleArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object doubleArrayToArray(double[][] in, Object out) {
        return Array2DUtil.doubleArrayToArray(in, 0, out, 0, -1);
    }

    public static Object floatArrayToArray(float[][] in, int inOffset, Object out, int outOffset, int length) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.floatArrayToByteArray(in, inOffset, (byte[][])out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.floatArrayToShortArray(in, inOffset, (short[][])out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.floatArrayToIntArray(in, inOffset, (int[][])out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.floatArrayToLongArray(in, inOffset, (long[][])out, outOffset, length);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.floatArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object floatArrayToArray(float[][] in, Object out) {
        return Array2DUtil.floatArrayToArray(in, 0, out, 0, -1);
    }

    public static Object longArrayToArray(long[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.longArrayToByteArray(in, inOffset, (byte[][])out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.longArrayToShortArray(in, inOffset, (short[][])out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.longArrayToIntArray(in, inOffset, (int[][])out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.longArrayToLongArray(in, inOffset, (long[][])out, outOffset, length);
            }
            case FLOAT: {
                return Array2DUtil.longArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array2DUtil.longArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object longArrayToArray(long[][] in, Object out, boolean signed) {
        return Array2DUtil.longArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object intArrayToArray(int[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.intArrayToByteArray(in, inOffset, (byte[][])out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.intArrayToShortArray(in, inOffset, (short[][])out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.intArrayToIntArray(in, inOffset, (int[][])out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.intArrayToLongArray(in, inOffset, (long[][])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.intArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array2DUtil.intArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object intArrayToArray(int[][] in, Object out, boolean signed) {
        return Array2DUtil.intArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object shortArrayToArray(short[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.shortArrayToByteArray(in, inOffset, (byte[][])out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToShortArray(in, inOffset, (short[][])out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.shortArrayToIntArray(in, inOffset, (int[][])out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.shortArrayToLongArray(in, inOffset, (long[][])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.shortArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array2DUtil.shortArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object shortArrayToArray(short[][] in, Object out, boolean signed) {
        return Array2DUtil.shortArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static Object byteArrayToArray(byte[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.byteArrayToByteArray(in, inOffset, (byte[][])out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.byteArrayToShortArray(in, inOffset, (short[][])out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.byteArrayToIntArray(in, inOffset, (int[][])out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.byteArrayToLongArray(in, inOffset, (long[][])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.byteArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, signed);
            }
            case DOUBLE: {
                return Array2DUtil.byteArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, signed);
            }
        }
        return out;
    }

    public static Object byteArrayToArray(byte[][] in, Object out, boolean signed) {
        return Array2DUtil.byteArrayToArray(in, 0, out, 0, -1, signed);
    }

    public static double[][] arrayToDoubleArray(Object in, int inOffset, double[][] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToDoubleArray((byte[][])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToDoubleArray((short[][])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.intArrayToDoubleArray((int[][])in, inOffset, out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.longArrayToDoubleArray((long[][])in, inOffset, out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToDoubleArray((float[][])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToDoubleArray((double[][])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static double[][] arrayToDoubleArray(Object in, double[][] out, boolean signed) {
        return Array2DUtil.arrayToDoubleArray(in, 0, out, 0, -1, signed);
    }

    public static double[][] arrayToDoubleArray(Object in, boolean signed) {
        return Array2DUtil.arrayToDoubleArray(in, 0, null, 0, -1, signed);
    }

    public static float[][] arrayToFloatArray(Object in, int inOffset, float[][] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToFloatArray((byte[][])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToFloatArray((short[][])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.intArrayToFloatArray((int[][])in, inOffset, out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.longArrayToFloatArray((long[][])in, inOffset, out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToFloatArray((float[][])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToFloatArray((double[][])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static float[][] arrayToFloatArray(Object in, float[][] out, boolean signed) {
        return Array2DUtil.arrayToFloatArray(in, 0, out, 0, -1, signed);
    }

    public static float[][] arrayToFloatArray(Object in, boolean signed) {
        return Array2DUtil.arrayToFloatArray(in, 0, null, 0, -1, signed);
    }

    public static int[][] arrayToIntArray(Object in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToIntArray((byte[][])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToIntArray((short[][])in, inOffset, out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.intArrayToIntArray((int[][])in, inOffset, out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.longArrayToIntArray((long[][])in, inOffset, out, outOffset, length);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToIntArray((float[][])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToIntArray((double[][])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static int[][] arrayToIntArray(Object in, int[][] out, boolean signed) {
        return Array2DUtil.arrayToIntArray(in, 0, out, 0, -1, signed);
    }

    public static int[][] arrayToIntArray(Object in, boolean signed) {
        return Array2DUtil.arrayToIntArray(in, 0, null, 0, -1, signed);
    }

    public static short[][] arrayToShortArray(Object in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToShortArray((byte[][])in, inOffset, out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToShortArray((short[][])in, inOffset, out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.intArrayToShortArray((int[][])in, inOffset, out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.longArrayToShortArray((long[][])in, inOffset, out, outOffset, length);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToShortArray((float[][])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToShortArray((double[][])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static short[][] arrayToShortArray(Object in, short[][] out, boolean signed) {
        return Array2DUtil.arrayToShortArray(in, 0, out, 0, -1, signed);
    }

    public static short[][] arrayToShortArray(Object in, boolean signed) {
        return Array2DUtil.arrayToShortArray(in, 0, null, 0, -1, signed);
    }

    public static byte[][] arrayToByteArray(Object in, int inOffset, byte[][] out, int outOffset, int length) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToByteArray((byte[][])in, inOffset, out, outOffset, length);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToByteArray((short[][])in, inOffset, out, outOffset, length);
            }
            case INT: {
                return Array2DUtil.intArrayToByteArray((int[][])in, inOffset, out, outOffset, length);
            }
            case LONG: {
                return Array2DUtil.longArrayToByteArray((long[][])in, inOffset, out, outOffset, length);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToByteArray((float[][])in, inOffset, out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToByteArray((double[][])in, inOffset, out, outOffset, length);
            }
        }
        return out;
    }

    public static byte[][] arrayToByteArray(Object in, byte[][] out) {
        return Array2DUtil.arrayToByteArray(in, 0, out, 0, -1);
    }

    public static byte[][] arrayToByteArray(Object in) {
        return Array2DUtil.arrayToByteArray(in, 0, null, 0, -1);
    }

    public static double[][] doubleArrayToDoubleArray(double[][] in, int inOffset, double[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.doubleArrayToDoubleArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static float[][] doubleArrayToFloatArray(double[][] in, int inOffset, float[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.doubleArrayToFloatArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static long[][] doubleArrayToLongArray(double[][] in, int inOffset, long[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.doubleArrayToLongArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static int[][] doubleArrayToIntArray(double[][] in, int inOffset, int[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.doubleArrayToIntArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static short[][] doubleArrayToShortArray(double[][] in, int inOffset, short[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.doubleArrayToShortArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static byte[][] doubleArrayToByteArray(double[][] in, int inOffset, byte[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.doubleArrayToByteArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static double[][] floatArrayToDoubleArray(float[][] in, int inOffset, double[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.floatArrayToDoubleArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static float[][] floatArrayToFloatArray(float[][] in, int inOffset, float[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.floatArrayToFloatArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static long[][] floatArrayToLongArray(float[][] in, int inOffset, long[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.floatArrayToLongArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static int[][] floatArrayToIntArray(float[][] in, int inOffset, int[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.floatArrayToIntArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static short[][] floatArrayToShortArray(float[][] in, int inOffset, short[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.floatArrayToShortArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static byte[][] floatArrayToByteArray(float[][] in, int inOffset, byte[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.floatArrayToByteArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static double[][] longArrayToDoubleArray(long[][] in, int inOffset, double[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.longArrayToDoubleArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static float[][] longArrayToFloatArray(long[][] in, int inOffset, float[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.longArrayToFloatArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static long[][] longArrayToLongArray(long[][] in, int inOffset, long[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.longArrayToLongArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static int[][] longArrayToIntArray(long[][] in, int inOffset, int[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.longArrayToIntArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static short[][] longArrayToShortArray(long[][] in, int inOffset, short[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.longArrayToShortArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static byte[][] longArrayToByteArray(long[][] in, int inOffset, byte[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.longArrayToByteArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static double[][] intArrayToDoubleArray(int[][] in, int inOffset, double[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.intArrayToDoubleArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static float[][] intArrayToFloatArray(int[][] in, int inOffset, float[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.intArrayToFloatArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static long[][] intArrayToLongArray(int[][] in, int inOffset, long[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.intArrayToLongArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static int[][] intArrayToIntArray(int[][] in, int inOffset, int[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.intArrayToIntArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static short[][] intArrayToShortArray(int[][] in, int inOffset, short[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.intArrayToShortArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static byte[][] intArrayToByteArray(int[][] in, int inOffset, byte[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.intArrayToByteArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static double[][] shortArrayToDoubleArray(short[][] in, int inOffset, double[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.shortArrayToDoubleArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static float[][] shortArrayToFloatArray(short[][] in, int inOffset, float[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.shortArrayToFloatArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static long[][] shortArrayToLongArray(short[][] in, int inOffset, long[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.shortArrayToLongArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static int[][] shortArrayToIntArray(short[][] in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.shortArrayToIntArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static short[][] shortArrayToShortArray(short[][] in, int inOffset, short[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.shortArrayToShortArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static byte[][] shortArrayToByteArray(short[][] in, int inOffset, byte[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.shortArrayToByteArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static double[][] byteArrayToDoubleArray(byte[][] in, int inOffset, double[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        double[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.byteArrayToDoubleArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static float[][] byteArrayToFloatArray(byte[][] in, int inOffset, float[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        float[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.byteArrayToFloatArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static long[][] byteArrayToLongArray(byte[][] in, int inOffset, long[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.byteArrayToLongArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static int[][] byteArrayToIntArray(byte[][] in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.byteArrayToIntArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static short[][] byteArrayToShortArray(byte[][] in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.byteArrayToShortArray(in[i + inOffset], 0, result[i + outOffset], 0, -1, signed);
            ++i;
        }
        return result;
    }

    public static byte[][] byteArrayToByteArray(byte[][] in, int inOffset, byte[][] out, int outOffset, int length) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] result = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            result[i + outOffset] = Array1DUtil.byteArrayToByteArray(in[i + inOffset], 0, result[i + outOffset], 0, -1);
            ++i;
        }
        return result;
    }

    public static float[][] doubleArrayToFloatArray(double[][] array) {
        return Array2DUtil.doubleArrayToFloatArray(array, 0, null, 0, array.length);
    }

    public static int[][] doubleArrayToIntArray(double[][] array) {
        return Array2DUtil.doubleArrayToIntArray(array, 0, null, 0, array.length);
    }

    public static short[][] doubleArrayToShortArray(double[][] array) {
        return Array2DUtil.doubleArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[][] doubleArrayToByteArray(double[][] array) {
        return Array2DUtil.doubleArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[][] floatArrayToDoubleArray(float[][] array) {
        return Array2DUtil.floatArrayToDoubleArray(array, 0, null, 0, array.length);
    }

    public static int[][] floatArrayToIntArray(float[][] array) {
        return Array2DUtil.floatArrayToIntArray(array, 0, null, 0, array.length);
    }

    public static short[][] floatArrayToShortArray(float[][] array) {
        return Array2DUtil.floatArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[][] floatArrayToByteArray(float[][] array) {
        return Array2DUtil.floatArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[][] intArrayToDoubleArray(int[][] array, boolean signed) {
        return Array2DUtil.intArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[][] intArrayToFloatArray(int[][] array, boolean signed) {
        return Array2DUtil.intArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static short[][] intArrayToShortArray(int[][] array) {
        return Array2DUtil.intArrayToShortArray(array, 0, null, 0, array.length);
    }

    public static byte[][] intArrayToByteArray(int[][] array) {
        return Array2DUtil.intArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[][] shortArrayToDoubleArray(short[][] array, boolean signed) {
        return Array2DUtil.shortArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[][] shortArrayToFloatArray(short[][] array, boolean signed) {
        return Array2DUtil.shortArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static int[][] shortArrayToIntArray(short[][] array, boolean signed) {
        return Array2DUtil.shortArrayToIntArray(array, 0, null, 0, array.length, signed);
    }

    public static byte[][] shortArrayToByteArray(short[][] array) {
        return Array2DUtil.shortArrayToByteArray(array, 0, null, 0, array.length);
    }

    public static double[][] byteArrayToDoubleArray(byte[][] array, boolean signed) {
        return Array2DUtil.byteArrayToDoubleArray(array, 0, null, 0, array.length, signed);
    }

    public static float[][] byteArrayToFloatArray(byte[][] array, boolean signed) {
        return Array2DUtil.byteArrayToFloatArray(array, 0, null, 0, array.length, signed);
    }

    public static int[][] byteArrayToIntArray(byte[][] array, boolean signed) {
        return Array2DUtil.byteArrayToIntArray(array, 0, null, 0, array.length, signed);
    }

    public static short[][] byteArrayToShortArray(byte[][] array, boolean signed) {
        return Array2DUtil.byteArrayToShortArray(array, 0, null, 0, array.length, signed);
    }

    public static Object doubleArrayToSafeArray(double[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.doubleArrayToSafeByteArray(in, inOffset, (byte[][])out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.doubleArrayToSafeShortArray(in, inOffset, (short[][])out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.doubleArrayToSafeIntArray(in, inOffset, (int[][])out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.doubleArrayToSafeLongArray(in, inOffset, (long[][])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.doubleArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object doubleArrayToSafeArray(double[][] in, Object out, boolean signed) {
        return Array2DUtil.doubleArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object floatArrayToSafeArray(float[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.floatArrayToSafeByteArray(in, inOffset, (byte[][])out, outOffset, length, signed);
            }
            case SHORT: {
                return Array2DUtil.floatArrayToSafeShortArray(in, inOffset, (short[][])out, outOffset, length, signed);
            }
            case INT: {
                return Array2DUtil.floatArrayToSafeIntArray(in, inOffset, (int[][])out, outOffset, length, signed);
            }
            case LONG: {
                return Array2DUtil.floatArrayToSafeLongArray(in, inOffset, (long[][])out, outOffset, length, signed);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length);
            }
            case DOUBLE: {
                return Array2DUtil.floatArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length);
            }
        }
        return out;
    }

    public static Object floatArrayToSafeArray(float[][] in, Object out, boolean signed) {
        return Array2DUtil.floatArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object longArrayToSafeArray(long[][] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.longArrayToSafeByteArray(in, inOffset, (byte[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array2DUtil.longArrayToSafeShortArray(in, inOffset, (short[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array2DUtil.longArrayToSafeIntArray(in, inOffset, (int[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array2DUtil.longArrayToSafeLongArray(in, inOffset, (long[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array2DUtil.longArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array2DUtil.longArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object longArrayToSafeArray(long[][] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.longArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object longArrayToSafeArray(long[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.longArrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static Object longArrayToSafeArray(long[][] in, Object out, boolean signed) {
        return Array2DUtil.longArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object intArrayToSafeArray(int[][] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.intArrayToSafeByteArray(in, inOffset, (byte[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array2DUtil.intArrayToSafeShortArray(in, inOffset, (short[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array2DUtil.intArrayToSafeIntArray(in, inOffset, (int[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array2DUtil.intArrayToLongArray(in, inOffset, (long[][])out, outOffset, length, srcSigned);
            }
            case FLOAT: {
                return Array2DUtil.intArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array2DUtil.intArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object intArrayToSafeArray(int[][] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.intArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object intArrayToSafeArray(int[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.intArrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static Object intArrayToSafeArray(int[][] in, Object out, boolean signed) {
        return Array2DUtil.intArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object shortArrayToSafeArray(short[][] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.shortArrayToSafeByteArray(in, inOffset, (byte[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToSafeShortArray(in, inOffset, (short[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array2DUtil.shortArrayToIntArray(in, inOffset, (int[][])out, outOffset, length, srcSigned);
            }
            case LONG: {
                return Array2DUtil.shortArrayToLongArray(in, inOffset, (long[][])out, outOffset, length, srcSigned);
            }
            case FLOAT: {
                return Array2DUtil.shortArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array2DUtil.shortArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object shortArrayToSafeArray(short[][] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.shortArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object shortArrayToSafeArray(short[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.shortArrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static Object shortArrayToSafeArray(short[][] in, Object out, boolean signed) {
        return Array2DUtil.shortArrayToSafeArray(in, 0, out, 0, -1, signed);
    }

    public static Object byteArrayToSafeArray(byte[][] in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(out)) {
            case BYTE: {
                return Array2DUtil.byteArrayToSafeByteArray(in, inOffset, (byte[][])out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array2DUtil.byteArrayToShortArray(in, inOffset, (short[][])out, outOffset, length, srcSigned);
            }
            case INT: {
                return Array2DUtil.byteArrayToIntArray(in, inOffset, (int[][])out, outOffset, length, srcSigned);
            }
            case LONG: {
                return Array2DUtil.byteArrayToLongArray(in, inOffset, (long[][])out, outOffset, length, srcSigned);
            }
            case FLOAT: {
                return Array2DUtil.byteArrayToFloatArray(in, inOffset, (float[][])out, outOffset, length, srcSigned);
            }
            case DOUBLE: {
                return Array2DUtil.byteArrayToDoubleArray(in, inOffset, (double[][])out, outOffset, length, srcSigned);
            }
        }
        return out;
    }

    public static Object byteArrayToSafeArray(byte[][] in, Object out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.byteArrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    public static long[][] arrayToSafeLongArray(Object in, int inOffset, long[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToLongArray((byte[][])in, inOffset, out, outOffset, length, srcSigned);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToLongArray((short[][])in, inOffset, out, outOffset, length, srcSigned);
            }
            case INT: {
                return Array2DUtil.intArrayToLongArray((int[][])in, inOffset, out, outOffset, length, srcSigned);
            }
            case LONG: {
                return Array2DUtil.longArrayToSafeLongArray((long[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToSafeLongArray((float[][])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToSafeLongArray((double[][])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static long[][] arrayToSafeLongArray(Object in, long[][] out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.arrayToSafeLongArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static long[][] arrayToSafeLongArray(Object in, int inOffset, long[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeLongArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static long[][] arrayToSafeLongArray(Object in, long[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeLongArray(in, 0, out, 0, -1, signed, signed);
    }

    public static int[][] arrayToSafeIntArray(Object in, int inOffset, int[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToIntArray((byte[][])in, inOffset, out, outOffset, length, srcSigned);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToIntArray((short[][])in, inOffset, out, outOffset, length, srcSigned);
            }
            case INT: {
                return Array2DUtil.intArrayToSafeIntArray((int[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array2DUtil.longArrayToSafeIntArray((long[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToSafeIntArray((float[][])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToSafeIntArray((double[][])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static int[][] arrayToSafeIntArray(Object in, int[][] out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.arrayToSafeIntArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static int[][] arrayToSafeIntArray(Object in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeIntArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static int[][] arrayToSafeIntArray(Object in, int[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeIntArray(in, 0, out, 0, -1, signed, signed);
    }

    public static short[][] arrayToSafeShortArray(Object in, int inOffset, short[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToShortArray((byte[][])in, inOffset, out, outOffset, length, srcSigned);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToSafeShortArray((short[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array2DUtil.intArrayToSafeShortArray((int[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array2DUtil.longArrayToSafeShortArray((long[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToSafeShortArray((float[][])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToSafeShortArray((double[][])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static short[][] arrayToSafeShortArray(Object in, short[][] out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.arrayToSafeShortArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static short[][] arrayToSafeShortArray(Object in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeShortArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static short[][] arrayToSafeShortArray(Object in, short[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeShortArray(in, 0, out, 0, -1, signed, signed);
    }

    public static byte[][] arrayToSafeByteArray(Object in, int inOffset, byte[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return Array2DUtil.byteArrayToSafeByteArray((byte[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case SHORT: {
                return Array2DUtil.shortArrayToSafeByteArray((short[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case INT: {
                return Array2DUtil.intArrayToSafeByteArray((int[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case LONG: {
                return Array2DUtil.longArrayToSafeByteArray((long[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
            }
            case FLOAT: {
                return Array2DUtil.floatArrayToSafeByteArray((float[][])in, inOffset, out, outOffset, length, dstSigned);
            }
            case DOUBLE: {
                return Array2DUtil.doubleArrayToSafeByteArray((double[][])in, inOffset, out, outOffset, length, dstSigned);
            }
        }
        return out;
    }

    public static byte[][] arrayToSafeByteArray(Object in, byte[][] out, boolean srcSigned, boolean dstSigned) {
        return Array2DUtil.arrayToSafeByteArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static byte[][] arrayToSafeByteArray(Object in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static byte[][] arrayToSafeByteArray(Object in, byte[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeByteArray(in, 0, out, 0, -1, signed, signed);
    }

    public static long[][] doubleArrayToSafeLongArray(double[][] in, int inOffset, long[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.doubleArrayToSafeLongArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static int[][] doubleArrayToSafeIntArray(double[][] in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.doubleArrayToSafeIntArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static short[][] doubleArrayToSafeShortArray(double[][] in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.doubleArrayToSafeShortArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static byte[][] doubleArrayToSafeByteArray(double[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.doubleArrayToSafeByteArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static long[][] floatArrayToSafeLongArray(float[][] in, int inOffset, long[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.floatArrayToSafeLongArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static int[][] floatArrayToSafeIntArray(float[][] in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.floatArrayToSafeIntArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static short[][] floatArrayToSafeShortArray(float[][] in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.floatArrayToSafeShortArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static byte[][] floatArrayToSafeByteArray(float[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.floatArrayToSafeByteArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, signed);
            ++i;
        }
        return outArray;
    }

    public static long[][] longArrayToSafeLongArray(long[][] in, int inOffset, long[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        long[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.longArrayToSafeLongArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static int[][] longArrayToSafeIntArray(long[][] in, int inOffset, int[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.longArrayToSafeIntArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static short[][] longArrayToSafeShortArray(long[][] in, int inOffset, short[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.longArrayToSafeShortArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static byte[][] longArrayToSafeByteArray(long[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.longArrayToSafeByteArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    @Deprecated
    public static int[][] longArrayToSafeIntArray(long[][] in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.longArrayToSafeIntArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static short[][] longArrayToSafeShortArray(long[][] in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.longArrayToSafeShortArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static byte[][] longArrayToSafeByteArray(long[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.longArrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static int[][] intArrayToSafeIntArray(int[][] in, int inOffset, int[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        int[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.intArrayToSafeIntArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static short[][] intArrayToSafeShortArray(int[][] in, int inOffset, short[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.intArrayToSafeShortArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static byte[][] intArrayToSafeByteArray(int[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.intArrayToSafeByteArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    @Deprecated
    public static short[][] intArrayToSafeShortArray(int[][] in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.intArrayToSafeShortArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    @Deprecated
    public static byte[][] intArrayToSafeByteArray(int[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.intArrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static short[][] shortArrayToSafeShortArray(short[][] in, int inOffset, short[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        short[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.shortArrayToSafeShortArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static byte[][] shortArrayToSafeByteArray(short[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.shortArrayToSafeByteArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    @Deprecated
    public static byte[][] shortArrayToSafeByteArray(short[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.shortArrayToSafeByteArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static byte[][] byteArrayToSafeByteArray(byte[][] in, int inOffset, byte[][] out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
        byte[][] outArray = Array2DUtil.allocIfNull(out, outOffset + len);
        int i = 0;
        while (i < len) {
            outArray[i + outOffset] = Array1DUtil.byteArrayToSafeByteArray(in[i + inOffset], 0, outArray[i + outOffset], 0, -1, srcSigned, dstSigned);
            ++i;
        }
        return outArray;
    }

    public static int[][] doubleArrayToSafeIntArray(double[][] array, boolean signed) {
        return Array2DUtil.doubleArrayToSafeIntArray(array, 0, null, 0, array.length, signed);
    }

    public static short[][] doubleArrayToSafeShortArray(double[][] array, boolean signed) {
        return Array2DUtil.doubleArrayToSafeShortArray(array, 0, null, 0, array.length, signed);
    }

    public static byte[][] doubleArrayToSafeByteArray(double[][] array, boolean signed) {
        return Array2DUtil.doubleArrayToSafeByteArray(array, 0, null, 0, array.length, signed);
    }

    public static int[][] floatArrayToSafeIntArray(float[][] array, boolean signed) {
        return Array2DUtil.floatArrayToSafeIntArray(array, 0, null, 0, array.length, signed);
    }

    public static short[][] floatArrayToSafeShortArray(float[][] array, boolean signed) {
        return Array2DUtil.floatArrayToSafeShortArray(array, 0, null, 0, array.length, signed);
    }

    public static byte[][] floatArrayToSafeByteArray(float[][] array, boolean signed) {
        return Array2DUtil.floatArrayToSafeByteArray(array, 0, null, 0, array.length, signed);
    }

    public static short[][] intArrayToSafeShortArray(int[][] array, boolean signed) {
        return Array2DUtil.intArrayToSafeShortArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static byte[][] intArrayToSafeByteArray(int[][] array, boolean signed) {
        return Array2DUtil.intArrayToSafeByteArray(array, 0, null, 0, array.length, signed, signed);
    }

    public static byte[][] shortArrayToSafeByteArray(short[][] array, boolean signed) {
        return Array2DUtil.shortArrayToSafeByteArray(array, 0, null, 0, array.length, signed, signed);
    }
}

