/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.array;

import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;

public class ByteArrayConvert {
    static int getCopyLengthInBytes(Object in, int inOffset, Object out, int outOffset, int length) {
        if (length == -1) {
            return ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset);
        }
        return length;
    }

    public static int getCopyLengthInBytes(Object in, int inOffset, Object out, int outOffset) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset);
        if (out == null) {
            return len;
        }
        return Math.min(len, ByteArrayConvert.getCopyLengthInBytes(out, outOffset));
    }

    public static int getCopyLengthInBytes(Object array, int offset) {
        return ArrayUtil.getCopyLength(array, offset) * ArrayUtil.getDataType(array).getSize();
    }

    public static byte readByte(byte[] array, int offset) {
        return array[offset];
    }

    public static short readShort(byte[] array, int offset, boolean littleEndian) {
        if (littleEndian) {
            return (short)(((array[offset + 0] & 0xFF) << 0) + ((array[offset + 1] & 0xFF) << 8));
        }
        return (short)(((array[offset + 0] & 0xFF) << 8) + ((array[offset + 1] & 0xFF) << 0));
    }

    public static int readInt(byte[] array, int offset, boolean littleEndian) {
        if (littleEndian) {
            return ((array[offset + 0] & 0xFF) << 0) + ((array[offset + 1] & 0xFF) << 8) + ((array[offset + 2] & 0xFF) << 16) + ((array[offset + 3] & 0xFF) << 24);
        }
        return ((array[offset + 0] & 0xFF) << 24) + ((array[offset + 1] & 0xFF) << 16) + ((array[offset + 2] & 0xFF) << 8) + ((array[offset + 3] & 0xFF) << 0);
    }

    public static long readLong(byte[] array, int offset, boolean littleEndian) {
        if (littleEndian) {
            int v1 = ((array[offset + 0] & 0xFF) << 0) + ((array[offset + 1] & 0xFF) << 8) + ((array[offset + 2] & 0xFF) << 16) + ((array[offset + 3] & 0xFF) << 24);
            int v2 = ((array[offset + 4] & 0xFF) << 0) + ((array[offset + 5] & 0xFF) << 8) + ((array[offset + 6] & 0xFF) << 16) + ((array[offset + 7] & 0xFF) << 24);
            return (((long)v1 & 0xFFFFFFFFL) << 0) + (((long)v2 & 0xFFFFFFFFL) << 32);
        }
        int v1 = ((array[offset + 0] & 0xFF) << 24) + ((array[offset + 1] & 0xFF) << 16) + ((array[offset + 2] & 0xFF) << 8) + ((array[offset + 3] & 0xFF) << 0);
        int v2 = ((array[offset + 4] & 0xFF) << 24) + ((array[offset + 5] & 0xFF) << 16) + ((array[offset + 6] & 0xFF) << 8) + ((array[offset + 7] & 0xFF) << 0);
        return (((long)v1 & 0xFFFFFFFFL) << 32) + (((long)v2 & 0xFFFFFFFFL) << 0);
    }

    public static float readFloat(byte[] array, int offset, boolean littleEndian) {
        return Float.intBitsToFloat(ByteArrayConvert.readInt(array, offset, littleEndian));
    }

    public static double readDouble(byte[] array, int offset, boolean littleEndian) {
        return Double.longBitsToDouble(ByteArrayConvert.readLong(array, offset, littleEndian));
    }

    public static void writeByte(byte[] array, int offset, byte value) {
        array[offset] = value;
    }

    public static void writeShort(byte[] array, int offset, short value, boolean littleEndian) {
        if (littleEndian) {
            array[offset + 0] = (byte)(value >> 0);
            array[offset + 1] = (byte)(value >> 8);
        } else {
            array[offset + 0] = (byte)(value >> 8);
            array[offset + 1] = (byte)(value >> 0);
        }
    }

    public static void writeInt(byte[] array, int offset, int value, boolean littleEndian) {
        if (littleEndian) {
            array[offset + 0] = (byte)(value >> 0);
            array[offset + 1] = (byte)(value >> 8);
            array[offset + 2] = (byte)(value >> 16);
            array[offset + 3] = (byte)(value >> 24);
        } else {
            array[offset + 0] = (byte)(value >> 24);
            array[offset + 1] = (byte)(value >> 16);
            array[offset + 2] = (byte)(value >> 8);
            array[offset + 3] = (byte)(value >> 0);
        }
    }

    public static void writeLong(byte[] array, int offset, long value, boolean littleEndian) {
        if (littleEndian) {
            int v = (int)(value >> 0);
            array[offset + 0] = (byte)(v >> 0);
            array[offset + 1] = (byte)(v >> 8);
            array[offset + 2] = (byte)(v >> 16);
            array[offset + 3] = (byte)(v >> 24);
            v = (int)(value >> 32);
            array[offset + 4] = (byte)(v >> 0);
            array[offset + 5] = (byte)(v >> 8);
            array[offset + 6] = (byte)(v >> 16);
            array[offset + 7] = (byte)(v >> 24);
        } else {
            int v = (int)(value >> 32);
            array[offset + 0] = (byte)(v >> 24);
            array[offset + 1] = (byte)(v >> 16);
            array[offset + 2] = (byte)(v >> 8);
            array[offset + 3] = (byte)(v >> 0);
            v = (int)(value >> 0);
            array[offset + 4] = (byte)(v >> 24);
            array[offset + 5] = (byte)(v >> 16);
            array[offset + 6] = (byte)(v >> 8);
            array[offset + 7] = (byte)(v >> 0);
        }
    }

    public static void writeFloat(byte[] array, int offset, float value, boolean littleEndian) {
        ByteArrayConvert.writeInt(array, offset, Float.floatToRawIntBits(value), littleEndian);
    }

    public static void writeDouble(byte[] array, int offset, double value, boolean littleEndian) {
        ByteArrayConvert.writeLong(array, offset, Double.doubleToRawLongBits(value), littleEndian);
    }

    public static byte[] byteArrayToByteArray(byte[] in, int inOffset, byte[] out, int outOffset, int length) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        System.arraycopy(in, inOffset, result, outOffset, len);
        return result;
    }

    public static byte[] byteArrayToByteArray(byte[] in, byte[] out) {
        return ByteArrayConvert.byteArrayToByteArray(in, 0, out, 0, -1);
    }

    public static byte[] byteArrayToByteArray(byte[] in) {
        return ByteArrayConvert.byteArrayToByteArray(in, 0, null, 0, -1);
    }

    public static short[] byteArrayToShortArray(byte[] in, int inOffset, short[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length) / 2;
        short[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len) {
            result[outOff++] = ByteArrayConvert.readShort(in, inOff, little);
            inOff += 2;
            ++i;
        }
        return result;
    }

    public static short[] byteArrayToShortArray(byte[] in, short[] out, boolean little) {
        return ByteArrayConvert.byteArrayToShortArray(in, 0, out, 0, -1, little);
    }

    public static short[] byteArrayToShortArray(byte[] in, boolean little) {
        return ByteArrayConvert.byteArrayToShortArray(in, 0, null, 0, -1, little);
    }

    public static int[] byteArrayToIntArray(byte[] in, int inOffset, int[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length) / 4;
        int[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len) {
            result[outOff++] = ByteArrayConvert.readInt(in, inOff, little);
            inOff += 4;
            ++i;
        }
        return result;
    }

    public static int[] byteArrayToIntArray(byte[] in, int[] out, boolean little) {
        return ByteArrayConvert.byteArrayToIntArray(in, 0, out, 0, -1, little);
    }

    public static int[] byteArrayToIntArray(byte[] in, boolean little) {
        return ByteArrayConvert.byteArrayToIntArray(in, 0, null, 0, -1, little);
    }

    public static long[] byteArrayToLongArray(byte[] in, int inOffset, long[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length) / 8;
        long[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len) {
            result[outOff++] = ByteArrayConvert.readLong(in, inOff, little);
            inOff += 8;
            ++i;
        }
        return result;
    }

    public static long[] byteArrayToLongArray(byte[] in, long[] out, boolean little) {
        return ByteArrayConvert.byteArrayToLongArray(in, 0, out, 0, -1, little);
    }

    public static long[] byteArrayToLongArray(byte[] in, boolean little) {
        return ByteArrayConvert.byteArrayToLongArray(in, 0, null, 0, -1, little);
    }

    public static float[] byteArrayToFloatArray(byte[] in, int inOffset, float[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length) / 4;
        float[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len) {
            result[outOff++] = ByteArrayConvert.readFloat(in, inOff, little);
            inOff += 4;
            ++i;
        }
        return result;
    }

    public static float[] byteArrayToFloatArray(byte[] in, float[] out, boolean little) {
        return ByteArrayConvert.byteArrayToFloatArray(in, 0, out, 0, -1, little);
    }

    public static float[] byteArrayToFloatArray(byte[] in, boolean little) {
        return ByteArrayConvert.byteArrayToFloatArray(in, 0, null, 0, -1, little);
    }

    public static double[] byteArrayToDoubleArray(byte[] in, int inOffset, double[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length) / 8;
        double[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len) {
            result[outOff++] = ByteArrayConvert.readDouble(in, inOff, little);
            inOff += 8;
            ++i;
        }
        return result;
    }

    public static double[] byteArrayToDoubleArray(byte[] in, double[] out, boolean little) {
        return ByteArrayConvert.byteArrayToDoubleArray(in, 0, out, 0, -1, little);
    }

    public static double[] byteArrayToDoubleArray(byte[] in, boolean little) {
        return ByteArrayConvert.byteArrayToDoubleArray(in, 0, null, 0, -1, little);
    }

    public static byte[] shortArrayToByteArray(short[] in, int inOffset, byte[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len / 2) {
            ByteArrayConvert.writeShort(result, outOff, in[inOff++], little);
            outOff += 2;
            ++i;
        }
        return result;
    }

    public static byte[] intArrayToByteArray(int[] in, int inOffset, byte[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len / 4) {
            ByteArrayConvert.writeInt(result, outOff, in[inOff++], little);
            outOff += 4;
            ++i;
        }
        return result;
    }

    public static byte[] longArrayToByteArray(long[] in, int inOffset, byte[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len / 8) {
            ByteArrayConvert.writeLong(result, outOff, in[inOff++], little);
            outOff += 8;
            ++i;
        }
        return result;
    }

    public static byte[] floatArrayToByteArray(float[] in, int inOffset, byte[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len / 4) {
            ByteArrayConvert.writeFloat(result, outOff, in[inOff++], little);
            outOff += 4;
            ++i;
        }
        return result;
    }

    public static byte[] doubleArrayToByteArray(double[] in, int inOffset, byte[] out, int outOffset, int length, boolean little) {
        int len = ByteArrayConvert.getCopyLengthInBytes(in, inOffset, out, outOffset, length);
        byte[] result = Array1DUtil.allocIfNull(out, outOffset + len);
        int inOff = inOffset;
        int outOff = outOffset;
        int i = 0;
        while (i < len / 8) {
            ByteArrayConvert.writeDouble(result, outOff, in[inOff++], little);
            outOff += 8;
            ++i;
        }
        return result;
    }

    public static Object byteArrayTo(byte[] in, int inOffset, Object out, int outOffset, int length, boolean little) {
        if (out == null) {
            return null;
        }
        switch (ArrayUtil.getDataType(out).getJavaType()) {
            case BYTE: {
                return ByteArrayConvert.byteArrayToByteArray(in, inOffset, (byte[])out, outOffset, length);
            }
            case SHORT: {
                return ByteArrayConvert.byteArrayToShortArray(in, inOffset, (short[])out, outOffset, length, little);
            }
            case INT: {
                return ByteArrayConvert.byteArrayToIntArray(in, inOffset, (int[])out, outOffset, length, little);
            }
            case LONG: {
                return ByteArrayConvert.byteArrayToLongArray(in, inOffset, (long[])out, outOffset, length, little);
            }
            case FLOAT: {
                return ByteArrayConvert.byteArrayToFloatArray(in, inOffset, (float[])out, outOffset, length, little);
            }
            case DOUBLE: {
                return ByteArrayConvert.byteArrayToDoubleArray(in, inOffset, (double[])out, outOffset, length, little);
            }
        }
        return null;
    }

    public static Object byteArrayTo(byte[] in, Object out, boolean little) {
        return ByteArrayConvert.byteArrayTo(in, 0, out, 0, -1, little);
    }

    public static Object byteArrayTo(byte[] in, int inOffset, DataType outDataType, int outOffset, int length, boolean little) {
        switch (outDataType.getJavaType()) {
            case BYTE: {
                return ByteArrayConvert.byteArrayToByteArray(in, inOffset, null, outOffset, length);
            }
            case SHORT: {
                return ByteArrayConvert.byteArrayToShortArray(in, inOffset, null, outOffset, length, little);
            }
            case INT: {
                return ByteArrayConvert.byteArrayToIntArray(in, inOffset, null, outOffset, length, little);
            }
            case LONG: {
                return ByteArrayConvert.byteArrayToLongArray(in, inOffset, null, outOffset, length, little);
            }
            case FLOAT: {
                return ByteArrayConvert.byteArrayToFloatArray(in, inOffset, null, outOffset, length, little);
            }
            case DOUBLE: {
                return ByteArrayConvert.byteArrayToDoubleArray(in, inOffset, null, outOffset, length, little);
            }
        }
        return null;
    }

    public static Object byteArrayTo(byte[] in, int inOffset, DataType outDataType, int length, boolean little) {
        return ByteArrayConvert.byteArrayTo(in, inOffset, outDataType, 0, length, little);
    }

    public static Object byteArrayTo(byte[] in, DataType outDataType, boolean little) {
        return ByteArrayConvert.byteArrayTo(in, 0, outDataType, 0, -1, little);
    }

    @Deprecated
    public static Object byteArrayTo(byte[] in, int inOffset, int outDataType, int length, boolean little) {
        return ByteArrayConvert.byteArrayTo(in, inOffset, DataType.getDataType(outDataType), 0, length, little);
    }

    @Deprecated
    public static Object byteArrayTo(byte[] in, int outDataType, boolean little) {
        return ByteArrayConvert.byteArrayTo(in, 0, DataType.getDataType(outDataType), 0, -1, little);
    }

    public static byte[] toByteArray(Object in, int inOffset, byte[] out, int outOffset, int length, boolean little) {
        switch (ArrayUtil.getDataType(in)) {
            case BYTE: {
                return ByteArrayConvert.byteArrayToByteArray((byte[])in, inOffset, out, outOffset, length);
            }
            case SHORT: {
                return ByteArrayConvert.shortArrayToByteArray((short[])in, inOffset, out, outOffset, length, little);
            }
            case INT: {
                return ByteArrayConvert.intArrayToByteArray((int[])in, inOffset, out, outOffset, length, little);
            }
            case LONG: {
                return ByteArrayConvert.longArrayToByteArray((long[])in, inOffset, out, outOffset, length, little);
            }
            case FLOAT: {
                return ByteArrayConvert.floatArrayToByteArray((float[])in, inOffset, out, outOffset, length, little);
            }
            case DOUBLE: {
                return ByteArrayConvert.doubleArrayToByteArray((double[])in, inOffset, out, outOffset, length, little);
            }
        }
        return out;
    }

    public static byte[] toByteArray(Object in, int inOffset, byte[] out, int outOffset, boolean little) {
        return ByteArrayConvert.toByteArray(in, inOffset, out, outOffset, -1, little);
    }

    public static byte[] toByteArray(Object in, int inOffset, int length, boolean little) {
        return ByteArrayConvert.toByteArray(in, inOffset, null, 0, length, little);
    }

    public static byte[] toByteArray(Object in, byte[] out, boolean little) {
        return ByteArrayConvert.toByteArray(in, 0, out, 0, -1, little);
    }

    public static byte[] toByteArray(Object in, boolean little) {
        return ByteArrayConvert.toByteArray(in, 0, null, 0, -1, little);
    }
}

