/*
 * Decompiled with CFR 0.152.
 */
package icy.type.point;

import java.awt.geom.Point2D;
import java.util.List;

public class Point2DUtil {
    public static boolean areConnected(Point2D p1, Point2D p2) {
        return Math.max(Math.abs(p2.getX() - p1.getX()), Math.abs(p2.getY() - p1.getY())) <= 1.0;
    }

    public static double getL1Distance(Point2D p1, Point2D p2) {
        return Math.abs(p2.getX() - p1.getX()) + Math.abs(p2.getY() - p1.getY());
    }

    public static double getSquareDistance(Point2D pt1, Point2D pt2) {
        double px = pt2.getX() - pt1.getX();
        double py = pt2.getY() - pt1.getY();
        return px * px + py * py;
    }

    public static double getDistance(Point2D pt1, Point2D pt2) {
        return Math.sqrt(Point2DUtil.getSquareDistance(pt1, pt2));
    }

    public static double getDistance(Point2D pt1, Point2D pt2, double factorX, double factorY) {
        double px = (pt2.getX() - pt1.getX()) * factorX;
        double py = (pt2.getY() - pt1.getY()) * factorY;
        return Math.sqrt(px * px + py * py);
    }

    public static double getTotalDistance(List<Point2D> points, double factorX, double factorY, boolean connectLastPoint) {
        int size = points.size();
        double result = 0.0;
        if (size > 1) {
            int i = 0;
            while (i < size - 1) {
                result += Point2DUtil.getDistance(points.get(i), points.get(i + 1), factorX, factorY);
                ++i;
            }
            if (connectLastPoint) {
                result += Point2DUtil.getDistance(points.get(size - 1), points.get(0), factorX, factorY);
            }
        }
        return result;
    }
}

