/*
 * Decompiled with CFR 0.152.
 */
package icy.workspace;

import icy.file.xml.XMLPersistent;
import icy.file.xml.XMLPersistentHelper;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.RibbonUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLoader;
import icy.plugin.PluginRepositoryLoader;
import icy.preferences.RepositoryPreferences;
import icy.util.StringUtil;
import icy.util.XMLUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Workspace
implements XMLPersistent,
Comparable<Workspace> {
    public static final String[] DEFAULT_ACTIVE_WORKSPACES = new String[]{"Initial Beta ToolSet", "Tutorial Basics"};
    public static final String WORKSPACE_SYSTEM_NAME = "sys";
    private static final String ID_NAME = "name";
    private static final String ID_DESCRIPTION = "description";
    private static final String ID_TASK = "task";
    private String name = "";
    private String description = "";
    private final ArrayList<TaskDefinition> tasks = new ArrayList();
    private RepositoryPreferences.RepositoryInfo repository = null;
    private boolean installing = false;

    public static boolean contains(List<TaskDefinition> tasks, TaskDefinition task) {
        for (TaskDefinition t : tasks) {
            if (!task.getName().equals(t.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<TaskDefinition.BandDefinition> bands, TaskDefinition.BandDefinition band) {
        for (TaskDefinition.BandDefinition b : bands) {
            if (!band.getName().equals(b.getName())) continue;
            return true;
        }
        return false;
    }

    public static Workspace getWorkspace(List<Workspace> list, String name) {
        for (Workspace workspace : list) {
            if (!workspace.getName().equals(name)) continue;
            return workspace;
        }
        return null;
    }

    public static boolean addWorkspace(List<Workspace> list, Workspace workspace) {
        if (!list.contains(workspace)) {
            list.add(workspace);
            return true;
        }
        return false;
    }

    public static boolean removeWorkspace(List<Workspace> list, String name) {
        return list.remove(Workspace.getWorkspace(list, name));
    }

    public Workspace() {
    }

    public Workspace(File file) throws IllegalArgumentException {
        this();
        this.load(file);
    }

    public Workspace(URL url, RepositoryPreferences.RepositoryInfo repos) throws IllegalArgumentException {
        this();
        this.load(url);
        this.repository = repos;
    }

    public Workspace(String name) throws IllegalArgumentException {
        this();
        this.name = name;
        this.load();
    }

    public String getLocalFilename() {
        return "workspace/" + this.name + ".xml";
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isInstalling() {
        return this.installing;
    }

    public RepositoryPreferences.RepositoryInfo getRepository() {
        return this.repository;
    }

    public void clear() {
        this.tasks.clear();
    }

    public TaskDefinition findTask(String taskName) {
        for (TaskDefinition task : this.tasks) {
            if (!task.name.equals(taskName)) continue;
            return task;
        }
        return null;
    }

    public TaskDefinition.BandDefinition findBand(String taskName, String bandName) {
        TaskDefinition task = this.findTask(taskName);
        if (task != null) {
            return task.findBand(bandName);
        }
        return null;
    }

    public TaskDefinition.BandDefinition.ItemDefinition findItem(String className) {
        for (TaskDefinition task : this.tasks) {
            TaskDefinition.BandDefinition.ItemDefinition item = task.findItem(className);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public ArrayList<TaskDefinition> getTasks() {
        return new ArrayList<TaskDefinition>(this.tasks);
    }

    public ArrayList<TaskDefinition.BandDefinition.ItemDefinition> getAllItems() {
        ArrayList<TaskDefinition.BandDefinition.ItemDefinition> result = new ArrayList<TaskDefinition.BandDefinition.ItemDefinition>();
        for (TaskDefinition task : this.tasks) {
            for (TaskDefinition.BandDefinition band : task.bands) {
                result.addAll(band.items);
            }
        }
        return result;
    }

    public TaskDefinition addTask(RibbonTask ribbonTask) {
        if (ribbonTask == null) {
            return null;
        }
        TaskDefinition result = this.addTask(ribbonTask.getTitle());
        result.clear();
        result.addBands(ribbonTask);
        return result;
    }

    public TaskDefinition addTask(String taskName) {
        TaskDefinition task = this.findTask(taskName);
        if (task == null) {
            task = new TaskDefinition();
            task.name = taskName;
            this.tasks.add(task);
        }
        return task;
    }

    public TaskDefinition.BandDefinition addBand(String taskName, String bandName) {
        return this.addTask(taskName).addBand(bandName);
    }

    public TaskDefinition.BandDefinition.ItemDefinition addItem(String taskName, String bandName, String className) {
        return this.addTask(taskName).addItem(bandName, className);
    }

    public boolean removeTask(String taskName) {
        return this.tasks.remove(this.findTask(taskName));
    }

    public boolean load() {
        return XMLPersistentHelper.loadFromXML((XMLPersistent)this, this.getLocalFilename());
    }

    public boolean load(File file) {
        return XMLPersistentHelper.loadFromXML((XMLPersistent)this, file);
    }

    public boolean load(URL url) {
        return XMLPersistentHelper.loadFromXML((XMLPersistent)this, url);
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.name = XMLUtil.getAttributeValue((Element)node, ID_NAME, "");
        this.description = XMLUtil.getAttributeValue((Element)node, ID_DESCRIPTION, "");
        this.tasks.clear();
        ArrayList<Node> nodesTask = XMLUtil.getChildren(node, ID_TASK);
        for (Node n : nodesTask) {
            this.tasks.add(new TaskDefinition(n));
        }
        return true;
    }

    public boolean save() {
        return XMLPersistentHelper.saveToXML((XMLPersistent)this, this.getLocalFilename());
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setAttributeValue((Element)node, ID_NAME, this.name);
        XMLUtil.setAttributeValue((Element)node, ID_DESCRIPTION, this.description);
        XMLUtil.removeAllChildren(node);
        for (TaskDefinition task : this.tasks) {
            task.saveToXML(XMLUtil.addElement(node, ID_TASK));
        }
        return true;
    }

    public int install(ProgressFrame progressFrame) {
        if (this.installing) {
            return 0;
        }
        this.installing = true;
        try {
            ArrayList<TaskDefinition.BandDefinition.ItemDefinition> items = this.getAllItems();
            ArrayList<PluginDescriptor> pluginsToInstall = new ArrayList<PluginDescriptor>();
            if (progressFrame != null) {
                progressFrame.setMessage("Waiting for plugin loader to find plugins...");
            }
            PluginRepositoryLoader.waitLoaded();
            if (progressFrame != null) {
                progressFrame.setMessage("Installing workspace '" + this.name + "' : searching for installed plugins...");
            }
            for (TaskDefinition.BandDefinition.ItemDefinition item : items) {
                String className;
                PluginDescriptor plugin;
                if (item.isSeparator() || (plugin = PluginLoader.getPlugin(className = item.getClassName())) != null) continue;
                plugin = PluginRepositoryLoader.getPlugin(className);
                if (plugin == null) {
                    System.err.println("Can't install plugin '" + className + "' : not found in repositery");
                    return 0;
                }
                PluginDescriptor.addToList(pluginsToInstall, plugin);
            }
            if (progressFrame != null) {
                progressFrame.setMessage("Installing workspace '" + this.name + "' : downloading plugins...");
            }
            for (PluginDescriptor plugin : pluginsToInstall) {
                PluginInstaller.install(plugin, progressFrame != null);
            }
            PluginInstaller.waitInstall();
            ArrayList<PluginDescriptor> installedPlugins = PluginLoader.getPlugins(false);
            int numberOfInstalledPlugin = 0;
            for (PluginDescriptor plugin : pluginsToInstall) {
                if (!PluginDescriptor.existInList(installedPlugins, plugin)) continue;
                ++numberOfInstalledPlugin;
            }
            if (numberOfInstalledPlugin == pluginsToInstall.size()) {
                return 1;
            }
            if (numberOfInstalledPlugin > 0) {
                return 2;
            }
            return 0;
        }
        finally {
            this.installing = false;
        }
    }

    @Override
    public int compareTo(Workspace o) {
        return this.name.compareTo(o.getName());
    }

    public class TaskDefinition
    implements XMLPersistent {
        private static final String ID_NAME = "name";
        private static final String ID_BAND = "band";
        String name = "";
        final ArrayList<BandDefinition> bands = new ArrayList();

        TaskDefinition() {
        }

        TaskDefinition(Node node) {
            this();
            this.loadFromXML(node);
        }

        TaskDefinition(RibbonTask ribbonTask) {
            this();
            this.loadFrom(ribbonTask);
        }

        public Workspace getWorkspace() {
            return Workspace.this;
        }

        public String getWorkspaceName() {
            return Workspace.this.getName();
        }

        public BandDefinition addBand(JRibbonBand ribbonBand) {
            if (ribbonBand == null) {
                return null;
            }
            BandDefinition result = this.addBand(ribbonBand.getTitle());
            result.clear();
            result.addItems(ribbonBand);
            return result;
        }

        public BandDefinition addBand(String bandName) {
            BandDefinition band = this.findBand(bandName);
            if (band == null) {
                band = new BandDefinition();
                band.name = bandName;
                this.bands.add(band);
            }
            return band;
        }

        public boolean addBands(RibbonTask ribbonTask) {
            if (ribbonTask == null) {
                return false;
            }
            for (AbstractRibbonBand ribbonBand : ribbonTask.getBands()) {
                if (!(ribbonBand instanceof JRibbonBand)) continue;
                this.addBand((JRibbonBand)ribbonBand);
            }
            return true;
        }

        public boolean removeBand(String bandName) {
            BandDefinition band = this.findBand(bandName);
            if (band == null) {
                return false;
            }
            return this.removeBand(band);
        }

        public boolean removeBand(BandDefinition band) {
            for (BandDefinition.ItemDefinition itd : band.getItems()) {
                band.removeItem(itd);
            }
            this.bands.remove(band);
            return true;
        }

        public BandDefinition.ItemDefinition addItem(String bandName, String className) {
            return this.addBand(bandName).addItem(className);
        }

        public void clear() {
            this.bands.clear();
        }

        public boolean loadFrom(RibbonTask ribbonTask) {
            if (ribbonTask == null) {
                return false;
            }
            this.name = ribbonTask.getTitle();
            this.bands.clear();
            return this.addBands(ribbonTask);
        }

        @Override
        public boolean loadFromXML(Node node) {
            if (node == null) {
                return false;
            }
            this.name = XMLUtil.getAttributeValue((Element)node, "name", "");
            this.bands.clear();
            ArrayList<Node> nodesBand = XMLUtil.getChildren(node, ID_BAND);
            for (Node n : nodesBand) {
                this.bands.add(new BandDefinition(n));
            }
            return true;
        }

        @Override
        public boolean saveToXML(Node node) {
            if (node == null) {
                return false;
            }
            XMLUtil.setAttributeValue((Element)node, "name", this.name);
            XMLUtil.removeAllChildren(node);
            for (BandDefinition band : this.bands) {
                band.saveToXML(XMLUtil.addElement(node, ID_BAND));
            }
            return true;
        }

        public BandDefinition findBand(String name) {
            for (BandDefinition band : this.bands) {
                if (!band.name.equals(name)) continue;
                return band;
            }
            return null;
        }

        public BandDefinition.ItemDefinition findItem(String className) {
            for (BandDefinition band : this.bands) {
                BandDefinition.ItemDefinition item = band.findItem(className);
                if (item == null) continue;
                return item;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<BandDefinition> getBands() {
            return new ArrayList<BandDefinition>(this.bands);
        }

        public class BandDefinition
        implements XMLPersistent {
            private static final String ID_ITEM = "item";
            private static final String ID_SEPARATOR = "separator";
            String name = "";
            final ArrayList<ItemDefinition> items = new ArrayList();

            BandDefinition() {
            }

            BandDefinition(Node node) {
                this();
                this.loadFromXML(node);
            }

            BandDefinition(JRibbonBand ribbonBand) {
                this();
                this.loadFrom(ribbonBand);
            }

            public ItemDefinition addItem(JRibbonBand band, AbstractCommandButton button) {
                return this.addItem(button.getName(), RibbonUtil.getButtonPriority(band, button));
            }

            public ItemDefinition addItem(String className, RibbonElementPriority prio) {
                ItemDefinition result = this.findItem(className);
                if (result == null) {
                    result = new ItemDefinition(className, prio);
                    this.items.add(result);
                } else {
                    result.priority = prio;
                }
                return result;
            }

            public ItemDefinition addItem(String className) {
                return this.addItem(className, RibbonElementPriority.LOW);
            }

            public void addSeparator() {
                this.addItem(ID_SEPARATOR);
            }

            public boolean addItems(JRibbonBand ribbonBand) {
                if (ribbonBand == null) {
                    return false;
                }
                for (JBandControlPanel.ControlPanelGroup panelGroup : ((JBandControlPanel)ribbonBand.getControlPanel()).getControlPanelGroups()) {
                    this.addSeparator();
                    for (AbstractCommandButton button : panelGroup.getRibbonButtons(RibbonElementPriority.LOW)) {
                        this.addItem(ribbonBand, button);
                    }
                    for (AbstractCommandButton button : panelGroup.getRibbonButtons(RibbonElementPriority.MEDIUM)) {
                        this.addItem(ribbonBand, button);
                    }
                    for (AbstractCommandButton button : panelGroup.getRibbonButtons(RibbonElementPriority.TOP)) {
                        this.addItem(ribbonBand, button);
                    }
                }
                return true;
            }

            public boolean addItems(Node node) {
                if (node == null) {
                    return false;
                }
                ArrayList<Node> nodesItem = XMLUtil.getChildren(node);
                for (Node n : nodesItem) {
                    ItemDefinition item = new ItemDefinition(n);
                    if (item.isEmpty()) continue;
                    this.items.add(item);
                }
                return true;
            }

            public boolean removeItem(ItemDefinition item) {
                if (item != null) {
                    return this.items.remove(item);
                }
                return false;
            }

            public boolean removeItem(String className) {
                return this.removeItem(this.findItem(className));
            }

            public void clear() {
                this.items.clear();
            }

            public TaskDefinition getTaskDefinition() {
                return TaskDefinition.this;
            }

            public String getTaskName() {
                return TaskDefinition.this.getName();
            }

            public Workspace getWorkspace() {
                return Workspace.this;
            }

            public String getWorkspaceName() {
                return Workspace.this.getName();
            }

            public boolean loadFrom(JRibbonBand ribbonBand) {
                if (ribbonBand == null) {
                    return false;
                }
                this.name = ribbonBand.getTitle();
                this.items.clear();
                return this.addItems(ribbonBand);
            }

            @Override
            public boolean loadFromXML(Node node) {
                if (node == null) {
                    return false;
                }
                this.name = XMLUtil.getAttributeValue((Element)node, "name", "");
                this.items.clear();
                return this.addItems(node);
            }

            @Override
            public boolean saveToXML(Node node) {
                if (node == null) {
                    return false;
                }
                XMLUtil.setAttributeValue((Element)node, "name", this.name);
                XMLUtil.removeAllChildren(node);
                for (ItemDefinition item : this.items) {
                    if (item.isSeparator()) {
                        item.saveToXML(XMLUtil.addElement(node, ID_SEPARATOR));
                        continue;
                    }
                    item.saveToXML(XMLUtil.addElement(node, ID_ITEM));
                }
                return true;
            }

            public ItemDefinition findItem(String className) {
                for (ItemDefinition item : this.items) {
                    if (!StringUtil.equals(item.getClassName(), className)) continue;
                    return item;
                }
                return null;
            }

            public String getName() {
                return this.name;
            }

            public ArrayList<ItemDefinition> getItems() {
                return new ArrayList<ItemDefinition>(this.items);
            }

            public class ItemDefinition
            implements XMLPersistent {
                private static final String ID_CLASSNAME = "classname";
                private static final String ID_PRIORITY = "priority";
                String className = "";
                RibbonElementPriority priority = RibbonElementPriority.MEDIUM;

                ItemDefinition() {
                }

                ItemDefinition(Node node) {
                    this();
                    this.loadFromXML(node);
                }

                ItemDefinition(JRibbonBand band, AbstractCommandButton button) {
                    this(button.getName(), RibbonUtil.getButtonPriority(band, button));
                }

                ItemDefinition(String className, RibbonElementPriority prio) {
                    this();
                    this.className = className;
                    this.priority = prio;
                }

                ItemDefinition(String className) {
                    this(className, RibbonElementPriority.LOW);
                }

                private RibbonElementPriority stringToPrio(String value) {
                    if (StringUtil.isEmpty(value)) {
                        return RibbonElementPriority.MEDIUM;
                    }
                    String prio = value.toLowerCase();
                    if (prio.equals("low")) {
                        return RibbonElementPriority.LOW;
                    }
                    if (prio.equals("top")) {
                        return RibbonElementPriority.TOP;
                    }
                    return RibbonElementPriority.MEDIUM;
                }

                private String prioToString(RibbonElementPriority value) {
                    switch (value) {
                        case LOW: {
                            return "low";
                        }
                        default: {
                            return "med";
                        }
                        case TOP: 
                    }
                    return "top";
                }

                @Override
                public boolean loadFromXML(Node node) {
                    if (node == null) {
                        return false;
                    }
                    String nodeName = node.getNodeName();
                    if (nodeName.equals(BandDefinition.ID_SEPARATOR)) {
                        this.className = BandDefinition.ID_SEPARATOR;
                    } else if (nodeName.equals(BandDefinition.ID_ITEM)) {
                        Element element = (Element)node;
                        this.className = XMLUtil.getAttributeValue(element, ID_CLASSNAME, "");
                        this.priority = this.stringToPrio(XMLUtil.getAttributeValue(element, ID_PRIORITY, ""));
                    } else {
                        return false;
                    }
                    return true;
                }

                @Override
                public boolean saveToXML(Node node) {
                    if (node == null) {
                        return false;
                    }
                    String nodeName = node.getNodeName();
                    if (nodeName.equals(BandDefinition.ID_ITEM)) {
                        Element element = (Element)node;
                        XMLUtil.setAttributeValue(element, ID_CLASSNAME, this.className);
                        XMLUtil.setAttributeValue(element, ID_PRIORITY, this.prioToString(this.priority));
                    } else if (!nodeName.equals(BandDefinition.ID_SEPARATOR)) {
                        return false;
                    }
                    return true;
                }

                public String getClassName() {
                    if (this.isSeparator()) {
                        return "";
                    }
                    return this.className;
                }

                public void setClassName(String className) {
                    this.className = className;
                }

                public boolean isSeparator() {
                    return StringUtil.equals(this.className, BandDefinition.ID_SEPARATOR);
                }

                public boolean isEmpty() {
                    return StringUtil.isEmpty(this.className);
                }

                public RibbonElementPriority getPriority() {
                    return this.priority;
                }

                public void setPriority(RibbonElementPriority value) {
                    this.priority = value;
                }

                public BandDefinition getBandDefinition() {
                    return BandDefinition.this;
                }

                public String getBandName() {
                    return BandDefinition.this.getName();
                }

                public TaskDefinition getTaskDefinition() {
                    return TaskDefinition.this;
                }

                public String getTaskName() {
                    return TaskDefinition.this.getName();
                }

                public Workspace getWorkspace() {
                    return Workspace.this;
                }

                public String getWorkspaceName() {
                    return Workspace.this.getName();
                }

                public boolean remove() {
                    return BandDefinition.this.removeItem(this);
                }
            }
        }
    }
}

