/*
 * Decompiled with CFR 0.152.
 */
package lpsolve;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import lpsolve.AbortListener;
import lpsolve.BbListener;
import lpsolve.LogListener;
import lpsolve.LpSolveException;
import lpsolve.MsgListener;
import lpsolve.VersionInfo;

public class LpSolve {
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int AUTOMATIC = 2;
    public static final int DYNAMIC = 4;
    public static final int FR = 0;
    public static final int LE = 1;
    public static final int GE = 2;
    public static final int EQ = 3;
    public static final int OF = 4;
    public static final int SIMPLEX_PRIMAL_PRIMAL = 5;
    public static final int SIMPLEX_DUAL_PRIMAL = 6;
    public static final int SIMPLEX_PRIMAL_DUAL = 9;
    public static final int SIMPLEX_DUAL_DUAL = 10;
    public static final int SIMPLEX_DEFAULT = 6;
    public static final int PRESOLVE_NONE = 0;
    public static final int PRESOLVE_ROWS = 1;
    public static final int PRESOLVE_COLS = 2;
    public static final int PRESOLVE_LINDEP = 4;
    public static final int PRESOLVE_SOS = 32;
    public static final int PRESOLVE_REDUCEMIP = 64;
    public static final int PRESOLVE_KNAPSACK = 128;
    public static final int PRESOLVE_ELIMEQ2 = 256;
    public static final int PRESOLVE_IMPLIEDFREE = 512;
    public static final int PRESOLVE_REDUCEGCD = 1024;
    public static final int PRESOLVE_PROBEFIX = 2048;
    public static final int PRESOLVE_PROBEREDUCE = 4096;
    public static final int PRESOLVE_ROWDOMINATE = 8192;
    public static final int PRESOLVE_COLDOMINATE = 16384;
    public static final int PRESOLVE_MERGEROWS = 32768;
    public static final int PRESOLVE_IMPLIEDSLK = 65536;
    public static final int PRESOLVE_COLFIXDUAL = 131072;
    public static final int PRESOLVE_BOUNDS = 262144;
    public static final int PRESOLVE_DUALS = 524288;
    public static final int PRESOLVE_SENSDUALS = 0x100000;
    public static final int CRASH_NOTHING = 0;
    public static final int CRASH_MOSTFEASIBLE = 2;
    public static final int ANTIDEGEN_NONE = 0;
    public static final int ANTIDEGEN_FIXEDVARS = 1;
    public static final int ANTIDEGEN_COLUMNCHECK = 2;
    public static final int ANTIDEGEN_STALLING = 4;
    public static final int ANTIDEGEN_NUMFAILURE = 8;
    public static final int ANTIDEGEN_LOSTFEAS = 16;
    public static final int ANTIDEGEN_INFEASIBLE = 32;
    public static final int ANTIDEGEN_DYNAMIC = 64;
    public static final int ANTIDEGEN_DURINGBB = 128;
    public static final int ANTIDEGEN_RHSPERTURB = 256;
    public static final int ANTIDEGEN_BOUNDFLIP = 512;
    public static final int NEUTRAL = 0;
    public static final int CRITICAL = 1;
    public static final int SEVERE = 2;
    public static final int IMPORTANT = 3;
    public static final int NORMAL = 4;
    public static final int DETAILED = 5;
    public static final int FULL = 6;
    public static final int MSG_NONE = 0;
    public static final int MSG_PRESOLVE = 1;
    public static final int MSG_ITERATION = 2;
    public static final int MSG_INVERT = 4;
    public static final int MSG_LPFEASIBLE = 8;
    public static final int MSG_LPOPTIMAL = 16;
    public static final int MSG_LPEQUAL = 32;
    public static final int MSG_LPBETTER = 64;
    public static final int MSG_MILPFEASIBLE = 128;
    public static final int MSG_MILPEQUAL = 256;
    public static final int MSG_MILPBETTER = 512;
    public static final int MSG_MILPSTRATEGY = 1024;
    public static final int MSG_MILPOPTIMAL = 2048;
    public static final int MSG_PERFORMANCE = 4096;
    public static final int MSG_INITPSEUDOCOST = 8192;
    public static final int IMPROVE_NONE = 0;
    public static final int IMPROVE_SOLUTION = 1;
    public static final int IMPROVE_DUALFEAS = 2;
    public static final int IMPROVE_THETAGAP = 4;
    public static final int IMPROVE_BBSIMPLEX = 8;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_EXTREME = 1;
    public static final int SCALE_RANGE = 2;
    public static final int SCALE_MEAN = 3;
    public static final int SCALE_GEOMETRIC = 4;
    public static final int SCALE_CURTISREID = 7;
    public static final int SCALE_LINEAR = 0;
    public static final int SCALE_QUADRATIC = 8;
    public static final int SCALE_LOGARITHMIC = 16;
    public static final int SCALE_USERWEIGHT = 31;
    public static final int SCALE_POWER2 = 32;
    public static final int SCALE_EQUILIBRATE = 64;
    public static final int SCALE_INTEGERS = 128;
    public static final int SCALE_DYNUPDATE = 256;
    public static final int SCALE_ROWSONLY = 512;
    public static final int SCALE_COLSONLY = 1024;
    public static final int PRICER_FIRSTINDEX = 0;
    public static final int PRICER_DANTZIG = 1;
    public static final int PRICER_DEVEX = 2;
    public static final int PRICER_STEEPESTEDGE = 3;
    public static final int PRICE_METHODDEFAULT = 0;
    public static final int PRICE_PRIMALFALLBACK = 4;
    public static final int PRICE_MULTIPLE = 8;
    public static final int PRICE_PARTIAL = 16;
    public static final int PRICE_ADAPTIVE = 32;
    public static final int PRICE_HYBRID = 64;
    public static final int PRICE_RANDOMIZE = 128;
    public static final int PRICE_AUTOPARTIAL = 512;
    public static final int PRICE_LOOPLEFT = 1024;
    public static final int PRICE_LOOPALTERNATE = 2048;
    public static final int PRICE_HARRISTWOPASS = 4096;
    public static final int PRICE_TRUENORMINIT = 16384;
    public static final int NODE_FIRSTSELECT = 0;
    public static final int NODE_GAPSELECT = 1;
    public static final int NODE_RANGESELECT = 2;
    public static final int NODE_FRACTIONSELECT = 3;
    public static final int NODE_PSEUDOCOSTSELECT = 4;
    public static final int NODE_PSEUDONONINTSELECT = 5;
    public static final int NODE_PSEUDORATIOSELECT = 6;
    public static final int NODE_USERSELECT = 7;
    public static final int NODE_WEIGHTREVERSEMODE = 8;
    public static final int NODE_BRANCHREVERSEMODE = 16;
    public static final int NODE_GREEDYMODE = 32;
    public static final int NODE_PSEUDOCOSTMODE = 64;
    public static final int NODE_DEPTHFIRSTMODE = 128;
    public static final int NODE_RANDOMIZEMODE = 256;
    public static final int NODE_DYNAMICMODE = 1024;
    public static final int NODE_RESTARTMODE = 2048;
    public static final int NODE_BREADTHFIRSTMODE = 4096;
    public static final int NODE_AUTOORDER = 8192;
    public static final int NODE_RCOSTFIXING = 16384;
    public static final int NODE_STRONGINIT = 32768;
    public static final int BRANCH_CEILING = 0;
    public static final int BRANCH_FLOOR = 1;
    public static final int BRANCH_AUTOMATIC = 2;
    public static final int BRANCH_DEFAULT = 3;
    public static final int UNKNOWNERROR = -5;
    public static final int DATAIGNORED = -4;
    public static final int NOBFP = -3;
    public static final int NOMEMORY = -2;
    public static final int NOTRUN = -1;
    public static final int OPTIMAL = 0;
    public static final int SUBOPTIMAL = 1;
    public static final int INFEASIBLE = 2;
    public static final int UNBOUNDED = 3;
    public static final int DEGENERATE = 4;
    public static final int NUMFAILURE = 5;
    public static final int USERABORT = 6;
    public static final int TIMEOUT = 7;
    public static final int RUNNING = 8;
    public static final int PRESOLVED = 9;
    public static final int PROCFAIL = 10;
    public static final int PROCBREAK = 11;
    public static final int FEASFOUND = 12;
    public static final int NOFEASFOUND = 13;
    private long lp = 0L;
    private AbortListener abortListener = null;
    private Object abortUserhandle = null;
    private LogListener logListener = null;
    private Object logUserhandle = null;
    private MsgListener msgListener = null;
    private Object msgUserhandle = null;
    private BbListener bbBranchListener = null;
    private Object bbBranchUserhandle = null;
    private BbListener bbNodeListener = null;
    private Object bbNodeUserhandle = null;
    private static Map lpMap = new HashMap();

    public static void initLib(File lib) {
        System.load(lib.getAbsolutePath());
        LpSolve.init();
    }

    private static native void init();

    private LpSolve(long lp) {
        this.lp = lp;
    }

    public static native LpSolve makeLp(int var0, int var1) throws LpSolveException;

    public static native LpSolve readLp(String var0, int var1, String var2) throws LpSolveException;

    public static native LpSolve readMps(String var0, int var1) throws LpSolveException;

    public static native LpSolve readFreeMps(String var0, int var1) throws LpSolveException;

    public static native LpSolve readXLI(String var0, String var1, String var2, String var3, int var4) throws LpSolveException;

    public static native VersionInfo lpSolveVersion();

    protected void finalize() throws Throwable {
        if (this.lp != 0L) {
            LpSolve.removeLp(this.lp);
            this.deleteLp();
        }
        super.finalize();
    }

    public long getLp() {
        return this.lp;
    }

    public native LpSolve copyLp() throws LpSolveException;

    public native void setLpName(String var1) throws LpSolveException;

    public native void resizeLp(int var1, int var2) throws LpSolveException;

    public native String getLpName() throws LpSolveException;

    public native void addConstraint(double[] var1, int var2, double var3) throws LpSolveException;

    public native void strAddConstraint(String var1, int var2, double var3) throws LpSolveException;

    public native void addConstraintex(int var1, double[] var2, int[] var3, int var4, double var5) throws LpSolveException;

    public native void delConstraint(int var1) throws LpSolveException;

    public native boolean isConstrType(int var1, int var2);

    public native void addLagCon(double[] var1, int var2, double var3) throws LpSolveException;

    public native void strAddLagCon(String var1, int var2, double var3) throws LpSolveException;

    public native void addColumn(double[] var1) throws LpSolveException;

    public native void addColumnex(int var1, double[] var2, int[] var3) throws LpSolveException;

    public native void strAddColumn(String var1) throws LpSolveException;

    public native void delColumn(int var1) throws LpSolveException;

    public native void setRow(int var1, double[] var2) throws LpSolveException;

    public native void setRowex(int var1, int var2, double[] var3, int[] var4) throws LpSolveException;

    public native void setColumn(int var1, double[] var2) throws LpSolveException;

    public native void setColumnex(int var1, int var2, double[] var3, int[] var4) throws LpSolveException;

    public native int columnInLp(double[] var1);

    public native void setRowName(int var1, String var2) throws LpSolveException;

    public native String getRowName(int var1) throws LpSolveException;

    public native String getOrigrowName(int var1) throws LpSolveException;

    public native void setColName(int var1, String var2) throws LpSolveException;

    public native String getColName(int var1) throws LpSolveException;

    public native String getOrigcolName(int var1) throws LpSolveException;

    public native void setRhVec(double[] var1) throws LpSolveException;

    public native void strSetRhVec(String var1) throws LpSolveException;

    public native void setRh(int var1, double var2) throws LpSolveException;

    public native double getRh(int var1);

    public native void setConstrType(int var1, int var2) throws LpSolveException;

    public native short getConstrType(int var1) throws LpSolveException;

    public native void addSOS(String var1, int var2, int var3, int var4, int[] var5, double[] var6) throws LpSolveException;

    public native boolean isSOSVar(int var1) throws LpSolveException;

    public native void setObjFn(double[] var1) throws LpSolveException;

    public native void strSetObjFn(String var1) throws LpSolveException;

    public native void setObjFnex(int var1, double[] var2, int[] var3) throws LpSolveException;

    public native void setObj(int var1, double var2) throws LpSolveException;

    public native void setMat(int var1, int var2, double var3) throws LpSolveException;

    public native double getMat(int var1, int var2);

    public native void getRow(int var1, double[] var2) throws LpSolveException;

    public native int getRowex(int var1, double[] var2, int[] var3) throws LpSolveException;

    public native double[] getPtrRow(int var1) throws LpSolveException;

    public native void getColumn(int var1, double[] var2) throws LpSolveException;

    public native int getColumnex(int var1, double[] var2, int[] var3) throws LpSolveException;

    public native double[] getPtrColumn(int var1) throws LpSolveException;

    public native void setMaxim();

    public native void setMinim();

    public native void setSense(boolean var1);

    public native boolean isMaxim();

    public native void setLowbo(int var1, double var2) throws LpSolveException;

    public native double getLowbo(int var1) throws LpSolveException;

    public native void setUpbo(int var1, double var2) throws LpSolveException;

    public native double getUpbo(int var1) throws LpSolveException;

    public native void setUnbounded(int var1) throws LpSolveException;

    public native boolean isUnbounded(int var1);

    public native boolean isNegative(int var1);

    public native void setBounds(int var1, double var2, double var4) throws LpSolveException;

    public native void setBoundsTighter(boolean var1);

    public native boolean getBoundsTighter();

    public native void setRhRange(int var1, double var2) throws LpSolveException;

    public native double getRhRange(int var1) throws LpSolveException;

    public native void setInt(int var1, boolean var2) throws LpSolveException;

    public native boolean isInt(int var1);

    public native void setBinary(int var1, boolean var2) throws LpSolveException;

    public native boolean isBinary(int var1);

    public native void setSemicont(int var1, boolean var2) throws LpSolveException;

    public native boolean isSemicont(int var1);

    public native void setInfinite(double var1);

    public native double getInfinite();

    public native boolean isInfinite(double var1);

    public native void setEpsint(double var1);

    public native double getEpsint();

    public native void setEpsb(double var1);

    public native double getEpsb();

    public native void setEpsd(double var1);

    public native double getEpsd();

    public native void setEpsel(double var1);

    public native double getEpsel();

    public native void setEpspivot(double var1);

    public native double getEpspivot();

    public native void setEpsperturb(double var1);

    public native double getEpsperturb();

    public native void setEpslevel(int var1) throws LpSolveException;

    public native int getStatus();

    public native void setMipGap(boolean var1, double var2);

    public native double getMipGap(boolean var1);

    public native void setVerbose(int var1);

    public native int getVerbose();

    public native void setTimeout(long var1);

    public native long getTimeout();

    public native double timeElapsed();

    public native void setPrintSol(int var1);

    public native int getPrintSol();

    public native void setDebug(boolean var1);

    public native boolean isDebug();

    public native void setTrace(boolean var1);

    public native boolean isTrace();

    public native void setLagTrace(boolean var1);

    public native boolean isLagTrace();

    public native boolean setAddRowmode(boolean var1);

    public native boolean isAddRowmode();

    public native void setAntiDegen(int var1);

    public native boolean isAntiDegen(int var1);

    public native int getAntiDegen();

    public native void setPresolve(int var1, int var2);

    public native boolean isPresolve(int var1);

    public native int getPresolve();

    public native int getPresolveloops();

    public native void setMaxpivot(int var1);

    public native int getMaxpivot();

    public native void setBbRule(int var1);

    public native int getBbRule();

    public native void setBbDepthlimit(int var1);

    public native int getBbDepthlimit();

    public native int getSolutioncount();

    public native void setSolutionlimit(int var1);

    public native int getSolutionlimit();

    public native void setObjBound(double var1);

    public native double getObjBound();

    public native void setBbFloorfirst(int var1);

    public native int getBbFloorfirst();

    public native void setVarBranch(int var1, int var2) throws LpSolveException;

    public native int getVarBranch(int var1) throws LpSolveException;

    public native void setVarWeights(double[] var1) throws LpSolveException;

    public native int getVarPriority(int var1) throws LpSolveException;

    public native void setBreakAtFirst(boolean var1);

    public native boolean isBreakAtFirst();

    public native void setBreakAtValue(double var1);

    public native double getBreakAtValue();

    public native void setScaling(int var1);

    public native int getScaling();

    public native boolean isScalemode(int var1);

    public native boolean isScaletype(int var1);

    public native boolean isIntegerscaling();

    public native void setScalelimit(double var1);

    public native double getScalelimit();

    public native void setImprove(int var1);

    public native int getImprove();

    public native void setPivoting(int var1);

    public native int getPivoting();

    public native boolean isPivMode(int var1);

    public native boolean isPivRule(int var1);

    public native void setPreferdual(boolean var1);

    public native void setSimplextype(int var1);

    public native int getSimplextype();

    public native void setNegrange(double var1);

    public native double getNegrange();

    public native long getTotalIter();

    public native int getMaxLevel();

    public native long getTotalNodes();

    public native int getNrows();

    public native int getNorigRows();

    public native int getLrows();

    public native int getNcolumns();

    public native int getNorigColumns();

    public native int getNonzeros();

    public native int getOrigIndex(int var1);

    public native int getLpIndex(int var1);

    public native void setBasis(int[] var1, boolean var2) throws LpSolveException;

    public native void guessBasis(double[] var1, int[] var2) throws LpSolveException;

    public native void getBasis(int[] var1, boolean var2) throws LpSolveException;

    public native void resetBasis();

    public native void defaultBasis();

    public native void setBasiscrash(int var1);

    public native int getBasiscrash();

    public native void unscale();

    public native void setBFP(String var1) throws LpSolveException;

    public native boolean isNativeBFP();

    public native boolean hasBFP();

    public native int solve() throws LpSolveException;

    public native String getStatustext(int var1);

    public native boolean isFeasible(double[] var1, double var2) throws LpSolveException;

    public native double getObjective() throws LpSolveException;

    public native double getWorkingObjective() throws LpSolveException;

    public native void getVariables(double[] var1) throws LpSolveException;

    public native double[] getPtrVariables() throws LpSolveException;

    public native void getConstraints(double[] var1) throws LpSolveException;

    public native double[] getPtrConstraints() throws LpSolveException;

    public native void getPrimalSolution(double[] var1) throws LpSolveException;

    public native double[] getPtrPrimalSolution() throws LpSolveException;

    public native double getVarPrimalresult(int var1) throws LpSolveException;

    public native void getSensitivityRhs(double[] var1, double[] var2, double[] var3) throws LpSolveException;

    public native double[][] getPtrSensitivityRhs() throws LpSolveException;

    public native void getDualSolution(double[] var1) throws LpSolveException;

    public native double[] getPtrDualSolution() throws LpSolveException;

    public native double getVarDualresult(int var1) throws LpSolveException;

    public native void getSensitivityObj(double[] var1, double[] var2) throws LpSolveException;

    public native double[][] getPtrSensitivityObj() throws LpSolveException;

    public native void getSensitivityObjex(double[] var1, double[] var2, double[] var3, double[] var4) throws LpSolveException;

    public native double[][] getPtrSensitivityObjex() throws LpSolveException;

    public native void getLambda(double[] var1) throws LpSolveException;

    public native double[] getPtrLambda() throws LpSolveException;

    public native void deleteLp();

    public native void writeLp(String var1) throws LpSolveException;

    public native void writeMps(String var1) throws LpSolveException;

    public native void writeFreeMps(String var1) throws LpSolveException;

    public native String readBasis(String var1) throws LpSolveException;

    public native void writeBasis(String var1) throws LpSolveException;

    public native void readParams(String var1, String var2) throws LpSolveException;

    public native void writeParams(String var1, String var2) throws LpSolveException;

    public native void resetParams();

    public native void printLp();

    public native void printConstraints(int var1);

    public native void printDuals();

    public native void printScales();

    public native void printTableau();

    public native void printObjective();

    public native void printSolution(int var1);

    public native void printStr(String var1);

    public native void setOutputfile(String var1) throws LpSolveException;

    public native void printDebugdump(String var1) throws LpSolveException;

    public native void setXLI(String var1) throws LpSolveException;

    public native void writeXLI(String var1, String var2, boolean var3) throws LpSolveException;

    public native boolean hasXLI();

    public native boolean isNativeXLI();

    public native int getNameindex(String var1, boolean var2);

    public native void dualizeLp() throws LpSolveException;

    public native boolean isUseNames(boolean var1);

    public native void setUseNames(boolean var1, boolean var2);

    public native double getConstrValue(int var1, int var2, double[] var3, int[] var4);

    public native int setBasisvar(int var1, int var2);

    private native void registerAbortfunc();

    public void putAbortfunc(AbortListener listener, Object userhandle) throws LpSolveException {
        this.abortListener = listener;
        this.abortUserhandle = listener != null ? userhandle : null;
        LpSolve.addLp(this);
        this.registerAbortfunc();
    }

    private native void registerLogfunc();

    public void putLogfunc(LogListener listener, Object userhandle) throws LpSolveException {
        this.logListener = listener;
        this.logUserhandle = listener != null ? userhandle : null;
        LpSolve.addLp(this);
        this.registerLogfunc();
    }

    private native void registerMsgfunc(int var1);

    public void putMsgfunc(MsgListener listener, Object userhandle, int mask) throws LpSolveException {
        this.msgListener = listener;
        this.msgUserhandle = listener != null ? userhandle : null;
        LpSolve.addLp(this);
        this.registerMsgfunc(mask);
    }

    private native void registerBbBranchfunc();

    public void putBbBranchfunc(BbListener listener, Object userhandle) throws LpSolveException {
        this.bbBranchListener = listener;
        this.bbBranchUserhandle = listener != null ? userhandle : null;
        LpSolve.addLp(this);
        this.registerBbBranchfunc();
    }

    private native void registerBbNodefunc();

    public void putBbNodefunc(BbListener listener, Object userhandle) throws LpSolveException {
        this.bbNodeListener = listener;
        this.bbNodeUserhandle = listener != null ? userhandle : null;
        LpSolve.addLp(this);
        this.registerBbNodefunc();
    }

    private static synchronized void addLp(LpSolve problem) {
        lpMap.put(new Long(problem.lp), problem);
    }

    private static synchronized LpSolve getLp(long lp) {
        return (LpSolve)lpMap.get(new Long(lp));
    }

    private static synchronized void removeLp(long lp) {
        lpMap.remove(new Long(lp));
    }
}

