/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.filtering;

import Jama.Matrix;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import plugins.nchenouard.particletracking.VirtualSpot;
import plugins.nchenouard.particletracking.filtering.KF3dDirected;
import plugins.nchenouard.particletracking.filtering.KF3dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.LikelihoodMap;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.filtering.Predictor3D;
import plugins.nchenouard.spot.Spot;

public class IMM3D
implements Predictor {
    public double inertia;
    protected int maxLikelihoodIndex = 0;
    int r;
    LikelihoodTypes likelihoodType;
    protected Predictor3D[] filter_i;
    protected double[][] p_ij;
    protected double[] m_est_i;
    protected double[][] m_est_ij;
    protected double[] m_pre_i;
    protected double[] l_i;
    protected Matrix x_est;
    protected Matrix P_est;
    protected Matrix x_pre;
    protected Matrix z_pre;
    int dim = 3;

    public IMM3D(LikelihoodTypes predictorType, double immInertia, List<Predictor3D> predictors) {
        this.r = predictors.size();
        this.inertia = immInertia;
        this.x_est = new Matrix(this.dim, 1);
        this.P_est = new Matrix(this.dim, this.dim);
        this.likelihoodType = predictorType;
        this.filter_i = new Predictor3D[this.r];
        this.p_ij = new double[this.r][this.r];
        this.m_est_i = new double[this.r];
        this.m_est_ij = new double[this.r][this.r];
        this.m_pre_i = new double[this.r];
        this.l_i = new double[this.r];
        double mi = 1.0 / (double)this.r;
        for (int i = 0; i < this.r; ++i) {
            this.m_pre_i[i] = mi;
            this.m_est_i[i] = mi;
            for (int j = 0; j < this.r; ++j) {
                this.p_ij[i][j] = i == j ? this.inertia : (1.0 - this.inertia) / ((double)this.r - 1.0);
            }
        }
        int cnt = 0;
        for (Predictor3D p : predictors) {
            this.setModelAt(p, cnt);
            ++cnt;
        }
    }

    public IMM3D(IMM3D toCopy) {
        int i;
        this.r = toCopy.r;
        this.likelihoodType = toCopy.likelihoodType;
        this.inertia = toCopy.inertia;
        this.x_est = toCopy.x_est.copy();
        if (this.z_pre != null) {
            this.z_pre = toCopy.z_pre.copy();
        }
        if (this.x_pre != null) {
            this.x_pre = toCopy.x_pre.copy();
        }
        this.P_est = toCopy.P_est.copy();
        this.l_i = new double[this.r];
        this.filter_i = new Predictor3D[this.r];
        for (i = 0; i < this.filter_i.length; ++i) {
            this.filter_i[i] = (Predictor3D)toCopy.filter_i[i].copy();
        }
        this.p_ij = new double[this.r][this.r];
        this.m_est_ij = new double[this.r][this.r];
        this.m_pre_i = new double[this.r];
        this.m_est_i = new double[this.r];
        System.arraycopy(toCopy.m_est_i, 0, this.m_est_i, 0, this.m_est_i.length);
        System.arraycopy(toCopy.m_pre_i, 0, this.m_pre_i, 0, this.m_pre_i.length);
        for (i = 0; i < this.r; ++i) {
            for (int j = 0; j < this.r; ++j) {
                this.p_ij[i][j] = toCopy.p_ij[i][j];
                this.m_est_ij[i][j] = toCopy.m_est_ij[i][j];
            }
        }
        this.maxLikelihoodIndex = toCopy.maxLikelihoodIndex;
    }

    @Override
    public Predictor copy() {
        return new IMM3D(this);
    }

    @Override
    public Predictor copyInit() {
        ArrayList<Predictor3D> predictors = new ArrayList<Predictor3D>(this.r);
        for (Predictor3D p : this.filter_i) {
            predictors.add((Predictor3D)p.copyInit());
        }
        return new IMM3D(this.likelihoodType, this.inertia, predictors);
    }

    @Override
    public Object clone() {
        return new IMM3D(this);
    }

    @Override
    public void correct(Matrix z) {
        if (z != null) {
            int i;
            int i2;
            for (Predictor3D p : this.filter_i) {
                p.correct(z);
            }
            this.likelihood(z, false, 10.0);
            double c = 0.0;
            for (i2 = 0; i2 < this.r; ++i2) {
                c += this.m_pre_i[i2] * this.l_i[i2];
            }
            for (i2 = 0; i2 < this.r; ++i2) {
                this.m_est_i[i2] = this.m_pre_i[i2] * this.l_i[i2] / c;
            }
            double xNew = 0.0;
            double yNew = 0.0;
            double zNew = 0.0;
            for (i = 0; i < this.r; ++i) {
                xNew += this.filter_i[i].getXCoordEstimated() * this.m_est_i[i];
                yNew += this.filter_i[i].getYCoordEstimated() * this.m_est_i[i];
                zNew += this.filter_i[i].getZCoordEstimated() * this.m_est_i[i];
            }
            this.x_est.set(0, 0, xNew);
            this.x_est.set(1, 0, yNew);
            this.x_est.set(2, 0, zNew);
            this.P_est.timesEquals(0.0);
            for (i = 0; i < this.r; ++i) {
                Matrix m0 = this.filter_i[i].getCurrentEstimatedState3D().minus(this.x_est);
                this.P_est.plusEquals(this.filter_i[i].getCurrentStateErrorCovariance3D().plus(m0.times(m0.transpose())).times(this.m_est_i[i]));
            }
        }
    }

    @Override
    public double[][] getCurrentCubicGate(double gateFactor) {
        double[][] bounds = this.filter_i[0].getCurrentCubicGate(gateFactor);
        for (int i = 1; i < this.r; ++i) {
            double[][] tmp = this.filter_i[i].getCurrentCubicGate(gateFactor);
            for (int k = 0; k < tmp.length; ++k) {
                bounds[k][0] = Math.min(bounds[k][0], tmp[k][0]);
                bounds[k][1] = Math.max(bounds[k][1], tmp[k][1]);
            }
        }
        return bounds;
    }

    @Override
    public ArrayList<Area> getCurrentGate(double gateFactor) {
        ArrayList<Area> areas = new ArrayList<Area>();
        for (int i = 0; i < this.r; ++i) {
            areas.addAll(this.filter_i[i].getCurrentGate(gateFactor));
        }
        return areas;
    }

    @Override
    public Matrix getCurrentEstimatedState() {
        return this.x_est;
    }

    @Override
    public Matrix getCurrentPredictedMeasurement() {
        return this.z_pre;
    }

    @Override
    public Matrix getCurrentPredictedState() {
        return this.x_pre;
    }

    @Override
    public Matrix getCurrentStateErrorCovariance() {
        return this.P_est;
    }

    @Override
    public void init(Matrix x0, Matrix P0) {
        for (int i = 0; i < this.r; ++i) {
            this.filter_i[i].init(x0, P0);
        }
    }

    @Override
    public void initWithFirstElement(Matrix firstElement, int t) {
        for (Predictor3D p3D : this.filter_i) {
            p3D.initWithFirstElement(firstElement, t);
        }
    }

    @Override
    public double likelihood(Spot s, boolean gated, double gateFactor) {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.likelihoodMax(s, gated, gateFactor);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                l = this.likelihoodMean(s, gated, gateFactor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return l;
    }

    @Override
    public double likelihood(Matrix z, boolean gated, double gateFactor) {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.likelihoodMax(z, gated, gateFactor);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                l = this.likelihoodMean(z, gated, gateFactor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return l;
    }

    public double likelihoodMax(Spot s, boolean gated, double gateFactor) {
        for (int i = 0; i < this.r; ++i) {
            this.l_i[i] = this.filter_i[i].likelihood(s, gated, gateFactor);
        }
        return this.l_i[this.maxLikelihoodIndex];
    }

    public double likelihoodMax(Matrix z, boolean gated, double gateFactor) {
        for (int i = 0; i < this.r; ++i) {
            this.l_i[i] = this.filter_i[i].likelihood(z, gated, gateFactor);
        }
        return this.l_i[this.maxLikelihoodIndex];
    }

    public double likelihoodMean(Spot s, boolean gated, double gateFactor) {
        double mean = 0.0;
        for (int i = 0; i < this.r; ++i) {
            this.l_i[i] = this.filter_i[i].likelihood(s, gated, gateFactor);
            mean += this.l_i[i] * this.m_est_i[i];
        }
        return mean;
    }

    public double likelihoodMean(Matrix z, boolean gated, double gateFactor) {
        double mean = 0.0;
        for (int i = 0; i < this.r; ++i) {
            this.l_i[i] = this.filter_i[i].likelihood(z, gated, gateFactor);
            mean += this.l_i[i] * this.m_est_i[i];
        }
        return mean;
    }

    public int maxLikelihoodIndex() {
        double max = Double.NEGATIVE_INFINITY;
        int index = 0;
        for (int i = 0; i < this.r; ++i) {
            if (!(max < this.l_i[i])) continue;
            max = this.l_i[i];
            index = i;
        }
        return index;
    }

    @Override
    public void predict() {
        int i;
        int i2;
        int j;
        int i3;
        int j2;
        for (j2 = 0; j2 < this.r; ++j2) {
            this.m_pre_i[j2] = 0.0;
            for (i3 = 0; i3 < this.r; ++i3) {
                int n = j2;
                this.m_pre_i[n] = this.m_pre_i[n] + this.p_ij[i3][j2] * this.m_est_i[i3];
            }
        }
        for (j2 = 0; j2 < this.r; ++j2) {
            for (i3 = 0; i3 < this.r; ++i3) {
                this.m_est_ij[i3][j2] = this.p_ij[i3][j2] * this.m_est_i[i3] / this.m_pre_i[j2];
            }
        }
        Matrix[] x_est_0j = new Matrix[this.r];
        Matrix[] P_est_0j = new Matrix[this.r];
        for (j = 0; j < this.r; ++j) {
            x_est_0j[j] = new Matrix(3, 1);
            for (i2 = 0; i2 < this.r; ++i2) {
                x_est_0j[j].plusEquals(this.filter_i[i2].getCurrentEstimatedState3D().times(this.m_est_ij[i2][j]));
            }
        }
        for (j = 0; j < this.r; ++j) {
            P_est_0j[j] = new Matrix(3, 3);
            for (i2 = 0; i2 < this.r; ++i2) {
                Matrix m0 = this.filter_i[i2].getCurrentEstimatedState3D().minus(x_est_0j[j]);
                m0 = this.filter_i[i2].getCurrentStateErrorCovariance3D().plus(m0.times(m0.transpose()));
                P_est_0j[j].plusEquals(m0.times(this.m_est_ij[i2][j]));
            }
        }
        this.maxLikelihoodIndex = this.maxLikelihoodIndex();
        for (i = 0; i < this.r; ++i) {
            this.filter_i[i].setCurrentEstimatedState3D(x_est_0j[i]);
            this.filter_i[i].setCurrentStateErrorCovariance3D(P_est_0j[i]);
            this.filter_i[i].predict();
        }
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                this.x_pre = this.filter_i[this.maxLikelihoodIndex].getCurrentPredictedState3D();
                this.z_pre = this.filter_i[this.maxLikelihoodIndex].getCurrentPredictedMeasurement();
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                this.x_pre = this.filter_i[0].getCurrentPredictedState3D().times(this.m_est_i[0]);
                this.z_pre = this.filter_i[0].getCurrentPredictedMeasurement().times(this.m_est_i[0]);
                for (i = 1; i < this.r; ++i) {
                    this.x_pre.plusEquals(this.filter_i[i].getCurrentPredictedState3D().times(this.m_est_i[i]));
                    this.z_pre.plusEquals(this.filter_i[i].getCurrentPredictedMeasurement().times(this.m_est_i[i]));
                }
                break;
            }
            default: {
                System.err.println("Unknown likelihood type in IMM2D");
            }
        }
    }

    @Override
    public void predict(int t) {
        int i;
        int i2;
        int j;
        int i3;
        int j2;
        for (j2 = 0; j2 < this.r; ++j2) {
            this.m_pre_i[j2] = 0.0;
            for (i3 = 0; i3 < this.r; ++i3) {
                int n = j2;
                this.m_pre_i[n] = this.m_pre_i[n] + this.p_ij[i3][j2] * this.m_est_i[i3];
            }
        }
        for (j2 = 0; j2 < this.r; ++j2) {
            for (i3 = 0; i3 < this.r; ++i3) {
                this.m_est_ij[i3][j2] = this.p_ij[i3][j2] * this.m_est_i[i3] / this.m_pre_i[j2];
            }
        }
        Matrix[] x_est_0j = new Matrix[this.r];
        Matrix[] P_est_0j = new Matrix[this.r];
        for (j = 0; j < this.r; ++j) {
            x_est_0j[j] = new Matrix(3, 1);
            for (i2 = 0; i2 < this.r; ++i2) {
                x_est_0j[j].plusEquals(this.filter_i[i2].getCurrentEstimatedState3D().times(this.m_est_ij[i2][j]));
            }
        }
        for (j = 0; j < this.r; ++j) {
            P_est_0j[j] = new Matrix(3, 3);
            for (i2 = 0; i2 < this.r; ++i2) {
                Matrix m0 = this.filter_i[i2].getCurrentEstimatedState3D().minus(x_est_0j[j]);
                m0 = this.filter_i[i2].getCurrentStateErrorCovariance3D().plus(m0.times(m0.transpose()));
                P_est_0j[j].plusEquals(m0.times(this.m_est_ij[i2][j]));
            }
        }
        this.maxLikelihoodIndex = this.maxLikelihoodIndex();
        for (i = 0; i < this.r; ++i) {
            this.filter_i[i].setCurrentEstimatedState3D(x_est_0j[i]);
            this.filter_i[i].setCurrentStateErrorCovariance3D(P_est_0j[i]);
            this.filter_i[i].predict(t);
        }
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                this.x_pre = this.filter_i[this.maxLikelihoodIndex].getCurrentPredictedState3D();
                this.z_pre = this.filter_i[this.maxLikelihoodIndex].getCurrentPredictedMeasurement();
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                this.x_pre = this.filter_i[0].getCurrentPredictedState3D().times(this.m_est_i[0]);
                this.z_pre = this.filter_i[0].getCurrentPredictedMeasurement().times(this.m_est_i[0]);
                for (i = 1; i < this.r; ++i) {
                    this.x_pre.plusEquals(this.filter_i[i].getCurrentPredictedState3D().times(this.m_est_i[i]));
                    this.z_pre.plusEquals(this.filter_i[i].getCurrentPredictedMeasurement().times(this.m_est_i[i]));
                }
                break;
            }
            default: {
                System.err.println("Unknown likelihood type in IMM2D");
            }
        }
    }

    public void setModelAt(Predictor3D predictor, int i) {
        this.filter_i[i] = predictor;
    }

    @Override
    public void setTrackingCovariances(double[] trackingCov) {
        for (Predictor3D p : this.filter_i) {
            p.setTrackingCovariances(trackingCov);
        }
    }

    @Override
    public double loglikelihood(Matrix z) {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.likelihoodMax(z, false, 10.0);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                l = this.likelihoodMean(z, false, 10.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return Math.log(l);
    }

    @Override
    public double loglikelihood(Spot s) {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.likelihoodMax(s, false, 10.0);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                l = this.likelihoodMean(s, false, 10.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return Math.log(l);
    }

    @Override
    public double likelihoodOfState(Matrix x) {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.likelihoodMaxOfState(x);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                l = this.likelihoodMeanOfState(x);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return l;
    }

    @Override
    public double loglikelihoodOfState(Matrix x) {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.likelihoodMaxOfState(x);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                l = this.likelihoodMeanOfState(x);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return Math.log(l);
    }

    public double likelihoodMaxOfState(Matrix x) {
        return this.filter_i[this.maxLikelihoodIndex].likelihoodOfState(x);
    }

    public double likelihoodMeanOfState(Matrix x) {
        double mean = 0.0;
        for (int i = 0; i < this.r; ++i) {
            mean += this.filter_i[i].likelihoodOfState(x) * this.m_est_i[i];
        }
        return mean;
    }

    @Override
    public double likelihoodOfPredictedState() {
        double l;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.filter_i[this.maxLikelihoodIndex].likelihoodOfPredictedState();
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                double mean = 0.0;
                for (int i = 0; i < this.r; ++i) {
                    mean += this.filter_i[i].likelihoodOfPredictedState() * this.m_est_i[i];
                }
                l = mean;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return l;
    }

    @Override
    public Matrix buildMeasurementMatrix(Spot spot) {
        return this.filter_i[0].buildMeasurementMatrix(spot);
    }

    @Override
    public void initWithFirstElement(Spot firstElement, int t) {
        for (int i = 0; i < this.r; ++i) {
            this.filter_i[i].initWithFirstElement(firstElement, t);
        }
        this.predict();
    }

    public VirtualSpot getPredictedStateAsSpot() {
        return new VirtualSpot(this.x_pre.get(0, 0), this.x_pre.get(1, 0), this.x_pre.get(2, 0));
    }

    @Override
    public Spot buildSpotFromState(Matrix state) {
        return new Spot(state.get(0, 0), state.get(1, 0), state.get(2, 0));
    }

    @Override
    public double getTotalGateLikelihood(boolean gated, double gateFactor) {
        double likelihood = 0.0;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                return this.filter_i[this.maxLikelihoodIndex].getTotalGateLikelihood(gated, gateFactor);
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                for (int i = 0; i < this.r; ++i) {
                    likelihood += this.filter_i[i].getTotalGateLikelihood(gated, gateFactor) * this.m_est_i[i];
                }
                return likelihood;
            }
        }
        throw new IllegalArgumentException("Unknown IMM likelihood type.");
    }

    public double[] getWeights() {
        return this.l_i;
    }

    @Override
    public double normalizedInnovation(Spot s) {
        Matrix m = this.buildMeasurementMatrix(s);
        return this.normalizedInnovation(m);
    }

    @Override
    public double normalizedInnovation(Matrix m) {
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                return this.filter_i[this.maxLikelihoodIndex].normalizedInnovation(m);
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                double innov = 0.0;
                for (int i = 0; i < this.r; ++i) {
                    innov += this.filter_i[i].normalizedInnovation(m) * this.m_est_i[i];
                }
                return innov;
            }
        }
        throw new IllegalArgumentException("Unknown IMM likelihood type.");
    }

    public LikelihoodMap[] getLikelihoodMapsIMM(double gateFactor, int t) {
        ArrayList<Integer> enabledFilters = new ArrayList<Integer>();
        for (int i = 0; i < this.r; ++i) {
            if (!(this.filter_i[i] instanceof KF3dDirected) && !(this.filter_i[i] instanceof KF3dRandomWalk)) continue;
            enabledFilters.add(new Integer(i));
        }
        if (enabledFilters.size() > 0) {
            LikelihoodMap[] maps = new LikelihoodMap[enabledFilters.size()];
            int cnt = 0;
            for (Integer i : enabledFilters) {
                maps[cnt] = ((KalmanFilter)((Object)this.filter_i[i])).getLikelihoodMap(gateFactor, t);
                ++cnt;
            }
            int minX = maps[0].getOffsetX();
            int minY = maps[0].getOffsetY();
            int minZ = maps[0].getOffsetZ();
            int maxX = maps[0].getOffsetX() + maps[0].getWidth() - 1;
            int maxY = maps[0].getOffsetY() + maps[0].getHeight() - 1;
            int maxZ = maps[0].getOffsetZ() + maps[0].getDepth() - 1;
            for (int i = 1; i < maps.length; ++i) {
                minX = Math.min(minX, maps[i].getOffsetX());
                minY = Math.min(minY, maps[i].getOffsetY());
                minZ = Math.min(minZ, maps[i].getOffsetZ());
                maxX = Math.max(maxX, maps[i].getOffsetX() + maps[i].getWidth() - 1);
                maxY = Math.max(maxY, maps[i].getOffsetY() + maps[i].getHeight() - 1);
                maxZ = Math.max(maxZ, maps[i].getOffsetZ() + maps[i].getDepth() - 1);
            }
            return maps;
        }
        throw new IllegalArgumentException("invalid KalmanFilter type to invoke getLikelihoodMap");
    }

    public LikelihoodMap getLikelihoodMap(double gateFactor, int t) {
        if (this.likelihoodType == LikelihoodTypes.IMM_MAX_LIKELIHOOD) {
            return ((KalmanFilter)((Object)this.filter_i[this.maxLikelihoodIndex])).getLikelihoodMap(gateFactor, t);
        }
        if (this.likelihoodType == LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD) {
            LikelihoodMap[] maps = new LikelihoodMap[this.filter_i.length];
            for (int cnt = 0; cnt < this.filter_i.length; ++cnt) {
                maps[cnt] = ((KalmanFilter)((Object)this.filter_i[cnt])).getLikelihoodMap(gateFactor, t);
                ++cnt;
            }
            int minX = maps[0].getOffsetX();
            int minY = maps[0].getOffsetY();
            int minZ = maps[0].getOffsetZ();
            int maxX = maps[0].getOffsetX() + maps[0].getWidth() - 1;
            int maxY = maps[0].getOffsetY() + maps[0].getHeight() - 1;
            int maxZ = maps[0].getOffsetZ() + maps[0].getDepth() - 1;
            for (int i = 1; i < maps.length; ++i) {
                minX = Math.min(minX, maps[i].getOffsetX());
                minY = Math.min(minY, maps[i].getOffsetY());
                minZ = Math.min(minZ, maps[i].getOffsetZ());
                maxX = Math.max(maxX, maps[i].getOffsetX() + maps[i].getWidth() - 1);
                maxY = Math.max(maxY, maps[i].getOffsetY() + maps[i].getHeight() - 1);
                maxZ = Math.max(maxZ, maps[i].getOffsetZ() + maps[i].getDepth() - 1);
            }
            LikelihoodMap lmap = new LikelihoodMap(maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1, minX, minY, minZ);
            for (int cnt = 0; cnt < this.filter_i.length; ++cnt) {
                LikelihoodMap map = maps[cnt];
                double p = this.m_est_i[cnt];
                for (int z = map.getOffsetZ(); z < map.getOffsetZ() + map.getDepth(); ++z) {
                    for (int y = map.getOffsetY(); y < map.getOffsetY() + map.getHeight(); ++y) {
                        for (int x = map.getOffsetX(); x < map.getOffsetX() + map.getWidth(); ++x) {
                            lmap.addLikelihood(x, y, z, map.getLikelihood(x, y, z) * p);
                        }
                    }
                }
            }
            return lmap;
        }
        throw new IllegalArgumentException("invalid KalmanFilter type to invoke getLikelihoodMap");
    }

    public LikelihoodMap getLikelihoodMap(boolean gated, double gateFactor, int t, int width, int height, int depth) {
        if (this.likelihoodType == LikelihoodTypes.IMM_MAX_LIKELIHOOD) {
            return ((KalmanFilter)((Object)this.filter_i[this.maxLikelihoodIndex])).getLikelihoodMap(gated, gateFactor, t, width, height, depth);
        }
        if (this.likelihoodType == LikelihoodTypes.IMM_WEIGHTED_LIKELIHOOD) {
            LikelihoodMap[] maps = new LikelihoodMap[this.filter_i.length];
            for (int cnt = 0; cnt < this.filter_i.length; ++cnt) {
                maps[cnt] = ((KalmanFilter)((Object)this.filter_i[cnt])).getLikelihoodMap(gated, gateFactor, t, width, height, depth);
                ++cnt;
            }
            LikelihoodMap lmap = new LikelihoodMap(width, height, depth, 0, 0, 0);
            for (int cnt = 0; cnt < this.filter_i.length; ++cnt) {
                LikelihoodMap map = maps[cnt];
                double p = this.m_est_i[cnt];
                for (int z = map.getOffsetZ(); z < map.getOffsetZ() + map.getDepth(); ++z) {
                    for (int y = map.getOffsetY(); y < map.getOffsetY() + map.getHeight(); ++y) {
                        for (int x = map.getOffsetX(); x < map.getOffsetX() + map.getWidth(); ++x) {
                            lmap.addLikelihood(x, y, z, map.getLikelihood(x, y, z) * p);
                        }
                    }
                }
            }
            return lmap;
        }
        throw new IllegalArgumentException("Unknown IMM likelihood type.");
    }

    @Override
    public void update(Matrix z, int t) {
        this.correct(z);
        if (z != null) {
            this.updateTime(t);
        }
        this.predict(t);
    }

    @Override
    public void update(Spot s, int t) {
        Matrix z = this.buildMeasurementMatrix(s);
        this.update(z, t);
    }

    @Override
    public void updateTime(int t) {
        for (int c = 0; c < this.r; ++c) {
            this.filter_i[c].updateTime(t);
        }
    }

    @Override
    public VirtualSpot getCurrentPredictedStateAsSpot() {
        switch (this.likelihoodType) {
            case IMM_WEIGHTED_LIKELIHOOD: {
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                for (int c = 0; c < this.r; ++c) {
                    VirtualSpot prediction = this.filter_i[c].getCurrentPredictedStateAsSpot();
                    x += prediction.mass_center.x * this.m_est_i[c];
                    y += prediction.mass_center.y * this.m_est_i[c];
                    z += prediction.mass_center.z * this.m_est_i[c];
                }
                return new VirtualSpot(x, y, z);
            }
            case IMM_MAX_LIKELIHOOD: {
                return this.filter_i[this.maxLikelihoodIndex].getCurrentPredictedStateAsSpot();
            }
        }
        System.err.println("Unknown likelihood type in IMM2D");
        return null;
    }

    @Override
    public double getMinLikelihoodInGate(double gateFactor, int t) {
        double l = 0.0;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.filter_i[this.maxLikelihoodIndex].getMinLikelihoodInGate(gateFactor, t);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                for (int i = 0; i < this.r; ++i) {
                    l += this.filter_i[i].getMinLikelihoodInGate(gateFactor, t) * this.m_est_i[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return l;
    }

    @Override
    public double getCurrentMinLikelihoodInGate(double gateFactor) {
        double l = 0.0;
        switch (this.likelihoodType) {
            case IMM_MAX_LIKELIHOOD: {
                l = this.filter_i[this.maxLikelihoodIndex].getCurrentMinLikelihoodInGate(gateFactor);
                break;
            }
            case IMM_WEIGHTED_LIKELIHOOD: {
                for (int i = 0; i < this.r; ++i) {
                    l += this.filter_i[i].getCurrentMinLikelihoodInGate(gateFactor) * this.m_est_i[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown IMM likelihood type.");
            }
        }
        return l;
    }

    @Override
    public Matrix getEstimatedState(int t) {
        return this.x_est;
    }

    @Override
    public Matrix getPredictedMeasurement(int t) {
        return this.z_pre;
    }

    @Override
    public Matrix getPredictedState(int t) {
        return null;
    }

    @Override
    public VirtualSpot getPredictedStateAsSpot(int t) {
        return null;
    }

    @Override
    public Matrix getStateErrorCovariance(int t) {
        return null;
    }

    @Override
    public ArrayList<Area> getGates(double gateFactor, int t) {
        return null;
    }

    public static enum LikelihoodTypes {
        IMM_MAX_LIKELIHOOD,
        IMM_WEIGHTED_LIKELIHOOD;

    }
}

