/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import loci.formats.in.LeicaMicrosystemsMetadata.LofXmlDocument;
import loci.formats.in.LeicaMicrosystemsMetadata.XlifDocument;

public class LOFReader
extends LMSFileReader {
    public static final byte LOF_MAGIC_BYTE = 112;
    public static final byte LOF_MEMORY_BYTE = 42;
    private static final String ENCODING = "ISO-8859-1";
    private List<Long> offsets;
    private int lastChannel = 0;
    private long endPointer;
    private MetadataSource metadataSource = MetadataSource.LOF;

    public LOFReader() {
        super("Leica Object Format", "lof");
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
    }

    public LOFReader(XlifDocument xlif) {
        super("Leica Object Format", "lof");
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
        this.associatedXmlDoc = xlif;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean blockLen = true;
        if (!FormatTools.validStream(stream, 1, true)) {
            return false;
        }
        if (stream.readInt() != 112) {
            return false;
        }
        stream.readInt();
        if (stream.readByte() != 42) {
            return false;
        }
        int nc = stream.readInt();
        String typeName = "";
        if (nc != 15) {
            return false;
        }
        for (int i = 0; i < nc; ++i) {
            typeName = typeName + stream.readChar();
        }
        if (!typeName.equals("LMS_Object_File")) {
            return false;
        }
        if (stream.readByte() != 42) {
            return false;
        }
        stream.readInt();
        if (stream.readByte() != 42) {
            return false;
        }
        stream.readInt();
        if (stream.readByte() != 42) {
            return false;
        }
        long memorySize = stream.readLong();
        stream.skipBytes(memorySize);
        if (stream.getFilePointer() >= stream.length()) {
            return false;
        }
        if (stream.readInt() != 112) {
            return false;
        }
        stream.readInt();
        if (stream.readByte() != 42) {
            return false;
        }
        int xmlLength = stream.readInt();
        String lofXml = "";
        for (int i = 0; i < xmlLength; ++i) {
            lofXml = lofXml + stream.readChar();
        }
        LofXmlDocument doc = new LofXmlDocument(lofXml, "");
        if (doc.getImageNode() != null) {
            return true;
        }
        LOGGER.info("This LOF does not contain image data, it cannot be opened directly.");
        return false;
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= 9) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        block8: for (int i = 0; i < 256; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                }
            }
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 3 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0 || this.lastChannel >= 9) {
            return null;
        }
        short[][] lut = new short[3][65536];
        block8: for (int i = 0; i < 65536; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[1][i] = (short)(i & 0xFFFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (short)(i & 0xFFFF);
                    lut[1][i] = (short)(i & 0xFFFF);
                    lut[2][i] = (short)(i & 0xFFFF);
                }
            }
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        int tileIndex;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (!this.isRGB()) {
            int[] pos = this.getZCTCoords(no);
            this.lastChannel = this.metaTemp.channelPrios[this.getTileIndex(this.series)][pos[1]];
        }
        if ((tileIndex = this.getTileIndex(this.series)) >= this.offsets.size()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        long offset = this.offsets.get(tileIndex);
        int bytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int bpp = bytes * this.getRGBChannelCount();
        long planeSize = (long)this.getSizeX() * (long)this.getSizeY() * (long)bpp;
        long nextOffset = tileIndex + 1 < this.offsets.size() ? this.offsets.get(tileIndex + 1) : this.endPointer;
        long bytesToSkip = nextOffset - offset - planeSize * (long)this.getImageCount();
        if (bytesToSkip % planeSize != 0L) {
            bytesToSkip = 0L;
        }
        bytesToSkip /= (long)this.getSizeY();
        if (this.getSizeX() % 4 == 0) {
            bytesToSkip = 0L;
        }
        if (offset + (planeSize + bytesToSkip * (long)this.getSizeY()) * (long)no >= this.in.length()) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        this.seekStartOfPlane(no, offset, planeSize);
        if (bytesToSkip == 0L) {
            buf = this.readPlane(this.in, x, y, w, h2, buf);
        } else {
            this.in.skipBytes(bytesToSkip * (long)this.getSizeY() * (long)no);
            this.in.skipBytes((long)y * ((long)(this.getSizeX() * bpp) + bytesToSkip));
            for (int row = 0; row < h2; ++row) {
                this.in.skipBytes(x * bpp);
                this.in.read(buf, row * w * bpp, w * bpp);
                long skip = (long)(bpp * (this.getSizeX() - w - x)) + bytesToSkip;
                if (this.in.getFilePointer() + skip >= this.in.length()) continue;
                this.in.skipBytes(skip);
            }
        }
        if (this.getRGBChannelCount() == 3 && this.metaTemp.inverseRgb[0]) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), bytes, this.getRGBChannelCount());
        }
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
            this.lastChannel = 0;
            this.endPointer = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.setEncoding(ENCODING);
        this.in.order(true);
        this.checkForLofLayout(this.in, id);
        if (this.metadataSource == MetadataSource.LOF) {
            int xmlLength = this.in.readInt();
            String lofXml = "";
            for (int i = 0; i < xmlLength; ++i) {
                lofXml = lofXml + this.in.readChar();
            }
            String name = id.replaceAll("^.*[\\/\\\\]", "").replace(".lof", "");
            LofXmlDocument doc = new LofXmlDocument(lofXml, name);
            this.translateMetadata(doc);
        } else {
            this.translateMetadata((XlifDocument)this.associatedXmlDoc);
        }
        if (this.endPointer == 0L) {
            this.endPointer = this.in.length();
        }
    }

    @Override
    public LMSFileReader.ImageFormat getImageFormat() {
        return LMSFileReader.ImageFormat.LOF;
    }

    private void checkForLofLayout(RandomAccessInputStream in, String filename) throws FormatException, IOException {
        this.offsets = new ArrayList<Long>();
        if (in.readInt() != 112) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at header section)");
        }
        in.readInt();
        if (in.readByte() != 42) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at header section)");
        }
        int nc = in.readInt();
        String typeName = "";
        for (int i = 0; i < nc; ++i) {
            typeName = typeName + in.readChar();
        }
        if (!typeName.equals("LMS_Object_File")) {
            throw new FormatException(filename + " is not a valid Leica LOF file (typename=" + typeName + ")");
        }
        if (in.readByte() != 42) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at header section)");
        }
        in.readInt();
        if (in.readByte() != 42) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at header section)");
        }
        in.readInt();
        if (in.readByte() != 42) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at header section)");
        }
        long memorySize = in.readLong();
        if (memorySize > 0L) {
            this.offsets.add(in.getFilePointer());
        }
        in.skipBytes(memorySize);
        if (in.getFilePointer() >= in.length()) {
            throw new FormatException(filename + "is not a valid Leica LOF file (xml section not found)");
        }
        if (in.readInt() != 112) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at xml section)");
        }
        in.readInt();
        if (in.readByte() != 42) {
            throw new FormatException(filename + " is not a valid Leica LOF file (error at xml section)");
        }
    }

    private void seekStartOfPlane(int no, long dataOffset, long planeSize) throws IOException {
        long posInFile;
        int index = this.getTileIndex(this.series);
        int numberOfTiles = this.metaTemp.tileCount[index];
        if (numberOfTiles > 1) {
            long bytesIncPerTile = this.metaTemp.tileBytesInc[index];
            long framesPerTile = bytesIncPerTile / planeSize;
            if (framesPerTile > Integer.MAX_VALUE) {
                throw new IOException("Could not read frame due to int overflow");
            }
            int noOutsideTiles = no / (int)framesPerTile;
            int noInsideTiles = no % (int)framesPerTile;
            int tile = this.series;
            for (int i = 0; i < index; ++i) {
                tile -= this.metaTemp.tileCount[i];
            }
            posInFile = dataOffset;
            posInFile += (long)noOutsideTiles * bytesIncPerTile * (long)numberOfTiles;
            posInFile += (long)tile * bytesIncPerTile;
            posInFile += (long)noInsideTiles * planeSize;
        } else {
            posInFile = dataOffset + (long)no * planeSize;
        }
        this.in.seek(posInFile);
    }

    private int getTileIndex(int coreIndex) {
        int count = 0;
        for (int tile = 0; tile < this.metaTemp.tileCount.length; ++tile) {
            if (coreIndex < count + this.metaTemp.tileCount[tile]) {
                return tile;
            }
            count += this.metaTemp.tileCount[tile];
        }
        return -1;
    }

    public void setIdWithMetadata(String id, XlifDocument xml) throws FormatException, IOException {
        this.metadataSource = MetadataSource.XLIF;
        this.associatedXmlDoc = xml;
        super.setId(id);
    }

    public static enum MetadataSource {
        LOF,
        XLIF;

    }
}

