/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.distanceMap3d;

import ij.IJ;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageShort;

public class EdtShortLabel {
    public ImageFloat run(ImageShort imp, float scaleXY, float scaleZ, int nCPUs) throws Exception {
        int thread;
        int thread2;
        int thread3;
        int w = imp.sizeX;
        int h = imp.sizeY;
        int d = imp.sizeZ;
        float scale = scaleZ / scaleXY;
        short[][] data = imp.pixels;
        int nThreads = Math.max(nCPUs, 1);
        ImageFloat res = new ImageFloat("EDT Label", w, h, d);
        res.setScale(imp);
        float[][] s = res.pixels;
        Step1Thread[] s1t = new Step1Thread[nThreads];
        for (thread3 = 0; thread3 < nThreads; ++thread3) {
            s1t[thread3] = new Step1Thread(thread3, nThreads, w, h, d, s, data, scale);
            s1t[thread3].start();
        }
        try {
            for (thread3 = 0; thread3 < nThreads; ++thread3) {
                s1t[thread3].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 1 .");
        }
        Step2Thread[] s2t = new Step2Thread[nThreads];
        for (thread2 = 0; thread2 < nThreads; ++thread2) {
            s2t[thread2] = new Step2Thread(thread2, nThreads, w, h, d, s, data);
            s2t[thread2].start();
        }
        try {
            for (thread2 = 0; thread2 < nThreads; ++thread2) {
                s2t[thread2].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 2 .");
        }
        Step3Thread[] s3t = new Step3Thread[nThreads];
        for (thread = 0; thread < nThreads; ++thread) {
            s3t[thread] = new Step3Thread(thread, nThreads, w, h, d, s, data, scale);
            s3t[thread].start();
        }
        try {
            for (thread = 0; thread < nThreads; ++thread) {
                s3t[thread].join();
            }
        }
        catch (InterruptedException ie) {
            IJ.error((String)"A thread was interrupted in step 3 .");
        }
        float distMax = 0.0f;
        int wh = w * h;
        for (int k = 0; k < d; ++k) {
            float[] sk = s[k];
            for (int ind = 0; ind < wh; ++ind) {
                float dist;
                if (data[k][ind] == 0) {
                    sk[ind] = 0.0f;
                    continue;
                }
                sk[ind] = dist = (float)Math.sqrt(sk[ind]) * scaleXY;
                distMax = dist > distMax ? dist : distMax;
            }
        }
        return res;
    }

    String stripExtension(String name) {
        int dotIndex;
        if (name != null && (dotIndex = name.lastIndexOf(".")) >= 0) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    class Step3Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;
        float scaleZ;

        public Step3Thread(int thread, int nThreads, int w, int h, int d, float[][] s, short[][] data, float scaleZ) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
            this.data = data;
            this.scaleZ = scaleZ * scaleZ;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            float[] tempInt = new float[n];
            float[] tempS = new float[n];
            for (int j = this.thread; j < this.h; j += this.nThreads) {
                for (int i = 0; i < this.w; ++i) {
                    int k;
                    int zStop;
                    int zStart;
                    boolean nonempty = false;
                    for (int k2 = 0; k2 < this.d; ++k2) {
                        tempS[k2] = this.s[k2][i + this.w * j];
                        if (!(tempS[k2] > 0.0f)) continue;
                        nonempty = true;
                    }
                    if (!nonempty) continue;
                    for (zStart = 0; zStart < this.d - 1 && tempS[zStart] == 0.0f; ++zStart) {
                    }
                    if (zStart > 0) {
                        --zStart;
                    }
                    for (zStop = this.d - 1; zStop > 0 && tempS[zStop] == 0.0f; --zStop) {
                    }
                    if (zStop < this.d - 1) {
                        ++zStop;
                    }
                    int offsetXY = j * this.w + i;
                    for (k = 0; k < this.d; ++k) {
                        if (this.data[k][i + this.w * j] == 0) continue;
                        float min = noResult;
                        int zBegin = zStart;
                        int zEnd = zStop;
                        if (zBegin > k) {
                            zBegin = k;
                        }
                        if (zEnd < k) {
                            zEnd = k;
                        }
                        int delta = k - zBegin;
                        for (int z = zBegin; z <= zEnd; ++z) {
                            float test;
                            if (this.data[k][offsetXY] == this.data[z][offsetXY]) {
                                int n2 = delta;
                                int n3 = delta--;
                                test = tempS[z] + (float)(n2 * n3) * this.scaleZ;
                                if (!(test < min)) continue;
                                min = test;
                                continue;
                            }
                            int n4 = delta;
                            int n5 = delta--;
                            test = (float)(n4 * n5) * this.scaleZ;
                            if (!(test < min)) continue;
                            min = test;
                        }
                        tempInt[k] = min;
                    }
                    for (k = 0; k < this.d; ++k) {
                        this.s[k][i + this.w * j] = tempInt[k];
                    }
                }
            }
        }
    }

    class Step2Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;

        public Step2Thread(int thread, int nThreads, int w, int h, int d, float[][] s, short[][] data) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.s = s;
            this.data = data;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            float[] tempInt = new float[n];
            float[] tempS = new float[n];
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                float[] sk = this.s[k];
                short[] dk = this.data[k];
                for (int i = 0; i < this.w; ++i) {
                    int j;
                    boolean nonempty = false;
                    for (j = 0; j < this.h; ++j) {
                        tempS[j] = sk[i + this.w * j];
                        if (!(tempS[j] > 0.0f)) continue;
                        nonempty = true;
                    }
                    if (!nonempty) continue;
                    for (j = 0; j < this.h; ++j) {
                        float min = noResult;
                        float delta = j;
                        for (int y = 0; y < this.h; ++y) {
                            float test;
                            if (dk[i + this.w * j] == dk[i + this.w * y]) {
                                float f = delta;
                                float f2 = delta;
                                delta = f2 - 1.0f;
                                test = tempS[y] + f * f2;
                                if (!(test < min)) continue;
                                min = test;
                                continue;
                            }
                            float f = delta;
                            float f3 = delta;
                            delta = f3 - 1.0f;
                            test = f * f3;
                            if (!(test < min)) continue;
                            min = test;
                        }
                        tempInt[j] = min;
                    }
                    for (j = 0; j < this.h; ++j) {
                        sk[i + this.w * j] = tempInt[j];
                    }
                }
            }
        }
    }

    class Step1Thread
    extends Thread {
        int thread;
        int nThreads;
        int w;
        int h;
        int d;
        float[][] s;
        short[][] data;
        float scaleZ;

        public Step1Thread(int thread, int nThreads, int w, int h, int d, float[][] s, short[][] data, float scaleZ) {
            this.thread = thread;
            this.nThreads = nThreads;
            this.w = w;
            this.h = h;
            this.d = d;
            this.data = data;
            this.s = s;
            this.scaleZ = scaleZ * scaleZ;
        }

        @Override
        public void run() {
            int n = this.w;
            if (this.h > n) {
                n = this.h;
            }
            if (this.d > n) {
                n = this.d;
            }
            int noResult = 3 * (n + 1) * (n + 1);
            for (int k = this.thread; k < this.d; k += this.nThreads) {
                float[] sk = this.s[k];
                short[] dk = this.data[k];
                boolean borderZ = k == 0 || k == this.d - 1;
                for (int j = 0; j < this.h; ++j) {
                    int offsetY = j * this.w;
                    boolean borderY = j == 0 || j == this.h - 1;
                    for (int i = 0; i < this.w; ++i) {
                        float min = noResult;
                        if (borderY || i == 0 || i == this.w - 1) {
                            min = 1.0f;
                        } else {
                            float test;
                            int x;
                            if (borderZ) {
                                min = this.scaleZ;
                            }
                            for (x = i; x < this.w; ++x) {
                                if (dk[x + offsetY] == dk[i + offsetY]) continue;
                                test = i - x;
                                if (!((test *= test) < min)) break;
                                min = test;
                                break;
                            }
                            for (x = i - 1; x >= 0; --x) {
                                if (dk[x + offsetY] == dk[i + offsetY]) continue;
                                test = i - x;
                                if (!((test *= test) < min)) break;
                                min = test;
                                break;
                            }
                        }
                        sk[i + this.w * j] = min;
                    }
                }
            }
        }
    }
}

