/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.blocks.tools.ij;

import icy.plugin.abstract_.Plugin;
import icy.system.IcyHandledException;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import plugins.adufour.blocks.tools.ij.IJBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarImagePlus;
import plugins.adufour.vars.lang.VarString;

public class CallIJPlugin
extends Plugin
implements IJBlock {
    VarImagePlus varIp = new VarImagePlus("Input ImagePlus", null);
    VarString pluginName = new VarString("plug-in name", "");
    VarString pluginParams = new VarString("parameters", "");
    VarImagePlus varActiveIP = new VarImagePlus("Output (active) ImagePlus", null);

    @Override
    public void run() {
        try {
            ImagePlus imgPlus = (ImagePlus)this.varIp.getValue(false);
            String params = (String)this.pluginParams.getValue(false);
            if (imgPlus != null) {
                IJ.run((ImagePlus)imgPlus, (String)((String)this.pluginName.getValue(true)), (String)params);
            } else {
                IJ.run((String)((String)this.pluginName.getValue(true)), (String)params);
            }
            ImagePlus output = null;
            try {
                output = WindowManager.getCurrentImage();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (output == null) {
                output = WindowManager.getTempCurrentImage();
            }
            if (output == null) {
                output = (ImagePlus)this.varIp.getValue();
            }
            this.varActiveIP.setValue((Object)output);
        }
        catch (RuntimeException e) {
            throw new IcyHandledException(e.getLocalizedMessage());
        }
    }

    @Override
    public void declareInput(VarList inputMap) {
        inputMap.add("Input ImagePlus", (Var<?>)this.varIp);
        inputMap.add("ImageJ plug-in name", (Var<?>)this.pluginName);
        inputMap.add("ImageJ plug-in parameters", (Var<?>)this.pluginParams);
    }

    @Override
    public void declareOutput(VarList outputMap) {
        outputMap.add("Output ImagePlus", (Var<?>)this.varActiveIP);
    }
}

