/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.gui.component.ImageComponent;
import icy.gui.util.ComponentUtil;
import icy.image.ImageUtil;
import icy.resource.ResourceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ThumbnailComponent
extends JToggleButton {
    private static final long serialVersionUID = 6742578649112198581L;
    private ImageComponent imageComp;
    private JLabel titleLabel;
    private JLabel infosLabel;
    private JLabel infos2Label;
    private boolean shortDisplay = false;

    public ThumbnailComponent(boolean selectable) {
        this.setMinimumSize(new Dimension(120, 12));
        this.setPreferredSize(new Dimension(160, 160));
        this.initialize();
        this.setEnabled(selectable);
    }

    private void initialize() {
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setLayout(new BorderLayout());
        this.imageComp = new ImageComponent();
        this.add((Component)this.imageComp, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setOpaque(false);
        GridBagLayout gbl_southPanel = new GridBagLayout();
        gbl_southPanel.columnWidths = new int[2];
        gbl_southPanel.rowHeights = new int[4];
        gbl_southPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_southPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        southPanel.setLayout(gbl_southPanel);
        this.titleLabel = new JLabel();
        GridBagConstraints gbc_titleLabel = new GridBagConstraints();
        gbc_titleLabel.fill = 2;
        gbc_titleLabel.insets = new Insets(0, 0, 0, 0);
        gbc_titleLabel.gridx = 0;
        gbc_titleLabel.gridy = 0;
        southPanel.add((Component)this.titleLabel, gbc_titleLabel);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(" ");
        this.titleLabel.setHorizontalTextPosition(10);
        ComponentUtil.setFontBold(this.titleLabel);
        this.infosLabel = new JLabel();
        GridBagConstraints gbc_infosLabel = new GridBagConstraints();
        gbc_infosLabel.fill = 2;
        gbc_infosLabel.insets = new Insets(0, 0, 0, 0);
        gbc_infosLabel.gridx = 0;
        gbc_infosLabel.gridy = 1;
        southPanel.add((Component)this.infosLabel, gbc_infosLabel);
        this.infosLabel.setHorizontalAlignment(0);
        this.infosLabel.setText(" ");
        this.infosLabel.setHorizontalTextPosition(10);
        ComponentUtil.setFontSize(this.infosLabel, 11);
        this.infos2Label = new JLabel();
        GridBagConstraints gbc_infos2Label = new GridBagConstraints();
        gbc_infos2Label.fill = 2;
        gbc_infos2Label.gridx = 0;
        gbc_infos2Label.gridy = 2;
        southPanel.add((Component)this.infos2Label, gbc_infos2Label);
        this.infos2Label.setHorizontalAlignment(0);
        this.infos2Label.setText(" ");
        this.infos2Label.setHorizontalTextPosition(10);
        ComponentUtil.setFontSize(this.infos2Label, 11);
        this.add((Component)southPanel, "South");
    }

    public void setImage(Image img) {
        if (img == null) {
            this.imageComp.setImage(null);
            return;
        }
        Image image = img;
        ImageUtil.waitImageReady(image);
        float ix = image.getWidth(null);
        float iy = image.getHeight(null);
        if (ix <= 0.0f || iy <= 0.0f) {
            image = ResourceUtil.ICON_DELETE;
            ix = image.getWidth(null);
            iy = image.getHeight(null);
        }
        if (this.imageComp.getWidth() != 0 && this.imageComp.getHeight() != 0) {
            float sx = (float)this.imageComp.getWidth() / ix;
            float sy = (float)this.imageComp.getHeight() / iy;
            float s = Math.min(sx, sy);
            int w = (int)(ix * s);
            int h = (int)(iy * s);
            if (w > 0 && h > 0) {
                image = ImageUtil.scaleQuality(img, w, h);
            }
        }
        this.imageComp.setImage(image);
    }

    public boolean getShortDisplay() {
        return this.shortDisplay;
    }

    public void setShortDisplay(boolean value) {
        if (this.shortDisplay != value) {
            this.shortDisplay = value;
            this.titleLabel.setVisible(!value);
            this.infos2Label.setVisible(!value);
        }
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public String getInfos() {
        return this.infosLabel.getText();
    }

    public String getInfos2() {
        return this.infos2Label.getText();
    }

    public void setTitle(String value) {
        this.titleLabel.setText(value);
    }

    public void setInfos(String value) {
        this.infosLabel.setText(value);
    }

    public void setInfos2(String value) {
        this.infos2Label.setText(value);
    }
}

