/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTextField;
import icy.gui.dialog.MessageDialog;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.math.MathUtil;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.system.SystemUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class GeneralPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = -5376356916415550024L;
    public static final String NODE_NAME = "General";
    JCheckBox exitConfirm;
    private JCheckBox sequencePersistence;
    private JCheckBox saveNewSequence;
    JCheckBox autoUpdateCheckBox;
    private JCheckBox usageStatistics;
    private JSpinner maxMemoryMBSpinner;
    private JLabel maxMemoryMBLabel;
    private JSpinner cacheMemoryPercent;
    IcyTextField cachePath;
    private JButton setCachePathButton;
    private JButton reenableAllToolTipButton;
    private JButton reenableAllConfirmButton;
    private JSeparator separator;
    private JLabel label;
    private JPanel panel;

    GeneralPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        int maxMemMB = (int)MathUtil.prevMultiple(ApplicationPreferences.getMaxMemoryMBLimit(), 32.0);
        this.initializeGUI(maxMemMB);
        String maxMemoryMess = " MB  (max = " + maxMemMB + " MB";
        maxMemoryMess = SystemUtil.is32bits() && SystemUtil.getTotalMemory() / 0x100000L >= 1500L ? String.valueOf(maxMemoryMess) + " - use 64bit JVM to allow more)" : String.valueOf(maxMemoryMess) + ")";
        this.reenableAllConfirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPreferences.getPreferencesConfirms().removeChildren();
                GeneralPreferences.getPreferencesConfirms().clear();
                GeneralPreferencePanel.this.exitConfirm.setSelected(true);
                MessageDialog.showDialog("All confirmation dialogs are now enabled again !");
            }
        });
        this.reenableAllToolTipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPreferences.getPreferencesToolTips().removeChildren();
                GeneralPreferences.getPreferencesToolTips().clear();
                MessageDialog.showDialog("All tooltips are now enabled again !");
            }
        });
        this.setCachePathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(new File(GeneralPreferencePanel.this.cachePath.getText()));
                fc.setFileSelectionMode(1);
                if (fc.showSaveDialog(GeneralPreferencePanel.this) == 0) {
                    GeneralPreferencePanel.this.cachePath.setText(fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.load();
    }

    private void initializeGUI(int maxMemMB) {
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 200;
        nArray[2] = 80;
        nArray[4] = 4;
        gbl_mainPanel.columnWidths = nArray;
        int[] nArray2 = new int[13];
        nArray2[5] = 4;
        nArray2[11] = 8;
        gbl_mainPanel.rowHeights = nArray2;
        gbl_mainPanel.columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gbl_mainPanel);
        this.exitConfirm = new JCheckBox("Show confirmation when exiting application");
        GridBagConstraints gbc_exitConfirm = new GridBagConstraints();
        gbc_exitConfirm.anchor = 17;
        gbc_exitConfirm.gridwidth = 4;
        gbc_exitConfirm.insets = new Insets(0, 0, 5, 5);
        gbc_exitConfirm.gridx = 0;
        gbc_exitConfirm.gridy = 0;
        this.mainPanel.add((Component)this.exitConfirm, gbc_exitConfirm);
        this.autoUpdateCheckBox = new JCheckBox("Enable application update");
        GridBagConstraints gbc_autoUpdateCheckBox = new GridBagConstraints();
        gbc_autoUpdateCheckBox.anchor = 17;
        gbc_autoUpdateCheckBox.gridwidth = 4;
        gbc_autoUpdateCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_autoUpdateCheckBox.gridx = 0;
        gbc_autoUpdateCheckBox.gridy = 1;
        this.mainPanel.add((Component)this.autoUpdateCheckBox, gbc_autoUpdateCheckBox);
        this.autoUpdateCheckBox.setToolTipText("Enable automatic update for application as soon a new version is available");
        this.sequencePersistence = new JCheckBox("Enable sequence persistence");
        GridBagConstraints gbc_sequencePersistence = new GridBagConstraints();
        gbc_sequencePersistence.anchor = 17;
        gbc_sequencePersistence.gridwidth = 4;
        gbc_sequencePersistence.insets = new Insets(0, 0, 5, 5);
        gbc_sequencePersistence.gridx = 0;
        gbc_sequencePersistence.gridy = 2;
        this.mainPanel.add((Component)this.sequencePersistence, gbc_sequencePersistence);
        this.sequencePersistence.setToolTipText("Enable the XML persistence for sequence (file is automatically loaded/saved when sequence is opened/closed)");
        this.saveNewSequence = new JCheckBox("Ask to save new sequence when closing them");
        GridBagConstraints gbc_saveNewSequence = new GridBagConstraints();
        gbc_saveNewSequence.anchor = 17;
        gbc_saveNewSequence.gridwidth = 4;
        gbc_saveNewSequence.insets = new Insets(0, 0, 5, 5);
        gbc_saveNewSequence.gridx = 0;
        gbc_saveNewSequence.gridy = 3;
        this.mainPanel.add((Component)this.saveNewSequence, gbc_saveNewSequence);
        this.usageStatistics = new JCheckBox("Usage statistics report");
        GridBagConstraints gbc_usageStatistics = new GridBagConstraints();
        gbc_usageStatistics.gridwidth = 4;
        gbc_usageStatistics.anchor = 17;
        gbc_usageStatistics.insets = new Insets(0, 0, 5, 5);
        gbc_usageStatistics.gridx = 0;
        gbc_usageStatistics.gridy = 4;
        this.mainPanel.add((Component)this.usageStatistics, gbc_usageStatistics);
        this.usageStatistics.setToolTipText("Report is 100% anonymous, very light on network trafic and help developers so keep it enabled please :)");
        this.separator = new JSeparator();
        GridBagConstraints gbc_separator = new GridBagConstraints();
        gbc_separator.anchor = 17;
        gbc_separator.fill = 3;
        gbc_separator.gridwidth = 4;
        gbc_separator.insets = new Insets(0, 0, 5, 5);
        gbc_separator.gridx = 0;
        gbc_separator.gridy = 5;
        this.mainPanel.add((Component)this.separator, gbc_separator);
        JLabel label_1 = new JLabel(" Max memory (max = " + maxMemMB + " MB)");
        GridBagConstraints gbc_label_1 = new GridBagConstraints();
        gbc_label_1.gridwidth = 2;
        gbc_label_1.anchor = 17;
        gbc_label_1.insets = new Insets(0, 0, 5, 5);
        gbc_label_1.gridx = 0;
        gbc_label_1.gridy = 6;
        this.mainPanel.add((Component)label_1, gbc_label_1);
        this.maxMemoryMBSpinner = new JSpinner(new SpinnerNumberModel(128, 64, maxMemMB, 32));
        GridBagConstraints gbc_maxMemoryMBSpinner = new GridBagConstraints();
        gbc_maxMemoryMBSpinner.fill = 2;
        gbc_maxMemoryMBSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_maxMemoryMBSpinner.gridx = 2;
        gbc_maxMemoryMBSpinner.gridy = 6;
        this.mainPanel.add((Component)this.maxMemoryMBSpinner, gbc_maxMemoryMBSpinner);
        this.maxMemoryMBSpinner.setToolTipText("Change the maximum memory available for application");
        this.maxMemoryMBLabel = new JLabel(" MB");
        GridBagConstraints gbc_lblMbmax = new GridBagConstraints();
        gbc_lblMbmax.anchor = 17;
        gbc_lblMbmax.insets = new Insets(0, 0, 5, 5);
        gbc_lblMbmax.gridx = 3;
        gbc_lblMbmax.gridy = 6;
        this.mainPanel.add((Component)this.maxMemoryMBLabel, gbc_lblMbmax);
        JLabel lblMemoryAllocatedFor = new JLabel(" Memory allocated for data cache ");
        lblMemoryAllocatedFor.setToolTipText("Change the memory portion allocated for image data caching (higher value allow faster image processing but less memory for others taks)");
        GridBagConstraints gbc_lblMemoryAllocatedFor = new GridBagConstraints();
        gbc_lblMemoryAllocatedFor.gridwidth = 2;
        gbc_lblMemoryAllocatedFor.anchor = 17;
        gbc_lblMemoryAllocatedFor.insets = new Insets(0, 0, 5, 5);
        gbc_lblMemoryAllocatedFor.gridx = 0;
        gbc_lblMemoryAllocatedFor.gridy = 7;
        this.mainPanel.add((Component)lblMemoryAllocatedFor, gbc_lblMemoryAllocatedFor);
        this.cacheMemoryPercent = new JSpinner(new SpinnerNumberModel(40, 10, 80, 5));
        GridBagConstraints gbc_cacheMemoryPercent = new GridBagConstraints();
        gbc_cacheMemoryPercent.fill = 2;
        gbc_cacheMemoryPercent.insets = new Insets(0, 0, 5, 5);
        gbc_cacheMemoryPercent.gridx = 2;
        gbc_cacheMemoryPercent.gridy = 7;
        this.mainPanel.add((Component)this.cacheMemoryPercent, gbc_cacheMemoryPercent);
        this.cacheMemoryPercent.setToolTipText("Change the memory portion allocated for image data caching (higher value allow faster image processing but less memory for others taks)");
        this.label = new JLabel("%");
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.anchor = 17;
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 3;
        gbc_label.gridy = 7;
        this.mainPanel.add((Component)this.label, gbc_label);
        JLabel lblCacheLocation = new JLabel(" Disk data cache location");
        lblCacheLocation.setToolTipText("Folder used to store image data cache (it's recommended to use fast storage location as SSD disk)");
        GridBagConstraints gbc_lblCacheLocation = new GridBagConstraints();
        gbc_lblCacheLocation.anchor = 17;
        gbc_lblCacheLocation.insets = new Insets(0, 0, 5, 5);
        gbc_lblCacheLocation.gridx = 0;
        gbc_lblCacheLocation.gridy = 8;
        this.mainPanel.add((Component)lblCacheLocation, gbc_lblCacheLocation);
        this.cachePath = new IcyTextField();
        GridBagConstraints gbc_cachePath = new GridBagConstraints();
        gbc_cachePath.fill = 2;
        gbc_cachePath.gridwidth = 2;
        gbc_cachePath.insets = new Insets(0, 0, 5, 5);
        gbc_cachePath.gridx = 1;
        gbc_cachePath.gridy = 8;
        this.mainPanel.add((Component)this.cachePath, gbc_cachePath);
        this.cachePath.setToolTipText("Folder used to store image data cache (it's recommended to use fast storage location as SSD disk)");
        this.cachePath.setColumns(10);
        this.setCachePathButton = new JButton("...");
        this.setCachePathButton.setPreferredSize(new Dimension(32, 23));
        GridBagConstraints gbc_setCachePathButton = new GridBagConstraints();
        gbc_setCachePathButton.anchor = 17;
        gbc_setCachePathButton.insets = new Insets(0, 0, 5, 5);
        gbc_setCachePathButton.gridx = 3;
        gbc_setCachePathButton.gridy = 8;
        this.mainPanel.add((Component)this.setCachePathButton, gbc_setCachePathButton);
        this.panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.gridwidth = 4;
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 10;
        this.mainPanel.add((Component)this.panel, gbc_panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        int[] nArray3 = new int[6];
        nArray3[0] = 16;
        nArray3[4] = 16;
        gbl_panel.columnWidths = nArray3;
        gbl_panel.rowHeights = new int[2];
        gbl_panel.columnWeights = new double[]{0.0, 1.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.panel.setLayout(gbl_panel);
        this.reenableAllToolTipButton = new JButton("Reactivate tooltips");
        GridBagConstraints gbc_reenableAllToolTipButton = new GridBagConstraints();
        gbc_reenableAllToolTipButton.insets = new Insets(0, 0, 0, 5);
        gbc_reenableAllToolTipButton.gridx = 1;
        gbc_reenableAllToolTipButton.gridy = 0;
        this.panel.add((Component)this.reenableAllToolTipButton, gbc_reenableAllToolTipButton);
        this.reenableAllToolTipButton.setToolTipText("All hidden tooltips will be made visible again");
        this.reenableAllConfirmButton = new JButton("Reactivate confirmations");
        GridBagConstraints gbc_reenableAllConfirmButton = new GridBagConstraints();
        gbc_reenableAllConfirmButton.insets = new Insets(0, 0, 0, 5);
        gbc_reenableAllConfirmButton.gridx = 3;
        gbc_reenableAllConfirmButton.gridy = 0;
        this.panel.add((Component)this.reenableAllConfirmButton, gbc_reenableAllConfirmButton);
        this.reenableAllConfirmButton.setToolTipText("All hidden confimation dialogs be made visible again");
        this.mainPanel.validate();
    }

    @Override
    protected void load() {
        this.maxMemoryMBSpinner.setValue(ApplicationPreferences.getMaxMemoryMB());
        this.cacheMemoryPercent.setValue(ApplicationPreferences.getCacheMemoryPercent());
        this.cachePath.setText(ApplicationPreferences.getCachePath());
        this.exitConfirm.setSelected(GeneralPreferences.getExitConfirm());
        this.sequencePersistence.setSelected(GeneralPreferences.getSequencePersistence());
        this.saveNewSequence.setSelected(GeneralPreferences.getSaveNewSequence());
        this.autoUpdateCheckBox.setSelected(GeneralPreferences.getAutomaticUpdate());
        this.usageStatistics.setSelected(GeneralPreferences.getUsageStatisticsReport());
    }

    @Override
    protected void save() {
        int intValue = (Integer)this.maxMemoryMBSpinner.getValue();
        if (ApplicationPreferences.getMaxMemoryMB() != intValue) {
            this.getPreferenceFrame().setNeedRestart();
        }
        ApplicationPreferences.setMaxMemoryMB(intValue);
        intValue = (Integer)this.cacheMemoryPercent.getValue();
        if (ApplicationPreferences.getCacheMemoryPercent() != intValue) {
            this.getPreferenceFrame().setNeedRestart();
        }
        ApplicationPreferences.setCacheMemoryPercent(intValue);
        String stringValue = this.cachePath.getText();
        if (!StringUtil.equals(ApplicationPreferences.getCachePath(), stringValue)) {
            this.getPreferenceFrame().setNeedRestart();
        }
        ApplicationPreferences.setCachePath(stringValue);
        GeneralPreferences.setExitConfirm(this.exitConfirm.isSelected());
        GeneralPreferences.setSequencePersistence(this.sequencePersistence.isSelected());
        GeneralPreferences.setSaveNewSequence(this.saveNewSequence.isSelected());
        GeneralPreferences.setAutomaticUpdate(this.autoUpdateCheckBox.isSelected());
        GeneralPreferences.setUsageStatisticsReport(this.usageStatistics.isSelected());
    }
}

