/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.dialog.ConfirmDialog;
import icy.gui.frame.IcyFrame;
import icy.gui.preferences.GUICanvasPreferencePanel;
import icy.gui.preferences.GeneralPreferencePanel;
import icy.gui.preferences.MagicWandPreferencePanel;
import icy.gui.preferences.NetworkPreferencePanel;
import icy.gui.preferences.PluginLocalPreferencePanel;
import icy.gui.preferences.PluginOnlinePreferencePanel;
import icy.gui.preferences.PluginPreferencePanel;
import icy.gui.preferences.PluginStartupPreferencePanel;
import icy.gui.preferences.PreferencePanel;
import icy.gui.preferences.RepositoryPreferencePanel;
import icy.gui.preferences.WorkspaceLocalPreferencePanel;
import icy.gui.preferences.WorkspaceOnlinePreferencePanel;
import icy.gui.preferences.WorkspacePreferencePanel;
import icy.gui.util.ComponentUtil;
import icy.gui.util.WindowPositionSaver;
import icy.main.Icy;
import icy.preferences.IcyPreferences;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class PreferenceFrame
extends IcyFrame
implements TreeSelectionListener {
    public static final String NODE_NAME = "Preferences";
    private static PreferenceFrame instance = null;
    List<PreferencePanel> preferencePanels;
    private JTree tree;
    private JSplitPane mainPanel;
    private DefaultMutableTreeNode node;
    boolean needRestart;
    boolean doRestart;
    WindowPositionSaver positionSaver;

    public PreferenceFrame(String section) {
        super(NODE_NAME, true, true, false, false);
        if (instance != null) {
            instance.toFront();
            return;
        }
        instance = this;
        this.positionSaver = new WindowPositionSaver(this, "frame/preference", new Point(100, 100), new Dimension(640, 480));
        this.needRestart = false;
        this.doRestart = false;
        this.preferencePanels = new ArrayList<PreferencePanel>();
        this.preferencePanels.add(new GeneralPreferencePanel(this));
        this.preferencePanels.add(new GUICanvasPreferencePanel(this));
        this.preferencePanels.add(new MagicWandPreferencePanel(this));
        this.preferencePanels.add(new NetworkPreferencePanel(this));
        this.preferencePanels.add(new RepositoryPreferencePanel(this));
        this.preferencePanels.add(new PluginPreferencePanel(this));
        this.preferencePanels.add(new PluginLocalPreferencePanel(this));
        this.preferencePanels.add(new PluginOnlinePreferencePanel(this));
        this.preferencePanels.add(new PluginStartupPreferencePanel(this));
        this.preferencePanels.add(new WorkspacePreferencePanel(this));
        this.preferencePanels.add(new WorkspaceLocalPreferencePanel(this));
        this.preferencePanels.add(new WorkspaceOnlinePreferencePanel(this));
        this.node = new DefaultMutableTreeNode(NODE_NAME);
        for (PreferencePanel panel : this.preferencePanels) {
            this.getNode(panel.getParentName()).add(panel.getNode());
        }
        this.tree = new JTree(this.node);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setSelectionRow(0);
        ComponentUtil.expandAllTree(this.tree);
        this.tree.setToggleClickCount(0);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        treeScrollPane.setMinimumSize(new Dimension(136, 100));
        this.mainPanel = new JSplitPane(1, treeScrollPane, null);
        this.mainPanel.setDividerSize(6);
        this.mainPanel.setDividerLocation(150);
        JButton resetButton = new JButton("Reset to default");
        JButton cancelButton = new JButton("Cancel");
        JButton okButton = new JButton("Ok");
        JButton applyButton = new JButton("Apply");
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfirmDialog.confirm("Reset all setting to default values ?")) {
                    IcyPreferences.clear();
                    for (PreferencePanel panel : PreferenceFrame.this.preferencePanels) {
                        panel.load();
                    }
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceFrame.this.close();
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PreferencePanel panel : PreferenceFrame.this.preferencePanels) {
                    panel.save();
                }
                PreferenceFrame.this.doRestart = PreferenceFrame.this.needRestart;
                PreferenceFrame.this.close();
            }
        });
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PreferencePanel panel : PreferenceFrame.this.preferencePanels) {
                    panel.save();
                }
                PreferenceFrame.this.doRestart = PreferenceFrame.this.needRestart;
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 2));
        bottomPanel.add(resetButton);
        bottomPanel.add(Box.createHorizontalStrut(8));
        bottomPanel.add(Box.createHorizontalGlue());
        bottomPanel.add(applyButton);
        bottomPanel.add(Box.createHorizontalStrut(8));
        bottomPanel.add(okButton);
        bottomPanel.add(Box.createHorizontalStrut(8));
        bottomPanel.add(cancelButton);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 3));
        tmpPanel.add(new JSeparator());
        tmpPanel.add(bottomPanel);
        this.setLayout(new BorderLayout());
        this.add(this.mainPanel, "Center");
        this.add(tmpPanel, "South");
        this.updateRightPanel();
        this.setMinimumSize(new Dimension(640, 440));
        this.setPreferredSize(new Dimension(800, 600));
        this.addToDesktopPane();
        this.setVisible(true);
        if (!StringUtil.isEmpty(section)) {
            this.setSelection(section);
        }
    }

    @Override
    public void onClosed() {
        if (this.preferencePanels != null) {
            for (PreferencePanel panel : this.preferencePanels) {
                panel.closed();
            }
            instance = null;
            if (this.doRestart) {
                Icy.confirmRestart();
                this.doRestart = false;
            }
        }
        super.onClosed();
    }

    private DefaultMutableTreeNode getNode(String name) {
        if (this.node.getUserObject().equals(name)) {
            return this.node;
        }
        int len = this.node.getChildCount();
        int i = 0;
        while (i < len) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.node.getChildAt(i);
            if (n.getUserObject().equals(name)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    private void updateRightPanel() {
        Object selected = this.tree.getSelectionPath().getLastPathComponent();
        for (PreferencePanel panel : this.preferencePanels) {
            if (panel.getNode().equals(selected)) {
                int divLocation = this.mainPanel.getDividerLocation();
                panel.setVisible(true);
                this.mainPanel.setRightComponent(panel);
                this.mainPanel.setDividerLocation(divLocation);
                continue;
            }
            panel.setVisible(true);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateRightPanel();
    }

    public void setSelection(String selection) {
        for (PreferencePanel panel : this.preferencePanels) {
            DefaultMutableTreeNode node = panel.getNode();
            if (!node.getUserObject().equals(selection)) continue;
            this.tree.setSelectionPath(ComponentUtil.buildTreePath(node));
            return;
        }
    }

    public void setNeedRestart() {
        this.needRestart = true;
    }
}

