/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.dialog.ActionDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.sequence.tools.SequenceDimensionMergePanel;
import icy.gui.util.ComponentUtil;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.AbstractSequenceModel;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;

public class SequenceDimensionMergeFrame
extends ActionDialog {
    private static final long serialVersionUID = 840989682349623342L;
    final SequenceDimensionMergePanel mergePanel;

    public SequenceDimensionMergeFrame(DimensionId dim) {
        super(String.valueOf(dim.toString()) + " Dimension merge");
        this.mergePanel = new SequenceDimensionMergePanel(dim);
        this.mergePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.mainPanel.add((Component)this.mergePanel, "Center");
        this.validate();
        this.mergePanel.setModel(new SequenceDimensionMergeFrameModel());
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        try (ProgressFrame pf = new ProgressFrame("Merging sequences...");){
                            Sequence out;
                            switch (SequenceDimensionMergeFrame.this.getDimensionId()) {
                                default: {
                                    out = SequenceUtil.concatC((this).SequenceDimensionMergeFrame.this.mergePanel.getSequences(), (this).SequenceDimensionMergeFrame.this.mergePanel.getSelectedChannels(), (this).SequenceDimensionMergeFrame.this.mergePanel.isFillEmptyImageEnabled(), (this).SequenceDimensionMergeFrame.this.mergePanel.isFitImagesEnabled(), pf);
                                    break;
                                }
                                case Z: {
                                    out = SequenceUtil.concatZ((this).SequenceDimensionMergeFrame.this.mergePanel.getSequences(), (this).SequenceDimensionMergeFrame.this.mergePanel.isInterlaceEnabled(), (this).SequenceDimensionMergeFrame.this.mergePanel.isFillEmptyImageEnabled(), (this).SequenceDimensionMergeFrame.this.mergePanel.isFitImagesEnabled(), pf);
                                    break;
                                }
                                case T: {
                                    out = SequenceUtil.concatT((this).SequenceDimensionMergeFrame.this.mergePanel.getSequences(), (this).SequenceDimensionMergeFrame.this.mergePanel.isInterlaceEnabled(), (this).SequenceDimensionMergeFrame.this.mergePanel.isFillEmptyImageEnabled(), (this).SequenceDimensionMergeFrame.this.mergePanel.isFitImagesEnabled(), pf);
                                }
                            }
                            Icy.getMainInterface().addSequence(out);
                        }
                    }
                });
            }
        });
        this.setSize(420, 520);
        ComponentUtil.center(this);
        this.setVisible(true);
    }

    DimensionId getDimensionId() {
        return this.mergePanel.getDimensionId();
    }

    private class SequenceDimensionMergeFrameModel
    extends AbstractSequenceModel {
        @Override
        public int getSizeX() {
            return SequenceUtil.getMaxDim(SequenceDimensionMergeFrame.this.mergePanel.getSequences(), DimensionId.X);
        }

        @Override
        public int getSizeY() {
            return SequenceUtil.getMaxDim(SequenceDimensionMergeFrame.this.mergePanel.getSequences(), DimensionId.Y);
        }

        @Override
        public int getSizeZ() {
            if (SequenceDimensionMergeFrame.this.getDimensionId() != DimensionId.Z) {
                return SequenceUtil.getMaxDim(SequenceDimensionMergeFrame.this.mergePanel.getSequences(), DimensionId.Z);
            }
            int size = 0;
            Sequence[] sequenceArray = SequenceDimensionMergeFrame.this.mergePanel.getSequences();
            int n = sequenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sequence seq = sequenceArray[n2];
                size += seq.getSizeZ();
                ++n2;
            }
            return size;
        }

        @Override
        public int getSizeT() {
            if (SequenceDimensionMergeFrame.this.getDimensionId() != DimensionId.T) {
                return SequenceUtil.getMaxDim(SequenceDimensionMergeFrame.this.mergePanel.getSequences(), DimensionId.T);
            }
            int size = 0;
            Sequence[] sequenceArray = SequenceDimensionMergeFrame.this.mergePanel.getSequences();
            int n = sequenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sequence seq = sequenceArray[n2];
                size += seq.getSizeT();
                ++n2;
            }
            return size;
        }

        @Override
        public int getSizeC() {
            int size = 0;
            if (SequenceDimensionMergeFrame.this.getDimensionId() != DimensionId.C) {
                Sequence[] sequenceArray = SequenceDimensionMergeFrame.this.mergePanel.getSequences();
                int n = sequenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Sequence seq = sequenceArray[n2];
                    size = Math.max(size, seq.getSizeC());
                    ++n2;
                }
                return size;
            }
            return SequenceDimensionMergeFrame.this.mergePanel.getSelectedChannels().length;
        }

        @Override
        public BufferedImage getImage(int t, int z) {
            IcyBufferedImage image;
            Sequence[] sequences = SequenceDimensionMergeFrame.this.mergePanel.getSequences();
            int sizeX = SequenceUtil.getMaxDim(sequences, DimensionId.X);
            int sizeY = SequenceUtil.getMaxDim(sequences, DimensionId.Y);
            int sizeC = this.getSizeC();
            switch (SequenceDimensionMergeFrame.this.getDimensionId()) {
                default: {
                    image = SequenceUtil.MergeCHelper.getImage(sequences, SequenceDimensionMergeFrame.this.mergePanel.getSelectedChannels(), sizeX, sizeY, t, z, SequenceDimensionMergeFrame.this.mergePanel.isFillEmptyImageEnabled(), SequenceDimensionMergeFrame.this.mergePanel.isFitImagesEnabled());
                    break;
                }
                case Z: {
                    image = SequenceUtil.MergeZHelper.getImage(sequences, sizeX, sizeY, sizeC, t, z, SequenceDimensionMergeFrame.this.mergePanel.isInterlaceEnabled(), SequenceDimensionMergeFrame.this.mergePanel.isFillEmptyImageEnabled(), SequenceDimensionMergeFrame.this.mergePanel.isFitImagesEnabled());
                    break;
                }
                case T: {
                    image = SequenceUtil.MergeTHelper.getImage(sequences, sizeX, sizeY, sizeC, t, z, SequenceDimensionMergeFrame.this.mergePanel.isInterlaceEnabled(), SequenceDimensionMergeFrame.this.mergePanel.isFillEmptyImageEnabled(), SequenceDimensionMergeFrame.this.mergePanel.isFitImagesEnabled());
                }
            }
            return image;
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            IcyBufferedImage img = (IcyBufferedImage)this.getImage(t, z);
            if (img != null) {
                return img.getImage(c);
            }
            return null;
        }
    }
}

