/*
 * Decompiled with CFR 0.152.
 */
package icy.main;

import icy.action.ActionManager;
import icy.common.Version;
import icy.file.FileUtil;
import icy.file.Loader;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.frame.ExitFrame;
import icy.gui.frame.IcyExternalFrame;
import icy.gui.frame.SplashScreenFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.inspector.InspectorPanel;
import icy.gui.main.IcyDesktopPane;
import icy.gui.main.MainFrame;
import icy.gui.main.MainInterface;
import icy.gui.main.MainInterfaceBatch;
import icy.gui.main.MainInterfaceGui;
import icy.gui.system.NewVersionFrame;
import icy.gui.util.LookAndFeelUtil;
import icy.image.cache.ImageCache;
import icy.imagej.ImageJPatcher;
import icy.imagej.ImageJWrapper;
import icy.math.UnitUtil;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.PluginUpdater;
import icy.plugin.abstract_.Plugin;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.preferences.IcyPreferences;
import icy.preferences.PluginPreferences;
import icy.sequence.Sequence;
import icy.sequence.SequencePrefetcher;
import icy.system.AppleUtil;
import icy.system.IcyExceptionHandler;
import icy.system.SingleInstanceCheck;
import icy.system.SystemUtil;
import icy.system.audit.Audit;
import icy.system.thread.ThreadUtil;
import icy.update.IcyUpdater;
import icy.util.StringUtil;
import icy.workspace.WorkspaceInstaller;
import icy.workspace.WorkspaceLoader;
import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.io.File;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import loci.common.DebugTools;
import vtk.vtkNativeLibrary;
import vtk.vtkVersion;

public class Icy {
    public static final String LIB_PATH = "lib";
    public static final int EXIT_FORCE_DELAY = 3000;
    public static Version version = new Version("2.4.2.0");
    private static MainInterface mainInterface = null;
    static FileLock lock = null;
    static SplashScreenFrame splashScreen = null;
    static boolean vtkLibraryLoaded = false;
    static boolean itkLibraryLoaded = false;
    static boolean noSplash = false;
    static boolean noHLExit = false;
    static boolean exiting = false;
    static String[] args;
    static String[] pluginArgs;
    static String startupPluginName;
    static Plugin startupPlugin;
    static String startupImage;
    static ExitFrame exitFrame;
    static Thread terminer;
    private static boolean disableCache;
    private static boolean disableNetwork;

    static {
        exitFrame = null;
        terminer = null;
        disableCache = false;
        disableNetwork = false;
    }

    public static void main(String[] args) {
        boolean headless = false;
        try {
            System.out.println("Initializing...");
            System.out.println();
            headless = Icy.handleAppArgs(args);
            if (!headless && SystemUtil.isHeadLess()) {
                headless = true;
            }
            IcyPreferences.init();
            lock = SingleInstanceCheck.lock("icy");
            if (lock == null && !headless) {
                IdConfirmDialog.Confirmer confirmer = new IdConfirmDialog.Confirmer("Confirmation", "Icy is already running on this computer. Start anyway ?", 0, "singleInstance");
                ThreadUtil.invokeNow(confirmer);
                if (!confirmer.getResult()) {
                    System.out.println("Exiting...");
                    IcyPreferences.save();
                    System.exit(0);
                    return;
                }
            }
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            DebugTools.enableLogging("ERROR");
            if (SystemUtil.isMac()) {
                System.setProperty("jogl.gljpanel.noglsl", "true");
            }
            if (!headless && !noSplash) {
                splashScreen = new SplashScreenFrame();
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        splashScreen.setVisible(true);
                    }
                });
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ImageCache.isEnabled();
                }
            }, "Initializer: Cache").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    NetworkUtil.init();
                }
            }, "Initializer: Network").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PluginLoader.reloadAsynch();
                    WorkspaceLoader.reloadAsynch();
                }
            }, "Initializer: Plugin and WS").start();
            try {
                ImageJPatcher.applyPatches();
            }
            catch (Throwable t) {
                System.err.println("Error while patching ImageJ classes:");
                IcyExceptionHandler.showErrorMessage(t, false);
            }
            mainInterface = headless ? new MainInterfaceBatch() : new MainInterfaceGui();
        }
        catch (Throwable t) {
            Icy.fatalError(t, headless);
        }
        if (!headless) {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    try {
                        LookAndFeelUtil.init();
                        Icy.getMainInterface().init();
                    }
                    catch (Throwable t) {
                        Icy.fatalError(t, false);
                    }
                }
            });
        } else {
            Icy.getMainInterface().init();
        }
        if (splashScreen != null) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    splashScreen.dispose();
                    splashScreen = null;
                }
            });
        }
        System.out.println(String.valueOf(SystemUtil.getJavaName()) + " " + SystemUtil.getJavaVersion() + " (" + SystemUtil.getJavaArchDataModel() + " bit)");
        System.out.println("Running on " + SystemUtil.getOSName() + " " + SystemUtil.getOSVersion() + " (" + SystemUtil.getOSArch() + ")");
        System.out.println("Number of processors : " + SystemUtil.getNumberOfCPUs());
        System.out.println("System total memory : " + UnitUtil.getBytesString(SystemUtil.getTotalMemory()));
        System.out.println("System available memory : " + UnitUtil.getBytesString(SystemUtil.getFreeMemory()));
        System.out.println("Max java memory : " + UnitUtil.getBytesString(SystemUtil.getJavaMaxMemory()));
        if (Icy.isCacheDisabled()) {
            System.out.println("Image cache is disabled.");
            InspectorPanel inspector = Icy.getMainInterface().getInspector();
            if (inspector != null) {
                inspector.imageCacheDisabled();
            }
        } else if (InspectorPanel.getVirtualMode()) {
            ImageCache.init(ApplicationPreferences.getCacheMemoryMB(), ApplicationPreferences.getCachePath());
        }
        if (headless) {
            System.out.println("Headless mode.");
        }
        System.out.println();
        if (!headless && SystemUtil.isMac()) {
            AppleUtil.init();
        }
        IcyExceptionHandler.init();
        if (!headless) {
            ActionManager.init();
        }
        Icy.nativeLibrariesInit();
        if (!ApplicationPreferences.getVersion().equals(version)) {
            String changeLog;
            if (!headless && !StringUtil.isEmpty(changeLog = Icy.getChangeLog())) {
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        new NewVersionFrame(Icy.getChangeLog());
                    }
                });
            }
            GeneralPreferences.setLastUpdateCheckTime(0L);
        }
        long currentTime = System.currentTimeMillis();
        long halfDayInterval = 43200000L;
        if (!Icy.isNetworkDisabled() && currentTime > GeneralPreferences.getLastUpdateCheckTime() + 43200000L) {
            if (GeneralPreferences.getAutomaticUpdate()) {
                IcyUpdater.checkUpdate(true);
            }
            if (PluginPreferences.getAutomaticUpdate()) {
                PluginUpdater.checkUpdate(true);
            }
            GeneralPreferences.setLastUpdateCheckTime(currentTime);
        }
        ApplicationPreferences.setVersion(version);
        System.out.println();
        System.out.println("Icy Version " + version + " started !");
        System.out.println();
        Icy.checkParameters();
        if (startupImage != null) {
            Icy.getMainInterface().addSequence(Loader.loadSequence(FileUtil.getGenericPath(startupImage), 0, false));
        }
        while (PluginUpdater.isCheckingForUpdate() || PluginInstaller.isProcessing() || WorkspaceInstaller.isProcessing()) {
            ThreadUtil.sleep(1);
        }
        if (startupPluginName != null) {
            PluginLoader.waitWhileLoading();
            PluginDescriptor plugin = PluginLoader.getPlugin(startupPluginName);
            if (plugin == null) {
                System.err.println("Could not launch plugin '" + startupPluginName + "': the plugin was not found.");
                System.err.println("Be sure you correctly wrote the complete class name and respected the case.");
                System.err.println("Ex: plugins.mydevid.analysis.MyPluginClass");
            } else {
                startupPlugin = PluginLauncher.start(plugin);
            }
        }
        if (headless && !noHLExit) {
            Icy.exit(false);
        }
    }

    private static boolean handleAppArgs(String[] args) {
        ArrayList<String> pluginArgsList = new ArrayList<String>();
        startupImage = null;
        startupPluginName = null;
        startupPlugin = null;
        boolean execute = false;
        boolean headless = false;
        disableCache = false;
        disableNetwork = false;
        Icy.args = args;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (startupPluginName != null) {
                pluginArgsList.add(arg);
            } else if (execute) {
                startupPluginName = arg;
            } else if (arg.equalsIgnoreCase("--disableJCL") || arg.equalsIgnoreCase("-dJCL")) {
                PluginLoader.setJCLDisabled(true);
            } else if (arg.equalsIgnoreCase("--headless") || arg.equalsIgnoreCase("-hl")) {
                headless = true;
            } else if (arg.equalsIgnoreCase("--nocache") || arg.equalsIgnoreCase("-nc")) {
                disableCache = true;
            } else if (arg.equalsIgnoreCase("--nonetwork") || arg.equalsIgnoreCase("-nnt")) {
                disableNetwork = true;
            } else if (arg.equalsIgnoreCase("--nosplash") || arg.equalsIgnoreCase("-ns")) {
                noSplash = true;
            } else if (arg.equalsIgnoreCase("--noHLexit") || arg.equalsIgnoreCase("-nhle")) {
                noHLExit = true;
            } else if (arg.equalsIgnoreCase("--execute") || arg.equalsIgnoreCase("-x")) {
                execute = true;
            } else {
                startupImage = arg;
            }
            ++n2;
        }
        pluginArgs = pluginArgsList.toArray(new String[pluginArgsList.size()]);
        return headless;
    }

    static void checkParameters() {
        String text;
        double javaVersion;
        if (SystemUtil.isWindows64() && SystemUtil.is32bits()) {
            String text2 = "You're using a 32 bits Java with a 64 bits OS, try to upgrade to 64 bits java for better performance !";
            System.out.println("Warning: You're using a 32 bits Java with a 64 bits OS, try to upgrade to 64 bits java for better performance !");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html>You're using a 32 bits Java with a 64 bits OS, try to upgrade to 64 bits java for better performance !</html>", 15, "badJavaArchTip");
            }
        }
        if ((javaVersion = SystemUtil.getJavaVersionAsNumber()) > 0.0 && javaVersion < 7.0 && SystemUtil.isMac()) {
            text = "It looks like you're using a old version of Java (1.6)<br>It's recommended to use last JDK 8 for OSX for a better user experience.<br>See the <a href=\"http://icy.bioimageanalysis.org/faq#35\">FAQ</a> to get information about how to update java.";
            System.out.println("Warning: It looks like you're using a old version of Java (1.6)<br>It's recommended to use last JDK 8 for OSX for a better user experience.<br>See the <a href=\"http://icy.bioimageanalysis.org/faq#35\">FAQ</a> to get information about how to update java.");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html>It looks like you're using a old version of Java (1.6)<br>It's recommended to use last JDK 8 for OSX for a better user experience.<br>See the <a href=\"http://icy.bioimageanalysis.org/faq#35\">FAQ</a> to get information about how to update java.</html>", 15, "outdatedJavaOSX");
            }
        }
        if (!NetworkUtil.isHTTPSSupported()) {
            String text1 = "Your version of java does not support HTTPS protocol which will be used soon by the new web site.";
            String text2 = "You need to upgrade your version of java to 7u111 (Java 7) or 8u101 (Java 8) at least to use online features (as search or plugin update) in future.";
            System.err.println("Warning: Your version of java does not support HTTPS protocol which will be used soon by the new web site.");
            System.err.println("You need to upgrade your version of java to 7u111 (Java 7) or 8u101 (Java 8) at least to use online features (as search or plugin update) in future.");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html><b>WARNING:</b> Your version of java does not support HTTPS protocol which will be used soon by the new web site.<br>You need to upgrade your version of java to 7u111 (Java 7) or 8u101 (Java 8) at least to use online features (as search or plugin update) in future.</html>", 0, "httpsNotSupportedWarning");
            }
        }
        if (ApplicationPreferences.getMaxMemoryMB() <= 128 && ApplicationPreferences.getMaxMemoryMBLimit() > 256) {
            text = "Your maximum memory setting is low, you should increase it in Preferences.";
            System.out.println("Warning: Your maximum memory setting is low, you should increase it in Preferences.");
            if (!Icy.getMainInterface().isHeadLess()) {
                new ToolTipFrame("<html>Your maximum memory setting is low, you should increase it in Preferences.</html>", 15, "lowMemoryTip");
            }
        } else if (ApplicationPreferences.getMaxMemoryMB() < ApplicationPreferences.getDefaultMemoryMB() / 2 && !Icy.getMainInterface().isHeadLess()) {
            new ToolTipFrame("<html><b>Tip:</b> you can increase your maximum memory in preferences setting.</html>", 15, "maxMemoryTip");
        }
        if (!Icy.getMainInterface().isHeadLess()) {
            ToolTipFrame tooltip = new ToolTipFrame("<html>Access the main menu by clicking on top left icon<br><img src=\"" + Icy.class.getResource("/image/help/main_menu.png").toString() + "\" /></html>", 30, "mainMenuTip");
            tooltip.setSize(456, 240);
            tooltip = new ToolTipFrame("<html><img src=\"" + Icy.class.getResource("/image/help/virtual_mode.jpg").toString() + "\" /><br>" + "This new button allow to enable/disable Icy <b>virtual mode</b>.<br><br>" + "Virtual mode will force all new created images to be in <i>virtual mode</i> which mean their data can be stored on disk to spare memory.<br>" + "Note that <i>virtual mode</i> is still experimental and <b>some plugins don't support it</b> (processed data can be lost) so use it carefully and only if you're running out of memory.<br>" + "<i>You can change the image caching settings in Icy preferences</i></html>", 30, "virtualMode");
            tooltip.setSize(380, 240);
            tooltip = new ToolTipFrame("<html><img src=\"" + Icy.class.getResource("/image/help/magic_wand.png").toString() + "\" /><br>" + "<b>Magic Wand</b> is now available in Icy !<br><br>" + "You can access its settings from preferences :<br>" + "<img src=\"" + Icy.class.getResource("/image/help/icy_prefs.png").toString() + "\" /></html>", 30, "magicWand");
            tooltip.setSize(300, 260);
        }
    }

    static void fatalError(Throwable t, boolean headless) {
        if (splashScreen != null && splashScreen.isVisible()) {
            splashScreen.dispose();
        }
        IcyExceptionHandler.showErrorMessage(t, true);
        if (!headless) {
            JOptionPane.showMessageDialog(null, IcyExceptionHandler.getErrorMessage(t, true), "Fatal error", 0);
        }
        System.exit(1);
    }

    public static void confirmRestart() {
        Icy.confirmRestart(null);
    }

    public static void confirmRestart(String message) {
        String mess = StringUtil.isEmpty(message) ? "Application need to be restarted so changes can take effect. Do it now ?" : message;
        if (ConfirmDialog.confirm(mess)) {
            Icy.exit(true);
        }
    }

    public static void announceRestart() {
        Icy.announceRestart(null);
    }

    public static void announceRestart(String message) {
        String mess = StringUtil.isEmpty(message) ? "Application need to be restarted so changes can take effet." : message;
        if (Icy.getMainInterface().isHeadLess()) {
            System.out.println(mess);
        } else {
            new AnnounceFrame(mess, "Restart Now", new Runnable(){

                @Override
                public void run() {
                    Icy.exit(true);
                }
            }, 20);
        }
    }

    public static boolean canExit(boolean showConfirm) {
        boolean safeExit;
        if (!Icy.getMainInterface().canExitExternal()) {
            return false;
        }
        if (Icy.getMainInterface().isHeadLess()) {
            return true;
        }
        boolean bl = safeExit = !PluginInstaller.isProcessing() && !WorkspaceInstaller.isProcessing();
        if (!safeExit) {
            return ConfirmDialog.confirm("Quit the application", "Some processes are not yet completed, are you sure you want to quit ?", 1);
        }
        if (showConfirm && GeneralPreferences.getExitConfirm()) {
            return IdConfirmDialog.confirm("Quit the application ?", "exit");
        }
        return true;
    }

    public static boolean exit(final boolean restart) {
        if (!Icy.canExit(!restart)) {
            return false;
        }
        if (exiting && terminer.isAlive()) {
            if (exitFrame != null) {
                exitFrame.requestFocus();
            }
            return true;
        }
        terminer = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean doUpdate;
                exiting = true;
                System.out.print("Exiting...");
                ImageJWrapper ij = Icy.getMainInterface().getImageJ();
                if (ij != null) {
                    ij.quit();
                }
                final MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        IcyDesktopPane desktopPane = Icy.getMainInterface().getDesktopPane();
                        if (desktopPane != null) {
                            JInternalFrame[] jInternalFrameArray = desktopPane.getAllFrames();
                            int n = jInternalFrameArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                JInternalFrame jInternalFrame = jInternalFrameArray[n2];
                                try {
                                    try {
                                        jInternalFrame.setClosed(true);
                                    }
                                    catch (PropertyVetoException e) {
                                        jInternalFrame.dispose();
                                    }
                                    catch (Throwable t) {
                                        jInternalFrame.dispose();
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                ++n2;
                            }
                        }
                        for (JFrame jFrame : Icy.getMainInterface().getExternalFrames()) {
                            if (jFrame == mainFrame) continue;
                            if (jFrame instanceof IcyExternalFrame) {
                                IcyExternalFrame iFrame = (IcyExternalFrame)jFrame;
                                iFrame.close();
                                if (iFrame.getDefaultCloseOperation() == 2) continue;
                                iFrame.dispose();
                                continue;
                            }
                            jFrame.dispose();
                        }
                    }
                });
                PluginLoader.stopDaemons();
                ThreadUtil.shutdown();
                SequencePrefetcher.shutdown();
                if (Icy.getMainInterface().isHeadLess()) {
                    while (!ThreadUtil.isShutdownAndTerminated()) {
                        ThreadUtil.sleep(1);
                    }
                } else {
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            exitFrame = new ExitFrame(3000);
                        }
                    });
                    while (!ThreadUtil.isShutdownAndTerminated() && !exitFrame.isForced()) {
                        ThreadUtil.sleep(1);
                    }
                    ThreadUtil.invokeNow(new Runnable(){

                        @Override
                        public void run() {
                            exitFrame.dispose();
                        }
                    });
                }
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        if (mainFrame != null) {
                            mainFrame.dispose();
                        }
                    }
                });
                IcyPreferences.save();
                Audit.save();
                ImageCache.shutDown();
                if (lock != null) {
                    SingleInstanceCheck.release(lock);
                }
                if ((doUpdate = IcyUpdater.getWantUpdate()) || restart) {
                    IcyUpdater.launchUpdater(doUpdate, restart);
                }
                System.out.println(" done");
                System.exit(0);
            }
        });
        terminer.setName("Icy Shutdown");
        terminer.start();
        return true;
    }

    @Deprecated
    public static boolean exit(boolean restart, boolean force) {
        return Icy.exit(restart);
    }

    public static boolean isVtkLibraryLoaded() {
        return vtkLibraryLoaded;
    }

    public static boolean isItkLibraryLoaded() {
        return itkLibraryLoaded;
    }

    @Deprecated
    public static boolean isHeadLess() {
        return Icy.getMainInterface().isHeadLess();
    }

    @Deprecated
    public static boolean isCacheEnabled() {
        return !Icy.isCacheDisabled();
    }

    @Deprecated
    public static boolean isNetworkEnabled() {
        return !Icy.isNetworkDisabled();
    }

    public static boolean isCacheDisabled() {
        return disableCache;
    }

    public static boolean isNetworkDisabled() {
        return disableNetwork;
    }

    public static boolean isExiting() {
        return exiting;
    }

    public static MainInterface getMainInterface() {
        if (mainInterface == null) {
            mainInterface = new MainInterfaceBatch();
        }
        return mainInterface;
    }

    public static String[] getCommandLineArgs() {
        return args;
    }

    public static String[] getCommandLinePluginArgs() {
        return pluginArgs;
    }

    public static void clearCommandLinePluginArgs() {
        pluginArgs = new String[0];
    }

    public static Plugin getStartupPlugin() {
        return startupPlugin;
    }

    public static String getChangeLog() {
        if (FileUtil.exists("CHANGELOG")) {
            return new String(FileUtil.load("CHANGELOG", false));
        }
        return "";
    }

    public static String getLicense() {
        if (FileUtil.exists("LICENSE")) {
            return new String(FileUtil.load("LICENSE", false));
        }
        return "";
    }

    public static String getReadMe() {
        if (FileUtil.exists("README.md")) {
            return new String(FileUtil.load("README.md", false));
        }
        return "";
    }

    @Deprecated
    public static void addSequence(Sequence sequence) {
        Icy.getMainInterface().addSequence(sequence);
    }

    static void nativeLibrariesInit() {
        String libPath = "lib/" + SystemUtil.getOSArchIdString();
        File libPathFile = new File(libPath);
        File[] files = FileUtil.getFiles(libPathFile, null, true, true, false);
        ArrayList<String> directories = new ArrayList<String>();
        directories.add(libPathFile.getAbsolutePath());
        directories.add(new File(SystemUtil.getTempLibraryDirectory()).getAbsolutePath());
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath;
            File f = fileArray[n2];
            if (f.isDirectory() && !directories.contains(filePath = f.getAbsolutePath())) {
                directories.add(filePath);
            }
            ++n2;
        }
        if (SystemUtil.isUnix()) {
            directories.add(new File("/lib").getAbsolutePath());
            directories.add(new File("/usr/lib").getAbsolutePath());
            if (SystemUtil.is64bits()) {
                directories.add(new File("/lib64").getAbsolutePath());
                directories.add(new File("/lib/x86_64").getAbsolutePath());
                directories.add(new File("/lib/x86_64-linux-gnu").getAbsolutePath());
                directories.add(new File("/usr/lib64").getAbsolutePath());
                directories.add(new File("/usr/lib/x86_64").getAbsolutePath());
                directories.add(new File("/usr/lib/x86_64-linux-gnu").getAbsolutePath());
            } else {
                directories.add(new File("/lib/x86").getAbsolutePath());
                directories.add(new File("/lib/x86-linux-gnu").getAbsolutePath());
                directories.add(new File("/usr/lib/x86").getAbsolutePath());
                directories.add(new File("/usr/lib/x86-linux-gnu").getAbsolutePath());
            }
        }
        if (!SystemUtil.addToJavaLibraryPath(directories.toArray(new String[directories.size()]))) {
            System.out.println("Some native libraries may not load correctly.");
        }
        Icy.loadVtkLibrary(libPathFile);
        SystemUtil.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }

    private static void loadVtkLibrary(File libPathFile) {
        String vtkLibPath = FileUtil.getGenericPath(new File(libPathFile, "vtk").getAbsolutePath());
        System.setProperty("vtk.lib.dir", vtkLibPath);
        vtkLibraryLoaded = false;
        try {
            Icy.loadLibrary(vtkLibPath, "vtkalglib", false);
            Icy.loadLibrary(vtkLibPath, "vtkdoubleconversion", false);
            Icy.loadLibrary(vtkLibPath, "vtklz4");
            Icy.loadLibrary(vtkLibPath, "vtkzlib");
            Icy.loadLibrary(vtkLibPath, "vtkexpat");
            Icy.loadLibrary(vtkLibPath, "vtkDICOMParser");
            Icy.loadLibrary(vtkLibPath, "vtkjpeg");
            Icy.loadLibrary(vtkLibPath, "vtkpng");
            Icy.loadLibrary(vtkLibPath, "vtkfreetype");
            Icy.loadLibrary(vtkLibPath, "vtksys");
            Icy.loadLibrary(vtkLibPath, "vtklzma", false);
            Icy.loadLibrary(vtkLibPath, "vtkgl2ps", false);
            Icy.loadLibrary(vtkLibPath, "vtkogg", false);
            Icy.loadLibrary(vtkLibPath, "vtkverdict");
            Icy.loadLibrary(vtkLibPath, "vtktheora", false);
            Icy.loadLibrary(vtkLibPath, "vtkoggtheora", false);
            Icy.loadLibrary(vtkLibPath, "vtkjsoncpp");
            Icy.loadLibrary(vtkLibPath, "vtkmetaio");
            Icy.loadLibrary(vtkLibPath, "vtktiff");
            Icy.loadLibrary(vtkLibPath, "vtklibharu");
            Icy.loadLibrary(vtkLibPath, "vtkproj", false);
            Icy.loadLibrary(vtkLibPath, "vtkproj4", false);
            Icy.loadLibrary(vtkLibPath, "vtklibxml2");
            Icy.loadLibrary(vtkLibPath, "vtkftgl", false);
            Icy.loadLibrary(vtkLibPath, "vtkftgl2", false);
            Icy.loadLibrary(vtkLibPath, "vtkglew", false);
            Icy.loadLibrary(vtkLibPath, "vtkpugixml", false);
            Icy.loadLibrary(vtkLibPath, "vtksqlite", false);
            Icy.loadLibrary(vtkLibPath, "vtkhdf5.8.2.0", false);
            Icy.loadLibrary(vtkLibPath, "vtkhdf5_hl.8.2.0", false);
            Icy.loadLibrary(vtkLibPath, "vtkhdf5", false);
            Icy.loadLibrary(vtkLibPath, "vtkhdf5_hl", false);
            Icy.loadLibrary(vtkLibPath, "vtkNetCDF");
            Icy.loadLibrary(vtkLibPath, "vtkNetCDF_cxx", false);
            Icy.loadLibrary(vtkLibPath, "vtknetcdf_c++", false);
            Icy.loadLibrary(vtkLibPath, "vtknetcdfcpp", false);
            Icy.loadLibrary(vtkLibPath, "vtkexodusII", false);
            Icy.loadLibrary(vtkLibPath, "vtkexoIIc", false);
            Icy.loadLibrary(vtkLibPath, "vtkCommonCore");
            Icy.loadLibrary(vtkLibPath, "vtkWrappingJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonSystem");
            Icy.loadLibrary(vtkLibPath, "vtkCommonMath");
            Icy.loadLibrary(vtkLibPath, "vtkCommonMisc");
            Icy.loadLibrary(vtkLibPath, "vtkCommonTransforms");
            Icy.loadLibrary(vtkLibPath, "vtkCommonDataModel");
            Icy.loadLibrary(vtkLibPath, "vtkCommonColor");
            Icy.loadLibrary(vtkLibPath, "vtkCommonComputationalGeometry");
            Icy.loadLibrary(vtkLibPath, "vtkCommonExecutionModel");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersTopology");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersVerdict");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersProgrammable");
            Icy.loadLibrary(vtkLibPath, "vtkImagingMath");
            Icy.loadLibrary(vtkLibPath, "vtkIOCore");
            Icy.loadLibrary(vtkLibPath, "vtkIOEnSight");
            Icy.loadLibrary(vtkLibPath, "vtkIOVideo");
            Icy.loadLibrary(vtkLibPath, "vtkIOVeraOut", false);
            Icy.loadLibrary(vtkLibPath, "vtkIOLegacy");
            Icy.loadLibrary(vtkLibPath, "vtkIONetCDF");
            Icy.loadLibrary(vtkLibPath, "vtkIOXMLParser");
            Icy.loadLibrary(vtkLibPath, "vtkIOXML");
            Icy.loadLibrary(vtkLibPath, "vtkIOTecplotTable");
            Icy.loadLibrary(vtkLibPath, "vtkIOImage");
            Icy.loadLibrary(vtkLibPath, "vtkIOSQL");
            Icy.loadLibrary(vtkLibPath, "vtkIOMovie");
            Icy.loadLibrary(vtkLibPath, "vtkParallelCore");
            Icy.loadLibrary(vtkLibPath, "vtkImagingCore");
            Icy.loadLibrary(vtkLibPath, "vtkIOSegY", false);
            Icy.loadLibrary(vtkLibPath, "vtkFiltersCore");
            Icy.loadLibrary(vtkLibPath, "vtkImagingColor");
            Icy.loadLibrary(vtkLibPath, "vtkImagingFourier");
            Icy.loadLibrary(vtkLibPath, "vtkImagingSources");
            Icy.loadLibrary(vtkLibPath, "vtkImagingHybrid");
            Icy.loadLibrary(vtkLibPath, "vtkImagingStatistics");
            Icy.loadLibrary(vtkLibPath, "vtkIOGeometry");
            Icy.loadLibrary(vtkLibPath, "vtkIOPLY");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersSelection");
            Icy.loadLibrary(vtkLibPath, "vtkImagingGeneral");
            Icy.loadLibrary(vtkLibPath, "vtkImagingStencil");
            Icy.loadLibrary(vtkLibPath, "vtkImagingMorphological");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersGeometry");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersStatistics");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersImaging");
            Icy.loadLibrary(vtkLibPath, "vtkIOLSDyna");
            Icy.loadLibrary(vtkLibPath, "vtkIOAsynchronous", false);
            Icy.loadLibrary(vtkLibPath, "vtkIOParallelXML");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersGeneral");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersHyperTree");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersSMP");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersTexture");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersAMR");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersExtraction");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersSources");
            Icy.loadLibrary(vtkLibPath, "vtkIOExodus");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersGeneric");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersModeling");
            Icy.loadLibrary(vtkLibPath, "vtkIOAMR");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersFlowPaths");
            Icy.loadLibrary(vtkLibPath, "vtkIOCityGML", false);
            Icy.loadLibrary(vtkLibPath, "vtkInfovisCore");
            Icy.loadLibrary(vtkLibPath, "vtkIOInfovis");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersPoints");
            Icy.loadLibrary(vtkLibPath, "vtkInfovisLayout");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingCore");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingLOD");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingImage");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingFreeType");
            Icy.loadLibrary(vtkLibPath, "vtkDomainsChemistry");
            Icy.loadLibrary(vtkLibPath, "vtkDomainsChemistryOpenGL2", false);
            Icy.loadLibrary(vtkLibPath, "vtkInteractionStyle");
            Icy.loadLibrary(vtkLibPath, "vtkIOImport");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingAnnotation");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingLabel");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersHybrid");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersParallel");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersParallelImaging");
            Icy.loadLibrary(vtkLibPath, "vtkIOMINC");
            Icy.loadLibrary(vtkLibPath, "vtkIOParallel");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingVolume");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingVolumeAMR", false);
            Icy.loadLibrary(vtkLibPath, "vtkInteractionWidgets");
            Icy.loadLibrary(vtkLibPath, "vtkInteractionImage");
            Icy.loadLibrary(vtkLibPath, "vtkViewsCore");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingOpenGL2", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingLIC", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingVolumeOpenGL2", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingContext2D");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingContextOpenGL2", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingGL2PS", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingGL2PSOpenGL2", false);
            Icy.loadLibrary(vtkLibPath, "vtkViewsContext2D");
            Icy.loadLibrary(vtkLibPath, "vtkGeovisCore");
            Icy.loadLibrary(vtkLibPath, "vtkIOExport");
            Icy.loadLibrary(vtkLibPath, "vtkIOExportOpenGL2");
            Icy.loadLibrary(vtkLibPath, "vtkIOExportPDF", false);
            Icy.loadLibrary(vtkLibPath, "vtkChartsCore");
            Icy.loadLibrary(vtkLibPath, "vtkViewsInfovis");
            Icy.loadLibrary(vtkLibPath, "vtkViewsGeovis", false);
            Icy.loadLibrary(vtkLibPath, "vtkCommonCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonSystemJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonMathJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonMiscJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonTransformsJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonDataModelJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonColorJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonComputationalGeometryJava");
            Icy.loadLibrary(vtkLibPath, "vtkCommonExecutionModelJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersTopologyJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersVerdictJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersProgrammableJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingMathJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOEnSightJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOVideoJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOVeraOutJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkIOLegacyJava");
            Icy.loadLibrary(vtkLibPath, "vtkIONetCDFJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOXMLParserJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOXMLJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOTecplotTableJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOImageJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOSQLJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOMovieJava");
            Icy.loadLibrary(vtkLibPath, "vtkParallelCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOSegYJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkFiltersCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingColorJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingFourierJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingSourcesJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingHybridJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingStatisticsJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOGeometryJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOPLYJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersSelectionJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingGeneralJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingStencilJava");
            Icy.loadLibrary(vtkLibPath, "vtkImagingMorphologicalJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersGeometryJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersStatisticsJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersImagingJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOLSDynaJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOAsynchronousJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkIOParallelXMLJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersGeneralJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersHyperTreeJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersSMPJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersTextureJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersAMRJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersExtractionJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersSourcesJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOExodusJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersGenericJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersModelingJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOAMRJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersFlowPathsJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOCityGMLJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkInfovisCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOInfovisJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersPointsJava");
            Icy.loadLibrary(vtkLibPath, "vtkInfovisLayoutJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingLODJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingImageJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingFreeTypeJava");
            Icy.loadLibrary(vtkLibPath, "vtkDomainsChemistryJava");
            Icy.loadLibrary(vtkLibPath, "vtkDomainsChemistryOpenGL2Java", false);
            Icy.loadLibrary(vtkLibPath, "vtkInteractionStyleJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOImportJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingAnnotationJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingLabelJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersHybridJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersParallelJava");
            Icy.loadLibrary(vtkLibPath, "vtkFiltersParallelImagingJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOMINCJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOParallelJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingVolumeJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingVolumeAMRJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkInteractionWidgetsJava");
            Icy.loadLibrary(vtkLibPath, "vtkInteractionImageJava");
            Icy.loadLibrary(vtkLibPath, "vtkViewsCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingOpenGL2Java", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingLICJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingVolumeOpenGL2Java", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingContext2DJava");
            Icy.loadLibrary(vtkLibPath, "vtkRenderingContextOpenGL2Java", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingGL2PSJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkRenderingGL2PSOpenGL2", false);
            Icy.loadLibrary(vtkLibPath, "vtkViewsContext2DJava");
            Icy.loadLibrary(vtkLibPath, "vtkGeovisCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOExportJava");
            Icy.loadLibrary(vtkLibPath, "vtkIOExportOpenGL2Java");
            Icy.loadLibrary(vtkLibPath, "vtkIOExportPDFJava", false);
            Icy.loadLibrary(vtkLibPath, "vtkChartsCoreJava");
            Icy.loadLibrary(vtkLibPath, "vtkViewsInfovisJava");
            Icy.loadLibrary(vtkLibPath, "vtkViewsGeovisJava", false);
            vtkLibraryLoaded = true;
            vtkNativeLibrary.DisableOutputWindow((File)new File("vtk.log"));
        }
        catch (Throwable e1) {
            IcyExceptionHandler.showErrorMessage(e1, false, false);
        }
        if (vtkLibraryLoaded) {
            String vv = new vtkVersion().GetVTKVersion();
            System.out.println("VTK " + vv + " library successfully loaded...");
        } else {
            String osVer;
            System.out.println("Cannot load VTK library...");
            if (SystemUtil.isMac() && ((osVer = SystemUtil.getOSVersion()).startsWith("10.6") || osVer.startsWith("10.5"))) {
                System.out.println("VTK 6.3 is not supported on OSX " + osVer + ", version 10.7 or above is required.");
            }
        }
    }

    private static void loadItkLibrary(String osDir) {
        String itkLibDir = String.valueOf(osDir) + "/" + "itk";
        try {
            Icy.loadLibrary(itkLibDir, "SimpleITKJava", true);
            System.out.println("SimpleITK library successfully loaded...");
            itkLibraryLoaded = true;
        }
        catch (Throwable e) {
            System.out.println("Cannot load SimpleITK library...");
        }
    }

    private static void loadLibrary(String dir, String name, boolean mandatory, boolean showLog) {
        block4: {
            if (mandatory) {
                SystemUtil.loadLibrary(dir, name);
            } else {
                try {
                    SystemUtil.loadLibrary(dir, name);
                }
                catch (Throwable e) {
                    if (!showLog) break block4;
                    System.out.println("cannot load " + name + ", skipping...");
                }
            }
        }
    }

    private static void loadLibrary(String dir, String name, boolean mandatory) {
        Icy.loadLibrary(dir, name, mandatory, false);
    }

    private static void loadLibrary(String dir, String name) {
        Icy.loadLibrary(dir, name, true, false);
    }

    static void nativeLibrariesShutdown() {
        File libraryFile;
        File[] libraryFiles;
        String path = "lib/" + SystemUtil.getOSArchIdString();
        File[] fileArray = libraryFiles = FileUtil.getFiles(new File(path), null, true, false, false);
        int n = libraryFiles.length;
        int n2 = 0;
        while (n2 < n) {
            libraryFile = fileArray[n2];
            File file = new File(libraryFile.getName());
            if (file.exists()) {
                file.deleteOnExit();
            }
            ++n2;
        }
        fileArray = libraryFiles = FileUtil.getFiles(new File(SystemUtil.getTempLibraryDirectory()), null, true, false, false);
        n = libraryFiles.length;
        n2 = 0;
        while (n2 < n) {
            libraryFile = fileArray[n2];
            if (!FileUtil.delete(libraryFile, false)) {
                libraryFile.deleteOnExit();
            }
            ++n2;
        }
    }
}

