/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin.abstract_;

import icy.file.FileUtil;
import icy.gui.frame.IcyFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.ImageUtil;
import icy.main.Icy;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginBundled;
import icy.preferences.PluginsPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.sequence.Sequence;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.audit.Audit;
import icy.util.ClassUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;

public abstract class Plugin {
    private PluginDescriptor descriptor = PluginLoader.getPlugin(this.getClass().getName());

    public static Plugin getPlugin(List<Plugin> list, String className) {
        for (Plugin plugin : list) {
            if (!plugin.getClass().getName().equals(className)) continue;
            return plugin;
        }
        return null;
    }

    public Plugin() {
        if (this.descriptor == null) {
            if (!this.getClass().isAnonymousClass()) {
                System.out.println("Warning : Plugin '" + this.getClass().getName() + "' started but not found in PluginLoader !");
                System.out.println("Local XML plugin description file is probably incorrect.");
            }
            this.descriptor = new PluginDescriptor(this.getClass());
            this.descriptor.setName(this.getClass().getSimpleName());
        }
        Audit.pluginInstanced(this);
    }

    protected void finalize() throws Throwable {
        Icy.getMainInterface().unRegisterPlugin(this);
        super.finalize();
    }

    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public boolean isBundled() {
        return this instanceof PluginBundled;
    }

    public String getOwnerClassName() {
        if (this.isBundled()) {
            return ((PluginBundled)((Object)this)).getMainPluginClassName();
        }
        return this.getClass().getName();
    }

    public String getInstallFolder() {
        return ClassUtil.getPathFromQualifiedName(ClassUtil.getPackageName(this.getClass().getName()));
    }

    public Viewer getActiveViewer() {
        return Icy.getMainInterface().getActiveViewer();
    }

    public Sequence getActiveSequence() {
        return Icy.getMainInterface().getActiveSequence();
    }

    public IcyBufferedImage getActiveImage() {
        return Icy.getMainInterface().getActiveImage();
    }

    @Deprecated
    public Viewer getFocusedViewer() {
        return this.getActiveViewer();
    }

    @Deprecated
    public Sequence getFocusedSequence() {
        return this.getActiveSequence();
    }

    @Deprecated
    public IcyBufferedImage getFocusedImage() {
        return this.getActiveImage();
    }

    public void addIcyFrame(IcyFrame frame) {
        frame.addToDesktopPane();
    }

    public void addSequence(Sequence sequence) {
        Icy.getMainInterface().addSequence(sequence);
    }

    public void removeSequence(Sequence sequence) {
        sequence.close();
    }

    public ArrayList<Sequence> getSequences() {
        return Icy.getMainInterface().getSequences();
    }

    public URL getResource(String name) {
        return this.getClass().getClassLoader().getResource(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.getClass().getClassLoader().getResources(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    public BufferedImage getImageResource(String resourceName) {
        return ImageUtil.load(this.getResourceAsStream(resourceName));
    }

    public ImageIcon getIconResource(String resourceName) {
        return ResourceUtil.getImageIcon(this.getImageResource(resourceName));
    }

    public XMLPreferences getPreferencesRoot() {
        return PluginsPreferences.root(this);
    }

    public XMLPreferences getPreferences(String name) {
        return this.getPreferencesRoot().node(name);
    }

    protected static String getResourceNativeLibraryPath() {
        return "lib/" + SystemUtil.getOSArchIdString();
    }

    public static URL getResource(Class clazz, String name) {
        return clazz.getClassLoader().getResource(name);
    }

    public static boolean loadLibrary(Class clazz, String libName) {
        File file = Plugin.prepareLibrary(clazz, libName);
        if (file == null) {
            return false;
        }
        System.load(file.getAbsolutePath());
        return true;
    }

    public static File prepareLibrary(Class clazz, String libName) {
        try {
            String mappedlibName = System.mapLibraryName(libName);
            String basePath = String.valueOf(Plugin.getResourceNativeLibraryPath()) + "/";
            URL libUrl = Plugin.getResource(clazz, String.valueOf(basePath) + mappedlibName);
            if (libUrl == null) {
                if (mappedlibName.endsWith(".jnilib")) {
                    mappedlibName = String.valueOf(mappedlibName.substring(0, mappedlibName.length() - 7)) + ".dylib";
                    libUrl = Plugin.getResource(clazz, String.valueOf(basePath) + mappedlibName);
                } else if (mappedlibName.endsWith(".dylib")) {
                    mappedlibName = String.valueOf(mappedlibName.substring(0, mappedlibName.length() - 6)) + ".jnilib";
                    libUrl = Plugin.getResource(clazz, String.valueOf(basePath) + mappedlibName);
                }
            }
            if (libUrl == null) {
                throw new IOException("Couldn't find resource " + basePath + mappedlibName);
            }
            File extractedFile = Plugin.extractResourceTo(String.valueOf(SystemUtil.getTempLibraryDirectory()) + "/" + mappedlibName, libUrl);
            return extractedFile;
        }
        catch (IOException e) {
            System.err.println("Error while extracting packed library " + libName + ": " + e);
            return null;
        }
    }

    protected static File extractResourceTo(String outputPath, URL resource) throws IOException {
        byte[] data;
        File result = new File(outputPath);
        try (InputStream in = resource.openStream();){
            data = NetworkUtil.download(in);
        }
        if (result.exists()) {
            if (result.length() == (long)data.length) {
                return result;
            }
            if (!FileUtil.delete(result, false)) {
                throw new IOException("Cannot overwrite " + result + " file !");
            }
        }
        FileUtil.save(result, data, true);
        return result;
    }

    @Deprecated
    protected String getResourceLibraryPath() {
        return Plugin.getResourceNativeLibraryPath();
    }

    public boolean loadLibrary(String libName) {
        return Plugin.loadLibrary(this.getClass(), libName);
    }

    public File prepareLibrary(String libName) {
        return Plugin.prepareLibrary(this.getClass(), libName);
    }

    @Deprecated
    protected File extractResource(String outputPath, URL resource) throws IOException {
        return Plugin.extractResourceTo(outputPath, resource);
    }

    public void report(String errorLog) {
        IcyExceptionHandler.report(this.descriptor, errorLog);
    }

    public String toString() {
        return this.getDescriptor().getName();
    }
}

