/*
 * Decompiled with CFR 0.152.
 */
package icy.search;

import icy.network.WebInterface;
import icy.search.SearchResultConsumer;
import icy.search.SearchResultProducer;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import org.w3c.dom.Document;

public abstract class OnlineSearchResultProducer
extends SearchResultProducer {
    @Deprecated
    protected static final String SEARCH_URL = "http://icy.bioimageanalysis.org/search/search.php?search=";
    public static final long REQUEST_INTERVAL = 250L;
    public static final long MAXIMUM_SEARCH_TIME = 5000L;

    @Override
    public void doSearch(String text, SearchResultConsumer consumer) {
        if (StringUtil.isEmpty(text)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 250L) {
            ThreadUtil.sleep(10);
            if (!this.hasWaitingSearch()) continue;
            return;
        }
        int retry = 0;
        Document document = null;
        while (System.currentTimeMillis() - startTime < 5000L && document == null && retry < 5) {
            try {
                document = this.doSearchRequest(text);
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage(e, false);
            }
            if (this.hasWaitingSearch()) {
                return;
            }
            if (document == null) {
                ThreadUtil.sleep(100);
            }
            ++retry;
        }
        if (this.hasWaitingSearch() || document == null) {
            return;
        }
        this.doSearch(document, text, consumer);
    }

    protected Document doSearchRequest(String text) throws Exception {
        return WebInterface.doSearch(text);
    }

    @Deprecated
    public void doSearch(Document doc, String[] words, SearchResultConsumer consumer) {
    }

    public void doSearch(Document doc, String text, SearchResultConsumer consumer) {
        this.doSearch(doc, text.split(" "), consumer);
    }
}

